/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.impl.receiver.prerelation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.WarningSceneService;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.receiver.ReceiverFieldResultBo;
import kd.hr.hrcs.common.constants.earlywarn.WarnPersonEntityNumEnum;
import kd.hr.hrcs.common.model.earlywarn.WarnQueryFieldBo;
import kd.hr.hrcs.common.model.earlywarn.ds.WarnDataRow;

@ExcludeFromJacocoGeneratedReport
public abstract class AbstractReceiverPreProcessor {
    public abstract List<ReceiverFieldResultBo> processSysUserTrans(List<ReceiverFieldResultBo> var1);

    public abstract List<ReceiverFieldResultBo> processPersonTrans(List<ReceiverFieldResultBo> var1);

    public abstract List<ReceiverFieldResultBo> processEmployeeTrans(List<ReceiverFieldResultBo> var1);

    public abstract List<ReceiverFieldResultBo> processDepempTrans(List<ReceiverFieldResultBo> var1);

    public List<ReceiverFieldResultBo> parseUsersList(DataSet dataSet, DynamicObject dyWarnScene, Set<String> dyEntries) {
        if (CollectionUtils.isEmpty(dyEntries)) {
            return Collections.emptyList();
        }
        if (dyWarnScene == null || CollectionUtils.isEmpty(dyEntries)) {
            return Collections.emptyList();
        }
        List<WarnQueryFieldBo> warnQueryFieldBoList = WarningSceneService.getInstance().querySceneQueryFieldsByFieldAliasAndAssemble(dyWarnScene, dyEntries);
        if (CollectionUtils.isEmpty(warnQueryFieldBoList)) {
            return Collections.emptyList();
        }
        Map<String, List<ReceiverFieldResultBo>> mapEntityNumberField = this.groupFields(warnQueryFieldBoList);
        if (mapEntityNumberField == null || mapEntityNumberField.isEmpty()) {
            return Collections.emptyList();
        }
        mapEntityNumberField = this.buildReceiverId(dataSet, mapEntityNumberField);
        ArrayList receiverFieldResultList = Lists.newArrayListWithCapacity((int)10);
        for (Map.Entry<String, List<ReceiverFieldResultBo>> entry : mapEntityNumberField.entrySet()) {
            String entityNumber = entry.getKey();
            List<ReceiverFieldResultBo> receiverFieldResultBos = entry.getValue();
            if (CollectionUtils.isEmpty(receiverFieldResultBos)) continue;
            if (WarnPersonEntityNumEnum.USER.getEntityNumber().equals(entityNumber)) {
                receiverFieldResultList.addAll(this.processSysUserTrans(receiverFieldResultBos));
                continue;
            }
            if (WarnPersonEntityNumEnum.PERSON.getEntityNumber().equals(entityNumber)) {
                receiverFieldResultList.addAll(this.processPersonTrans(receiverFieldResultBos));
                continue;
            }
            if (WarnPersonEntityNumEnum.EMPLOYEE.getEntityNumber().equals(entityNumber)) {
                receiverFieldResultList.addAll(this.processEmployeeTrans(receiverFieldResultBos));
                continue;
            }
            if (!WarnPersonEntityNumEnum.ORG_PERSON.getEntityNumber().equals(entityNumber)) continue;
            receiverFieldResultList.addAll(this.processDepempTrans(receiverFieldResultBos));
        }
        return receiverFieldResultList;
    }

    private Map<String, List<ReceiverFieldResultBo>> groupFields(List<WarnQueryFieldBo> warnQueryFieldBoList) {
        HashMap mapEntityNumberField = Maps.newHashMapWithExpectedSize((int)16);
        for (WarnQueryFieldBo warnQueryFieldBo : warnQueryFieldBoList) {
            if (warnQueryFieldBo == null) continue;
            String entityNumber = warnQueryFieldBo.getBaseDataNum();
            String fieldAlias = warnQueryFieldBo.getFieldAlias();
            if (StringUtils.isEmpty((String)entityNumber) || StringUtils.isEmpty((String)fieldAlias)) continue;
            if (WarnPersonEntityNumEnum.USER.getEntityNumber().equals(entityNumber)) {
                this.buildFieldMap(mapEntityNumberField, fieldAlias, WarnPersonEntityNumEnum.USER.getEntityNumber());
                continue;
            }
            if (WarnPersonEntityNumEnum.PERSON.getEntityNumber().equals(entityNumber)) {
                this.buildFieldMap(mapEntityNumberField, fieldAlias, WarnPersonEntityNumEnum.PERSON.getEntityNumber());
                continue;
            }
            if (WarnPersonEntityNumEnum.EMPLOYEE.getEntityNumber().equals(entityNumber)) {
                this.buildFieldMap(mapEntityNumberField, fieldAlias, WarnPersonEntityNumEnum.EMPLOYEE.getEntityNumber());
                continue;
            }
            if (!WarnPersonEntityNumEnum.ORG_PERSON.getEntityNumber().equals(entityNumber)) continue;
            this.buildFieldMap(mapEntityNumberField, fieldAlias, WarnPersonEntityNumEnum.ORG_PERSON.getEntityNumber());
        }
        return mapEntityNumberField;
    }

    private void buildFieldMap(Map<String, List<ReceiverFieldResultBo>> mapEntityNumberField, String fieldAlias, String key) {
        ArrayList fieldList = mapEntityNumberField.get(key);
        if (fieldList == null) {
            fieldList = Lists.newArrayListWithExpectedSize((int)10);
            mapEntityNumberField.put(key, fieldList);
        }
        ReceiverFieldResultBo receiverFieldResultBo = new ReceiverFieldResultBo();
        receiverFieldResultBo.setFieldAlias(fieldAlias);
        fieldList.add(receiverFieldResultBo);
    }

    private Map<String, List<ReceiverFieldResultBo>> buildReceiverId(DataSet dataSet, Map<String, List<ReceiverFieldResultBo>> mapEntityNumberField) {
        RowMeta rowMeta = dataSet.getRowMeta();
        ArrayList listRow = Lists.newArrayListWithExpectedSize((int)10);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            listRow.add(new WarnDataRow(rowMeta, row));
        }
        HashMap mapEntityNumberFieldId = Maps.newHashMapWithExpectedSize((int)mapEntityNumberField.size());
        for (Row row : listRow) {
            for (Map.Entry<String, List<ReceiverFieldResultBo>> entry : mapEntityNumberField.entrySet()) {
                for (ReceiverFieldResultBo receiverFieldResultBo : entry.getValue()) {
                    this.buildResultList(mapEntityNumberFieldId, row, entry.getKey(), receiverFieldResultBo.getFieldAlias());
                }
            }
        }
        return mapEntityNumberFieldId;
    }

    private void buildResultList(Map<String, List<ReceiverFieldResultBo>> mapEntityNumberFieldId, Row row, String entityNumber, String fieldAlias) {
        Object obj = row.get(fieldAlias);
        if (obj instanceof Long) {
            Long id = (Long)obj;
            ArrayList receiverFieldResultBoList = mapEntityNumberFieldId.get(entityNumber);
            if (receiverFieldResultBoList == null) {
                receiverFieldResultBoList = Lists.newArrayListWithExpectedSize((int)10);
                mapEntityNumberFieldId.put(entityNumber, receiverFieldResultBoList);
            } else if (receiverFieldResultBoList.stream().anyMatch(e -> e.getFiledId().equals(id))) {
                return;
            }
            ReceiverFieldResultBo receiverFieldResultRow = new ReceiverFieldResultBo();
            receiverFieldResultRow.setFieldAlias(fieldAlias);
            receiverFieldResultRow.setFiledId(id);
            receiverFieldResultBoList.add(receiverFieldResultRow);
        }
    }
}

