/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.domain.service.earlywarn.exportconfig;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.db.DBRoute;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.isv.ISVService;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.sqlscript.PreInsDataScriptBuilder;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRDBUtil;

@ExcludeFromJacocoGeneratedReport
public class HRWarnPreSQLHelper {
    private static final String STR_WRAP = "\r\n";

    public void generateHRWarnScenePreSQLFile(AbstractListPlugin listPlugIn, List<Long> idList) {
        if (idList == null || idList.size() < 1) {
            return;
        }
        ArrayList<Map<String, StringWriter>> xmlFileList = new ArrayList<Map<String, StringWriter>>(16);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("/****** HR WarnScene SQL ******/").append(STR_WRAP);
        this.generateWarnScenePreSQL(idList, xmlFileList, sqlBuilder);
        String isv = ISVService.getISVInfo().getId();
        if ("kingdee".equals(isv)) {
            isv = "kd";
        }
        String sqlFileName = String.format("%s_%s_%s.sql", isv, "hrcs_warn_scene_initsql_", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        try (ByteArrayInputStream ins = new ByteArrayInputStream(sqlBuilder.toString().getBytes(StandardCharsets.UTF_8));){
            this.exportFile(listPlugIn, ins, sqlFileName);
            this.exportXmlFile(listPlugIn, xmlFileList);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("KSQLExpPlugin error:%s.", e.getMessage())});
        }
    }

    private void generateWarnScenePreSQL(List<Long> idList, List<Map<String, StringWriter>> xmlFileList, StringBuilder sqlBuilder) {
        List<Map<String, Object>> listSqlMap = this.generateWarnScenePreSQL(idList);
        for (Map<String, Object> map : listSqlMap) {
            sqlBuilder.append(map.get("sql")).append(STR_WRAP);
            if (map.get("xml") == null) continue;
            xmlFileList.add((Map)map.get("xml"));
        }
        listSqlMap = this.generateWarnSceneEntityPreSQL(idList);
        for (Map<String, Object> map : listSqlMap) {
            sqlBuilder.append(map.get("sql")).append(STR_WRAP);
            if (map.get("xml") == null) continue;
            xmlFileList.add((Map)map.get("xml"));
        }
        listSqlMap = this.generateWarnSceneRCPreSQL(idList);
        for (Map<String, Object> map : listSqlMap) {
            sqlBuilder.append(map.get("sql")).append(STR_WRAP);
            if (map.get("xml") == null) continue;
            xmlFileList.add((Map)map.get("xml"));
        }
    }

    public void generateHRWarnSchemePreSQLFile(AbstractListPlugin listPlugIn, List<Long> idList) {
        String isv;
        if (idList == null || idList.size() < 1) {
            return;
        }
        ArrayList<Map<String, StringWriter>> xmlFileList = new ArrayList<Map<String, StringWriter>>(16);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("/****** HR WarnScheme SQL ******/").append(STR_WRAP);
        List<Map<String, Object>> listSqlMap = this.generateWarnSchemePreSQL(idList);
        for (Map<String, Object> map : listSqlMap) {
            sqlBuilder.append(map.get("sql")).append(STR_WRAP);
            if (map.get("xml") == null) continue;
            xmlFileList.add((Map)map.get("xml"));
        }
        String splitIds = Joiner.on((String)",").join(idList);
        String warnSceneSql = "SELECT FWARNSCENEID FROM T_HRCS_WARNSCHEME WHERE FID IN (" + splitIds + ")";
        DataSet warnSceneDataSet = HRDBUtil.queryDataSet((String)"HRWarnPreSQLHelper.generateHRWarnSchemePreSQLFile", (DBRoute)DBRoute.of((String)"hmp"), (String)warnSceneSql, null);
        ArrayList<Long> warnSceneList = new ArrayList<Long>(10);
        while (warnSceneDataSet.hasNext()) {
            Row row = warnSceneDataSet.next();
            warnSceneList.add(row.getLong("FWARNSCENEID"));
        }
        if (warnSceneList.size() == 0) {
            this.generateWarnScenePreSQL(warnSceneList, xmlFileList, sqlBuilder);
        }
        if ("kingdee".equals(isv = ISVService.getISVInfo().getId())) {
            isv = "kd";
        }
        String sqlFileName = String.format("%s_%s_%s.sql", isv, "hrcs_warn_scheme_initsql_", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        try (ByteArrayInputStream ins = new ByteArrayInputStream(sqlBuilder.toString().getBytes(StandardCharsets.UTF_8));){
            this.exportFile(listPlugIn, ins, sqlFileName);
            this.exportXmlFile(listPlugIn, xmlFileList);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("KSQLExpPlugin error:%s.", e.getMessage())});
        }
    }

    private List<Map<String, Object>> generateWarnSceneEntityPreSQL(List<Long> idList) {
        ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>(16);
        String splitIds = Joiner.on((String)",").join(idList);
        String exportFields = "FID,FWARNSCENEID,FCREATORID,FCREATETIME,FMODIFIERID,FMODIFYTIME,FENTITYNAME,FLONGNUMBER,FENTITYNUMBER,FENTITYALIAS,FTYPE,FVERSION,FINDEX";
        String whereCondition = "FWARNSCENEID IN (" + splitIds + ")";
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        Map map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRCS_WARNSCENEENTITY", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FPKID,FID,FLOCALEID,FENTITYNAME";
        whereCondition = "FID IN (SELECT FID FROM T_HRCS_WARNSCENEENTITY WHERE FWARNSCENEID IN (" + splitIds + ")) AND FLOCALEID='zh_CN'";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRCS_WARNSCENEENTITY_L", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FID,FWARNSCENEID,FCREATORID,FCREATETIME,FMODIFIERID,FMODIFYTIME,FENTITYID,FJOINTYPE,FJOINENTITYID,FVERSION";
        whereCondition = "FWARNSCENEID IN (" + splitIds + ")";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRCS_WARNSCENERELATION", exportFields, whereCondition, null, null);
        listMap.add(map);
        whereCondition = "FID IN (SELECT FID FROM T_HRCS_WARNSCENERELATION WHERE FWARNSCENEID IN (" + splitIds + "))";
        map = Maps.newHashMapWithExpectedSize((int)1);
        String deleteConditionSql = "DELETE FROM T_HRCS_WARNSCENERELCON WHERE " + whereCondition + ";";
        map.put("sql", deleteConditionSql);
        listMap.add(map);
        exportFields = "FENTRYID,FID,FSEQ,FLEFTPROP,FCOMPARETYPE,FRIGHTPROP,FRIGHTPROPTYPE,FRIGHTPROPVAL,FLOGICTYPE";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRCS_WARNSCENERELCON", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FID,FWARNSCENEID,FCREATORID,FCREATETIME,FMODIFIERID,FMODIFYTIME,FENTITYNUMBER,FFIELDNAME,FFIELDALIAS,FFIELDPATH,FVALUETYPE,FCOMPLEXTYPE,FCONTROLTYPE";
        whereCondition = "FWARNSCENEID IN (" + splitIds + ")";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRCS_WARNSCENEFIELD", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FPKID,FID,FLOCALEID,FFIELDNAME";
        whereCondition = "FID IN (SELECT FID FROM T_HRCS_WARNSCENEFIELD WHERE FWARNSCENEID IN (" + splitIds + ")) AND FLOCALEID='zh_CN'";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRCS_WARNSCENEFIELD_L", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FID,FNUMBER,FNAME,FTYPE,FVALUETYPE,FCONTROLTYPE,FEXPR,FVIEWEXPR,FSOURCE,FORDER,FISSELECTED,FCALMETHOD,FHIDEFIELD,FSOURCEID,FCREATORID,FCREATETIME,FMODIFIERID,FMODIFYTIME,FINDEX";
        whereCondition = "FSOURCEID IN (" + splitIds + ")\u3000and FSOURCE='warnscene' ";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRCS_WARNCALFIELD", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FID,FLOCALEID,FPKID,FNAME";
        whereCondition = "FID IN (SELECT FID FROM T_HRCS_WARNCALFIELD WHERE FSOURCEID IN (" + splitIds + ") and FSOURCE='warnscene') AND FLOCALEID='zh_CN'";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRPTMC_CALCULATEFIELD_L", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FENTRYID,FSEQ,FREFTYPE,FREFFIELDALIAS,FREFCALFIELDID,FID";
        whereCondition = "FID IN (SELECT FID FROM T_HRCS_WARNCALFIELD WHERE FSOURCEID IN (" + splitIds + ") and FSOURCE='warnscene')";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRCS_WARNCALREFFIELD", exportFields, whereCondition, null, null);
        listMap.add(map);
        return listMap;
    }

    private List<Map<String, Object>> generateWarnScenePreSQL(List<Long> idList) {
        ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>(16);
        String exportFields = "FID,FDESCRIPTION,FNUMBER,FNAME,FDATAFILTER,FENABLE,FBIZAPPID,FSTARTDATE,FENDDATE,FREPEATPERIOD,FWEEKDAY,FMONTHDAY,FYEARDAY,FPUSHCHANNEL,FMERGEWAY,FMERGEDIMENSION,FISMERGEMSG,FRECEIVER,FMSGTITLE,FMSGMAIN,FMSGCONTENT,FJUMPHANDLE,FCOMMONCONDITION,FMONITORTIME,FCREATORID,FCREATETIME,FMODIFIERID,FMODIFYTIME,FISSYSPRESET,FVERSION";
        String splitIds = Joiner.on((String)",").join(idList);
        String whereCondition = "FID IN (" + splitIds + ")";
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        Map map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRCS_EARLYWARNSCENE", exportFields, whereCondition, null, null);
        listMap.add(map);
        String multiLanExportFields = "FLOCALEID,FPKID,FID,FDESCRIPTION,FNAME";
        String paramWhereCondition = "FID IN (" + splitIds + ") AND FLOCALEID='zh_CN'";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRCS_EARLYWARNSCENE_L", multiLanExportFields, paramWhereCondition, null, null);
        listMap.add(map);
        exportFields = "FENTRYID,FID,FTITLELINE,FDATALINE,FSEQRULE,FSEQ";
        whereCondition = "FID IN (" + splitIds + ")";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRCS_EARLYWARNSCENE_MSG", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FPKID,FENTRYID,FLOCALEID,FTITLELINE,FDATALINE";
        whereCondition = "FENTRYID IN (SELECT FENTRYID FROM T_HRCS_EARLYWARNSCENE_MSG WHERE FID IN (" + splitIds + ")) AND FLOCALEID='zh_CN'";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRCS_EARLYWARNSCENE_MSG_L", exportFields, whereCondition, null, null);
        listMap.add(map);
        return listMap;
    }

    private List<Map<String, Object>> generateWarnSceneRCPreSQL(List<Long> idList) {
        ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>(16);
        String splitIds = Joiner.on((String)",").join(idList);
        String exportFields = "FENTRYID,FSEQ,FRELATIONNAMEZDY,FRELATIONNAME,FRCDESCRIPTION,FDEPENDFIELD,FRELATIONCLASS,FRELATIONNAMEDISPLAY,FCREATEMODE,FID";
        String whereCondition = "FID IN (" + splitIds + ")";
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        Map map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRCS_EARLYWARNSCENE_RC", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = "FENTRYID,FLOCALEID,FPKID,FRELATIONNAMEZDY,FRCDESCRIPTION,FRELATIONNAMEDISPLAY";
        whereCondition = "FENTRYID IN (SELECT FENTRYID FROM T_HRCS_EARLYWARNSCENE_RC WHERE FID IN (" + splitIds + ")) AND FLOCALEID='zh_CN'";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRCS_EARLYWARNSCENE_RC_L", exportFields, whereCondition, null, null);
        listMap.add(map);
        return listMap;
    }

    private List<Map<String, Object>> generateWarnSchemePreSQL(List<Long> idList) {
        ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>(16);
        String exportFields = "FID,FNUMBER,FNAME,FSTATUS,FENABLE,FCREATEORGID,FORGID,FUSEORGID,FCTRLSTRATEGY,FSIMPLENAME,FDESCRIPTION,FPUSHCHANNELS,FMERGEWAY,FMERGEDIMENSION,FISMERGE,FRECEIVER,FMSGTITLE,FMSGMAIN,FMSGCONTENT,FJUMPHANDLE,FWARNSCENEID,FBIZAPPID,FISOPEN,FSTARTDATE,FENDDATE,FREPEATPERIOD,FWEEKDAY,FMONTHDAY,FYEARDAY,FJOBID,FPLANID,FMONITORTIME,FCREATORID,FMODIFIERID,FCREATETIME,FMODIFYTIME,FMASTERID,FINDEX,FISSYSPRESET,FDISABLERID,FDISABLEDATE,FSOURCEDATAID,FBITINDEX,FSOURCEBITINDEX,FBASECONDITION,FPUSHCHANNEL,FRECEIVERPROP,FISMERGEMSG";
        String splitIds = Joiner.on((String)",").join(idList);
        String whereCondition = "FID IN (" + splitIds + ")";
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        Map map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRCS_WARNSCHEME", exportFields, whereCondition, null, null);
        listMap.add(map);
        String multiLanExportFields = "FID,FLOCALEID,FPKID,FNAME,FSIMPLENAME,FDESCRIPTION";
        String paramWhereCondition = "FID IN (" + splitIds + ") AND FLOCALEID='zh_CN'";
        map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HRCS_WARNSCHEME_L", multiLanExportFields, paramWhereCondition, null, null);
        listMap.add(map);
        return listMap;
    }

    private void exportXmlFile(AbstractListPlugin listPlugIn, List<Map<String, StringWriter>> xmlFileList) {
        for (Map<String, StringWriter> longTextDataFile : xmlFileList) {
            for (Map.Entry<String, StringWriter> entry : longTextDataFile.entrySet()) {
                StringWriter sw = entry.getValue();
                byte[] xmlByteArray = sw.toString().getBytes(StandardCharsets.UTF_8);
                try {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlByteArray);
                    Throwable throwable = null;
                    try {
                        String fileName = this.getXmlFileName(entry);
                        this.exportFile(listPlugIn, inputStream, fileName);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                ((InputStream)inputStream).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((InputStream)inputStream).close();
                    }
                }
                catch (Exception e) {
                    throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("KSQLExpPlugin error:%s.", e.getMessage())});
                }
            }
        }
    }

    private String getXmlFileName(Map.Entry<String, StringWriter> entry) {
        String curDate = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        String xmlFileName = entry.getKey();
        xmlFileName = xmlFileName.substring(0, xmlFileName.lastIndexOf(46)) + "_" + curDate + ".xml";
        return xmlFileName;
    }

    private void exportFile(AbstractListPlugin listPlugIn, InputStream ins, String sqlFileName) {
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(sqlFileName, ins, 5000);
        listPlugIn.getView().openUrl(url);
    }
}

