/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.domain.service.earlywarn.joinentity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinEntityCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.common.model.earlywarn.WarnJoinEntityBo;

public class JoinEntityHelper {
    private static final String META_NUMBER_BOS_ENTITY_OBJECT = "bos_entityobject";

    public static List<WarnJoinEntityBo> assembleJoinEntities(List<DynamicObject> joinEntityList) {
        ArrayList joinEntities = Lists.newArrayListWithCapacity((int)joinEntityList.size());
        Set entityNums = joinEntityList.stream().map(dy -> dy.getString("entitynumber")).collect(Collectors.toSet());
        HRBaseServiceHelper entityHelper = new HRBaseServiceHelper(META_NUMBER_BOS_ENTITY_OBJECT);
        DynamicObjectCollection entityDys = entityHelper.queryOriginalCollection(String.join((CharSequence)",", "name", "number"), new QFilter[]{new QFilter("number", "in", entityNums)});
        Map<String, String> entityNumMap = entityDys.stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getString("name")));
        for (DynamicObject joinEntityDy : joinEntityList) {
            WarnJoinEntityBo joinEntity = new WarnJoinEntityBo();
            joinEntity.setId(joinEntityDy.getString("id"));
            joinEntity.setSource(joinEntityDy.getString("source"));
            joinEntity.setSourceId(joinEntityDy.getString("sourceid"));
            String type = joinEntityDy.getString("type");
            String longNumber = joinEntityDy.getString("longnumber");
            if (HRStringUtils.isEmpty((String)longNumber)) {
                if (HRStringUtils.equals((String)type, (String)"main")) {
                    joinEntity.setLongNumber("0");
                } else {
                    int index = joinEntityDy.getInt("index");
                    joinEntity.setLongNumber("0!" + index);
                }
            } else {
                joinEntity.setLongNumber(joinEntityDy.getString("longnumber"));
            }
            longNumber = joinEntity.getLongNumber();
            if (longNumber.contains("!")) {
                joinEntity.setParentLongNumber(longNumber.substring(0, longNumber.lastIndexOf("!")));
            } else {
                joinEntity.setParentLongNumber(null);
            }
            if (HRStringUtils.equals((String)longNumber, (String)"0")) {
                joinEntity.setLevel(Integer.valueOf(0));
            } else {
                String[] longNumberSp = longNumber.split("!");
                joinEntity.setLevel(Integer.valueOf(longNumberSp.length - 1));
            }
            joinEntity.setEntityNumber(joinEntityDy.getString("entitynumber"));
            joinEntity.setEntityAlias(joinEntityDy.getString("entityalias"));
            joinEntity.setType(joinEntityDy.getString("type"));
            joinEntity.setCore(joinEntityDy.getBoolean("iscore"));
            String entityName = entityNumMap.get(joinEntity.getEntityNumber());
            String[] split = joinEntity.getEntityAlias().split("\u03b4");
            if (split.length > 1) {
                joinEntity.setDisplayName(entityName + split[1]);
            } else {
                joinEntity.setDisplayName(entityName);
            }
            joinEntities.add(joinEntity);
        }
        return joinEntities.stream().sorted(Comparator.comparing(JoinEntityCommonBo::getLongNumber)).collect(Collectors.toList());
    }
}

