/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.domain.service.earlywarn.query;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.ReportQueryService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.SortFieldInfo;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinEntityCommonBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.PluginFieldCommonBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.WarnSchemeService;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.WarningSceneService;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.calfield.WarnCalcFieldService;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.query.WarnQFilterBuildUtils;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.query.function.PluginFieldAliasChangeFunction;
import kd.hr.hrcs.common.constants.earlywarn.WarnObjTplConstants;
import kd.hr.hrcs.common.constants.earlywarn.WarnSceneFieldConstants;
import kd.hr.hrcs.common.constants.earlywarn.WarnSchemeFieldConstants;
import kd.hr.hrcs.common.constants.earlywarn.WarningConstants;
import kd.hr.hrcs.common.constants.earlywarn.WarningSceneConstants;
import kd.hr.hrcs.common.model.earlywarn.WarnBaseConditionBo;
import kd.hr.hrcs.common.model.earlywarn.WarnCalFieldBo;
import kd.hr.hrcs.common.model.earlywarn.WarnCommonConditionBo;
import kd.hr.hrcs.common.model.earlywarn.WarnEntityRelationBo;
import kd.hr.hrcs.common.model.earlywarn.WarnJoinEntityBo;
import kd.hr.hrcs.common.model.earlywarn.WarnQueryFieldBo;
import kd.hr.hrcs.common.model.earlywarn.vo.WarnBaseConditionReturnVo;
import kd.hr.hrcs.common.util.earlywarn.WarnComplexObjTransferUtil;
import kd.hr.hrcs.common.util.earlywarn.WarnFilterUtils;

public class WarnQueryUtils
implements WarningConstants,
WarnObjTplConstants,
WarnSceneFieldConstants,
WarningSceneConstants,
WarnSchemeFieldConstants {
    private static final Log LOGGER = LogFactory.getLog(WarnQueryUtils.class);
    private static final HRBaseServiceHelper SCHEME_HELPER = new HRBaseServiceHelper("hrcs_warnscheme");
    private static final HRBaseServiceHelper OBJ_TPL_HELPER = new HRBaseServiceHelper("hrcs_warnobjtpl");

    public static Optional<DataSet> queryDataByWarnSchemeId(long schemeId) {
        try {
            return WarnQueryUtils.queryDataByWarnSchemeId(schemeId, -1, -1);
        }
        catch (Exception exception) {
            LOGGER.error("error:", (Throwable)exception);
            return Optional.empty();
        }
    }

    public static Optional<DataSet> queryDataByWarnSchemeId(long schemeId, int start, int limit) {
        try {
            HRComplexObjContext context = WarnQueryUtils.buildWarnQueryContext(schemeId, false);
            LOGGER.info("queryDataByWarnSchemeId_WarnQuery_context_is={}", (Object)context);
            DataSet dataSet = new ReportQueryService(context).queryDataSet(start, limit);
            return Optional.of(WarnQueryUtils.reconvertPluginFieldAlias(dataSet, context));
        }
        catch (Exception exception) {
            LOGGER.error("error:", (Throwable)exception);
            return Optional.empty();
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public static long queryDataCountByWarnSchemeId(long schemeId) {
        try {
            HRComplexObjContext context = WarnQueryUtils.buildWarnQueryContext(schemeId, true);
            LOGGER.info("queryDataCountByWarnSchemeId_WarnQuery_context_is={}", (Object)context);
            return new ReportQueryService(context).queryDataCount(-1, -1);
        }
        catch (Exception exception) {
            LOGGER.error("error:", (Throwable)exception);
            return 0L;
        }
    }

    private static HRComplexObjContext buildWarnQueryContext(long schemeId, boolean isCount) {
        String dataFilterStr;
        QFilter dataQFilter;
        DynamicObject schemeDy = SCHEME_HELPER.loadSingle((Object)schemeId);
        if (schemeDy == null) {
            LOGGER.error("schemeId_get_null_DynamicObj");
            throw new KDBizException("schemeId get null DynamicObj");
        }
        DynamicObject sceneDy = schemeDy.getDynamicObject("warnscene");
        WarningSceneService sceneService = WarningSceneService.getInstance();
        WarnCalcFieldService calcFieldService = WarnCalcFieldService.getInstance();
        List<WarnJoinEntityBo> joinEntities = sceneService.queryAllJoinEntitiesAndAssemble(sceneDy);
        List<WarnQueryFieldBo> queryFields = WarnQueryUtils.removeQueryFieldWithoutEntity(joinEntities, sceneService.queryAllQueryFieldsAndAssemble(sceneDy));
        List<WarnEntityRelationBo> entityRelations = sceneService.queryAllEntityRelationsAndAssemble(sceneDy);
        List<WarnCalFieldBo> calFieldBos = WarnQueryUtils.removeCalFieldWithoutQueryField(queryFields, calcFieldService.loadSceneAllFieldCalFieldsBySourceId(sceneDy));
        DynamicObject objTplDy = sceneDy.getDynamicObject("warnobjtpl");
        objTplDy = OBJ_TPL_HELPER.loadSingle(objTplDy.getPkValue());
        String objDataFilter = objTplDy.getString("datafilter");
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)3);
        QFilter objTplDataQFilter = WarnQFilterBuildUtils.getWarnSceneQFilters(objDataFilter, joinEntities, queryFields);
        if (objTplDataQFilter != null) {
            qFilters.add(objTplDataQFilter);
        }
        if ((dataQFilter = WarnQFilterBuildUtils.getWarnSceneQFilters(dataFilterStr = sceneDy.getString("datafilter"), joinEntities, queryFields)) != null) {
            qFilters.add(dataQFilter);
        }
        String commonConditionStr = sceneDy.getString("commoncondition");
        String baseConditionStr = schemeDy.getString("basecondition");
        List<PluginFieldCommonBo> pluginFields = WarnQueryUtils.getPluginFields(calFieldBos);
        WarnQueryUtils.setNewSchemeBaseConditionQFilterData(queryFields, qFilters, baseConditionStr, commonConditionStr);
        HRComplexObjContext context = WarnComplexObjTransferUtil.transferToComplexObjContext(joinEntities, queryFields, entityRelations, calFieldBos, (List)qFilters, pluginFields);
        if (!isCount) {
            WarnQueryUtils.setSortFieldInfo(context, schemeDy);
        }
        return context;
    }

    @ExcludeFromJacocoGeneratedReport
    private static void setSchemeBaseConditionQFilterData(long sceneId, List<WarnQueryFieldBo> queryFields, List<WarnCalFieldBo> calFieldBos, List<QFilter> qFilters, String baseConditionStr, List<PluginFieldCommonBo> pluginFields) {
        QFilter baseConditionQFilter;
        if (HRStringUtils.isNotEmpty((String)baseConditionStr) && (baseConditionQFilter = WarnFilterUtils.condition2QFilter4Warn((String)baseConditionStr, (String)SerializationUtils.toJsonString(queryFields))) != null) {
            qFilters.add(baseConditionQFilter);
        }
    }

    private static void setNewSchemeBaseConditionQFilterData(List<WarnQueryFieldBo> queryFields, List<QFilter> qFilters, String baseConditionStr, String commonConditionStr) {
        if (HRStringUtils.isNotEmpty((String)baseConditionStr) && HRStringUtils.isNotEmpty((String)commonConditionStr)) {
            WarnBaseConditionReturnVo baseConditionInfo = (WarnBaseConditionReturnVo)SerializationUtils.fromJsonString((String)baseConditionStr, WarnBaseConditionReturnVo.class);
            List commonConditions = JSONArray.parseArray((String)commonConditionStr, WarnCommonConditionBo.class);
            Map commonConditionMap = commonConditions.stream().collect(Collectors.toMap(WarnCommonConditionBo::getRuleValueUnique, Function.identity(), (oldValue, newValue) -> newValue));
            QFilter baseQFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
            List baseConditionBos = baseConditionInfo.getBaseConditionBos();
            boolean addBaseQFilter = false;
            for (WarnBaseConditionBo baseConditionBo : baseConditionBos) {
                String selectValue = baseConditionBo.getSelectValue();
                if (!HRStringUtils.isNotEmpty((String)selectValue)) continue;
                WarnCommonConditionBo commonConditionBo = (WarnCommonConditionBo)commonConditionMap.get(baseConditionBo.getRuleValueUnique());
                if (commonConditionBo != null) {
                    baseConditionBo.setOperator(commonConditionBo.getOperator());
                }
                addBaseQFilter = true;
                baseQFilter.and(WarnFilterUtils.condition2QFilter((WarnBaseConditionBo)baseConditionBo, queryFields, (List)Lists.newArrayListWithExpectedSize((int)10)));
            }
            if (addBaseQFilter) {
                qFilters.add(baseQFilter);
            }
        }
    }

    private static void setSortFieldInfo(HRComplexObjContext context, DynamicObject schemeDy) {
        List<DynamicObject> schemeMsgTableDyList = WarnSchemeService.getSchemeMsgTableDyList(schemeDy.getPkValue());
        LOGGER.info("WarnQueryUtils_getSchemeMsgTableDyList_size_={}", (Object)schemeMsgTableDyList.size());
        if (!schemeMsgTableDyList.isEmpty()) {
            ArrayList sortFieldInfoList = Lists.newArrayListWithExpectedSize((int)schemeMsgTableDyList.size());
            Map fieldInfoMap = context.getComplexObjFieldInfoList().stream().collect(Collectors.toMap(HRComplexObjFieldInfo::getAlias, Function.identity(), (oldValue, newValue) -> newValue));
            for (int rowIndex = 0; rowIndex < schemeMsgTableDyList.size(); ++rowIndex) {
                DynamicObject mainText = schemeMsgTableDyList.get(rowIndex);
                String dataLine = mainText.getString("dataline");
                String seqLine = mainText.getString("seqrule");
                if ("1".equals(seqLine)) continue;
                if (!"2".equals(seqLine) && !"3".equals(seqLine)) {
                    LOGGER.error("sort_field_order_value_error,fieldAlias={},order={}", (Object)dataLine, (Object)seqLine);
                    continue;
                }
                HRComplexObjFieldInfo fieldInfo = (HRComplexObjFieldInfo)fieldInfoMap.get(dataLine = dataLine.replaceFirst("#", ""));
                if (fieldInfo != null) {
                    SortFieldInfo sortFieldInfo = new SortFieldInfo();
                    sortFieldInfo.setFieldAlias(dataLine);
                    if ("2".equals(seqLine)) {
                        sortFieldInfo.setSortord(SortFieldInfo.SORTORD_ASC);
                    } else {
                        sortFieldInfo.setSortord(SortFieldInfo.SORTORD_DESC);
                    }
                    sortFieldInfo.setDataType(fieldInfo.getDataType());
                    sortFieldInfo.setDependSort(false);
                    sortFieldInfo.setSeq(rowIndex);
                    sortFieldInfoList.add(sortFieldInfo);
                    continue;
                }
                LOGGER.error("sort_field_is_not_in_query_field_error,fieldAlias={}", (Object)dataLine);
            }
            context.setSortFieldInfoList((List)sortFieldInfoList);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private static List<WarnQueryFieldBo> removeQueryFieldWithoutEntity(List<WarnJoinEntityBo> joinEntityBos, List<WarnQueryFieldBo> queryFieldBos) {
        if (queryFieldBos != null && !queryFieldBos.isEmpty()) {
            Set entityAliasSet = joinEntityBos.stream().map(JoinEntityCommonBo::getEntityAlias).collect(Collectors.toSet());
            LOGGER.info("removeQueryFieldWithoutEntity_original_field_{}", queryFieldBos);
            Iterator<WarnQueryFieldBo> iterator = queryFieldBos.iterator();
            while (iterator.hasNext()) {
                String entityAlias;
                WarnQueryFieldBo queryFieldBo = iterator.next();
                if (entityAliasSet.contains(queryFieldBo.getEntityNumber()) || entityAliasSet.contains(entityAlias = queryFieldBo.getFieldAlias().split("\\.")[0])) continue;
                iterator.remove();
                LOGGER.info("removeQueryFieldWithoutEntity_remove_field_{}", (Object)queryFieldBo);
            }
            LOGGER.info("removeQueryFieldWithoutEntity_after_field_{}", queryFieldBos);
        }
        return queryFieldBos;
    }

    @ExcludeFromJacocoGeneratedReport
    private static List<WarnCalFieldBo> removeCalFieldWithoutQueryField(List<WarnQueryFieldBo> queryFieldBos, List<WarnCalFieldBo> calFieldBos) {
        if (calFieldBos != null && !calFieldBos.isEmpty()) {
            Set<String> queryFieldAliasSet = queryFieldBos.stream().map(QueryFieldCommonBo::getFieldAlias).collect(Collectors.toSet());
            Iterator<WarnCalFieldBo> iterator = calFieldBos.iterator();
            while (iterator.hasNext()) {
                WarnCalFieldBo calFieldBo = iterator.next();
                WarnQueryUtils.removeCalFieldRefFieldError(iterator, calFieldBo, queryFieldAliasSet);
            }
        }
        return calFieldBos;
    }

    @ExcludeFromJacocoGeneratedReport
    private static boolean removeCalFieldRefFieldError(Iterator<WarnCalFieldBo> iterator, WarnCalFieldBo currentLevelCalFieldBo, Set<String> queryFieldAliasSet) {
        List refEntityFields = currentLevelCalFieldBo.getRefEntityFields();
        for (String refEntityField : refEntityFields) {
            if (queryFieldAliasSet.contains(refEntityField)) continue;
            iterator.remove();
            return true;
        }
        List refCalculateFields = currentLevelCalFieldBo.getRefCalculateFields();
        for (WarnCalFieldBo refCalculateField : refCalculateFields) {
            if (!WarnQueryUtils.removeCalFieldRefFieldError(iterator, refCalculateField, queryFieldAliasSet)) continue;
            return true;
        }
        return false;
    }

    @ExcludeFromJacocoGeneratedReport
    private static List<PluginFieldCommonBo> getPluginFields(List<WarnCalFieldBo> calFieldBos) {
        if (calFieldBos != null && !calFieldBos.isEmpty()) {
            ArrayList pluginFieldCommonBos = Lists.newArrayListWithExpectedSize((int)calFieldBos.size());
            Iterator<WarnCalFieldBo> iterator = calFieldBos.iterator();
            while (iterator.hasNext()) {
                WarnCalFieldBo calFieldBo = iterator.next();
                if (!"2".equals(calFieldBo.getConfWay())) continue;
                String serviceClass = calFieldBo.getServiceClass();
                if (HRStringUtils.isNotEmpty((String)serviceClass)) {
                    String[] keys = serviceClass.split("\\.");
                    if (keys.length == 2) {
                        String cloudNumber = WarningSceneService.getInstance().getCloudNumByAppNum(keys[0]);
                        if (HRStringUtils.isNotEmpty((String)cloudNumber)) {
                            PluginFieldCommonBo pluginFieldCommonBo = new PluginFieldCommonBo();
                            pluginFieldCommonBo.setFieldAlias("PLUGIN_FIELD_ALIAS_PREFIX_" + calFieldBo.getFieldNumber());
                            pluginFieldCommonBo.setMService(true);
                            pluginFieldCommonBo.setCloud(cloudNumber);
                            pluginFieldCommonBo.setApp(keys[0]);
                            pluginFieldCommonBo.setServicePath(keys[1]);
                            pluginFieldCommonBo.setDataType(DataTypeEnum.of((String)calFieldBo.getValueType()));
                            pluginFieldCommonBos.add(pluginFieldCommonBo);
                        } else {
                            LOGGER.warn("pluginField_serviceClass_appNum_error_{}", (Object)calFieldBo);
                        }
                    } else {
                        LOGGER.warn("pluginField_serviceClass_is_error_{}", (Object)calFieldBo);
                    }
                } else {
                    LOGGER.warn("pluginField_serviceClass_is_empty_{}", (Object)calFieldBo);
                }
                iterator.remove();
            }
            return pluginFieldCommonBos;
        }
        return Lists.newArrayListWithExpectedSize((int)0);
    }

    @ExcludeFromJacocoGeneratedReport
    private static DataSet reconvertPluginFieldAlias(DataSet dataSet, HRComplexObjContext context) {
        List<HRComplexObjFieldInfo> pluginFieldList = context.getComplexObjFieldInfoList().stream().filter(field -> "4".equals(field.getFieldType())).collect(Collectors.toList());
        if (!pluginFieldList.isEmpty()) {
            dataSet = dataSet.map((MapFunction)new PluginFieldAliasChangeFunction(pluginFieldList, dataSet.getRowMeta()));
        }
        return dataSet;
    }
}

