/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.earlywarn.log;

import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.Locale;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrcs.common.constants.earlywarn.EarlyWarnLogConstants;

@ExcludeFromJacocoGeneratedReport
public class EarlyWarnLogPlugin
extends HRDataBaseEdit
implements EarlyWarnLogConstants {
    private static final Log LOGGER = LogFactory.getLog(EarlyWarnLogPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        OperationStatus status = e.getFormShowParameter().getStatus();
        String caption = e.getFormShowParameter().getCaption();
        if (OperationStatus.VIEW.equals((Object)status)) {
            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s-\u6267\u884c\u65e5\u5fd7", (String)"EarlyWarnLogPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), caption);
            e.getFormShowParameter().setCaption(message);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Date endTime = (Date)this.getModelVal("endtime");
        Date startTime = (Date)this.getModelVal("starttime");
        this.getModel().setValue("exectime", (Object)(this.getTime(endTime) - this.getTime(startTime)));
    }

    private long getTime(Date date) {
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int hour = calendar.get(11);
            int minute = calendar.get(12);
            int second = calendar.get(13);
            return hour * 3600 + minute * 60 + second;
        }
        return 0L;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }
}

