/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.earlywarn.msgpersist;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.commonfield.BigIntField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.entity.commonfield.TimeField;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.msgpersist.MsgDataHeadFieldBo;
import kd.hr.hrcs.common.constants.msgpersist.MsgPersistConstants;
import kd.hr.hrcs.formplugin.web.earlywarn.msgpersist.control.GridBooleanProp;
import kd.hr.hrcs.formplugin.web.earlywarn.msgpersist.control.MsgShowEntryGrid;

public class MsgDataPersistEdit
extends HRDataBaseEdit
implements MsgPersistConstants {
    private static final Log LOGGER = LogFactory.getLog(MsgDataPersistEdit.class);
    private static final String CONTROL_SHOW_ENTITY_FLEX = "showentityflex";

    public void initialize() {
        try {
            super.initialize();
            this.getView().addCustomControls(new String[]{"showentity"});
        }
        catch (Exception exception) {
            LOGGER.error("initialize_error_", (Throwable)exception);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs eventArgs) {
        try {
            super.preOpenForm(eventArgs);
            FormShowParameter formShowParameter = eventArgs.getFormShowParameter();
            formShowParameter.setCaption(formShowParameter.getFormConfig().getCaption().getLocaleValue());
        }
        catch (Exception exception) {
            LOGGER.error("preOpenForm_error_", (Throwable)exception);
        }
    }

    public void beforeBindData(EventObject eventObject) {
        try {
            super.beforeBindData(eventObject);
            EntryAp entryAp = this.createEntryAp((BillShowParameter)this.getView().getFormShowParameter());
            Container container = (Container)this.getView().getControl(CONTROL_SHOW_ENTITY_FLEX);
            MsgShowEntryGrid entryGrid = (MsgShowEntryGrid)this.getView().getControl("showentity");
            List fieldEdits = ((Container)entryAp.buildRuntimeControl()).getItems();
            for (Control fieldEdit : fieldEdits) {
                fieldEdit.setView(this.getView());
                entryGrid.getItems().add(fieldEdit);
            }
            container.getItems().add(entryGrid);
        }
        catch (Exception exception) {
            LOGGER.error("beforeBindData_error_", (Throwable)exception);
        }
    }

    public void loadData(LoadDataEventArgs eventArgs) {
        try {
            super.loadData(eventArgs);
            this.getModel().putContextVariable("MODEL_BOSENTRYSERVERFILTERSORT", (Object)true);
        }
        catch (Exception exception) {
            LOGGER.error("loadData_error_", (Throwable)exception);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        try {
            super.beforeClosed(e);
            this.getModel().setDataChanged(false);
        }
        catch (Exception exception) {
            LOGGER.error("beforeClosed_error_", (Throwable)exception);
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs metasArgs) {
        try {
            super.loadCustomControlMetas(metasArgs);
            HashMap mapEntry = Maps.newHashMapWithExpectedSize((int)2);
            BillShowParameter showParameter = (BillShowParameter)metasArgs.getSource();
            EntryAp entryAp = this.createEntryAp(showParameter);
            ArrayList items = Lists.newArrayListWithExpectedSize((int)1);
            items.add(entryAp.createControl());
            mapEntry.put("id", CONTROL_SHOW_ENTITY_FLEX);
            mapEntry.put("items", items);
            metasArgs.getItems().add(mapEntry);
        }
        catch (Exception exception) {
            LOGGER.error("loadCustomControlMetas_error_", (Throwable)exception);
        }
    }

    public void afterBindData(EventObject eventObject) {
        try {
            super.afterBindData(eventObject);
            String msgTitle = this.getModel().getDataEntity().getString("msgtitle");
            String msgMain = this.getModel().getDataEntity().getString("msgmain");
            String msgEnd = this.getModel().getDataEntity().getString("msgend");
            Label msgTitleLabel = (Label)this.getControl("msgtitlelabel");
            Label msgMainLabel = (Label)this.getControl("msgmainlabel");
            Label msgEndLabel = (Label)this.getControl("msgendlabel");
            msgTitleLabel.setText(msgTitle);
            msgMainLabel.setText(msgMain);
            msgEndLabel.setText(msgEnd);
            MsgShowEntryGrid entryGrid = (MsgShowEntryGrid)this.getView().getControl("showentity");
            EntryData entryData = entryGrid.getEntryData();
            Map data = entryData.getData();
            Object rowCount = data.get("rowcount");
            if (rowCount == null || "0".equals(String.valueOf(rowCount))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"showentity"});
            }
            this.getView().setStatus(OperationStatus.VIEW);
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
        }
        catch (Exception exception) {
            LOGGER.error("afterBindData_error_", (Throwable)exception);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs eventArgs) {
        try {
            MainEntityType oldMainType = eventArgs.getOriginalEntityType();
            MainEntityType newMainType = (MainEntityType)oldMainType.clone();
            this.registerEntityType(newMainType);
            eventArgs.setNewEntityType(newMainType);
        }
        catch (Exception exception) {
            LOGGER.error("getEntityType_error_", (Throwable)exception);
        }
    }

    public void onGetControl(OnGetControlArgs controlArgs) {
        try {
            String key = controlArgs.getKey();
            IFormView source = (IFormView)controlArgs.getSource();
            if ("showentity".equals(key)) {
                EntryAp entryAp = this.createEntryAp((BillShowParameter)source.getFormShowParameter());
                EntryGrid entryGrid = (EntryGrid)entryAp.buildRuntimeControl();
                for (Control item : entryGrid.getItems()) {
                    item.setView(this.getView());
                }
                EntryGrid EntryGrid2 = this.newEntryGrid(entryGrid);
                EntryGrid2.setEntryKey(controlArgs.getKey());
                controlArgs.setControl((Control)EntryGrid2);
            }
        }
        catch (Exception exception) {
            LOGGER.error("onGetControl_error_", (Throwable)exception);
        }
    }

    private EntryAp createEntryAp(BillShowParameter showParameter) {
        EntryAp entryAp = new EntryAp();
        entryAp.setId("showentity");
        entryAp.setKey("showentity");
        entryAp.setShowSeq(true);
        List rowHeadFieldBos = JSONArray.parseArray((String)this.getMsgDataHeadFields(this.getView(), showParameter.getPkId()), MsgDataHeadFieldBo.class);
        if (rowHeadFieldBos != null && !rowHeadFieldBos.isEmpty()) {
            for (MsgDataHeadFieldBo rowHeadFieldBo : rowHeadFieldBos) {
                entryAp.getItems().add(this.createEntryFieldAp(rowHeadFieldBo));
            }
        }
        entryAp.setSplitPage(true);
        entryAp.setPageRow(10);
        entryAp.setPageType("nicety");
        entryAp.setHeight(new LocaleString("100%"));
        EntryEntity entryEntity = new EntryEntity();
        entryEntity.setKey(entryAp.getKey());
        entryEntity.setId(entryAp.getId());
        entryEntity.setName(new LocaleString(entryAp.getKey()));
        entryEntity.setDefaultRows(0);
        entryAp.setEntry(entryEntity);
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId("seq");
        fieldAp.setKey(fieldAp.getId());
        IntegerField field = new IntegerField();
        field.setKey(fieldAp.getId());
        field.setId(fieldAp.getId());
        fieldAp.setField((Field)field);
        entryAp.getItems().add(fieldAp);
        return entryAp;
    }

    private void registerEntityType(MainEntityType newMainType) {
        DataEntityPropertyCollection propertyCollection = newMainType.getProperties();
        EntryProp entryPropNew = new EntryProp();
        entryPropNew.setName("showentity");
        entryPropNew.setDbIgnore(true);
        entryPropNew.setDefaultRows(0);
        EntryType itemType = new EntryType();
        itemType.setName(entryPropNew.getName());
        itemType.setExtendName(entryPropNew.getName());
        entryPropNew.setItemType((IDataEntityType)itemType);
        Object msgId = ((BillShowParameter)this.getView().getFormShowParameter()).getPkId();
        List rowHeadFieldBos = JSONArray.parseArray((String)this.getMsgDataHeadFields(this.getView(), msgId), MsgDataHeadFieldBo.class);
        DataEntityPropertyCollection itemPropertyCollection = entryPropNew.getDynamicCollectionItemPropertyType().getProperties();
        if (rowHeadFieldBos != null && !rowHeadFieldBos.isEmpty()) {
            for (MsgDataHeadFieldBo rowHeadFieldBo : rowHeadFieldBos) {
                String controlType;
                Object fieldProp = null;
                if (DataTypeEnum.BOOLEAN.getDataTypeKey().equals(rowHeadFieldBo.getDataType())) {
                    fieldProp = new GridBooleanProp();
                } else if (DataTypeEnum.DATETIME.getDataTypeKey().equals(rowHeadFieldBo.getDataType())) {
                    controlType = rowHeadFieldBo.getControlType();
                    fieldProp = FieldControlType.DATE_TIME.getValue().equals(controlType) ? new DateTimeProp() : (FieldControlType.DATE.getValue().equals(controlType) ? new DateProp() : new DateTimeProp());
                } else if (DataTypeEnum.BIGDECIMAL.getDataTypeKey().equals(rowHeadFieldBo.getDataType())) {
                    fieldProp = new DecimalProp();
                } else if (DataTypeEnum.LONG.getDataTypeKey().equals(rowHeadFieldBo.getDataType())) {
                    fieldProp = new BigIntProp();
                } else if (DataTypeEnum.INTEGER.getDataTypeKey().equals(rowHeadFieldBo.getDataType())) {
                    fieldProp = new IntegerProp();
                } else {
                    controlType = rowHeadFieldBo.getControlType();
                    if (FieldControlType.COMBO.getValue().equals(controlType)) {
                        fieldProp = new ComboProp();
                        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)rowHeadFieldBo.getEntityNumber());
                        ComboProp property = (ComboProp)dataEntityType.getProperty(rowHeadFieldBo.getFieldPath());
                        if (property != null) {
                            List comboItems = property.getComboItems();
                            ArrayList newComboItems = Lists.newArrayListWithExpectedSize((int)comboItems.size());
                            for (ValueMapItem comboItem : comboItems) {
                                newComboItems.add(new ValueMapItem(comboItem.getImageKey(), comboItem.getName().getLocaleValue(), comboItem.getName()));
                            }
                            ((ComboProp)fieldProp).setComboItems((List)newComboItems);
                        }
                        fieldProp.setFilterControlType("combo");
                    } else {
                        fieldProp = new TextProp();
                    }
                }
                fieldProp.setDbIgnore(true);
                fieldProp.setDisplayName(new LocaleString(rowHeadFieldBo.getFieldName()));
                fieldProp.setName(rowHeadFieldBo.getFieldAliasWithDot());
                itemPropertyCollection.add(fieldProp);
            }
        }
        IntegerProp integerProp = new IntegerProp();
        integerProp.setName("seq");
        integerProp.setDbIgnore(true);
        itemPropertyCollection.add((Object)integerProp);
        propertyCollection.add((Object)entryPropNew);
    }

    private EntryGrid newEntryGrid(EntryGrid oldEntryGrid) {
        MsgShowEntryGrid newEntryGrid = new MsgShowEntryGrid();
        newEntryGrid.getItems().addAll(oldEntryGrid.getItems());
        newEntryGrid.setKey(oldEntryGrid.getKey());
        newEntryGrid.setEntryKey(oldEntryGrid.getEntryKey());
        newEntryGrid.setModel(oldEntryGrid.getModel());
        newEntryGrid.setView(this.getView());
        newEntryGrid.setSplitPage(true);
        newEntryGrid.setPageRow(10);
        return newEntryGrid;
    }

    private EntryFieldAp createEntryFieldAp(MsgDataHeadFieldBo rowHeadFieldBo) {
        EntryFieldAp entryFieldAp = new EntryFieldAp();
        entryFieldAp.setId(rowHeadFieldBo.getFieldAliasWithDot());
        entryFieldAp.setKey(rowHeadFieldBo.getFieldAliasWithDot());
        entryFieldAp.setWidth(new LocaleString("100px"));
        entryFieldAp.setName(new LocaleString(rowHeadFieldBo.getFieldName()));
        Object field = null;
        if (DataTypeEnum.BOOLEAN.getDataTypeKey().equals(rowHeadFieldBo.getDataType())) {
            CheckBoxField checkBoxField = new CheckBoxField();
            checkBoxField.setShowStyle(2);
            field = checkBoxField;
        } else if (DataTypeEnum.DATETIME.getDataTypeKey().equals(rowHeadFieldBo.getDataType())) {
            String controlType = rowHeadFieldBo.getControlType();
            field = FieldControlType.DATE_TIME.getValue().equals(controlType) ? new DateTimeField() : (FieldControlType.DATE.getValue().equals(controlType) ? new DateField() : new DateTimeField());
            entryFieldAp.setMask(rowHeadFieldBo.getDateShowFormatMask());
        } else if (DataTypeEnum.BIGDECIMAL.getDataTypeKey().equals(rowHeadFieldBo.getDataType())) {
            DecimalField decimalField = new DecimalField();
            decimalField.setPrecision(rowHeadFieldBo.getPrecision());
            decimalField.setScale(rowHeadFieldBo.getScale());
            decimalField.setZeroShow(rowHeadFieldBo.isZeroShow());
            field = decimalField;
        } else if (DataTypeEnum.LONG.getDataTypeKey().equals(rowHeadFieldBo.getDataType())) {
            field = new BigIntField();
        } else if (DataTypeEnum.INTEGER.getDataTypeKey().equals(rowHeadFieldBo.getDataType())) {
            if (FieldControlType.TIME.getValue().equals(rowHeadFieldBo.getControlType())) {
                entryFieldAp.setMask(rowHeadFieldBo.getDateShowFormatMask());
                field = new TimeField();
            } else {
                field = new IntegerField();
            }
        } else {
            String controlType = rowHeadFieldBo.getControlType();
            if (FieldControlType.COMBO.getValue().equals(controlType)) {
                field = new ComboField();
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)rowHeadFieldBo.getEntityNumber());
                ComboProp property = (ComboProp)dataEntityType.getProperty(rowHeadFieldBo.getFieldPath());
                if (property != null) {
                    List comboItems = property.getComboItems();
                    ArrayList comboItemList = Lists.newArrayListWithExpectedSize((int)comboItems.size());
                    for (int index = 0; index < comboItems.size(); ++index) {
                        ValueMapItem comboItem = (ValueMapItem)comboItems.get(index);
                        comboItemList.add(new ComboItem(index, comboItem.getName(), comboItem.getName().getLocaleValue(), comboItem.getImageKey()));
                    }
                    ((ComboField)field).setItems((List)comboItemList);
                }
            } else {
                field = new TextField();
            }
        }
        field.setId(rowHeadFieldBo.getFieldAliasWithDot());
        field.setKey(rowHeadFieldBo.getFieldAliasWithDot());
        entryFieldAp.setField((Field)field);
        return entryFieldAp;
    }
}

