/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.earlywarn.msgpersist.control.function;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.FilterFunction;
import kd.bos.algox.RowX;
import kd.bos.service.KDDateUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.msgpersist.MsgDataHeadFieldBo;
import kd.hr.hrcs.common.constants.msgpersist.MsgPersistConstants;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

@ExcludeFromJacocoGeneratedReport
public class RowDataFilterFunction
extends FilterFunction
implements MsgPersistConstants {
    private static final long serialVersionUID = -707592643110883174L;
    private final MsgDataHeadFieldBo msgDataHeadFieldBo;
    private final String fieldName;
    private final String compareType;
    private final Object value;
    private final Map<String, Integer> indexMap;
    private final TimeZone sysTimeZone = KDDateUtils.getSysTimeZone();
    private final TimeZone userTimeZone = KDDateUtils.getTimeZone();
    private final Calendar calendar = Calendar.getInstance(this.userTimeZone);

    public RowDataFilterFunction(RowMeta rowMeta, MsgDataHeadFieldBo msgDataHeadFieldBo, String fieldName, String compareType, Object value) {
        this.fieldName = fieldName;
        this.msgDataHeadFieldBo = msgDataHeadFieldBo;
        this.compareType = compareType;
        if (FieldControlType.CHECKBOX.getValue().equals(msgDataHeadFieldBo.getControlType())) {
            value = value instanceof Collection ? ((Collection)value).stream().map(obj -> "1".equals(String.valueOf(obj))).collect(Collectors.toList()) : ("1".equals(String.valueOf(value)) ? Boolean.valueOf(true) : Boolean.valueOf(false));
        }
        this.value = value;
        Field[] fields = rowMeta.getFields();
        this.indexMap = Maps.newHashMapWithExpectedSize((int)fields.length);
        for (int index = 0; index < fields.length; ++index) {
            this.indexMap.put(fields[index].getAlias(), index);
        }
    }

    public boolean test(RowX rowX) {
        Object checkValue = rowX.get(this.indexMap.get(this.fieldName).intValue());
        switch (this.compareType) {
            case "83": {
                return this.notEquals(checkValue, this.value);
            }
            case "17": {
                return this.inCheck(checkValue, this.value);
            }
            case "34": {
                return this.notInCheck(checkValue, this.value);
            }
            case "37": {
                return HRStringUtils.isEmpty((String)String.valueOf(checkValue)) || Objects.isNull(checkValue);
            }
            case "9": {
                return HRStringUtils.isNotEmpty((String)String.valueOf(checkValue)) && Objects.nonNull(checkValue);
            }
            case "59": {
                return this.checkContains(checkValue, this.value);
            }
            case "60": {
                return this.checkStartWith(checkValue, this.value);
            }
            case "211": {
                return this.checkEndWith(checkValue, this.value);
            }
            case "58": {
                return this.checkNotContains(checkValue, this.value);
            }
            case "21": {
                if (checkValue instanceof Date || this.value instanceof Date) {
                    return this.dateMoreThan(checkValue, this.value);
                }
                return this.numberMoreThan(checkValue, this.value);
            }
            case "65": {
                if (checkValue instanceof Date || this.value instanceof Date) {
                    return this.dateMoreEquals(checkValue, this.value);
                }
                return this.numberMoreEquals(checkValue, this.value);
            }
            case "36": {
                if (checkValue instanceof Date || this.value instanceof Date) {
                    return this.dateLessThan(checkValue, this.value);
                }
                return this.numberLessThan(checkValue, this.value);
            }
            case "19": {
                if (checkValue instanceof Date || this.value instanceof Date) {
                    return this.dateLessEquals(checkValue, this.value);
                }
                return this.numberLessEquals(checkValue, this.value);
            }
            case "13": {
                return this.timeCompare(checkValue, false, this.getCurrentUserDateTime().withTimeAtStartOfDay(), this.getCurrentUserDateTime().millisOfDay().withMaximumValue());
            }
            case "10": {
                return this.timeCompare(checkValue, false, this.getCurrentUserDateTime().dayOfWeek().withMinimumValue().withTimeAtStartOfDay(), this.getCurrentUserDateTime().dayOfWeek().withMaximumValue().millisOfDay().withMaximumValue());
            }
            case "63": {
                return this.timeCompare(checkValue, false, this.getCurrentUserDateTime().dayOfMonth().withMinimumValue().withTimeAtStartOfDay(), this.getCurrentUserDateTime().dayOfMonth().withMaximumValue().millisOfDay().withMaximumValue());
            }
            case "92": {
                return this.timeCompare(checkValue, false, this.getCurrentUserDateTime().minusMonths(1).dayOfMonth().withMinimumValue().withTimeAtStartOfDay(), this.getCurrentUserDateTime().minusMonths(1).dayOfMonth().withMaximumValue().millisOfDay().withMaximumValue());
            }
            case "51": {
                return this.timeCompare(checkValue, false, this.getCurrentUserDateTime().minusMonths(1), this.getCurrentUserDateTime());
            }
            case "24": {
                return this.timeCompare(checkValue, false, this.getCurrentUserDateTime().minusMonths(3), this.getCurrentUserDateTime());
            }
            case "1": {
                if (this.value instanceof List && ((List)this.value).size() > 1) {
                    return this.timeCompare(checkValue, false, this.getDateTime(((List)this.value).get(0), false), this.getDateTime(((List)this.value).get(1), false));
                }
                return false;
            }
        }
        return this.isEquals(checkValue, this.value);
    }

    private boolean checkContains(Object checkValue, Object compareValue) {
        return Objects.nonNull(checkValue) && String.valueOf(checkValue).contains(String.valueOf(compareValue));
    }

    private boolean checkNotContains(Object checkValue, Object compareValue) {
        return Objects.isNull(checkValue) || !String.valueOf(checkValue).contains(String.valueOf(compareValue));
    }

    private boolean checkStartWith(Object checkValue, Object compareValue) {
        return Objects.nonNull(checkValue) && String.valueOf(checkValue).startsWith(String.valueOf(compareValue));
    }

    private boolean checkEndWith(Object checkValue, Object compareValue) {
        return Objects.nonNull(checkValue) && String.valueOf(checkValue).endsWith(String.valueOf(compareValue));
    }

    private boolean isEquals(Object checkValue, Object compareValue) {
        if (checkValue instanceof Date) {
            DateTime dateTime = this.getDateTime(compareValue, false);
            if (dateTime == null) {
                return false;
            }
            return String.valueOf(((Date)checkValue).getTime()).equals(String.valueOf(dateTime.getMillis()));
        }
        if (DataTypeEnum.BIGDECIMAL.getDataTypeKey().equals(this.msgDataHeadFieldBo.getDataType())) {
            BigDecimal checkNum = this.parseBigDecimal(checkValue);
            BigDecimal compareNum = this.parseBigDecimal(compareValue);
            if (checkNum == null && compareNum == null) {
                return true;
            }
            if (checkNum != null && compareNum != null) {
                int scale = checkNum.scale();
                compareNum = compareNum.setScale(scale, RoundingMode.UNNECESSARY);
                return checkNum.equals(compareNum);
            }
            return false;
        }
        return String.valueOf(checkValue).equals(String.valueOf(compareValue));
    }

    private boolean notEquals(Object checkValue, Object compareValue) {
        return !this.isEquals(checkValue, compareValue);
    }

    private boolean numberLessEquals(Object checkValue, Object compareValue) {
        return this.numberCompare(checkValue, String.valueOf(compareValue), Arrays.asList(-1, 0));
    }

    private boolean dateLessEquals(Object checkValue, Object compareValue) {
        return this.dateCompare(checkValue, String.valueOf(compareValue), Arrays.asList(-1, 0));
    }

    private boolean numberLessThan(Object checkValue, Object compareValue) {
        return this.numberCompare(checkValue, String.valueOf(compareValue), Collections.singletonList(-1));
    }

    private boolean dateLessThan(Object checkValue, Object compareValue) {
        return this.dateCompare(checkValue, String.valueOf(compareValue), Collections.singletonList(-1));
    }

    private boolean numberMoreEquals(Object checkValue, Object compareValue) {
        return this.numberCompare(checkValue, String.valueOf(compareValue), Arrays.asList(1, 0));
    }

    private boolean dateMoreEquals(Object checkValue, Object compareValue) {
        return this.dateCompare(checkValue, String.valueOf(compareValue), Arrays.asList(1, 0));
    }

    private boolean numberMoreThan(Object checkValue, Object compareValue) {
        return this.numberCompare(checkValue, String.valueOf(compareValue), Collections.singletonList(1));
    }

    private boolean dateMoreThan(Object checkValue, Object compareValue) {
        return this.dateCompare(checkValue, String.valueOf(compareValue), Collections.singletonList(1));
    }

    private boolean inCheck(Object checkValue, Object compareValue) {
        if (Objects.isNull(checkValue) || Objects.isNull(compareValue)) {
            return false;
        }
        Set<Object> valueSet = compareValue instanceof Collection ? ((Collection)compareValue).stream().map(String::valueOf).collect(Collectors.toSet()) : new HashSet<String>(Arrays.asList(String.valueOf(compareValue).split(",")));
        return valueSet.contains(String.valueOf(checkValue));
    }

    private boolean notInCheck(Object checkValue, Object compareValue) {
        return !this.inCheck(checkValue, compareValue);
    }

    private boolean numberCompare(Object condition, String value, List<Integer> resultList) {
        BigDecimal conditionValue = this.parseBigDecimal(condition);
        if (Objects.isNull(conditionValue)) {
            return false;
        }
        BigDecimal compareValue = this.parseBigDecimal(value);
        int result = conditionValue.compareTo(compareValue);
        return resultList.contains(result);
    }

    private boolean dateCompare(Object condition, String value, List<Integer> resultList) {
        DateTime conditionTime = this.getDateTime(condition, false);
        DateTime compareValue = this.getDateTime(value, false);
        if (conditionTime == null) {
            return false;
        }
        int result = conditionTime.compareTo((ReadableInstant)compareValue);
        return resultList.contains(result);
    }

    private boolean timeCompare(Object condition, boolean needChangeTimeZone, DateTime startTime, DateTime endTime) {
        DateTime time = this.getDateTime(condition, needChangeTimeZone);
        if (time == null) {
            return false;
        }
        return startTime.minusMillis(1).isBefore((ReadableInstant)time) && endTime.plusMillis(1).isAfter((ReadableInstant)time);
    }

    private BigDecimal parseBigDecimal(Object value) {
        try {
            if (Objects.isNull(value) || HRStringUtils.isEmpty((String)String.valueOf(value))) {
                return null;
            }
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            return new BigDecimal(String.valueOf(value));
        }
        catch (NumberFormatException nf) {
            return null;
        }
    }

    private DateTime getDateTime(Object value, boolean needChangeTimeZone) {
        DateTime time;
        if (value instanceof String) {
            try {
                if (needChangeTimeZone) {
                    time = new DateTime((Object)HRDateTimeUtils.parseDate((String)String.valueOf(value), (TimeZone)this.userTimeZone));
                }
                time = new DateTime((Object)HRDateTimeUtils.parseDate((String)String.valueOf(value), (TimeZone)this.sysTimeZone));
            }
            catch (ParseException e) {
                return null;
            }
        } else if (value instanceof Date) {
            time = new DateTime(value);
        } else {
            return null;
        }
        return time;
    }

    private DateTime getCurrentUserDateTime() {
        return new DateTime(this.calendar.getTimeInMillis());
    }
}

