/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.earlywarn.objecttpl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.CustomEventArgs;
import kd.hr.hbp.business.service.labelandreport.FieldDefineService;
import kd.hr.hbp.common.model.complexobj.labelandreport.EntityRelationCommonBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinEntityCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrcs.common.model.earlywarn.WarnCalFieldBo;
import kd.hr.hrcs.common.model.earlywarn.WarnEntityRelationBo;
import kd.hr.hrcs.common.model.earlywarn.WarnJoinEntityBo;
import kd.hr.hrcs.common.model.earlywarn.WarnQueryFieldBo;
import kd.hr.hrcs.common.util.earlywarn.WarnComplexObjTransferUtil;
import kd.hr.hrcs.formplugin.web.earlywarn.objecttpl.WarnObjTplCommonProcessor;

public class WarnObjTplDataProcessor
extends WarnObjTplCommonProcessor {
    private static final String DATA_SOURCE = "changeDataSourceConfirm_dataSource";

    public WarnObjTplDataProcessor(HRDataBaseEdit plugin) {
        super(plugin);
    }

    public void getAllData(CustomEventArgs args) {
        Map dataMap = (Map)SerializationUtils.fromJsonString((String)args.getEventArgs(), Map.class);
        Object entityNodes = dataMap.get("entityNodes");
        String joinEntitiesStr = SerializationUtils.toJsonString(entityNodes);
        this.getView().getPageCache().put("joinEntities", joinEntitiesStr);
        List entityRelationBos = Lists.newArrayListWithCapacity((int)10);
        if (HRStringUtils.isNotEmpty((String)joinEntitiesStr)) {
            List queryEntityBos = JSON.parseArray((String)joinEntitiesStr, WarnJoinEntityBo.class);
            List entityRelationCommonBos = queryEntityBos.stream().map(JoinEntityCommonBo::getEntityRelation).filter(Objects::nonNull).collect(Collectors.toList());
            entityRelationBos = WarnComplexObjTransferUtil.reverseEntityRelationBos(entityRelationCommonBos);
        }
        this.getView().getPageCache().put("entityRelations", SerializationUtils.toJsonString((Object)entityRelationBos));
        Object queryFields = dataMap.get("queryFields");
        List<WarnQueryFieldBo> queryFieldBos = this.getSelectedQueryFields(queryFields);
        this.getView().getPageCache().put("queryFields", SerializationUtils.toJsonString(queryFieldBos));
        Object calFields = dataMap.get("calFields");
        List calculateFieldBos = Lists.newArrayListWithCapacity((int)10);
        String calFieldsStr = SerializationUtils.toJsonString(calFields);
        if (HRStringUtils.isNotEmpty((String)calFieldsStr)) {
            calculateFieldBos = JSON.parseArray((String)calFieldsStr, WarnCalFieldBo.class);
        }
        this.getView().getPageCache().put("calculateFields", SerializationUtils.toJsonString((Object)calculateFieldBos));
        String operate = (String)dataMap.get("operate");
        if (HRStringUtils.equals((String)operate, (String)"dataPreview")) {
            this.getView().invokeOperation("previewdata");
        } else if (HRStringUtils.equals((String)operate, (String)"nextStep")) {
            this.getView().invokeOperation("nextstep");
        } else if (HRStringUtils.equals((String)operate, (String)"save")) {
            this.getView().invokeOperation("save");
        }
    }

    public boolean validateFieldDefineData(String op) {
        List joinEntities = Collections.emptyList();
        List entityRelations = Collections.emptyList();
        List queryFields = Collections.emptyList();
        List calculateFields = Collections.emptyList();
        String joinEntitiesStr = this.getView().getPageCache().get("joinEntities");
        String queryFieldsStr = this.getView().getPageCache().get("queryFields");
        String entityRelationsStr = this.getView().getPageCache().get("entityRelations");
        String calculateFieldsStr = this.getView().getPageCache().get("calculateFields");
        if (HRStringUtils.isNotEmpty((String)joinEntitiesStr)) {
            joinEntities = JSON.parseArray((String)joinEntitiesStr, WarnJoinEntityBo.class);
        }
        if (HRStringUtils.isNotEmpty((String)entityRelationsStr)) {
            entityRelations = JSON.parseArray((String)entityRelationsStr, WarnEntityRelationBo.class);
        }
        if (HRStringUtils.isEmpty((String)joinEntitiesStr) || joinEntities.isEmpty()) {
            String dataSource = this.getView().getPageCache().get(DATA_SOURCE);
            if (HRStringUtils.equals((String)dataSource, (String)"virtual")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u865a\u62df\u5bf9\u8c61\u540e\u91cd\u8bd5\u3002", (String)"WarnObjDataProcessor_17", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u540e\u91cd\u8bd5\u3002", (String)"WarnObjDataProcessor_12", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        for (WarnJoinEntityBo joinEntity : joinEntities) {
            if (HRStringUtils.equals((String)joinEntity.getType(), (String)"main")) continue;
            Optional<WarnEntityRelationBo> relationOptional = entityRelations.stream().filter(relation -> relation != null && HRStringUtils.isNotEmpty((String)relation.getEntityAlias()) && HRStringUtils.equals((String)relation.getJoinEntityAlias(), (String)joinEntity.getEntityAlias())).findAny();
            boolean noSet = false;
            if (relationOptional.isPresent()) {
                EntityRelationCommonBo entityRelation;
                List conditions;
                if (HRStringUtils.equals((String)relationOptional.get().getJoinType(), (String)"none")) {
                    noSet = true;
                }
                if ((conditions = (entityRelation = (EntityRelationCommonBo)relationOptional.get()).getConditions()) == null || conditions.isEmpty() || HRStringUtils.isEmpty((String)entityRelation.getJoinType())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u4e1a\u52a1\u5bf9\u8c61\u672a\u8bbe\u7f6e\u5173\u8054\u5173\u7cfb\u6761\u4ef6\uff0c\u8bf7\u64cd\u4f5c\u540e\u91cd\u8bd5\u3002", (String)"WarnObjDataProcessor_24", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                    return false;
                }
            } else {
                noSet = true;
            }
            if (!noSet) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u4e1a\u52a1\u5bf9\u8c61\u672a\u8bbe\u7f6e\u5173\u8054\u5173\u7cfb\uff0c\u8bf7\u64cd\u4f5c\u540e\u91cd\u8bd5\u3002", (String)"WarnObjDataProcessor_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (HRStringUtils.isNotEmpty((String)queryFieldsStr)) {
            queryFields = JSON.parseArray((String)queryFieldsStr, WarnQueryFieldBo.class);
        }
        if (HRStringUtils.isNotEmpty((String)calculateFieldsStr)) {
            calculateFields = JSON.parseArray((String)calculateFieldsStr, WarnCalFieldBo.class);
        }
        if (queryFields.isEmpty() && calculateFields.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u5b57\u6bb5\u540e\u91cd\u8bd5\u3002", (String)"WarnObjDataProcessor_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (queryFields.isEmpty()) {
            boolean hasSelected = false;
            for (WarnCalFieldBo calculateField : calculateFields) {
                if (!calculateField.getSelected().booleanValue()) continue;
                hasSelected = true;
                break;
            }
            if (!hasSelected) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u5b57\u6bb5\u540e\u91cd\u8bd5\u3002", (String)"WarnObjDataProcessor_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (HRStringUtils.equals((String)op, (String)"save")) {
                return true;
            }
        }
        return true;
    }

    public void confirmChangeDataSource(int result) {
        String dataSource = this.getView().getPageCache().get(DATA_SOURCE);
        if (result == MessageBoxResult.Yes.getValue()) {
            this.changeDataSource(dataSource);
        } else if (HRStringUtils.equals((String)dataSource, (String)"virtual")) {
            this.getView().getPageCache().put(DATA_SOURCE, "business");
        } else {
            this.getView().getPageCache().put(DATA_SOURCE, "virtual");
        }
    }

    private void changeDataSource(String dataSource) {
        FieldDefineService fieldDefineService = new FieldDefineService();
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        dataMap.put("method", "changeDataSource");
        List dataSourceCloudBos = fieldDefineService.getDataSourceTree();
        dataMap.put("dataSource", dataSourceCloudBos);
        dataMap.put("entities", fieldDefineService.getAllEntities(dataSourceCloudBos));
        dataMap.put("time", new Date());
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        customcontrol.setData((Object)dataMap);
        this.clearEntityAndFields();
    }

    private void clearEntityAndFields() {
        this.getView().getPageCache().remove("allFieldTreeNodes");
        this.getView().getPageCache().remove("joinEntities");
        this.getView().getPageCache().remove("entityRelations");
        this.getView().getPageCache().remove("queryFields");
        this.getView().getPageCache().remove("calculateFields");
    }

    public boolean validateNumber(String nextTab) {
        if (HRStringUtils.equals((String)nextTab, (String)"definefield")) {
            String number = (String)this.getModel().getValue("number");
            return Pattern.matches("^[a-zA-Z0-9_]*$", number);
        }
        return true;
    }
}

