/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.earlywarn.objecttpl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.ext.hr.filter.control.HRFilter;
import kd.bos.ext.hr.ruleengine.utils.RuleUtil;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.service.labelandreport.AnobjFilterUtil;
import kd.hr.hbp.business.service.labelandreport.FieldDefineService;
import kd.hr.hbp.common.model.complexobj.labelandreport.DataSourceCloudBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.FieldTreeNode;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.WarnObjTplService;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.calfield.WarnCalcFieldService;
import kd.hr.hrcs.common.model.earlywarn.WarnCalFieldBo;
import kd.hr.hrcs.common.model.earlywarn.WarnEntityRelationBo;
import kd.hr.hrcs.common.model.earlywarn.WarnJoinEntityBo;
import kd.hr.hrcs.common.model.earlywarn.WarnQueryFieldBo;
import kd.hr.hrcs.common.util.earlywarn.WarnComplexObjTransferUtil;
import kd.hr.hrcs.formplugin.web.earlywarn.objecttpl.WarnObjTplCommonProcessor;
import kd.hr.hrcs.formplugin.web.earlywarn.scene.enums.WarnSceneControlSceneEnum;

public class WarnObjTplInitProcessor
extends WarnObjTplCommonProcessor {
    public WarnObjTplInitProcessor(HRDataBaseEdit plugin) {
        super(plugin);
    }

    public void initData() {
        if (this.getModel().getDataEntity().getDataEntityState().getFromDatabase()) {
            WarnObjTplService anObjService = WarnObjTplService.getInstance();
            Long id = (Long)this.getModel().getValue("id");
            List joinEntities = anObjService.queryAndAssembleJoinEntities(id);
            List queryFields = anObjService.queryAndAssembleQueryFields(id);
            List entityRelations = anObjService.queryAndAssembleEntityRelations(id);
            for (WarnEntityRelationBo entityRelation : entityRelations) {
                joinEntities.stream().filter(entityBo -> HRStringUtils.equals((String)entityBo.getEntityAlias(), (String)entityRelation.getJoinEntityAlias())).findAny().ifPresent(entityBo -> entityBo.setEntityRelation(entityRelation));
            }
            for (WarnEntityRelationBo entityRelation : entityRelations) {
                if (!HRStringUtils.equals((String)entityRelation.getJoinType(), (String)"RightJoin")) continue;
                entityRelation.setJoinType(null);
            }
            WarnCalcFieldService calFieldService = WarnCalcFieldService.getInstance();
            List calculateFields = calFieldService.loadAllFieldCalFieldsBySourceIdForBo((Object)id, true);
            boolean warnObjRefByScene = anObjService.isWarnObjRefByScene(id);
            this.getView().getPageCache().put("joinEntities", SerializationUtils.toJsonString((Object)joinEntities));
            this.getView().getPageCache().put("queryFields", SerializationUtils.toJsonString((Object)queryFields));
            this.getView().getPageCache().put("originQueryFields", SerializationUtils.toJsonString((Object)queryFields));
            this.getView().getPageCache().put("entityRelations", SerializationUtils.toJsonString((Object)entityRelations));
            this.getView().getPageCache().put("calculateFields", SerializationUtils.toJsonString((Object)calculateFields));
            this.getView().getPageCache().put("warnObjRefByScheme", String.valueOf(warnObjRefByScene));
        }
    }

    public void initData(Long sourceWarnObjTplId, Long newWarnObjTplId) {
        WarnObjTplService anObjService = WarnObjTplService.getInstance();
        List joinEntities = anObjService.queryAndAssembleJoinEntities(sourceWarnObjTplId);
        List queryFields = anObjService.queryAndAssembleQueryFields(sourceWarnObjTplId);
        List entityRelations = anObjService.queryAndAssembleEntityRelations(sourceWarnObjTplId);
        for (WarnEntityRelationBo entityRelation : entityRelations) {
            joinEntities.stream().filter(entityBo -> HRStringUtils.equals((String)entityBo.getEntityAlias(), (String)entityRelation.getJoinEntityAlias())).findAny().ifPresent(entityBo -> entityBo.setEntityRelation(entityRelation));
        }
        for (WarnEntityRelationBo entityRelation : entityRelations) {
            if (!HRStringUtils.equals((String)entityRelation.getJoinType(), (String)"RightJoin")) continue;
            entityRelation.setJoinType(null);
        }
        WarnCalcFieldService calFieldService = WarnCalcFieldService.getInstance();
        List calculateFields = calFieldService.loadAllFieldCalFieldsBySourceIdForBo((Object)sourceWarnObjTplId, true);
        boolean warnObjRefByScene = anObjService.isWarnObjRefByScene(sourceWarnObjTplId);
        for (WarnJoinEntityBo warnJoinEntityBo : joinEntities) {
            warnJoinEntityBo.setSourceId(String.valueOf(newWarnObjTplId));
        }
        for (WarnQueryFieldBo warnQueryFieldBo : queryFields) {
            warnQueryFieldBo.setSourceId(String.valueOf(newWarnObjTplId));
        }
        for (WarnEntityRelationBo warnEntityRelationBo : entityRelations) {
            warnEntityRelationBo.setSourceId(String.valueOf(newWarnObjTplId));
        }
        this.getView().getPageCache().put("joinEntities", SerializationUtils.toJsonString((Object)joinEntities));
        this.getView().getPageCache().put("queryFields", SerializationUtils.toJsonString((Object)queryFields));
        this.getView().getPageCache().put("originQueryFields", SerializationUtils.toJsonString((Object)queryFields));
        this.getView().getPageCache().put("entityRelations", SerializationUtils.toJsonString((Object)entityRelations));
        this.getView().getPageCache().put("calculateFields", SerializationUtils.toJsonString((Object)calculateFields));
        this.getView().getPageCache().put("warnObjRefByScheme", String.valueOf(warnObjRefByScene));
    }

    public void initDataFilter() {
        HRFilter hrFilter;
        ArrayList WarnQueryFieldBos = Lists.newArrayListWithExpectedSize((int)16);
        String fieldTreeNodeStr = this.getView().getPageCache().get("allFieldTreeNodes");
        if (HRStringUtils.isEmpty((String)fieldTreeNodeStr)) {
            return;
        }
        List fieldTreeNodes = JSON.parseArray((String)fieldTreeNodeStr, FieldTreeNode.class);
        for (FieldTreeNode node : fieldTreeNodes) {
            QueryFieldCommonBo queryFieldCommonBo = new QueryFieldCommonBo();
            queryFieldCommonBo.setEntityName(node.getEntityName());
            queryFieldCommonBo.setEntityNumber(node.getEntityNumber());
            queryFieldCommonBo.setFieldName(node.getName());
            queryFieldCommonBo.setFieldAlias(node.getFieldAlias());
            queryFieldCommonBo.setFieldPath(node.getFieldPath());
            queryFieldCommonBo.setValueType(node.getValueType());
            queryFieldCommonBo.setComplexType(node.getComplexType());
            queryFieldCommonBo.setControlType(node.getControlType());
            queryFieldCommonBo.setVirtualEntityField(false);
            WarnQueryFieldBos.add(queryFieldCommonBo);
        }
        AnalyseObjectUtil.setFieldControlType((List)WarnQueryFieldBos);
        List inputMap = AnobjFilterUtil.getParamList((List)WarnQueryFieldBos);
        if (inputMap.isEmpty()) {
            return;
        }
        String value = (String)this.getModel().getValue("datafilter");
        HashMap data = Maps.newHashMapWithExpectedSize((int)4);
        data.put("param", inputMap);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            value = RuleUtil.getNewestConditionValue((String)value);
            data.put("value", value);
            hrFilter = (HRFilter)this.getPlugin().getControl("hrfilterap");
            hrFilter.setValue(value);
            data.put("onlyUpdateWeb", "true");
        }
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.EDIT && ((Boolean)this.getModel().getValue("issyspreset")).booleanValue()) {
            data.put("pageState", OperationStatus.VIEW.toString());
        } else {
            data.put("pageState", this.getView().getFormShowParameter().getStatus().toString());
        }
        hrFilter = (HRFilter)this.getPlugin().getControl("hrfilterap");
        hrFilter.updateControlData((Map)data);
    }

    public void initCustomControl() {
        List joinEntities = Collections.emptyList();
        List queryFields = Collections.emptyList();
        List entityRelations = Collections.emptyList();
        List calculateFields = Collections.emptyList();
        List entityAllFields = Lists.newArrayListWithCapacity((int)10);
        String joinEntitiesStr = this.getView().getPageCache().get("joinEntities");
        String queryFieldsStr = this.getView().getPageCache().get("queryFields");
        String entityRelationsStr = this.getView().getPageCache().get("entityRelations");
        String calFieldsStr = this.getView().getPageCache().get("calculateFields");
        ArrayList selectedFieldKeys = Lists.newArrayListWithCapacity((int)10);
        String copyWarnObjTplId = this.getView().getPageCache().get("copyWarnObjTplId");
        if (this.getModel().getDataEntity().getDataEntityState().getFromDatabase() || StringUtils.isNotBlank((CharSequence)copyWarnObjTplId)) {
            Set refByReportFieldAliasList = WarnObjTplService.getInstance().getRefByFieldAliasCollection((Long)this.getModel().getValue("id"));
            if (HRStringUtils.isNotEmpty((String)joinEntitiesStr)) {
                joinEntities = JSON.parseArray((String)joinEntitiesStr, WarnJoinEntityBo.class);
            }
            if (HRStringUtils.isNotEmpty((String)queryFieldsStr)) {
                queryFields = JSON.parseArray((String)queryFieldsStr, WarnQueryFieldBo.class);
                queryFields.stream().filter(queryField -> queryField.isVirtualEntityField() || !queryField.getFieldAlias().endsWith(".id")).forEach(queryField -> selectedFieldKeys.add(queryField.getFieldAlias()));
            }
            if (HRStringUtils.isNotEmpty((String)entityRelationsStr)) {
                entityRelations = JSON.parseArray((String)entityRelationsStr, WarnEntityRelationBo.class);
            }
            if (HRStringUtils.isNotEmpty((String)calFieldsStr)) {
                calculateFields = JSON.parseArray((String)calFieldsStr, WarnCalFieldBo.class);
                calculateFields.stream().filter(WarnCalFieldBo::getSelected).forEach(field -> {
                    if (refByReportFieldAliasList.contains(field.getFieldNumber())) {
                        field.setDisabled(Boolean.TRUE);
                    }
                    selectedFieldKeys.add(field.getFieldNumber());
                });
            }
            FieldDefineService service = new FieldDefineService();
            service.setSetComplexType(true);
            service.setShowHRPersonQuery(true);
            entityAllFields = service.getEntityAllFields(WarnComplexObjTransferUtil.transferJoinEntityBos((List)joinEntities), WarnComplexObjTransferUtil.transferQueryFieldBos((List)queryFields), refByReportFieldAliasList);
            this.setAllFieldsToCache(entityAllFields);
        }
        FieldDefineService fieldDefineService = new FieldDefineService();
        List dataSourceCloudBos = fieldDefineService.getDataSourceTree();
        Map<String, Object> dataMap = this.assembleData(dataSourceCloudBos, joinEntities, entityRelations, entityAllFields, calculateFields, selectedFieldKeys);
        dataMap.put("form", "warnobjtpl");
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        customcontrol.setData(dataMap);
        this.getView().getPageCache().put("initCompleted", "1");
    }

    private Map<String, Object> assembleData(List<DataSourceCloudBo> clouds, List<WarnJoinEntityBo> joinEntities, List<WarnEntityRelationBo> entityRelations, List<FieldTreeNode> entityAllFields, List<WarnCalFieldBo> calculateFields, List<String> selectedFieldKeys) {
        for (WarnJoinEntityBo joinEntity : joinEntities) {
            if (!HRStringUtils.equals((String)joinEntity.getType(), (String)"sub")) continue;
            entityRelations.stream().filter(relation -> HRStringUtils.equals((String)relation.getJoinEntityAlias(), (String)joinEntity.getEntityAlias())).findAny().ifPresent(arg_0 -> ((WarnJoinEntityBo)joinEntity).setEntityRelation(arg_0));
        }
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String statusParam = status.toString();
        if (status == OperationStatus.EDIT && ((Boolean)this.getModel().getValue("issyspreset")).booleanValue()) {
            statusParam = OperationStatus.VIEW.toString();
        }
        this.getView().getPageCache().put("pageStatus", statusParam);
        dataMap.put("status", statusParam);
        dataMap.put("entityNodes", joinEntities);
        dataMap.put("clouds", clouds);
        if (HRStringUtils.equals((String)statusParam, (String)OperationStatus.VIEW.toString())) {
            entityAllFields.forEach(this::disableFieldTreeNode);
            calculateFields.forEach(field -> field.setDisabled(Boolean.TRUE));
        }
        dataMap.put("fieldTreeNode", entityAllFields);
        dataMap.put("calFields", calculateFields);
        List<String> refFieldAliasList = this.getAllRefFieldAliasByCalField(calculateFields);
        dataMap.put("refFieldAliasList", refFieldAliasList);
        HashSet refFieldAlias = Sets.newHashSetWithExpectedSize((int)16);
        Map<WarnSceneControlSceneEnum, Set<String>> allControlRefFieldAlias = this.getAllControlRefFieldAlias();
        for (Map.Entry<WarnSceneControlSceneEnum, Set<String>> entry : allControlRefFieldAlias.entrySet()) {
            Set<String> value = entry.getValue();
            if (value == null || WarnSceneControlSceneEnum.DATA_FILTER == entry.getKey()) continue;
            refFieldAlias.addAll(value);
        }
        dataMap.put("filterFieldAliasList", refFieldAlias);
        dataMap.put("selectedFieldKeys", selectedFieldKeys);
        dataMap.put("method", "init");
        dataMap.put("isReport", Boolean.TRUE);
        FieldDefineService fieldDefineService = new FieldDefineService();
        dataMap.put("entities", fieldDefineService.getAllEntities(clouds));
        String dataSource = "business";
        dataMap.put("dataSource", dataSource);
        return dataMap;
    }

    private void disableFieldTreeNode(FieldTreeNode node) {
        node.setDisabled(Boolean.TRUE);
        if (node.getChildren() != null) {
            for (FieldTreeNode child : node.getChildren()) {
                this.disableFieldTreeNode(child);
            }
        }
    }
}

