/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.earlywarn.scene;

import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.FilterContainer;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.AfterSearchClickListener;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.formplugin.web.earlywarn.scene.WarnFieldListDataProvider;

public class WarnSceneFieldF7TreeListPlugin
extends AbstractTreeListPlugin
implements TreeNodeClickListener,
CreateListDataProviderListener,
AfterSearchClickListener {
    private static final Log LOGGER = LogFactory.getLog(WarnSceneFieldF7TreeListPlugin.class);

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
    }

    public void click(SearchClickEvent searchClickEvent) {
        List filterList = searchClickEvent.getFastQFilters();
        this.saveQfilterList2Cache(filterList);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.getEntryState().setCurrentPageIndex(Integer.valueOf(1));
        this.getView().updateView("billlistap");
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
        Control source = (Control)evt.getSource();
        if ("treeview".equals(source.getKey())) {
            String nodeId = (String)evt.getNodeId();
            this.showFieldList(nodeId);
        }
    }

    private void showFieldList(String nodeId) {
        this.getPageCache().put("treeNodeId", nodeId);
        BillList billList = (BillList)this.getControl("billlistap");
        IListDataProvider provider = billList.getListModel().getProvider();
        if (provider instanceof WarnFieldListDataProvider) {
            ((WarnFieldListDataProvider)provider).setCurTreeNodeId(nodeId);
        }
        if (StringUtils.isNotEmpty((CharSequence)nodeId)) {
            this.refreshFilterAndPageIndex();
            this.getView().updateView("billlistap");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectRows = billList.getSelectedRows();
        if (selectRows != null && selectRows.size() > 0) {
            Object pkid = billList.getSelectedRows().get(0).getPrimaryKeyValue();
            String value = this.getView().getParentView().getPageCache().get("fieldname");
            if (HRStringUtils.isNotEmpty((String)value)) {
                List fieldList = (List)SerializationUtils.fromJsonString((String)value, List.class);
                int idx = Integer.parseInt(String.valueOf(pkid));
                if (fieldList.size() > idx) {
                    this.getView().returnDataToParent(fieldList.get(Integer.parseInt(String.valueOf(pkid))));
                }
            }
        }
    }

    private void refreshFilterAndPageIndex() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.getEntryState().setCurrentPageIndex(Integer.valueOf(1));
        HRPageCache pageCache = new HRPageCache(this.getView());
        pageCache.put("FILTER_SIZE", (Object)0);
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        filterContainer.clearFast();
        this.getView().updateView("filtercontainerap");
    }

    private void saveQfilterList2Cache(List<QFilter> filterList) {
        HRPageCache pageCache = new HRPageCache(this.getView());
        if (filterList != null && filterList.size() > 0) {
            pageCache.put("FILTER_SIZE", (Object)filterList.size());
            for (int idx = 0; idx < filterList.size(); ++idx) {
                pageCache.put("WARN_FIELD_FILTER_" + idx, (Object)filterList.get(idx).toSerializedString());
            }
        } else {
            pageCache.put("FILTER_SIZE", (Object)0);
        }
    }

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"cardview"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadTreeData();
        BillList billList = (BillList)this.getControl("billlistap");
        billList.getListModel().setProvider((IListDataProvider)this.getListDataProvider());
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs beforeCreateListDataProviderArgs) {
        beforeCreateListDataProviderArgs.setListDataProvider((IListDataProvider)this.getListDataProvider());
    }

    private WarnFieldListDataProvider getListDataProvider() {
        WarnFieldListDataProvider listDataProvider = new WarnFieldListDataProvider();
        String value = this.getView().getPageCache().get("treeNodeIdMap");
        if (HRStringUtils.isNotEmpty((String)value)) {
            Map treeNodeIdMap = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
            listDataProvider.getTreeNodeIdMap().putAll(treeNodeIdMap);
        }
        if (HRStringUtils.isNotEmpty((String)(value = this.getView().getParentView().getPageCache().get("fieldname")))) {
            List fieldList = (List)SerializationUtils.fromJsonString((String)value, List.class);
            listDataProvider.getFieldList().addAll(fieldList);
        }
        if (HRStringUtils.isNotEmpty((String)(value = this.getView().getPageCache().get("treeNodeId")))) {
            listDataProvider.setCurTreeNodeId(value);
        }
        return listDataProvider;
    }

    private void loadTreeData() {
        List entityList;
        String value;
        TreeView pairTree = (TreeView)this.getView().getControl("treeview");
        pairTree.deleteAllNodes();
        if (this.getView() != null && this.getView().getParentView() != null && HRStringUtils.isNotEmpty((String)(value = this.getView().getParentView().getPageCache().get("joinEntities"))) && (entityList = (List)SerializationUtils.fromJsonString((String)value, List.class)) != null && entityList.size() > 0) {
            LinkedHashMap treeNodeIdMap = new LinkedHashMap(16);
            for (Map entityItem : entityList) {
                TreeNode root;
                treeNodeIdMap.put(entityItem.get("longNumber"), entityItem.get("entityAlias"));
                if (entityItem.containsKey("parentLongNumber") && HRStringUtils.isNotEmpty((String)((String)entityItem.get("parentLongNumber")))) {
                    if (treeNodeIdMap.containsKey(entityItem.get("parentLongNumber"))) {
                        pairTree.addNode(new TreeNode((String)entityItem.get("parentLongNumber"), (String)entityItem.get("longNumber"), (String)entityItem.get("displayName")));
                        continue;
                    }
                    root = new TreeNode("", (String)entityItem.get("longNumber"), (String)entityItem.get("displayName"));
                    pairTree.addNode(root);
                    pairTree.expand((String)entityItem.get("longNumber"));
                    pairTree.focusNode(root);
                    continue;
                }
                root = new TreeNode("", (String)entityItem.get("longNumber"), (String)entityItem.get("displayName"));
                pairTree.addNode(root);
                pairTree.expand((String)entityItem.get("longNumber"));
                pairTree.focusNode(root);
            }
            this.getView().getPageCache().put("treeNodeIdMap", SerializationUtils.toJsonString(treeNodeIdMap));
        }
    }
}

