/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.earlywarn.scene;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.WarnSchemeService;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.WarningSceneService;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.calfield.WarnCalcFieldService;
import kd.hr.hrcs.formplugin.web.earlywarn.scene.MsgContent;
import kd.hr.hrcs.formplugin.web.earlywarn.scene.WarnSceneMsgBaseEdit;
import kd.hr.hrcs.formplugin.web.earlywarn.scene.process.WarnMsgProcessor;
import org.apache.commons.lang3.StringUtils;

@ExcludeFromJacocoGeneratedReport
public class WarnSceneMsgEdit
extends WarnSceneMsgBaseEdit
implements TreeNodeClickListener,
CellClickListener,
TabSelectListener {
    private static final Log LOGGER = LogFactory.getLog(WarnSceneMsgEdit.class);
    private static final String MSG_TITLE_HIDE = "msgtitlehide";
    private static final String MSG_MAIN_HIDE = "msgmainhide";
    private static final String MSG_CONCLUSION_HIDE = "msgconclusionhide";
    private static final String MSG_CONTENT_CACHE_KEY = "msgContent";
    private static final String MSG_TABLE_UPDATED = "MSG_TABLE_UPDATED";
    private final WarnMsgProcessor warnMsgProcessor = new WarnMsgProcessor(this);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView queryfieldtree = (TreeView)this.getControl("queryfieldtree");
        queryfieldtree.addTreeNodeClickListener((TreeNodeClickListener)this);
        TreeView sysparamtree = (TreeView)this.getControl("sysparamtree");
        sysparamtree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        try {
            this.warnMsgProcessor.initAttVisible();
            this.initMsgCollection();
            this.initMsgQueryField();
            this.warnMsgProcessor.getFieldAllTreeNodes();
        }
        catch (Exception exception) {
            LOGGER.error("WarnSceneEdit_itemClick_error:", (Throwable)exception);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String actionId = messageBoxClosedEvent.getCallBackId();
        try {
            if ("warnscene".contains(actionId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.initMsgQueryField();
                if ("warnmsgtab".equals(this.warnMsgProcessor.getCurChannelTab())) {
                    this.warnMsgProcessor.initTreeControl();
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("WarnSceneEdit_itemClick_error:", (Throwable)exception);
        }
    }

    public void initMsgCollection() {
        Stream.of(this.queryMsgCollection()).filter(dy -> dy.getString("channel").equals(this.warnMsgProcessor.getCurChannelTab())).findAny().ifPresent(dy2 -> {
            this.getModel().setValue(MSG_TITLE_HIDE, (Object)dy2.getString("msgtitle"));
            this.getModel().setValue(MSG_MAIN_HIDE, (Object)dy2.getString("msgmain"));
            this.getModel().setValue(MSG_CONCLUSION_HIDE, (Object)dy2.getString("msgconclusion"));
        });
    }

    public void initMsgTableCollection() {
        Map<String, String> aliasToName = this.warnMsgProcessor.getAliasToName();
        DynamicObject[] dynamicObjects = this.queryMsgTableCollection();
        ArrayList list = Lists.newArrayListWithCapacity((int)dynamicObjects.length);
        Stream.of(dynamicObjects).filter(dy -> dy.getString("channel").equals(this.warnMsgProcessor.getCurChannelTab())).forEach(dy2 -> {
            HashMap map = Maps.newHashMapWithExpectedSize((int)3);
            map.put("titleline", dy2.getString("titleline"));
            map.put("dataline", aliasToName.get(dy2.getString("dataline")));
            map.put("seqrule", dy2.getString("seqrule"));
            map.put("datalineRes", dy2.getString("dataline").replace("#", ""));
            list.add(map);
        });
        this.getPageCache().put("mainTableAllData", SerializationUtils.toJsonString((Object)list));
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        HashMap data = Maps.newHashMapWithExpectedSize((int)16);
        data.put("data", list);
        data.put("method", "init");
        data.put("viewStatus", status.name());
        data.put("times", System.currentTimeMillis());
        CustomControl customcontrol = (CustomControl)this.getView().getControl("maintable");
        customcontrol.setData((Object)data);
    }

    public DynamicObject[] queryMsgCollection() {
        Long schemeId = (Long)this.getModel().getValue("id");
        if (schemeId == null || schemeId == 0L) {
            return new DynamicObject[0];
        }
        QFilter qFilter = new QFilter("sourceid", "=", (Object)schemeId);
        QFilter typeQFilter = new QFilter("sourcetype", "=", (Object)this.getView().getEntityId());
        String curChannelTab = this.warnMsgProcessor.getCurChannelTab();
        QFilter channelQFilter = new QFilter("channel", "=", (Object)curChannelTab);
        return new HRBaseServiceHelper("hrcs_warnmsgconf").query("channel,localeid,msgtitle,msgmain,msgconclusion", new QFilter[]{qFilter, typeQFilter, channelQFilter});
    }

    public DynamicObject[] queryMsgTableCollection() {
        Long schemeId = (Long)this.getModel().getValue("id");
        if (schemeId == null || schemeId == 0L) {
            return new DynamicObject[0];
        }
        String curChannelTab = this.warnMsgProcessor.getCurChannelTab();
        return WarnSchemeService.queryMsgTableCollection((Long)schemeId, (String)this.getView().getEntityId(), (String)curChannelTab);
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        try {
            String mainTableAllData;
            super.propertyChanged(propertyChangedArgs);
            String changeKey = propertyChangedArgs.getProperty().getName();
            if ("pushchannel".equals(changeKey)) {
                this.warnMsgProcessor.initAttVisible();
            } else if ("warnscene".equals(changeKey)) {
                ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
                DynamicObject newValue = (DynamicObject)changeData.getNewValue();
                if (newValue != null) {
                    this.initMsgQueryField();
                }
            } else if ("localeid".equals(changeKey) && !HRStringUtils.isEmpty((String)(mainTableAllData = this.getPageCache().get("mainTableAllData")))) {
                List mainTableAllDataList = JSONObject.parseArray((String)mainTableAllData, Map.class);
                String nodeIdToMultiLang = this.getPageCache().get("nodeIdToMultiLangCache");
                if (!HRStringUtils.isEmpty((String)nodeIdToMultiLang)) {
                    Map nodeIdToMultiLangMap = (Map)JSONObject.parseObject((String)nodeIdToMultiLang, (TypeReference)new TypeReference<Map<String, LocaleString>>(){}, (Feature[])new Feature[0]);
                    mainTableAllDataList.stream().forEach(map -> map.put("titleline", ((LocaleString)nodeIdToMultiLangMap.get(map.get("datalineRes"))).get(this.getModel().getValue("localeid"))));
                }
                HashMap data = Maps.newHashMapWithExpectedSize((int)16);
                data.put("data", mainTableAllDataList);
                data.put("method", "refreshTitleContent");
                data.put("times", System.currentTimeMillis());
                CustomControl customcontrol = (CustomControl)this.getView().getControl("maintable");
                customcontrol.setData((Object)data);
            }
        }
        catch (Exception exception) {
            LOGGER.error("propertyChanged_error:", (Throwable)exception);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        try {
            if ("save".equals(operateKey) && this.warnMsgProcessor.isMainTableInitComplete() && !op.getOption().tryGetVariableValue(MSG_TABLE_UPDATED, new RefObject())) {
                this.warnMsgProcessor.returnAllMainTableData(operateKey);
                args.setCancel(true);
            }
        }
        catch (Exception exception) {
            LOGGER.error("beforeDoOperation_error:", (Throwable)exception);
        }
    }

    public void initMsgQueryField() {
        DynamicObject sceneDy = (DynamicObject)this.getModel().getValue("warnscene");
        if (sceneDy != null) {
            long warnObjId = sceneDy.getLong("warnobjtpl.id");
            WarningSceneService anObjService = WarningSceneService.getInstance();
            List queryFields = anObjService.queryWarnQueryFieldsAndAssemble(sceneDy);
            WarnCalcFieldService calFieldService = WarnCalcFieldService.getInstance();
            List calculateFields = calFieldService.loadSceneAllFieldCalFieldsBySourceIdForBo(sceneDy);
            List joinEntities = anObjService.queryAllJoinEntitiesAndAssemble(sceneDy);
            Set refByReportFieldAliasList = WarningSceneService.getInstance().getRefBySchemeFieldAliasCollection(Long.valueOf(warnObjId));
            this.getView().getPageCache().put("queryFields", SerializationUtils.toJsonString((Object)queryFields));
            this.getView().getPageCache().put("calculateFields", SerializationUtils.toJsonString((Object)calculateFields));
            this.getView().getPageCache().put("joinEntities", SerializationUtils.toJsonString((Object)joinEntities));
            this.getView().getPageCache().put("refByReportFieldAliasList", SerializationUtils.toJsonString((Object)refByReportFieldAliasList));
        }
    }

    @Override
    public void tabSelected(TabSelectEvent tabSelectEvent) {
        try {
            String tabKey = tabSelectEvent.getTabKey();
            if ("warnmsgtab".equals(tabKey)) {
                if (!"true".equals(this.getPageCache().get("CACHE_KEY_MSGTAB_SELECT"))) {
                    this.warnMsgProcessor.initTreeControl();
                    this.initMsgTableCollection();
                    this.initCodeMirror();
                    this.getPageCache().put("CACHE_KEY_MSGTAB_SELECT", "true");
                }
                this.getPageCache().remove("CurFocusTextKey");
                this.getPageCache().remove("cache_key_nameToAlias");
            } else if ("msgcenter".equals(tabKey) || "email".equals(tabKey) || "sms".equals(tabKey) || "yunzhijia".equals(tabKey)) {
                this.cacheCurMsgContent();
            }
        }
        catch (Exception exception) {
            LOGGER.error("tabSelected_error:", (Throwable)exception);
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent evt) {
        try {
            Map focusNode = ((TreeView)evt.getSource()).getTreeState().getFocusNode();
            String curFocusTextKey = this.getPageCache().get("CurFocusTextKey");
            if (!((Boolean)focusNode.get("isParent")).booleanValue() && StringUtils.isNotBlank((CharSequence)curFocusTextKey)) {
                if ("maintable".equals(curFocusTextKey)) {
                    if ("sysparamtree".equals(((TreeView)evt.getSource()).getKey())) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u6dfb\u52a0\u7cfb\u7edf\u53c2\u6570\u81f3\u8868\u683c\u4e2d\u3002", (String)"WarnSceneMsgEdit_10", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]));
                    } else {
                        Map nodeIdToMultiLangMap;
                        HashMap data = Maps.newHashMapWithExpectedSize((int)16);
                        data.put("titleContent", String.valueOf(focusNode.get("text")));
                        String nodeIdToMultiLang = this.getPageCache().get("nodeIdToMultiLangCache");
                        if (!HRStringUtils.isEmpty((String)nodeIdToMultiLang) && (nodeIdToMultiLangMap = (Map)JSONObject.parseObject((String)nodeIdToMultiLang, (TypeReference)new TypeReference<Map<String, LocaleString>>(){}, (Feature[])new Feature[0])).containsKey(focusNode.get("id"))) {
                            data.put("titleContent", ((LocaleString)nodeIdToMultiLangMap.get(focusNode.get("id"))).get(this.getModel().getValue("localeid")));
                        }
                        data.put("datalineRes", focusNode.get("id"));
                        data.put("displayContent", String.valueOf(focusNode.get("text")));
                        data.put("method", "treeNodeDoubleClick");
                        data.put("times", System.currentTimeMillis());
                        CustomControl customcontrol = (CustomControl)this.getView().getControl("maintable");
                        customcontrol.setData((Object)data);
                    }
                } else {
                    String displayContent = " [" + String.valueOf(focusNode.get("text")).split("\\|", 2)[0].trim() + "] ";
                    OperationStatus status = this.getView().getFormShowParameter().getStatus();
                    this.warnMsgProcessor.updateMsgContentTextData(curFocusTextKey, "insert", displayContent, status.name());
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("treeNodeDoubleClick_error:", (Throwable)exception);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        try {
            if (HRStringUtils.equals((String)evt.getItemKey(), (String)"bar_save")) {
                if (StringUtils.isBlank((CharSequence)((String)this.getModel().getValue(MSG_TITLE_HIDE)))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6d88\u606f\u6807\u9898\u3002", (String)"WarnSceneMsgEdit_4", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]));
                    OperationStatus status = this.getView().getFormShowParameter().getStatus();
                    this.warnMsgProcessor.updateMsgContentTextData("msgtitle", "tip", "", status.name());
                    evt.setCancel(true);
                }
                this.cacheCurMsgContent();
            }
        }
        catch (Exception exception) {
            LOGGER.error("beforeItemClick_error:", (Throwable)exception);
        }
    }

    private void cacheCurMsgContent() {
        String msgContentSrc = this.getPageCache().get(MSG_CONTENT_CACHE_KEY);
        if (StringUtils.isBlank((CharSequence)msgContentSrc)) {
            ArrayList msgContentList = Lists.newArrayListWithExpectedSize((int)16);
            MsgContent msgContent3 = new MsgContent((String)this.getModel().getValue(MSG_TITLE_HIDE), (String)this.getModel().getValue(MSG_MAIN_HIDE), (String)this.getModel().getValue(MSG_CONCLUSION_HIDE));
            msgContent3.setChannel(this.warnMsgProcessor.getCurChannelTab());
            msgContent3.setLocaleId((String)this.getModel().getValue("localeid"));
            msgContentList.add(msgContent3);
            this.getPageCache().put(MSG_CONTENT_CACHE_KEY, SerializationUtils.toJsonString((Object)msgContentList));
        } else {
            List msgContentList = SerializationUtils.fromJsonStringToList((String)msgContentSrc, MsgContent.class);
            msgContentList.stream().filter(msgContent -> msgContent.getChannel().equals(this.warnMsgProcessor.getCurChannelTab()) && msgContent.getLocaleId().equals((String)this.getModel().getValue("localeid"))).findAny().ifPresent(msgContent2 -> {
                msgContent2.setMsgTitle((String)this.getModel().getValue(MSG_TITLE_HIDE));
                msgContent2.setMsgMain((String)this.getModel().getValue(MSG_MAIN_HIDE));
                msgContent2.setMsgConclusion((String)this.getModel().getValue(MSG_CONCLUSION_HIDE));
            });
            this.getPageCache().put(MSG_CONTENT_CACHE_KEY, SerializationUtils.toJsonString((Object)msgContentList));
        }
        LOGGER.info("WarnSceneMsgEdit.cacheCurMsgContent:{}", (Object)this.getPageCache().get(MSG_CONTENT_CACHE_KEY));
    }

    private void transferMsgVariable(Map<String, String> nameToAlias, MsgContent msgContent) {
        if (nameToAlias.size() > 0) {
            String msgTitleHide = msgContent.getMsgTitle();
            String msgMainHide = msgContent.getMsgMain();
            String msgConclusionHide = msgContent.getMsgConclusion();
            for (Map.Entry<String, String> entry : nameToAlias.entrySet()) {
                String key = "\\[" + entry.getKey().split(" \\| ")[0] + "\\]";
                String value = "[" + entry.getValue() + "]";
                msgTitleHide = msgTitleHide.replaceAll(key, value);
                msgMainHide = msgMainHide.replaceAll(key, value);
                msgConclusionHide = msgConclusionHide.replaceAll(key, value);
            }
            msgContent.setMsgTitle(msgTitleHide);
            msgContent.setMsgMain(msgMainHide);
            msgContent.setMsgConclusion(msgConclusionHide);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("save".equals(operateKey)) {
            LOGGER.info("WarnSceneMsgEdit.afterDoOperation_operationResult:{}", (Object)afterDoOperationEventArgs.getOperationResult());
            if (afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                Map<String, String> nameToAlias = this.warnMsgProcessor.getNameToAlias();
                try {
                    this.saveMsgContent(nameToAlias);
                    this.saveMsgTableContent(nameToAlias);
                }
                catch (Exception exception) {
                    afterDoOperationEventArgs.getOperationResult().setSuccess(false);
                    afterDoOperationEventArgs.getOperationResult().setMessage(exception.getMessage());
                    LOGGER.error("afterDoOperation_error:", (Throwable)exception);
                }
            }
        }
    }

    private void saveMsgTableContent(Map<String, String> nameToAlias) {
        PageCache pageCache = new PageCache(this.getView().getPageId());
        String mainTableData = pageCache.get("mainTableData");
        if (mainTableData == null) {
            return;
        }
        List list = JSONArray.parseArray((String)mainTableData, Map.class);
        DynamicObject[] dynamicObjects = this.queryMsgTableCollection();
        if (dynamicObjects.length == 0) {
            DynamicObject[] saveDys = new DynamicObject[list.size()];
            for (int index = 0; index < list.size(); ++index) {
                Map mapTemp = (Map)list.get(index);
                DynamicObject dy = this.createBaseDy("hrcs_warnmsgtable");
                dy.set("titleline", mapTemp.get("titleline"));
                dy.set("dataline", (Object)nameToAlias.get(mapTemp.get("dataline")));
                dy.set("seqrule", mapTemp.get("seqrule"));
                dy.set("fieldseq", (Object)(index + 1));
                saveDys[index] = dy;
            }
            SaveServiceHelper.save((DynamicObject[])saveDys);
        } else {
            int size = list.size();
            int size2 = dynamicObjects.length;
            ArrayList saveDy = Lists.newArrayListWithExpectedSize((int)size);
            ArrayList updateDy = Lists.newArrayListWithExpectedSize((int)size);
            HashSet removeIds = Sets.newHashSetWithExpectedSize((int)size2);
            for (int index = 0; index < size; ++index) {
                Map mapTemp = (Map)list.get(index);
                if (index > size2 - 1) {
                    DynamicObject dy = this.createBaseDy("hrcs_warnmsgtable");
                    dy.set("titleline", mapTemp.get("titleline"));
                    dy.set("dataline", (Object)nameToAlias.get(mapTemp.get("dataline")));
                    dy.set("seqrule", mapTemp.get("seqrule"));
                    dy.set("fieldseq", (Object)(index + 1));
                    saveDy.add(dy);
                    continue;
                }
                dynamicObjects[index].set("titleline", mapTemp.get("titleline"));
                dynamicObjects[index].set("dataline", (Object)nameToAlias.get(mapTemp.get("dataline")));
                dynamicObjects[index].set("seqrule", mapTemp.get("seqrule"));
                updateDy.add(dynamicObjects[index]);
            }
            if (saveDy.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])saveDy.toArray(new DynamicObject[saveDy.size()]));
            }
            SaveServiceHelper.update((DynamicObject[])updateDy.toArray(new DynamicObject[updateDy.size()]));
            while (size2 > size) {
                removeIds.add(dynamicObjects[size2 - 1].getLong("id"));
                --size2;
            }
            if (removeIds.size() > 0) {
                DeleteServiceHelper.delete((String)"hrcs_warnmsgtable", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)removeIds)});
            }
        }
        pageCache.remove("mainTableData");
    }

    private DynamicObject createBaseDy(String entityKey) {
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityKey));
        dynamicObject.set("sourceid", this.getModel().getValue("id"));
        dynamicObject.set("sourcetype", (Object)this.getView().getEntityId());
        dynamicObject.set("localeid", this.getModel().getValue("localeid"));
        dynamicObject.set("channel", (Object)this.warnMsgProcessor.getCurChannelTab());
        return dynamicObject;
    }

    private void saveMsgContent(Map<String, String> nameToAlias) {
        IPageCache service = (IPageCache)this.getView().getService(IPageCache.class);
        String msgContentSrc = service.get(MSG_CONTENT_CACHE_KEY);
        LOGGER.info("WarnSceneMsgEdit.saveMsgContent:{}", (Object)msgContentSrc);
        if (StringUtils.isNotBlank((CharSequence)msgContentSrc)) {
            List msgContentList = SerializationUtils.fromJsonStringToList((String)msgContentSrc, MsgContent.class);
            DynamicObject[] dynamicObjectCollection = this.queryMsgCollection();
            if (dynamicObjectCollection.length == 0) {
                this.SaveMsgContentOfNew(nameToAlias);
            } else {
                AtomicBoolean isUpdate = new AtomicBoolean(false);
                Stream.of(dynamicObjectCollection).forEach(dy -> msgContentList.stream().filter(msgContent -> msgContent.getChannel().equals(dy.getString("channel"))).findAny().ifPresent(content -> {
                    this.transferMsgVariable(nameToAlias, (MsgContent)content);
                    dy.set("msgtitle", (Object)content.getMsgTitle());
                    dy.set("msgmain", (Object)content.getMsgMain());
                    dy.set("msgconclusion", (Object)content.getMsgConclusion());
                    isUpdate.set(true);
                }));
                if (isUpdate.get()) {
                    SaveServiceHelper.update((DynamicObject[])dynamicObjectCollection);
                } else {
                    this.SaveMsgContentOfNew(nameToAlias);
                }
            }
            service.remove(MSG_CONTENT_CACHE_KEY);
        } else {
            this.SaveMsgContentOfNew(nameToAlias);
        }
    }

    private void SaveMsgContentOfNew(Map<String, String> nameToAlias) {
        MsgContent msgContent = new MsgContent((String)this.getModel().getValue(MSG_TITLE_HIDE), (String)this.getModel().getValue(MSG_MAIN_HIDE), (String)this.getModel().getValue(MSG_CONCLUSION_HIDE));
        this.transferMsgVariable(nameToAlias, msgContent);
        DynamicObject dynamicObject = this.createBaseDy("hrcs_warnmsgconf");
        dynamicObject.set("channel", (Object)this.warnMsgProcessor.getCurChannelTab());
        dynamicObject.set("msgtitle", (Object)msgContent.getMsgTitle());
        dynamicObject.set("msgmain", (Object)msgContent.getMsgMain());
        dynamicObject.set("msgconclusion", (Object)msgContent.getMsgConclusion());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private void initCodeMirror() {
        Map<String, String> aliasToName = this.warnMsgProcessor.getAliasToName();
        String msgTitleHide = (String)this.getModel().getValue(MSG_TITLE_HIDE);
        String msgMainHide = (String)this.getModel().getValue(MSG_MAIN_HIDE);
        String msgConclusionHide = (String)this.getModel().getValue(MSG_CONCLUSION_HIDE);
        for (Map.Entry<String, String> entry : aliasToName.entrySet()) {
            String value = entry.getValue().contains("|") ? entry.getValue().split("\\|")[0].trim() : entry.getValue();
            msgTitleHide = msgTitleHide.replace(entry.getKey(), value);
            msgConclusionHide = msgConclusionHide.replace(entry.getKey(), value);
            msgMainHide = msgMainHide.replace(entry.getKey(), value);
        }
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        this.warnMsgProcessor.updateMsgContentTextData("msgtitle", "init", msgTitleHide, status.name());
        this.warnMsgProcessor.updateMsgContentTextData("msgmain", "init", msgMainHide, status.name());
        this.warnMsgProcessor.updateMsgContentTextData("msgcontent", "init", msgConclusionHide, status.name());
    }

    public void customEvent(CustomEventArgs customEventArgs) {
        String eventName = customEventArgs.getEventName();
        try {
            if ("returnMsgContentText".equals(eventName)) {
                String args = customEventArgs.getEventArgs();
                this.getModel().setValue(MSG_CONCLUSION_HIDE, (Object)args);
            } else if ("returnMsgTitleText".equals(eventName)) {
                String args = customEventArgs.getEventArgs();
                this.getModel().setValue(MSG_TITLE_HIDE, (Object)args);
            } else if ("returnMsgMainText".equals(eventName)) {
                String args = customEventArgs.getEventArgs();
                this.getModel().setValue(MSG_MAIN_HIDE, (Object)args);
            } else if ("returnCurFocusText".equals(eventName)) {
                this.getPageCache().put("CurFocusTextKey", customEventArgs.getEventArgs());
            } else if ("getAllMainTableDataByRefresh".equals(eventName)) {
                String eventArgs = customEventArgs.getEventArgs();
                JSONObject allMainTableData = JSON.parseObject((String)eventArgs);
                JSONArray dataSource = allMainTableData.getJSONArray("dataSource");
                this.getPageCache().put("mainTableAllData", dataSource.toJSONString());
            } else if ("getAllMainTableData".equals(eventName)) {
                String eventArgs = customEventArgs.getEventArgs();
                JSONObject allMainTableData = JSON.parseObject((String)eventArgs);
                JSONArray dataSource = allMainTableData.getJSONArray("dataSource");
                boolean succeed = allMainTableData.getBooleanValue("successed");
                this.getPageCache().put("mainTableCheckFlag", String.valueOf(succeed));
                String opKey = allMainTableData.getString("opKey");
                if (!succeed) {
                    return;
                }
                this.getPageCache().put("mainTableData", dataSource.toJSONString());
                this.getPageCache().saveChanges();
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(MSG_TABLE_UPDATED, "true");
                this.getView().invokeOperation(opKey, operateOption);
            }
        }
        catch (Exception exception) {
            LOGGER.error("customEvent_error:", (Throwable)exception);
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        this.getPageCache().put("CurFocusTextKey", null);
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }
}

