/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.earlywarn.scene.process;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.ext.hr.filter.control.HRFilter;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.business.util.HRBaseDataConfigUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.WarnSchemeService;
import kd.hr.hrcs.common.model.earlywarn.WarnCommonConditionBo;
import kd.hr.hrcs.formplugin.web.earlywarn.scene.WarnSceneCommonEdit;
import kd.hr.hrcs.formplugin.web.earlywarn.scene.process.WarnObjCommonProcessor;

@ExcludeFromJacocoGeneratedReport
public class WarnObjFormProcessor
extends WarnObjCommonProcessor {
    private static final Log LOGGER = LogFactory.getLog(WarnObjFormProcessor.class);

    public WarnObjFormProcessor(WarnSceneCommonEdit plugin) {
        super(plugin);
    }

    public void sendFlagForGetAllData(String operationKey, String nextTab) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        dataMap.put("method", "getAllData");
        dataMap.put("operate", "nextStep");
        dataMap.put("time", new Date());
        if (HRStringUtils.equals((String)operationKey, (String)"previewdata")) {
            dataMap.put("operate", "dataPreview");
            dataMap.put("time", System.currentTimeMillis());
        } else if (HRStringUtils.equals((String)operationKey, (String)"save")) {
            dataMap.put("operate", "save");
        } else if (HRStringUtils.equals((String)nextTab, (String)"filterdata")) {
            dataMap.put("operate", "nextStep");
            dataMap.put("time", System.currentTimeMillis());
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            LOGGER.error((Throwable)ex);
        }
        customcontrol.setData((Object)dataMap);
    }

    public void sendFlagForToStep2() {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        dataMap.put("method", "toStep2");
        dataMap.put("uuid", UUID.randomUUID());
        customcontrol.setData((Object)dataMap);
    }

    public String getNextTab(Tab tab) {
        String currentTab = tab.getCurrentTab();
        List items = tab.getItems();
        String nextTab = null;
        boolean foundCurrent = false;
        for (Control item : items) {
            if (foundCurrent) {
                nextTab = item.getKey();
                break;
            }
            if (!HRStringUtils.equals((String)currentTab, (String)item.getKey())) continue;
            foundCurrent = true;
        }
        return nextTab;
    }

    public String getLastTab(Tab tab) {
        String currentTab = tab.getCurrentTab();
        List items = tab.getItems();
        String lastTab = ((Control)items.get(0)).getKey();
        if (HRStringUtils.equals((String)lastTab, (String)currentTab)) {
            return null;
        }
        for (int i = 1; i < items.size(); ++i) {
            if (HRStringUtils.equals((String)currentTab, (String)((Control)items.get(i)).getKey())) {
                return lastTab;
            }
            lastTab = ((Control)items.get(i)).getKey();
        }
        return lastTab;
    }

    public void setVisibleForBtn(String tab, IFormView view) {
        if (HRStringUtils.equals((String)tab, (String)"defineobj")) {
            view.setVisible(Boolean.TRUE, new String[]{"nextstepbtn"});
            view.setVisible(Boolean.FALSE, new String[]{"laststepbtn", "previewbtn", "bar_save"});
        } else if (HRStringUtils.equals((String)tab, (String)"definefield")) {
            view.setVisible(Boolean.TRUE, new String[]{"laststepbtn", "nextstepbtn", "previewbtn"});
            view.setVisible(Boolean.FALSE, new String[]{"bar_save"});
        } else if (HRStringUtils.equals((String)tab, (String)"filterdata")) {
            view.setVisible(Boolean.TRUE, new String[]{"laststepbtn", "bar_save"});
            view.setVisible(Boolean.FALSE, new String[]{"previewbtn", "nextstepbtn"});
        }
    }

    public void updateFormStatus() {
        String formId = this.getView().getModel().getDataEntityType().getName();
        IDataEntityProperty property = this.getModel().getProperty("status");
        if (property != null) {
            LOGGER.info("HRBaseDataTplEdit getStatus:" + this.getView().getFormShowParameter().getStatus());
            LOGGER.info("HRBaseDataTplEdit getValue:" + this.getModel().getValue("status"));
            boolean bFromDb = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
            if (!bFromDb) {
                ((IBillView)this.getView()).setBillStatus(BillOperationStatus.ADDNEW);
                return;
            }
            if (!HRBaseDataConfigUtil.getAudit((String)formId)) {
                LOGGER.info("HRBaseDataTplEdit getAudit false:");
                ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
                ((BillShowParameter)this.getView().getFormShowParameter()).setBillStatus(BillOperationStatus.EDIT);
            }
        }
    }

    public boolean changeObjTplCheck(Object oldValueId, boolean showErrorMsg) {
        List commonConditionBos;
        String commonConditionStr;
        RuleConditionInfo ruleConditionInfo;
        List conditionList;
        List schemeNames = WarnSchemeService.getSceneRelSchemeNames((Object)this.getModel().getDataEntity().getPkValue());
        if (!schemeNames.isEmpty()) {
            if (showErrorMsg) {
                schemeNames = schemeNames.stream().map(name -> "\u201c" + name + "\u201d").collect(Collectors.toList());
                this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u4fee\u6539\u5931\u8d25\uff0c\u9884\u8b66\u65b9\u6848{0}\u5f15\u7528\u4e86\u6b64\u9884\u8b66\u5bf9\u8c61\u5b57\u6bb5\u3002", (String)"WarnSceneEdit_0", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", schemeNames)));
                this.getPageCache().put("CACHE_KEY_CANCEL_CHANGE_OBJ_TPL", "true");
            }
            return false;
        }
        ArrayList clearTabNames = Lists.newArrayListWithExpectedSize((int)5);
        HRFilter ruleCondition = (HRFilter)this.getView().getControl("hrfilterap");
        String dataFilterStr = ruleCondition.getValue();
        String dataFilter = (String)this.getModel().getValue("datafilter");
        if ((HRStringUtils.isNotEmpty((String)dataFilterStr) || HRStringUtils.isNotEmpty((String)dataFilter)) && (conditionList = (ruleConditionInfo = (RuleConditionInfo)SerializationUtils.fromJsonString((String)(HRStringUtils.isNotEmpty((String)dataFilterStr) ? dataFilterStr : dataFilter), RuleConditionInfo.class)).getConditionList()) != null && !conditionList.isEmpty()) {
            clearTabNames.add(ResManager.loadKDString((String)"\u201c\u9884\u8b66\u6570\u636e\u8fc7\u6ee4\u201d", (String)"WarnSceneEdit_1", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]));
        }
        if (HRStringUtils.isNotEmpty((String)(commonConditionStr = (String)this.getModel().getValue("commoncondition"))) && (commonConditionBos = JSONArray.parseArray((String)commonConditionStr, WarnCommonConditionBo.class)) != null && !commonConditionBos.isEmpty()) {
            clearTabNames.add(ResManager.loadKDString((String)"\u201c\u5e38\u7528\u6761\u4ef6\u201d", (String)"WarnSceneEdit_2", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]));
        }
        if (!clearTabNames.isEmpty()) {
            if (showErrorMsg) {
                this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u5176\u5b57\u6bb5\u5df2\u88ab{0}\u5f15\u7528\uff0c\u9700\u53d6\u6d88\u5f15\u7528\u5173\u7cfb\u624d\u53ef\u4fee\u6539\u3002", (String)"WarnObjFormProcessor_2", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", clearTabNames)));
                this.getPageCache().put("CACHE_KEY_CANCEL_CHANGE_OBJ_TPL", "true");
            }
            return false;
        }
        ConfirmCallBackListener confirmListener = new ConfirmCallBackListener("clickWarnObjTpl", (IFormPlugin)this.getPlugin());
        this.getView().showConfirm(ResManager.loadKDString((String)"\u91cd\u65b0\u62d6\u5165\u9884\u8b66\u5bf9\u8c61\u6a21\u677f\u540e\uff0c\u5c06\u4f1a\u6e05\u7a7a\u6240\u6709\u914d\u7f6e\uff0c\u786e\u5b9a\u7ee7\u7eed\u64cd\u4f5c\u5417\uff1f", (String)"WarnSceneEdit_3", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmListener);
        return true;
    }

    public void clearDataFilterTable() {
        CustomControl dataFilterControl = (CustomControl)this.getView().getControl("anobjdatafiltercontrol");
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        dataMap.put("eventKey", "confirmDeleteDataFilter");
        dataMap.put("date", System.currentTimeMillis());
        dataFilterControl.setData((Object)dataMap);
    }
}

