/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.earlywarn.scene.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.ext.hr.filter.control.HRFilter;
import kd.bos.ext.hr.ruleengine.utils.RuleUtil;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.service.labelandreport.AnobjFilterUtil;
import kd.hr.hbp.business.service.labelandreport.FieldDefineService;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.model.complexobj.labelandreport.DataSourceCloudBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.FieldTreeNode;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.WarnObjTplService;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.WarningSceneService;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.calfield.WarnCalcFieldService;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.utils.WarnCommonConditionUtils;
import kd.hr.hrcs.common.constants.earlywarn.WarnSceneComConditionConstants;
import kd.hr.hrcs.common.model.earlywarn.WarnCalFieldBo;
import kd.hr.hrcs.common.model.earlywarn.WarnCommonConditionBo;
import kd.hr.hrcs.common.model.earlywarn.WarnEntityRelationBo;
import kd.hr.hrcs.common.model.earlywarn.WarnJoinEntityBo;
import kd.hr.hrcs.common.model.earlywarn.WarnQueryFieldBo;
import kd.hr.hrcs.common.model.earlywarn.vo.WarnCommonConditionReturnVo;
import kd.hr.hrcs.common.util.earlywarn.WarnComplexObjTransferUtil;
import kd.hr.hrcs.common.util.earlywarn.WarningCommonUtils;
import kd.hr.hrcs.formplugin.web.earlywarn.scene.WarnSceneCommonEdit;
import kd.hr.hrcs.formplugin.web.earlywarn.scene.enums.WarnSceneControlSceneEnum;
import kd.hr.hrcs.formplugin.web.earlywarn.scene.process.WarnObjCommonProcessor;
import kd.hr.hrcs.formplugin.web.earlywarn.utils.FilterOperatorUtils;

@ExcludeFromJacocoGeneratedReport
public class WarnObjInitProcessor
extends WarnObjCommonProcessor
implements WarnSceneComConditionConstants {
    public WarnObjInitProcessor(WarnSceneCommonEdit plugin) {
        super(plugin);
    }

    public void initCacheData(Object newId) {
        DynamicObject sceneDy = this.getModel().getDataEntity();
        Object id = sceneDy.getPkValue();
        DynamicObject objTplDy = sceneDy.getDynamicObject("warnobjtpl");
        if (objTplDy == null) {
            this.getView().getPageCache().remove("joinEntities");
            this.getView().getPageCache().remove("queryFields");
            this.getView().getPageCache().remove("originQueryFields");
            this.getView().getPageCache().remove("entityRelations");
            this.getView().getPageCache().remove("calculateFields");
            this.getView().getPageCache().remove("warnObjRefByScheme");
        } else {
            WarningSceneService sceneService = WarningSceneService.getInstance();
            WarnObjTplService warnObjTplService = WarnObjTplService.getInstance();
            List joinEntities = sceneService.queryAllJoinEntitiesAndAssemble(sceneDy);
            List queryObjTplFields = warnObjTplService.queryAndAssembleQueryFields(Long.valueOf(objTplDy.getLong("id")));
            List querySceneFields = sceneService.queryWarnQueryFieldsAndAssemble(sceneDy);
            List entityRelations = sceneService.queryAllEntityRelationsAndAssemble(sceneDy);
            for (WarnEntityRelationBo entityRelation : entityRelations) {
                joinEntities.stream().filter(entityBo -> HRStringUtils.equals((String)entityBo.getEntityAlias(), (String)entityRelation.getJoinEntityAlias())).findAny().ifPresent(entityBo -> entityBo.setEntityRelation(entityRelation));
            }
            for (WarnEntityRelationBo entityRelation : entityRelations) {
                if (!HRStringUtils.equals((String)entityRelation.getJoinType(), (String)"RightJoin")) continue;
                entityRelation.setJoinType(null);
            }
            if (newId != null) {
                for (WarnJoinEntityBo warnJoinEntityBo : joinEntities) {
                    if (!"warnscene".equals(warnJoinEntityBo.getSource())) continue;
                    warnJoinEntityBo.setSourceId(String.valueOf(newId));
                }
                for (WarnQueryFieldBo warnQueryFieldBo : querySceneFields) {
                    warnQueryFieldBo.setSourceId(String.valueOf(newId));
                }
                for (WarnEntityRelationBo warnEntityRelationBo : entityRelations) {
                    if (!"warnscene".equals(warnEntityRelationBo.getSource())) continue;
                    warnEntityRelationBo.setSourceId(String.valueOf(newId));
                }
            }
            WarnCalcFieldService calFieldService = WarnCalcFieldService.getInstance();
            List calculateFields = calFieldService.loadSceneAllFieldCalFieldsBySourceId(sceneDy);
            boolean warnObjRefByScheme = sceneService.isWarnObjRefByScheme(id);
            this.getView().getPageCache().put("joinEntities", SerializationUtils.toJsonString((Object)joinEntities));
            this.getView().getPageCache().put("queryFields", SerializationUtils.toJsonString((Object)querySceneFields));
            this.getView().getPageCache().put("originQueryFields", SerializationUtils.toJsonString((Object)querySceneFields));
            this.getView().getPageCache().put("entityRelations", SerializationUtils.toJsonString((Object)entityRelations));
            this.getView().getPageCache().put("calculateFields", SerializationUtils.toJsonString((Object)calculateFields));
            this.getView().getPageCache().put("warnObjRefByScheme", String.valueOf(warnObjRefByScheme));
            this.getView().getPageCache().put("queryObjTplFields", SerializationUtils.toJsonString((Object)queryObjTplFields));
            this.getView().getPageCache().remove("allFieldTreeNodes");
            this.getView().getPageCache().remove("allQueryFields");
        }
    }

    public void initCommonCondition(String methodName) {
        WarnCommonConditionReturnVo conditionReturnVo = new WarnCommonConditionReturnVo();
        this.setSceneObjFields(conditionReturnVo);
        if ("initControl".equals(methodName)) {
            conditionReturnVo.setInit(true);
            conditionReturnVo.setMethod("initControl");
            String commonConditionJson = (String)this.getModel().getValue("commoncondition");
            if (HRStringUtils.isNotEmpty((String)commonConditionJson)) {
                List warnSceneCommonConditionBos = JSONArray.parseArray((String)commonConditionJson, WarnCommonConditionBo.class);
                Map referencedData = WarnCommonConditionUtils.getReferCommonConditionToSchemeName((Long)this.getModel().getDataEntity().getLong("id"));
                Iterator iterator = warnSceneCommonConditionBos.iterator();
                while (iterator.hasNext()) {
                    WarnCommonConditionBo conditionBo;
                    conditionBo.setLock(HRStringUtils.isNotEmpty((String)(conditionBo = (WarnCommonConditionBo)iterator.next()).getRuleValueUnique()) && referencedData.containsKey(conditionBo.getRuleValueUnique()));
                }
                conditionReturnVo.setConditionBos(warnSceneCommonConditionBos);
            }
        } else if ("reRenderControl".equals(methodName)) {
            conditionReturnVo.setMethod("reRenderControl");
        } else if ("reRenderControlAndClearCondition".equals(methodName)) {
            conditionReturnVo.setMethod("reRenderControlAndClearCondition");
        }
        conditionReturnVo.setEnabledLang(InteServiceHelper.getEnabledLang());
        conditionReturnVo.setOperatorMap(FilterOperatorUtils.getAllOperatorMap());
        CustomControl conditionControl = (CustomControl)this.getView().getControl("hrwarnscene");
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        conditionReturnVo.setStatus(status.name());
        conditionReturnVo.setTime(HRDateTimeUtils.curDate().toString());
        conditionControl.setData((Object)conditionReturnVo);
    }

    public void initDataFilter() {
        ArrayList WarnQueryFieldBos = Lists.newArrayListWithExpectedSize((int)16);
        String fieldTreeNodeStr = this.getView().getPageCache().get("allFieldTreeNodes");
        if (HRStringUtils.isEmpty((String)fieldTreeNodeStr)) {
            return;
        }
        List fieldTreeNodes = JSON.parseArray((String)fieldTreeNodeStr, FieldTreeNode.class);
        for (FieldTreeNode node : fieldTreeNodes) {
            QueryFieldCommonBo queryFieldCommonBo = new QueryFieldCommonBo();
            queryFieldCommonBo.setEntityName(node.getEntityName());
            queryFieldCommonBo.setEntityNumber(node.getEntityNumber());
            queryFieldCommonBo.setFieldName(node.getName());
            queryFieldCommonBo.setFieldAlias(node.getFieldAlias());
            queryFieldCommonBo.setFieldPath(node.getFieldPath());
            queryFieldCommonBo.setValueType(node.getValueType());
            queryFieldCommonBo.setComplexType(node.getComplexType());
            queryFieldCommonBo.setControlType(node.getControlType());
            queryFieldCommonBo.setVirtualEntityField(false);
            queryFieldCommonBo.setBaseDataNum(node.getBaseDataNum());
            WarnQueryFieldBos.add(queryFieldCommonBo);
        }
        this.getView().getPageCache().put("allQueryFields", SerializationUtils.toJsonString((Object)WarnQueryFieldBos));
        AnalyseObjectUtil.setFieldControlType((List)WarnQueryFieldBos);
        List inputMap = AnobjFilterUtil.getParamList((List)WarnQueryFieldBos);
        if (inputMap.isEmpty()) {
            return;
        }
        String value = (String)this.getModel().getValue("datafilter");
        HRFilter ruleCondition = (HRFilter)this.getPlugin().getControl("hrfilterap");
        HashMap data = Maps.newHashMapWithExpectedSize((int)4);
        data.put("param", inputMap);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            value = RuleUtil.getNewestConditionValue((String)value);
            data.put("value", value);
            data.put("onlyUpdateWeb", "true");
        }
        ruleCondition.setValue(value);
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.EDIT && ((Boolean)this.getModel().getValue("issyspreset")).booleanValue()) {
            data.put("pageState", OperationStatus.VIEW.toString());
        } else {
            data.put("pageState", this.getView().getFormShowParameter().getStatus().toString());
        }
        ruleCondition.updateControlData((Map)data);
    }

    public void initCustomControl() {
        List joinEntities = Collections.emptyList();
        List queryFields = Collections.emptyList();
        List queryObjTplFields = Collections.emptyList();
        List entityRelations = Collections.emptyList();
        List calculateFields = Collections.emptyList();
        List<FieldTreeNode> entityAllFields = Lists.newArrayListWithCapacity((int)10);
        String joinEntitiesStr = this.getView().getPageCache().get("joinEntities");
        String queryFieldsStr = this.getView().getPageCache().get("queryFields");
        String queryObjTplFieldsStr = this.getView().getPageCache().get("queryObjTplFields");
        String entityRelationsStr = this.getView().getPageCache().get("entityRelations");
        String calFieldsStr = this.getView().getPageCache().get("calculateFields");
        ArrayList selectedFieldKeys = Lists.newArrayListWithCapacity((int)10);
        HashSet refFieldKeys = Sets.newHashSetWithExpectedSize((int)16);
        Map<WarnSceneControlSceneEnum, Set<String>> allControlRefFieldAlias = this.getAllControlRefFieldAlias(Sets.newHashSetWithExpectedSize((int)16));
        for (Map.Entry<WarnSceneControlSceneEnum, Set<String>> entry : allControlRefFieldAlias.entrySet()) {
            Set<String> value = entry.getValue();
            if (value == null) continue;
            refFieldKeys.addAll(value);
        }
        if (HRStringUtils.isNotEmpty((String)joinEntitiesStr)) {
            joinEntities = JSON.parseArray((String)joinEntitiesStr, WarnJoinEntityBo.class);
        }
        if (HRStringUtils.isNotEmpty((String)queryFieldsStr)) {
            queryFields = JSON.parseArray((String)queryFieldsStr, WarnQueryFieldBo.class);
            queryFields.stream().filter(queryField -> queryField.isVirtualEntityField() || !queryField.getFieldAlias().endsWith(".id")).forEach(queryField -> selectedFieldKeys.add(queryField.getFieldAlias()));
        }
        if (HRStringUtils.isNotEmpty((String)queryObjTplFieldsStr)) {
            queryObjTplFields = JSON.parseArray((String)queryObjTplFieldsStr, WarnQueryFieldBo.class);
        }
        if (HRStringUtils.isNotEmpty((String)entityRelationsStr)) {
            entityRelations = JSON.parseArray((String)entityRelationsStr, WarnEntityRelationBo.class);
        }
        if (HRStringUtils.isNotEmpty((String)calFieldsStr)) {
            calculateFields = JSON.parseArray((String)calFieldsStr, WarnCalFieldBo.class);
            calculateFields.stream().filter(WarnCalFieldBo::getSelected).forEach(field -> {
                if (refFieldKeys.contains(field.getFieldNumber())) {
                    field.setDisabled(Boolean.TRUE);
                }
                selectedFieldKeys.add(field.getFieldNumber());
            });
            calculateFields.stream().forEach(field -> refFieldKeys.addAll(field.getRefEntityFields()));
        }
        Set sceneQueryFieldAliasSet = queryFields.stream().map(QueryFieldCommonBo::getFieldAlias).collect(Collectors.toSet());
        Map<String, String> fieldMap = queryObjTplFields.stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, QueryFieldCommonBo::getEntityNumber));
        Map<String, LocaleString> fieldNameMap = queryObjTplFields.stream().filter(field -> !sceneQueryFieldAliasSet.contains(field.getFieldAlias())).collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, QueryFieldCommonBo::getFieldName));
        List objTplEntityNumbers = joinEntities.stream().filter(e -> e.isCore()).map(e -> e.getEntityAlias()).collect(Collectors.toList());
        FieldDefineService service = new FieldDefineService();
        service.setSetComplexType(true);
        service.setShowHRPersonQuery(true);
        entityAllFields = service.getEntityAllFields(WarnComplexObjTransferUtil.transferJoinEntityBos((List)joinEntities), WarnComplexObjTransferUtil.transferQueryFieldBos((List)queryFields), (Set)refFieldKeys);
        entityAllFields.forEach(e -> {
            if (objTplEntityNumbers.contains(e.getNumber())) {
                WarningCommonUtils.deleteFieldTreeNode((FieldTreeNode)e, (Map)fieldMap, (Set)refFieldKeys, (boolean)false);
                WarningCommonUtils.changeFieldTreeNodeName((FieldTreeNode)e, (Map)fieldNameMap);
            }
        });
        this.setAllFieldsToCache(entityAllFields);
        FieldDefineService fieldDefineService = new FieldDefineService();
        List dataSourceCloudBos = fieldDefineService.getDataSourceTree();
        Map<String, Object> dataMap = this.assembleData(dataSourceCloudBos, joinEntities, entityRelations, entityAllFields, calculateFields, selectedFieldKeys, refFieldKeys);
        List warnObjTplBoList = WarnObjTplService.getInstance().queryFields("1");
        DynamicObject warnObjTpl = this.getModel().getDataEntity().getDynamicObject("warnobjtpl");
        if (null != warnObjTpl) {
            warnObjTplBoList.stream().filter(bo -> HRStringUtils.equals((String)bo.getId(), (String)warnObjTpl.getString("id"))).findAny().ifPresent(bo -> bo.setSelected(Boolean.valueOf(true)));
        }
        dataMap.put("warnObjTplSource", warnObjTplBoList);
        dataMap.put("form", "warnscene");
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        customcontrol.setData(dataMap);
        this.getView().getPageCache().put("initCompleted", "1");
    }

    private Map<String, Object> assembleData(List<DataSourceCloudBo> clouds, List<WarnJoinEntityBo> joinEntities, List<WarnEntityRelationBo> entityRelations, List<FieldTreeNode> entityAllFields, List<WarnCalFieldBo> calculateFields, List<String> selectedFieldKeys, Set<String> refFieldAlias) {
        for (WarnJoinEntityBo joinEntity : joinEntities) {
            if (!HRStringUtils.equals((String)joinEntity.getType(), (String)"sub")) continue;
            entityRelations.stream().filter(relation -> HRStringUtils.equals((String)relation.getJoinEntityAlias(), (String)joinEntity.getEntityAlias())).findAny().ifPresent(arg_0 -> ((WarnJoinEntityBo)joinEntity).setEntityRelation(arg_0));
        }
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String statusParam = status.toString();
        if (status == OperationStatus.EDIT && ((Boolean)this.getModel().getValue("issyspreset")).booleanValue()) {
            statusParam = OperationStatus.VIEW.toString();
        }
        this.getView().getPageCache().put("pageStatus", statusParam);
        dataMap.put("status", statusParam);
        dataMap.put("entityNodes", joinEntities);
        dataMap.put("clouds", clouds);
        if (HRStringUtils.equals((String)statusParam, (String)OperationStatus.VIEW.toString())) {
            entityAllFields.forEach(this::disableFieldTreeNode);
            calculateFields.forEach(field -> field.setDisabled(Boolean.TRUE));
        }
        dataMap.put("fieldTreeNode", entityAllFields);
        dataMap.put("calFields", calculateFields);
        List<String> refFieldAliasList = this.getAllRefFieldAliasByCalField(calculateFields);
        dataMap.put("refFieldAliasList", refFieldAliasList);
        dataMap.put("filterFieldAliasList", refFieldAlias);
        dataMap.put("selectedFieldKeys", selectedFieldKeys);
        dataMap.put("method", "init");
        dataMap.put("isReport", Boolean.TRUE);
        FieldDefineService fieldDefineService = new FieldDefineService();
        dataMap.put("entities", fieldDefineService.getAllEntities(clouds));
        String dataSource = "business";
        dataMap.put("dataSource", dataSource);
        return dataMap;
    }

    private void disableFieldTreeNode(FieldTreeNode node) {
        node.setDisabled(Boolean.TRUE);
        if (node.getChildren() != null) {
            for (FieldTreeNode child : node.getChildren()) {
                this.disableFieldTreeNode(child);
            }
        }
    }

    private void setSceneObjFields(WarnCommonConditionReturnVo conditionReturnVo) {
        String calFieldsStr;
        String queryFieldsStr = this.getPageCache().get("queryFields");
        if (HRStringUtils.isNotEmpty((String)queryFieldsStr)) {
            List queryFieldBos = JSON.parseArray((String)queryFieldsStr, WarnQueryFieldBo.class);
            WarningSceneService sceneService = WarningSceneService.getInstance();
            sceneService.setQueryFieldEnumComboItems(queryFieldBos);
            Iterator iterator = queryFieldBos.iterator();
            while (iterator.hasNext()) {
                String fieldAlias;
                WarnQueryFieldBo queryFieldBo = (WarnQueryFieldBo)iterator.next();
                String complexType = queryFieldBo.getComplexType();
                if (FieldComplexType.ADMIN_ORG.getValue().equals(complexType) || FieldComplexType.HIS_BASE_DATA.getValue().equals(complexType)) {
                    queryFieldBo.setComplexType(FieldComplexType.BASE_DATA.getValue());
                }
                if (!HRStringUtils.isNotEmpty((String)(fieldAlias = queryFieldBo.getFieldAlias())) || !fieldAlias.endsWith(".id")) continue;
                iterator.remove();
            }
            conditionReturnVo.setQueryFieldBos(queryFieldBos);
        }
        if (HRStringUtils.isNotEmpty((String)(calFieldsStr = this.getPageCache().get("calculateFields")))) {
            List calFieldBos = JSON.parseArray((String)calFieldsStr, WarnCalFieldBo.class);
            conditionReturnVo.setCalFieldBos(calFieldBos.stream().filter(e -> e.getSelected()).collect(Collectors.toList()));
        }
    }
}

