/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.earlywarn.scheme;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.function.service.ReportFunctionExecuteService;
import kd.hr.hbp.business.service.formula.helper.FormulaViewServiceHelper;
import kd.hr.hbp.business.service.function.FunctionSubPageService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.calfield.WarnCalcFieldService;
import kd.hr.hrcs.common.constants.earlywarn.WarnCalFieldConstants;
import kd.hr.hrcs.common.constants.earlywarn.WarnSchemeAdConditionConstants;
import kd.hr.hrcs.common.constants.earlywarn.WarnSchemeFieldConstants;
import kd.hr.hrcs.common.model.earlywarn.WarnCalFieldBo;
import kd.hr.hrcs.formplugin.web.earlywarn.scheme.enums.ConditionEditorKeyEnum;
import kd.hr.hrcs.formplugin.web.earlywarn.scheme.enums.OperatorEnum;

@ExcludeFromJacocoGeneratedReport
public class WarnSchemeAdFilterEditPlugin
extends HRDataBaseEdit
implements WarnSchemeFieldConstants,
WarnCalFieldConstants,
WarnSchemeAdConditionConstants {
    private static final Log LOG = LogFactory.getLog(WarnSchemeAdFilterEditPlugin.class);
    private static final Set<Character> SPECIAL_CHAR = Sets.newHashSet((Object[])new Character[]{Character.valueOf('['), Character.valueOf(']'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('*'), Character.valueOf('/'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('\"'), Character.valueOf(','), Character.valueOf(' '), Character.valueOf('='), Character.valueOf('>'), Character.valueOf('<'), Character.valueOf('!'), Character.valueOf('\"')});
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^([-+])?\\d+(\\.\\d+)?$");
    private static final String[] BTN_KEY_ARRAY = new String[]{"oper_plus", "oper_subtract", "oper_multiply", "oper_divide", "oper_gt", "oper_lt", "oper_gtorequal", "oper_ltorequal", "oper_unequal", "oper_equal", "oper_leftparenthesis", "oper_rightparenthesis", "oper_dublequotationmark", "oper_and", "oper_or"};
    private static final Map<String, String> OPERATOR_MAP = ImmutableMap.builder().put((Object)"oper_plus", (Object)" + ").put((Object)"oper_subtract", (Object)" - ").put((Object)"oper_multiply", (Object)" * ").put((Object)"oper_divide", (Object)" / ").put((Object)"oper_gt", (Object)" > ").put((Object)"oper_lt", (Object)" < ").put((Object)"oper_gtorequal", (Object)" >= ").put((Object)"oper_ltorequal", (Object)" <= ").put((Object)"oper_unequal", (Object)" != ").put((Object)"oper_equal", (Object)" = ").put((Object)"oper_leftparenthesis", (Object)" (").put((Object)"oper_rightparenthesis", (Object)") ").put((Object)"oper_dublequotationmark", (Object)"\"\"").put((Object)"oper_and", (Object)" and ").put((Object)"oper_or", (Object)" or ").build();
    private final Random rand = new SecureRandom();
    private final FunctionSubPageService functionSubPageService = new FunctionSubPageService();

    public void registerListener(EventObject e) {
        try {
            super.registerListener(e);
            this.addClickListeners(BTN_KEY_ARRAY);
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
    }

    public void beforeBindData(EventObject e) {
        try {
            super.beforeBindData(e);
            this.updateAdConditionCache();
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
    }

    public void afterBindData(EventObject e) {
        try {
            super.afterBindData(e);
            this.initFormulaEditor();
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        try {
            Object oldValue;
            super.propertyChanged(args);
            String fieldKey = args.getProperty().getName();
            if (HRStringUtils.equals((String)"warnscene", (String)fieldKey) && (oldValue = args.getChangeSet()[0].getOldValue()) == null) {
                this.refreshFormulaEdit();
            }
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
    }

    public void click(EventObject evt) {
        try {
            super.click(evt);
            Control source = (Control)evt.getSource();
            String key = source.getKey();
            if (key.startsWith("oper_") && source instanceof Button) {
                this.addOperationToEditor((Button)source);
            }
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        try {
            super.beforeDoOperation(args);
            AbstractOperate op = (AbstractOperate)args.getSource();
            String operateKey = op.getOperateKey();
            if ("save".equals(operateKey)) {
                this.beforeSave(args, op);
            }
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        try {
            super.afterDoOperation(afterDoOperationEventArgs);
            AbstractOperate op = (AbstractOperate)afterDoOperationEventArgs.getSource();
            String operateKey = op.getOperateKey();
            if ("save".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                this.updateAdConditionCache();
            }
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
    }

    public void customEvent(CustomEventArgs eventArgs) {
        try {
            String key = eventArgs.getKey();
            String args = eventArgs.getEventArgs();
            if ("conditioneditor".equals(key)) {
                this.updateOriginalExp(args);
            }
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
    }

    private void updateOriginalExp(String args) {
        String originalExp = (String)this.getModel().getValue("adconditionviewexpr");
        if (!HRStringUtils.equals((String)originalExp, (String)args)) {
            this.getModel().setValue("adconditionviewexpr", (Object)args);
        }
    }

    private void beforeSave(BeforeDoOperationEventArgs args, AbstractOperate op) {
        try {
            WarnCalFieldBo warnCalFieldBo = this.buildAdConditionCalFieldBo();
            if (warnCalFieldBo != null) {
                op.getOption().setVariableValue("OP_AD_CONDITION_CAL_FIELD_KEY", SerializationUtils.toJsonString((Object)warnCalFieldBo));
            } else {
                this.getPageCache().remove("CACHE_CURRENT_AD_CONDITION_FIELD");
            }
        }
        catch (KDBizException e) {
            args.setCancel(true);
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    private void initFormulaEditor() {
        String showValue;
        CustomControl conditionEditor = (CustomControl)this.getView().getControl("conditioneditor");
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        List<Map<String, Object>> fields = this.getFieldListCache();
        data.put("key", this.getEditorKey(fields));
        try {
            showValue = this.getShowConditionExp(fields);
        }
        catch (Exception e) {
            LOG.error(String.format(Locale.ROOT, "translate_lang_error_id_is_%1$s", this.getModel().getDataEntity().getPkValue()), (Throwable)e);
            WarnCalFieldBo currentCalField = this.getCurrentCalField();
            showValue = currentCalField != null ? currentCalField.getViewExpr() : "";
        }
        data.put("value", showValue);
        if (HRStringUtils.isNotEmpty((String)showValue)) {
            this.getModel().setValue("adconditionviewexpr", (Object)showValue);
            this.getModel().setDataChanged(false);
        }
        if (FormulaViewServiceHelper.isViewStatus((IFormView)this.getView())) {
            data.put("readOnly", "true");
        }
        data.put("date", String.valueOf(System.currentTimeMillis()));
        conditionEditor.setData(data);
    }

    void refreshFormulaEdit() {
        try {
            CustomControl formulaEditor = (CustomControl)this.getView().getControl("conditioneditor");
            HashMap<String, Object> data = new HashMap<String, Object>(16);
            List<Map<String, Object>> fields = this.getFieldListCache();
            data.put("method", "refreshKey");
            data.put("key", this.getEditorKey(fields));
            data.put("value", "");
            data.put("date", String.valueOf(System.currentTimeMillis()));
            formulaEditor.setData(data);
            this.getPageCache().remove("CACHE_CURRENT_AD_CONDITION_FIELD");
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
    }

    private void addOperationToEditor(Button button) {
        String key = button.getKey();
        CustomControl formulaEditor = (CustomControl)this.getView().getControl("conditioneditor");
        HashMap<String, String> data = new HashMap<String, String>(16);
        data.put("method", "insertValue");
        String value = OPERATOR_MAP.get(key);
        data.put("value", value);
        data.put("date", String.valueOf(System.currentTimeMillis()));
        formulaEditor.setData(data);
    }

    private Map<String, Object> getEditorKey(List<Map<String, Object>> fieldList) {
        HashMap editorKeyMap = Maps.newHashMapWithExpectedSize((int)16);
        HashSet keySet = Sets.newHashSetWithExpectedSize((int)16);
        keySet.addAll(Arrays.stream(OperatorEnum.values()).map(OperatorEnum::getAlias).collect(Collectors.toList()));
        editorKeyMap.put("conditionKey", keySet);
        keySet = Sets.newHashSetWithExpectedSize((int)16);
        keySet.addAll(fieldList.stream().map(field -> "[" + field.get("fieldName") + "]").collect(Collectors.toList()));
        editorKeyMap.put("fieldItemKey", keySet);
        keySet = Sets.newHashSetWithExpectedSize((int)16);
        keySet.add(ConditionEditorKeyEnum.QUOT.getAlias());
        editorKeyMap.put("textKey", keySet);
        return editorKeyMap;
    }

    private List<Map<String, Object>> getFieldListCache() {
        String fieldStr = this.getPageCache().get("CACHE_KEY_FIELD_MAP_LIST");
        if (HRStringUtils.isEmpty((String)fieldStr)) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        return (List)SerializationUtils.fromJsonString((String)fieldStr, List.class);
    }

    private String getShowConditionExp(List<Map<String, Object>> fields) {
        WarnCalFieldBo currentCalField = this.getCurrentCalField();
        if (currentCalField == null) {
            return "";
        }
        String viewExpr = currentCalField.getViewExpr();
        if (HRStringUtils.isEmpty((String)viewExpr)) {
            viewExpr = currentCalField.getExpr();
        }
        return this.functionSubPageService.replaceFieldName(viewExpr, fields);
    }

    private WarnCalFieldBo buildAdConditionCalFieldBo() throws KDBizException {
        ArrayList<String> refFieldNums;
        Map<String, Object> defaultValMap;
        String viewExpr = (String)this.getModel().getValue("adconditionviewexpr");
        if (HRStringUtils.isEmpty((String)viewExpr)) {
            return null;
        }
        StringBuilder errorMsg = new StringBuilder();
        Map<String, Object> functionExpr = this.parseFunctionExpr(errorMsg);
        if (functionExpr == null) {
            throw new KDBizException(errorMsg.toString());
        }
        String expr = (String)functionExpr.get("expr");
        if (HRStringUtils.isEmpty((String)expr)) {
            return null;
        }
        String functionViewExpr = (String)functionExpr.get("viewExpr");
        Object executeResult = this.preExecuteExpr(functionViewExpr, defaultValMap = this.getDefaultValMap(refFieldNums = new ArrayList<String>((Set)functionExpr.get("refFieldNums"))), errorMsg);
        if (executeResult == null && errorMsg.length() > 0) {
            throw new KDBizException(errorMsg.toString());
        }
        if (!(executeResult instanceof Boolean)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ec5\u7ef4\u62a4\u5e03\u5c14\u7c7b\u578b\u7684\u9ad8\u7ea7\u6761\u4ef6\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"WarnSchemeAdFilterEditPlugin_0", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]));
        }
        WarnCalFieldBo currentCalField = this.getCurrentCalField();
        currentCalField = this.setCurrentCalculateField(currentCalField, functionExpr);
        String calculateStr = this.getPageCache().get("CACHE_KEY_CAL_FIELD_LIST");
        List calculateFieldBos = Lists.newArrayListWithCapacity((int)10);
        if (HRStringUtils.isNotEmpty((String)calculateStr)) {
            calculateFieldBos = JSON.parseArray((String)calculateStr, WarnCalFieldBo.class);
        }
        this.handleCalculateRefFieldAndOrder(currentCalField, calculateFieldBos, refFieldNums);
        currentCalField.setCalMethod("normal");
        return currentCalField;
    }

    private Map<String, Object> parseFunctionExpr(StringBuilder errorMsg) {
        String viewExpr = (String)this.getModel().getValue("adconditionviewexpr");
        String fieldStr = this.getPageCache().get("CACHE_KEY_FIELD_NAME_TO_NUMBER_MAP");
        String baseDataMapStr = this.getPageCache().get("CACHE_LEFT_TREE_BASE_DATA_MAP");
        Map baseDataMap = Maps.newHashMapWithExpectedSize((int)16);
        if (HRStringUtils.isNotEmpty((String)baseDataMapStr)) {
            baseDataMap = (Map)SerializationUtils.fromJsonString((String)baseDataMapStr, Map.class);
        }
        String enumEntityNumMapStr = this.getPageCache().get("CACHE_LEFT_TREE_ENUM_MAP");
        Map enumEntityNumMap = Maps.newHashMapWithExpectedSize((int)16);
        if (HRStringUtils.isNotEmpty((String)baseDataMapStr)) {
            enumEntityNumMap = (Map)SerializationUtils.fromJsonString((String)enumEntityNumMapStr, Map.class);
        }
        return this.functionSubPageService.parseFunctionExpr(errorMsg, viewExpr, fieldStr, baseDataMap, enumEntityNumMap);
    }

    private Map<String, Object> getDefaultValMap(List<String> refFieldNums) {
        if (refFieldNums == null || refFieldNums.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap defaultValMap = Maps.newHashMapWithExpectedSize((int)16);
        String fieldMapStr = this.getPageCache().get("CACHE_KEY_FIELD_NUMBER_TO_IDENTITY_MAP");
        Map fieldMap = (Map)SerializationUtils.fromJsonString((String)fieldMapStr, Map.class);
        for (String refFieldNum : refFieldNums) {
            DataTypeEnum typeEnum;
            boolean isBaseData;
            if (refFieldNum.endsWith(".id")) continue;
            Map field = (Map)fieldMap.get(refFieldNum);
            String type = (String)field.get("valueType");
            String baseDataNum = (String)field.get("baseDataNum");
            boolean bl = isBaseData = HRStringUtils.isNotEmpty((String)baseDataNum) && (refFieldNum.endsWith(".name") || refFieldNum.endsWith(".number"));
            if (isBaseData) {
                String idType = this.getBaseDataIdType(baseDataNum);
                typeEnum = DataTypeEnum.of((String)idType);
            } else {
                typeEnum = DataTypeEnum.of((String)type);
            }
            switch (typeEnum) {
                case STRING: 
                case LOCALESTRING: {
                    defaultValMap.put(refFieldNum, "2023-02-03");
                    break;
                }
                case DATETIME: {
                    defaultValMap.put(refFieldNum, new Date());
                    break;
                }
                case INTEGER: {
                    defaultValMap.put(refFieldNum, this.rand.nextInt());
                    break;
                }
                case LONG: {
                    defaultValMap.put(refFieldNum, this.rand.nextLong());
                    break;
                }
                case BIGDECIMAL: {
                    defaultValMap.put(refFieldNum, this.rand.nextDouble());
                    break;
                }
                case BOOLEAN: {
                    defaultValMap.put(refFieldNum, "1");
                    break;
                }
            }
        }
        return defaultValMap;
    }

    private String getBaseDataIdType(String baseDataNum) {
        Class propertyType = EntityMetadataCache.getDataEntityType((String)baseDataNum).getPrimaryKey().getPropertyType();
        if (propertyType == Long.TYPE || propertyType == Long.class) {
            return "long";
        }
        return "string";
    }

    private Object preExecuteExpr(String expr, Map<String, Object> paramMap, StringBuilder errorMsg) {
        return this.functionSubPageService.preExecuteExpr(expr, paramMap, errorMsg, ReportFunctionExecuteService.class.getName());
    }

    private WarnCalFieldBo getCurrentCalField() {
        String currentCalFieldStr = this.getPageCache().get("CACHE_CURRENT_AD_CONDITION_FIELD");
        if (HRStringUtils.isEmpty((String)currentCalFieldStr)) {
            return null;
        }
        return (WarnCalFieldBo)SerializationUtils.fromJsonString((String)currentCalFieldStr, WarnCalFieldBo.class);
    }

    private WarnCalFieldBo setCurrentCalculateField(WarnCalFieldBo currentCalField, Map<String, Object> exprMap) {
        LocaleString name = ResManager.getLocaleString((String)AD_CONDITION_CAL_FIELD_NAME.getDescription(), (String)AD_CONDITION_CAL_FIELD_NAME.getResourceID(), (String)AD_CONDITION_CAL_FIELD_NAME.getSystemType());
        if (currentCalField == null) {
            currentCalField = new WarnCalFieldBo(name, "AD_CONDITION_CAL_FIELD_NUMBER");
            currentCalField.setSelected(Boolean.valueOf(true));
            currentCalField.setIndex(Integer.valueOf(0));
            currentCalField.setSource("warnscheme");
        } else {
            currentCalField.setFieldName(name);
            currentCalField.setFieldNumber("AD_CONDITION_CAL_FIELD_NUMBER");
            currentCalField.setTitle(currentCalField.getFieldName().getLocaleValue() + " | " + currentCalField.getFieldNumber());
        }
        String runExpr = (String)exprMap.get("runExpr");
        String viewExpr = (String)exprMap.get("viewExpr");
        boolean isUseFunc = (Boolean)exprMap.get("isUseFunc");
        currentCalField.setValueType(DataTypeEnum.BOOLEAN.getDataTypeKey());
        currentCalField.setExpr(runExpr);
        currentCalField.setViewExpr(viewExpr);
        if (isUseFunc) {
            currentCalField.setType("complex");
        } else {
            currentCalField.setType("simple");
        }
        String controlType = WarnCalcFieldService.getInstance().getControlTypeByValueType(DataTypeEnum.BOOLEAN.getDataTypeKey());
        currentCalField.setControlType(controlType);
        return currentCalField;
    }

    private void handleCalculateRefFieldAndOrder(WarnCalFieldBo currentCalField, List<WarnCalFieldBo> calculateFieldBos, List<String> refFieldNums) {
        this.parseCalFieldRef(currentCalField.getExpr(), currentCalField, calculateFieldBos, refFieldNums);
    }

    private void parseCalFieldRef(String parsedExpr, WarnCalFieldBo currentCalField, List<WarnCalFieldBo> calculateFieldBos, List<String> refFieldNums) {
        if (calculateFieldBos.isEmpty() && refFieldNums.isEmpty()) {
            return;
        }
        Map<String, WarnCalFieldBo> calFieldMap = calculateFieldBos.stream().collect(Collectors.toMap(WarnCalFieldBo::getFieldNumber, field -> field));
        int currentOrder = 0;
        ArrayList refCalFields = Lists.newArrayListWithExpectedSize((int)16);
        char[] exprArr = parsedExpr.toCharArray();
        StringBuilder fieldSb = new StringBuilder();
        boolean isQuotation = false;
        for (char chr : exprArr) {
            if (SPECIAL_CHAR.contains(Character.valueOf(chr))) {
                if (chr == '\"') {
                    boolean bl = isQuotation = !isQuotation;
                }
                if (fieldSb.length() <= 0) continue;
                if (chr == '(' || isQuotation || NUMBER_PATTERN.matcher(fieldSb.toString()).matches()) {
                    fieldSb = new StringBuilder();
                    continue;
                }
                if (!fieldSb.toString().startsWith("$") || !fieldSb.toString().endsWith("$")) {
                    fieldSb = new StringBuilder();
                    continue;
                }
                currentOrder = this.handleRefField(fieldSb, currentOrder, calFieldMap, refCalFields, refFieldNums);
                fieldSb = new StringBuilder();
                continue;
            }
            fieldSb.append(chr);
        }
        if (fieldSb.length() > 0 && !NUMBER_PATTERN.matcher(fieldSb.toString()).matches() && fieldSb.toString().startsWith("$") && fieldSb.toString().endsWith("$")) {
            currentOrder = this.handleRefField(fieldSb, currentOrder, calFieldMap, refCalFields, refFieldNums);
        }
        currentCalField.setRefEntityFields(refFieldNums);
        currentCalField.setRefCalculateFields((List)refCalFields);
        currentCalField.setOrder(Integer.valueOf(++currentOrder));
    }

    private int handleRefField(StringBuilder fieldSb, int currentOrder, Map<String, WarnCalFieldBo> calFieldMap, List<WarnCalFieldBo> refCalFields, List<String> refFieldNums) {
        String newFieldNum = fieldSb.substring(1, fieldSb.length() - 1);
        WarnCalFieldBo calField = calFieldMap.get(newFieldNum);
        if (calField != null) {
            refCalFields.add(calField);
            currentOrder = calField.getOrder() > currentOrder ? calField.getOrder() : currentOrder;
            refFieldNums.remove(newFieldNum);
        }
        return currentOrder;
    }

    private void updateAdConditionCache() {
        List warnCalFieldBos;
        DynamicObject warnScene;
        Object id;
        DynamicObject schemeDy = this.getModel().getDataEntity();
        BaseShowParameter showParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        Boolean isCopy = (Boolean)showParameter.getCustomParam("iscopy");
        if (isCopy != null && isCopy.booleanValue()) {
            id = showParameter.getPkId();
            schemeDy = new HRBaseServiceHelper("hrcs_warnscheme").loadSingle(id);
        } else {
            id = schemeDy.getPkValue();
        }
        if (id != null && !"0".equals(String.valueOf(id)) && (warnScene = schemeDy.getDynamicObject("warnscene")) != null && !(warnCalFieldBos = WarnCalcFieldService.getInstance().loadAllSchemeCalFieldsForBo(warnScene, schemeDy)).isEmpty()) {
            if (isCopy != null && isCopy.booleanValue()) {
                warnCalFieldBos = warnCalFieldBos.stream().peek(calField -> calField.setId(null)).collect(Collectors.toList());
            }
            this.getPageCache().put("CACHE_CURRENT_AD_CONDITION_FIELD", SerializationUtils.toJsonString(warnCalFieldBos.get(0)));
        }
    }
}

