/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.earlywarn.scheme;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.formula.entity.floatcontrol.SelectItem;
import kd.hr.hbp.business.service.formula.entity.item.CalItem;
import kd.hr.hbp.business.service.formula.entity.item.Item;
import kd.hr.hbp.business.service.formula.entity.item.TreeNodeItem;
import kd.hr.hbp.business.service.formula.enums.CalItemTypeEnum;
import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;
import kd.hr.hbp.business.service.formula.helper.FormulaViewServiceHelper;
import kd.hr.hbp.business.service.formula.utils.FormulaTreeNodeUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.model.complexobj.labelandreport.FieldTreeNode;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.calfield.CalFieldHelper;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.utils.WarnObjUtils;
import kd.hr.hrcs.common.constants.earlywarn.WarnSchemeAdConditionConstants;
import kd.hr.hrcs.common.constants.earlywarn.WarnSchemeFieldConstants;
import kd.hr.hrcs.common.model.earlywarn.WarnCalFieldBo;

@ExcludeFromJacocoGeneratedReport
public class WarnSchemeAdFilterLeftTreeEditPlugin
extends HRDataBaseEdit
implements WarnSchemeFieldConstants,
WarnSchemeAdConditionConstants,
TreeNodeClickListener,
SearchEnterListener {
    private static final Log LOG = LogFactory.getLog(WarnSchemeAdFilterLeftTreeEditPlugin.class);
    private static final String FIELD_TREE_VIEW = "fieldtreeview";
    private static final String SEARCHAP = "searchap";
    private static final String FLOAT = "float";
    private static final String APPEND_LOAD_DATA = "appendLoadData";
    private static final String SEARCH_LIST_ITEM = "searchListItem";
    private final MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();

    public void registerListener(EventObject e) {
        try {
            super.registerListener(e);
            TreeView treeView = (TreeView)this.getView().getControl(FIELD_TREE_VIEW);
            treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
            Search search = (Search)this.getView().getControl(SEARCHAP);
            search.addEnterListener((SearchEnterListener)this);
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
    }

    public void beforeBindData(EventObject e) {
        try {
            super.beforeBindData(e);
            this.renderFieldTree();
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        try {
            Object oldValue;
            super.propertyChanged(args);
            String fieldKey = args.getProperty().getName();
            if (HRStringUtils.equals((String)"warnscene", (String)fieldKey) && (oldValue = args.getChangeSet()[0].getOldValue()) == null) {
                this.renderFieldTree();
            }
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        try {
            String nodeId = evt.getNodeId().toString();
            String parentId = (String)evt.getParentNodeId();
            if (HRStringUtils.isEmpty((String)parentId)) {
                return;
            }
            FloatResult floatResult = this.getItemValue(nodeId, 0, null);
            if (floatResult != null && !HRObjectUtils.isEmpty(floatResult.getItems())) {
                this.getView().setVisible(Boolean.TRUE, new String[]{FLOAT});
                this.showFloat(floatResult, nodeId, false, false);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{FLOAT});
            }
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
    }

    private FloatResult getItemValue(String nodeId, int start, String searchValue) {
        CalItem calItem = this.getCalItemByNodeId(nodeId);
        if (Objects.nonNull(calItem)) {
            if (CalItemTypeEnum.BASE_DATA == calItem.getItemType() && HRStringUtils.isNotEmpty((String)calItem.getEntityNumber()) && HRStringUtils.isNotEmpty((String)calItem.getPropertyField()) && !"id".equals(calItem.getPropertyField())) {
                return this.getBaseDataFloatList(calItem, start, searchValue);
            }
            if (CalItemTypeEnum.ENUM == calItem.getItemType() && HRStringUtils.isNotEmpty((String)calItem.getEntityNumber()) && HRStringUtils.isNotEmpty((String)calItem.getPropertyField())) {
                return this.getEnumItemFloatList(calItem, start, searchValue);
            }
        }
        return null;
    }

    private CalItem getCalItemByNodeId(String nodeId) {
        HRPageCache pageCache = new HRPageCache(this.getView());
        Map map = (Map)pageCache.get("CACHE_KEY_FIELD_ITEM_MAP", Map.class);
        if (map == null) {
            return null;
        }
        Object value = map.get(nodeId);
        if (value == null) {
            return null;
        }
        return (CalItem)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(value), CalItem.class);
    }

    private List<TreeNodeItem> getTreeNodeItemCache() {
        HRPageCache pageCache = new HRPageCache(this.getView());
        List list = (List)pageCache.get("CACHE_KEY_FIELD_TREE_NODE_LIST", List.class);
        if (list == null) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        ArrayList treeNodeItems = Lists.newArrayListWithExpectedSize((int)list.size());
        for (Object obj : list) {
            treeNodeItems.add(JSONObject.parseObject((String)SerializationUtils.toJsonString(obj), TreeNodeItem.class));
        }
        return treeNodeItems;
    }

    private void showFloat(FloatResult FieldFloatResult, String nodeId, boolean isAppend, boolean isSearchInit) {
        CustomControl floatControl = (CustomControl)this.getView().getControl(FLOAT);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("listItem", FieldFloatResult.getItems());
        data.put("treeDom", "itemlistflex");
        data.put("nodeId", nodeId);
        data.put("nextStart", FieldFloatResult.getNextStart());
        if (isAppend) {
            data.put("isAppend", "true");
        }
        if (isSearchInit) {
            data.put("isSearchInit", "true");
        }
        data.put("isEnd", String.valueOf(FieldFloatResult.isEnd()));
        data.put("date", String.valueOf(new Date().getTime()));
        floatControl.setData(data);
    }

    public void treeNodeDoubleClick(TreeNodeEvent evt) {
        try {
            Optional<TreeNodeItem> first;
            String nodeId = evt.getNodeId().toString();
            String parentId = (String)evt.getParentNodeId();
            if (HRStringUtils.isEmpty((String)parentId) || FormulaViewServiceHelper.isViewStatus((IFormView)this.getView())) {
                return;
            }
            List<TreeNodeItem> treeNodeItems = this.getTreeNodeItemCache();
            if (!HRStringUtils.isEmpty((String)nodeId) && (first = treeNodeItems.stream().filter(treeNodeItem -> nodeId.equals(treeNodeItem.getId())).findFirst()).isPresent()) {
                TreeNodeItem nodeItem = first.get();
                if (treeNodeItems.stream().noneMatch(treeNodeItem -> nodeItem.getId().equals(treeNodeItem.getParentId()))) {
                    CustomControl formulaEditor = (CustomControl)this.getView().getControl("conditioneditor");
                    HashMap<String, String> data = new HashMap<String, String>();
                    String itemPrefix = "[%s]";
                    data.put("method", "insertValue");
                    data.put("value", String.format(itemPrefix, nodeItem.getName().trim()));
                    data.put("date", String.valueOf(new Date().getTime()));
                    formulaEditor.setData(data);
                }
            }
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
    }

    public void search(SearchEnterEvent arg) {
        try {
            List<Object> findNodeItems;
            String searchText = arg.getText();
            List<TreeNodeItem> treeNodeItems = this.getTreeNodeItemCache();
            if (HRStringUtils.isNotEmpty((String)searchText)) {
                findNodeItems = treeNodeItems.stream().filter(treeNodeItem -> HRStringUtils.isNotEmpty((String)treeNodeItem.getName()) && treeNodeItem.getName().contains(searchText)).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(findNodeItems)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22,\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879", (String)"", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]));
                    return;
                }
                findNodeItems.addAll(FormulaTreeNodeUtils.getAllParentTreeNodeItem(findNodeItems, treeNodeItems));
            } else {
                findNodeItems = treeNodeItems;
            }
            FormulaTreeNodeUtils.loadTreeNodeItemList(findNodeItems).ifPresent(nodeList -> {
                TreeView treeView = (TreeView)this.getView().getControl(FIELD_TREE_VIEW);
                treeView.deleteAllNodes();
                treeView.addNodes(nodeList);
            });
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
    }

    public void customEvent(CustomEventArgs e) {
        try {
            String key = e.getKey();
            String name = e.getEventName();
            String args = e.getEventArgs();
            if (HRStringUtils.equals((String)key, (String)FLOAT) && !FormulaViewServiceHelper.isViewStatus((IFormView)this.getView())) {
                CustomControl formulaEditor = (CustomControl)this.getView().getControl("conditioneditor");
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("method", name);
                data.put("value", args);
                if (FormulaViewServiceHelper.isViewStatus((IFormView)this.getView())) {
                    data.put("method", "readOnly");
                    data.put("readOnly", "true");
                }
                data.put("date", String.valueOf(new Date().getTime()));
                formulaEditor.setData(data);
            }
            if (HRStringUtils.equals((String)key, (String)FLOAT) && (HRStringUtils.equals((String)name, (String)APPEND_LOAD_DATA) || HRStringUtils.equals((String)name, (String)SEARCH_LIST_ITEM)) && HRStringUtils.isNotEmpty((String)args)) {
                JSONObject param = JSONObject.parseObject((String)args);
                int start = param.getIntValue("start");
                String nodeId = param.getString("nodeId");
                String searchValue = param.getString("searchValue");
                boolean isAppend = HRStringUtils.equals((String)"true", (String)param.getString("isAppend"));
                FloatResult FieldFloatResult = this.getItemValue(nodeId, start, searchValue);
                if (FieldFloatResult == null) {
                    return;
                }
                int offset = 0;
                if (FieldFloatResult.getItems() != null) {
                    offset = FieldFloatResult.getItems().size();
                }
                boolean isSearchInit = HRStringUtils.equals((String)SEARCH_LIST_ITEM, (String)name);
                FieldFloatResult.setNextStart(start + offset);
                this.showFloat(FieldFloatResult, nodeId, isAppend, isSearchInit);
            }
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
    }

    private FloatResult getBaseDataFloatList(CalItem calItem, int start, String searchValue) {
        String entityNumber = calItem.getEntityNumber();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        HRBaseServiceHelper queryHelper = new HRBaseServiceHelper(entityNumber);
        ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)10);
        QFilter[] qFilters = calItem.getqFilters();
        DynamicProperty enable = dataEntityType.getProperty("enable");
        if (Objects.isNull(qFilters)) {
            if (enable != null) {
                qFilterList.add(new QFilter("enable", "=", (Object)"1"));
            }
        } else {
            for (QFilter qFilter : qFilters) {
                String property;
                DynamicProperty dynamicProperty;
                if (HRStringUtils.isEmpty((String)qFilter.getProperty()) || !Objects.nonNull(dynamicProperty = dataEntityType.getProperty(property = qFilter.getProperty().split("\\.")[0]))) continue;
                qFilterList.add(qFilter);
            }
            if (qFilterList.isEmpty() && enable != null) {
                qFilterList.add(new QFilter("enable", "=", (Object)"1"));
            }
        }
        String propertyField = calItem.getPropertyField();
        if (HRStringUtils.isNotEmpty((String)searchValue)) {
            String[] fields = propertyField.split(",");
            QFilter firstFilter = null;
            for (String field : fields) {
                QFilter likeFilter = QFilter.like((String)field, (String)searchValue);
                if (firstFilter == null) {
                    firstFilter = likeFilter;
                    continue;
                }
                firstFilter.or(likeFilter);
            }
            if (firstFilter != null) {
                qFilterList.add(firstFilter);
            }
        }
        DynamicObject[] baseDataArray = queryHelper.queryOriginalArray("id," + propertyField, qFilterList.toArray(new QFilter[0]), calItem.getOrders());
        ArrayList selectItems = Lists.newArrayListWithExpectedSize((int)baseDataArray.length);
        if (baseDataArray.length == 0) {
            return new FloatResult(selectItems, true);
        }
        HashSet hashSet = Sets.newHashSetWithExpectedSize((int)baseDataArray.length);
        for (DynamicObject baseData : baseDataArray) {
            SelectItem selectItem = SelectItem.getSelectItemByBaseData((CalItem)calItem, (DynamicObject)baseData);
            if (hashSet.contains(selectItem.getShowKey())) continue;
            hashSet.add(selectItem.getShowKey());
            selectItems.add(selectItem);
        }
        List<SelectItem> result = selectItems.stream().skip(start).limit(20L).collect(Collectors.toList());
        boolean isEnd = start + result.size() == selectItems.size();
        return new FloatResult(result, isEnd);
    }

    private FloatResult getEnumItemFloatList(CalItem calItem, int start, String searchValue) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)calItem.getEntityNumber());
        DynamicProperty property = mainEntityType.getProperty(calItem.getPropertyField());
        if (property instanceof ComboProp) {
            List<SelectItem> selectItems;
            ComboProp prop = (ComboProp)property;
            List comboItems = prop.getComboItems();
            if (comboItems == null) {
                return null;
            }
            if (HRStringUtils.isNotEmpty((String)searchValue)) {
                comboItems = comboItems.stream().filter(item -> item.getName().getLocaleValue().contains(searchValue)).collect(Collectors.toList());
            }
            boolean isEnd = start + (selectItems = comboItems.stream().skip(start).limit(20L).map(item -> SelectItem.getSelectItemByValueMapItem((CalItem)calItem, (ValueMapItem)item)).collect(Collectors.toList())).size() == comboItems.size();
            return new FloatResult(selectItems, isEnd);
        }
        throw new KDBizException(MessageFormat.format("{} is not a enum field in metadata {}", calItem.getPropertyField(), calItem.getEntityNumber()));
    }

    void renderFieldTree() {
        try {
            DynamicObject warnTplDy = (DynamicObject)this.getModel().getValue("warnscene");
            List fieldTreeNodes = Collections.emptyList();
            List allCalculateFields = Collections.emptyList();
            List<TreeNodeItem> treeNodeItems = Collections.emptyList();
            if (warnTplDy != null) {
                fieldTreeNodes = CalFieldHelper.getAllEntityFieldsByTree((DynamicObject)warnTplDy);
                allCalculateFields = CalFieldHelper.getAllCalculateFields((DynamicObject)warnTplDy);
                treeNodeItems = this.transToTreeOrCalItemList("", fieldTreeNodes);
                if (allCalculateFields != null && !allCalculateFields.isEmpty()) {
                    TreeNodeItem calFieldRootTreeNodeItem = this.getCalFieldRootTreeNodeItem();
                    treeNodeItems.add(calFieldRootTreeNodeItem);
                    for (WarnCalFieldBo warnCalFieldBo : allCalculateFields) {
                        treeNodeItems.add(this.transCalFieldBoToCalItem(calFieldRootTreeNodeItem.getId(), warnCalFieldBo));
                    }
                }
            }
            this.updateCache(treeNodeItems, fieldTreeNodes, allCalculateFields);
            Optional optionalTreeNodes = FormulaTreeNodeUtils.loadTreeNodeItemList(treeNodeItems);
            TreeView treeView = (TreeView)this.getView().getControl(FIELD_TREE_VIEW);
            if (optionalTreeNodes.isPresent()) {
                List treeNodes = (List)optionalTreeNodes.get();
                treeView.deleteAllNodes();
                treeView.addNodes(treeNodes);
            } else {
                treeView.deleteAllNodes();
            }
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
    }

    private List<TreeNodeItem> transToTreeOrCalItemList(String parentId, List<FieldTreeNode> fieldTreeNodes) {
        ArrayList treeNodeItems = Lists.newArrayListWithExpectedSize((int)10);
        for (FieldTreeNode fieldTreeNode : fieldTreeNodes) {
            TreeNodeItem treeNodeItem = this.transToTreeOrCalItem(parentId, fieldTreeNode);
            List children = fieldTreeNode.getChildren();
            treeNodeItems.add(treeNodeItem);
            if (children == null || children.isEmpty()) continue;
            treeNodeItem.setHasChild(true);
            List<TreeNodeItem> childNodes = this.transToTreeOrCalItemList(treeNodeItem.getId(), children);
            treeNodeItems.addAll(childNodes);
            treeNodeItem.setShow(childNodes.stream().anyMatch(TreeNodeItem::isShow));
        }
        return treeNodeItems;
    }

    private TreeNodeItem getCalFieldRootTreeNodeItem() {
        TreeNodeItem rootItem = new TreeNodeItem("", "calField", "", CAL_FIELD_TREE_NODE_NAME.loadKDString());
        rootItem.setExpand(true);
        return rootItem;
    }

    private TreeNodeItem transCalFieldBoToCalItem(String parentId, WarnCalFieldBo calFieldBo) {
        CalItem calItem = new CalItem();
        calItem.setId(calFieldBo.getFieldNumber());
        calItem.setParentId(parentId);
        calItem.setCheckUniqueCode(false);
        calItem.setUniqueCode(calFieldBo.getFieldNumber());
        calItem.setHasChild(false);
        calItem.setName(calFieldBo.getFieldName().getLocaleValue());
        calItem.setItemCategory("");
        calItem.setDataType(this.transDataTypeEnum(calFieldBo.getValueType()));
        calItem.setShow(calFieldBo.getSelected() != null && calFieldBo.getSelected() != false);
        return calItem;
    }

    private TreeNodeItem transToTreeOrCalItem(String parentId, FieldTreeNode treeNode) {
        Object item = treeNode.getField() != false ? new CalItem() : new TreeNodeItem();
        item.setCheckUniqueCode(false);
        if (treeNode.getField().booleanValue()) {
            item.setId(treeNode.getFieldAlias());
            item.setUniqueCode(treeNode.getFieldAlias());
        } else {
            item.setId(treeNode.getNumber());
            item.setUniqueCode(treeNode.getNumber());
        }
        item.setItemCategory("");
        item.setParentId(parentId);
        if (HRStringUtils.isEmpty((String)parentId)) {
            item.setExpand(true);
        }
        item.setName(treeNode.getName().getLocaleValue());
        String baseDataNum = treeNode.getBaseDataNum();
        String enumEntityNum = treeNode.getEnumEntityNum();
        if (item instanceof CalItem) {
            CalItem calItem = item;
            calItem.setDataType(this.transDataTypeEnum(treeNode.getValueType()));
            if (HRStringUtils.isNotEmpty((String)baseDataNum)) {
                calItem.setItemType(CalItemTypeEnum.BASE_DATA);
                calItem.setEntityNumber(baseDataNum);
                IDataEntityProperty property = WarnObjUtils.parseFieldAliasGetProperty((String)treeNode.getEntityNumber(), (String)treeNode.getFieldAlias(), (MainEntityTypeUtil)this.mainEntityTypeUtil);
                calItem.setPropertyField(property.getName());
            } else if (HRStringUtils.isNotEmpty((String)enumEntityNum)) {
                calItem.setItemType(CalItemTypeEnum.ENUM);
                calItem.setEntityNumber(enumEntityNum);
                IDataEntityProperty property = WarnObjUtils.parseFieldAliasGetProperty((String)calItem.getEntityNumber(), (String)treeNode.getFieldAlias(), (MainEntityTypeUtil)this.mainEntityTypeUtil);
                calItem.setPropertyField(property.getName());
            } else {
                calItem.setItemType(CalItemTypeEnum.BASIC);
            }
        }
        item.setShow(treeNode.getSelected() != null && treeNode.getSelected() != false);
        return item;
    }

    private DataTypeEnum transDataTypeEnum(String valueType) {
        if (kd.hr.hbp.common.model.complexobj.DataTypeEnum.STRING.getDataTypeKey().equals(valueType) || kd.hr.hbp.common.model.complexobj.DataTypeEnum.LOCALESTRING.getDataTypeKey().equals(valueType)) {
            return DataTypeEnum.TEXT;
        }
        if (kd.hr.hbp.common.model.complexobj.DataTypeEnum.BOOLEAN.getDataTypeKey().equals(valueType)) {
            return DataTypeEnum.BOOLEAN;
        }
        if (kd.hr.hbp.common.model.complexobj.DataTypeEnum.DATETIME.getDataTypeKey().equals(valueType)) {
            return DataTypeEnum.DATE;
        }
        if (kd.hr.hbp.common.model.complexobj.DataTypeEnum.BIGDECIMAL.getDataTypeKey().equals(valueType) || kd.hr.hbp.common.model.complexobj.DataTypeEnum.LONG.getDataTypeKey().equals(valueType)) {
            return DataTypeEnum.NUM;
        }
        if (kd.hr.hbp.common.model.complexobj.DataTypeEnum.INTEGER.getDataTypeKey().equals(valueType)) {
            return DataTypeEnum.INT;
        }
        return null;
    }

    private void updateCache(List<TreeNodeItem> treeNodeItems, List<FieldTreeNode> fieldTreeNodes, List<WarnCalFieldBo> warnCalFieldBos) {
        HRPageCache pageCache = new HRPageCache(this.getPageCache());
        pageCache.put("CACHE_KEY_FIELD_TREE_NODE_LIST", treeNodeItems);
        pageCache.put("CACHE_KEY_FIELD_ITEM_MAP", treeNodeItems.stream().filter(item -> item instanceof CalItem).collect(Collectors.toMap(Item::getId, item -> item)));
        List fieldMap = CalFieldHelper.buildEntityFieldList(fieldTreeNodes, (boolean)false);
        HashMap baseDataMap = Maps.newHashMapWithExpectedSize((int)fieldMap.size());
        HashMap enumEntityNumMap = Maps.newHashMapWithExpectedSize((int)fieldMap.size());
        HashMap fieldNameToNumber = Maps.newHashMapWithExpectedSize((int)fieldMap.size());
        for (Map map : fieldMap) {
            String enumEntityNum;
            String name;
            Object nameObj = map.get("fieldName");
            if (nameObj instanceof String) {
                name = (String)nameObj;
            } else {
                LocaleString nameLocaleStr = (LocaleString)SerializationUtils.fromJsonString((String)JSONObject.toJSONString(nameObj), LocaleString.class);
                name = nameLocaleStr.getLocaleValue();
            }
            map.put("fieldName", name);
            String number = (String)map.get("fieldNumber");
            String baseDataNum = (String)map.get("baseDataNum");
            if ((number.endsWith(".name") || number.endsWith(".number")) && HRStringUtils.isNotEmpty((String)baseDataNum)) {
                baseDataMap.put("$" + number + "$", baseDataNum);
            }
            if (HRStringUtils.isNotEmpty((String)(enumEntityNum = (String)map.get("enumEntityNum")))) {
                enumEntityNumMap.put("$" + number + "$", enumEntityNum);
            }
            fieldNameToNumber.put("[" + name + "]", number);
        }
        pageCache.put("CACHE_KEY_FIELD_NUMBER_TO_IDENTITY_MAP", fieldMap.stream().collect(Collectors.toMap(field -> (String)field.get("fieldNumber"), field -> field)));
        pageCache.put("CACHE_KEY_FIELD_NAME_TO_NUMBER_MAP", (Object)fieldNameToNumber);
        pageCache.put("CACHE_KEY_CAL_FIELD_LIST", warnCalFieldBos);
        pageCache.put("CACHE_LEFT_TREE_BASE_DATA_MAP", (Object)baseDataMap);
        pageCache.put("CACHE_LEFT_TREE_ENUM_MAP", (Object)enumEntityNumMap);
        pageCache.put("CACHE_KEY_FIELD_MAP_LIST", (Object)fieldMap);
    }

    static class FloatResult {
        private final List<SelectItem> items;
        private final boolean isEnd;
        private int nextStart;

        public FloatResult(List<SelectItem> items, boolean isEnd) {
            this.items = items;
            this.isEnd = isEnd;
            if (items != null) {
                this.nextStart = items.size();
            }
        }

        public List<SelectItem> getItems() {
            return this.items;
        }

        public boolean isEnd() {
            return this.isEnd;
        }

        public int getNextStart() {
            return this.nextStart;
        }

        public void setNextStart(int nextStart) {
            this.nextStart = nextStart;
        }
    }
}

