/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.earlywarn.scheme;

import com.google.common.collect.Maps;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.inte.service.InteServiceImpl;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.action.EngineLog;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.impl.EarlyWarnServiceImpl;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.WarnExecuteParamBo;
import kd.hr.hrcs.common.constants.earlywarn.WarnRepeatPeriodEnum;
import kd.hr.hrcs.common.constants.earlywarn.WarnSchemeFieldConstants;
import kd.hr.hrcs.common.model.earlywarn.WarningSceneCacheBo;
import kd.hr.hrcs.common.model.earlywarn.log.WarnScheduleOperationType;
import kd.hr.hrcs.common.model.earlywarn.log.WarnScheduleStatus;
import kd.hr.hrcs.formplugin.web.earlywarn.scene.WarnSceneMsgEdit;
import kd.hr.hrcs.formplugin.web.earlywarn.scene.process.WarnMsgProcessor;
import kd.hr.hrcs.formplugin.web.earlywarn.scheme.WarnSchemeAdFilterEditPlugin;
import kd.hr.hrcs.formplugin.web.earlywarn.scheme.WarnSchemeAdFilterLeftTreeEditPlugin;
import kd.hr.hrcs.formplugin.web.earlywarn.scheme.WarnSchemeBCFilterEditPlugin;
import kd.hr.hrcs.formplugin.web.earlywarn.scheme.processor.WarnSchemeFormProcessor;

public class WarnSchemeEditPlugin
extends HRDataBaseEdit
implements WarnSchemeFieldConstants,
BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(WarnSchemeEditPlugin.class);
    private static final String KEY_ADMIN_ORG = "adminorg";
    private final WarnSchemeFormProcessor formProcessor = new WarnSchemeFormProcessor(this);

    @ExcludeFromJacocoGeneratedReport
    public static Map<String, Object> copyAttachment(Map<String, Object> attachment) {
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String tempUrl = String.valueOf(attachment.get("url"));
        String uid = String.valueOf(attachment.get("uid"));
        String fileName = String.valueOf(attachment.get("name"));
        Long size = (Long)attachment.get("size");
        FileService service = FileServiceFactory.getAttachmentFileService();
        InputStream inputStream = service.getInputStream(tempUrl);
        HashMap<String, Object> newAttachment = new HashMap<String, Object>();
        long time = new Date().getTime();
        newAttachment.put("lastModified", time);
        newAttachment.put("name", fileName);
        newAttachment.put("size", size);
        newAttachment.put("status", "success");
        newAttachment.put("type", String.valueOf(attachment.get("type")));
        StringBuilder newUid = new StringBuilder("rc-upload-");
        newUid.append(time);
        newUid.append("-");
        String uidIndex = null;
        int index = uid.lastIndexOf("-");
        if (index > 0) {
            uidIndex = uid.substring(index + 1);
        }
        newUid.append(uidIndex);
        newAttachment.put("uid", newUid.toString());
        StringBuilder newUrl = new StringBuilder(RequestContext.get().getClientFullContextPath());
        if (!newUrl.toString().endsWith("/")) {
            newUrl.append("/");
        }
        String tempNewUrl = tempFileCache.saveAsUrl(fileName, inputStream, 7200);
        tempNewUrl = EncreptSessionUtils.encryptSession((String)tempNewUrl);
        newUrl.append(tempNewUrl);
        newAttachment.put("url", newUrl.toString());
        return newAttachment;
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        ((BasedataEdit)this.getControl(KEY_ADMIN_ORG)).addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Object createOrg;
        super.afterCreateNewData(e);
        Object owner = this.getModel().getValue("owner");
        if (owner == null) {
            this.getModel().setValue("owner", (Object)RequestContext.get().getCurrUserId());
        }
        if ((createOrg = this.getModel().getValue("createorg")) == null) {
            this.getModel().setValue("createorg", (Object)RequestContext.get().getOrgId());
        }
    }

    public void beforeBindData(EventObject eventObject) {
        try {
            super.beforeBindData(eventObject);
            this.setDefaultValue();
            this.processControlCustomYearDay();
            if (this.getView().getFormShowParameter().getCustomParam("warnscene") != null) {
                this.getModel().setValue("warnscene", this.getView().getFormShowParameter().getCustomParam("warnscene"));
            }
            for (DynamicObject dynObject : this.getModel().getEntryEntity("rcfixentryentity")) {
                dynObject.getDataEntityState().setBizChanged(Boolean.FALSE.booleanValue());
            }
        }
        catch (Exception exception) {
            LOGGER.error("error:", (Throwable)exception);
        }
    }

    public void afterBindData(EventObject eventObject) {
        try {
            super.afterBindData(eventObject);
            this.setTabVisible();
            this.setBizApp();
            this.processControlCustomYearDay();
            for (DynamicObject dynObject : this.getModel().getEntryEntity("rcfixentryentity")) {
                dynObject.getDataEntityState().setBizChanged(Boolean.FALSE.booleanValue());
            }
        }
        catch (Exception exception) {
            LOGGER.error("error:", (Throwable)exception);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        try {
            String itemKey = evt.getItemKey();
            if (HRStringUtils.equals((String)"bar_close", (String)itemKey)) {
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                DataEntityState dataEntityState = dataEntity.getDataEntityState();
                Iterable bizChangedProperties = dataEntityState.getBizChangedProperties();
                if (this.getModel().getDataChanged()) {
                    for (IDataEntityProperty next : bizChangedProperties) {
                        String name = next.getName();
                        if ("createorg_id".equals(name) || "msgtitlehide".equals(name) || "msgmainhide".equals(name) || "msgconclusionhide".equals(name)) {
                            dataEntityState.setBizChanged(next.getOrdinal(), false);
                            continue;
                        }
                        if (!"pushchannel".equals(name) && !"timezone_id".equals(name) && !"bizapp_id".equals(name) && !"warnscene_id".equals(name) && !"localeid".equals(name) && !"owner_id".equals(name) && !"startdate".equals(name) && !"enddate".equals(name) || (Long)this.getModel().getValue("id") != 0L) continue;
                        dataEntityState.setBizChanged(next.getOrdinal(), false);
                    }
                    DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("rcrelationentryentity");
                    collection.forEach(dy -> {
                        DataEntityState entityState = dy.getDataEntityState();
                        for (IDataEntityProperty bizChangedProperty : entityState.getBizChangedProperties()) {
                            String name = bizChangedProperty.getName();
                            if (!"rcuserdisplay".equals(name)) continue;
                            dy.getDataEntityState().setBizChanged(bizChangedProperty.getOrdinal(), false);
                        }
                    });
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("error:", (Throwable)exception);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        this.formProcessor.updateFormStatus();
    }

    @ExcludeFromJacocoGeneratedReport
    public void propertyChanged(PropertyChangedArgs args) {
        try {
            String changeKey = args.getProperty().getName();
            WarningSceneCacheBo warningSceneCacheBo = new WarningSceneCacheBo();
            if ("warnscene".equals(changeKey)) {
                ChangeData changeData = args.getChangeSet()[0];
                DynamicObject newValue = (DynamicObject)changeData.getNewValue();
                DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
                if ("true".equals(this.getPageCache().get("CACHE_KEY_CANCEL_CHANGE_SCENE"))) {
                    this.getPageCache().remove("CACHE_KEY_CANCEL_CHANGE_SCENE");
                    return;
                }
                if (oldValue != null) {
                    this.getPageCache().put("CACHE_KEY_OLD_SCENE_ID", String.valueOf(oldValue.getPkValue()));
                    ConfirmCallBackListener confirmListener = new ConfirmCallBackListener("warnscene", (IFormPlugin)this);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u66f4\u6539\u9884\u8b66\u573a\u666f\u5c06\u91cd\u7f6e\u8be5\u9884\u8b66\u65b9\u6848\u4e0b\u7684\u6570\u636e\uff0c\u786e\u5b9a\u8981\u66f4\u6539\u5417\uff1f", (String)"WarnSchemeEditPlugin_1", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmListener);
                    if (newValue != null) {
                        this.buildCacheForPeriod(warningSceneCacheBo, newValue);
                        this.getPageCache().put("warnscene", SerializationUtils.toJsonString((Object)warningSceneCacheBo));
                    }
                } else {
                    this.reloadDefaultData();
                }
            } else if ("repeatperiod".equals(changeKey)) {
                this.processControlCustomYearDay();
            }
        }
        catch (Exception exception) {
            LOGGER.error("error:", (Throwable)exception);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public void confirmCallBack(MessageBoxClosedEvent event) {
        try {
            super.confirmCallBack(event);
            String actionId = event.getCallBackId();
            if ("warnscene".contains(actionId)) {
                if (event.getResult() == MessageBoxResult.Yes) {
                    WarningSceneCacheBo warningSceneCacheBo;
                    this.renderBaseConditionControl();
                    this.renderAdConditionControl();
                    this.renderMsgTree();
                    this.setBizApp();
                    String data = this.getPageCache().get("warnscene");
                    if (StringUtils.isNotEmpty((String)data) && (warningSceneCacheBo = (WarningSceneCacheBo)SerializationUtils.fromJsonString((String)data, WarningSceneCacheBo.class)) != null) {
                        this.fillDataForPeriod(warningSceneCacheBo);
                    }
                    this.reloadDefaultData();
                } else {
                    String oldSceneId = this.getPageCache().get("CACHE_KEY_OLD_SCENE_ID");
                    this.getPageCache().put("CACHE_KEY_CANCEL_CHANGE_SCENE", "true");
                    if (HRStringUtils.isNotEmpty((String)oldSceneId)) {
                        this.getModel().setValue("warnscene", (Object)Long.parseLong(oldSceneId));
                    } else {
                        this.getModel().setValue("warnscene", null);
                    }
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("error:", (Throwable)exception);
        }
    }

    private void renderMsgTree() {
        WarnSceneMsgEdit warnSceneMsgEdit = new WarnSceneMsgEdit();
        warnSceneMsgEdit.setView(this.getView());
        warnSceneMsgEdit.initMsgQueryField();
        new WarnMsgProcessor(this).initTreeControl();
    }

    private void reloadDefaultData() {
        this.setTabVisible();
        this.setBizApp();
        this.processControlCustomYearDay();
        this.setUserTimeZone();
    }

    private String getActionTag() {
        return ResManager.loadKDString((String)"\u624b\u5de5\u6267\u884c", (String)"WarnSchemeEditPlugin_4", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        block11: {
            try {
                super.beforeDoOperation(args);
                AbstractOperate op = (AbstractOperate)args.getSource();
                String operateKey = op.getOperateKey();
                if ("manualexecute".equals(operateKey)) {
                    Long id = this.getModel().getDataEntity().getLong("id");
                    DynamicObject warnScene = this.getModel().getDataEntity().getDynamicObject("warnscene");
                    if (id == null || id == 0L || warnScene == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6570\u636e\u3002", (String)"WarnSchemeEditPlugin_2", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    EngineLog log = EngineLog.getInstance((String)String.valueOf(id), (String)warnScene.getString("id"), (WarnScheduleOperationType)WarnScheduleOperationType.Manual);
                    log.logRecord(this.getActionTag(), ResManager.loadKDString((String)"\u624b\u52a8\u6267\u884c\u5f00\u59cb", (String)"WarnSchemeEditPlugin_5", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]));
                    WarnScheduleStatus status = WarnScheduleStatus.Success;
                    try {
                        EarlyWarnServiceImpl.getInstance().execute(new WarnExecuteParamBo(Long.valueOf(warnScene.getLong("id")), id, WarnScheduleOperationType.Manual.toString(), log.getEarlyWarnLogId()));
                        this.getView().showMessage(ResManager.loadKDString((String)"\u624b\u52a8\u6267\u884c\u6210\u529f", (String)"WarnSchemeEditPlugin_9", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]));
                        break block11;
                    }
                    catch (Throwable e) {
                        status = WarnScheduleStatus.Failure;
                        String msg = String.format(ResManager.loadKDString((String)"\u624b\u52a8\u6267\u884c\u5f02\u5e38\uff1a%s", (String)"WarnSchemeEditPlugin_6", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]), e.getLocalizedMessage());
                        log.logRecord(this.getActionTag(), msg);
                        this.getView().showErrorNotification(msg);
                        break block11;
                    }
                    finally {
                        log.logRecord(this.getActionTag(), ResManager.loadKDString((String)"\u624b\u52a8\u6267\u884c\u7ed3\u675f", (String)"WarnSchemeEditPlugin_7", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]));
                        log.endRecord(status);
                    }
                }
                if ("viewexelog".equals(operateKey)) {
                    Object pkValue = this.getModel().getDataEntity().getPkValue();
                    if (pkValue == null || "0".equals(String.valueOf(pkValue))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6570\u636e", (String)"WarnSchemeEditPlugin_8", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"hrcs_earlywarn_log", (boolean)false, (int)0, (boolean)true);
                    listShowParameter.getListFilterParameter().setFilter(new QFilter("warnscheme", "=", pkValue));
                    this.getView().showForm((FormShowParameter)listShowParameter);
                }
            }
            catch (Exception exception) {
                LOGGER.error("error:", (Throwable)exception);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        try {
            String propertyName = beforeF7SelectEvent.getProperty().getName();
            if (HRStringUtils.equals((String)KEY_ADMIN_ORG, (String)propertyName)) {
                beforeF7SelectEvent.getFormShowParameter().setCustomParam("struct_project_ids", (Object)SerializationUtils.toJsonString(Collections.singletonList("1010")));
                beforeF7SelectEvent.getFormShowParameter().setCustomParam("struct_project_visible", (Object)"false");
            }
        }
        catch (Exception exception) {
            LOGGER.error("error:", (Throwable)exception);
        }
    }

    public void customEvent(CustomEventArgs args) {
        try {
            if (HRStringUtils.equals((String)args.getEventName(), (String)"selectDay")) {
                this.getModel().setValue("yearday", (Object)args.getEventArgs());
            }
        }
        catch (Exception exception) {
            LOGGER.error("error:", (Throwable)exception);
        }
    }

    private void setDefaultValue() {
        BaseShowParameter showParameter;
        Boolean isCopy;
        Date startDate;
        Date endDate = (Date)this.getModel().getValue("enddate");
        if (endDate == null) {
            this.getModel().setValue("enddate", (Object)HRBaseUtils.getMaxEndDate());
        }
        if ((startDate = (Date)this.getModel().getValue("startdate")) == null) {
            this.getModel().setValue("startdate", (Object)new Date());
        }
        if ((isCopy = (Boolean)(showParameter = (BaseShowParameter)this.getView().getFormShowParameter()).getCustomParam("iscopy")) != null && isCopy.booleanValue()) {
            Object id = showParameter.getPkId();
            HRBaseServiceHelper helper = new HRBaseServiceHelper(showParameter.getFormId());
            DynamicObject dbDy = helper.queryOriginalOne("number,name", id);
            this.getModel().setValue("number", (Object)(dbDy.getString("number") + "-copy"));
            this.getModel().setValue("name", (Object)MessageFormat.format(ResManager.loadKDString((String)"{0}-\u590d\u5236", (String)"WarnSchemeEditPlugin_3", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]), dbDy.getString("name")));
        }
    }

    private void setUserTimeZone() {
        InteServiceImpl inteServiceImpl = new InteServiceImpl();
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject userTimezoneMeta = inteServiceImpl.getUserTimezone(Long.valueOf(userId));
        if (userTimezoneMeta == null) {
            userTimezoneMeta = inteServiceImpl.getSysTimezone();
        }
        if (userTimezoneMeta != null) {
            this.getModel().setValue("timezone", (Object)userTimezoneMeta);
        }
    }

    private void buildCacheForPeriod(WarningSceneCacheBo warningSceneCacheBo, DynamicObject newValue) {
        warningSceneCacheBo.setStartDate(newValue.getDate("startdate"));
        warningSceneCacheBo.setEndDate(newValue.getDate("enddate"));
        warningSceneCacheBo.setRepeatPeriod(newValue.getString("repeatperiod"));
        warningSceneCacheBo.setWeekday(newValue.getString("weekday"));
        warningSceneCacheBo.setMonthday(newValue.getString("monthday"));
        warningSceneCacheBo.setYearDay(newValue.getString("yearday"));
        warningSceneCacheBo.setMonitorTime(newValue.getString("monitortime"));
    }

    private void fillDataForPeriod(WarningSceneCacheBo warningSceneCacheBo) {
        if (warningSceneCacheBo.getStartDate() != null) {
            this.getModel().setValue("startdate", (Object)warningSceneCacheBo.getStartDate());
        } else {
            this.getModel().setValue("startdate", (Object)new Date());
        }
        this.getModel().setValue("enddate", (Object)warningSceneCacheBo.getEndDate());
        String repeatPeriod = warningSceneCacheBo.getRepeatPeriod();
        if (StringUtils.isEmpty((String)repeatPeriod)) {
            repeatPeriod = "0";
        }
        this.getModel().setValue("repeatperiod", (Object)repeatPeriod);
        this.getModel().setValue("weekday", (Object)warningSceneCacheBo.getWeekday());
        this.getModel().setValue("monthday", (Object)warningSceneCacheBo.getMonthday());
        this.getModel().setValue("yearday", (Object)warningSceneCacheBo.getYearDay());
        String monitorTime = warningSceneCacheBo.getMonitorTime();
        if (StringUtils.isEmpty((String)monitorTime)) {
            monitorTime = "0";
        }
        this.getModel().setValue("monitortime", (Object)monitorTime);
    }

    @ExcludeFromJacocoGeneratedReport
    private void renderBaseConditionControl() {
        WarnSchemeBCFilterEditPlugin plugin = new WarnSchemeBCFilterEditPlugin();
        plugin.setView(this.getView());
        plugin.renderConditionControl(false);
    }

    @ExcludeFromJacocoGeneratedReport
    private void renderAdConditionControl() {
        WarnSchemeAdFilterEditPlugin adFilterEditPlugin = new WarnSchemeAdFilterEditPlugin();
        adFilterEditPlugin.setView(this.getView());
        adFilterEditPlugin.refreshFormulaEdit();
        WarnSchemeAdFilterLeftTreeEditPlugin adFilterLeftTreeEditPlugin = new WarnSchemeAdFilterLeftTreeEditPlugin();
        adFilterLeftTreeEditPlugin.setView(this.getView());
        adFilterLeftTreeEditPlugin.renderFieldTree();
    }

    private void processControlCustomYearDay() {
        String repeatPeriod = (String)this.getModel().getValue("repeatperiod");
        if (StringUtils.isEmpty((String)repeatPeriod)) {
            return;
        }
        if (repeatPeriod.equals(WarnRepeatPeriodEnum.ByYears.getPeriod())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"customyearday"});
            CustomControl customcontrol = (CustomControl)this.getView().getControl("customyearday");
            this.getView().getControl("repeatperiod");
            String yearDay = (String)this.getModel().getValue("yearday");
            if (StringUtils.isEmpty((String)yearDay)) {
                yearDay = "01-01";
            }
            HashMap data = Maps.newHashMapWithExpectedSize((int)2);
            data.put("enable", true);
            data.put("value", yearDay);
            customcontrol.setData((Object)data);
            this.getView().setVisible(Boolean.FALSE, new String[]{"weekday"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"monthday"});
        } else {
            if (repeatPeriod.equals(WarnRepeatPeriodEnum.ByWeeks.getPeriod())) {
                String weekDay = (String)this.getModel().getValue("weekday");
                if (StringUtils.isEmpty((String)weekDay) || ",,".equals(weekDay)) {
                    this.getModel().setValue("weekday", (Object)",2,");
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{"weekday"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"monthday"});
            } else if (repeatPeriod.equals(WarnRepeatPeriodEnum.ByMonths.getPeriod())) {
                String weekDay = (String)this.getModel().getValue("monthday");
                if (StringUtils.isEmpty((String)weekDay) || ",,".equals(weekDay)) {
                    this.getModel().setValue("monthday", (Object)",1,");
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"weekday"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"monthday"});
            } else if (repeatPeriod.equals(WarnRepeatPeriodEnum.ByDays.getPeriod())) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"weekday"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"monthday"});
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"customyearday"});
        }
    }

    private void setBizApp() {
        if (this.getModel().getValue("warnscene") != null) {
            this.getModel().setValue("bizapp", (Object)((DynamicObject)this.getModel().getValue("warnscene")).getString("bizapp.id"));
        }
    }

    private void setTabVisible() {
        DynamicObject sceneDy = (DynamicObject)this.getModel().getValue("warnscene");
        if (sceneDy == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"maintabap"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"maintabap"});
            if (sceneDy.getBoolean("permrc")) {
                this.setRcFixPerm(Boolean.TRUE);
            } else {
                this.setRcFixPerm(Boolean.FALSE);
            }
        }
    }

    private void setRcFixPerm(boolean visible) {
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"rcfixperm"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"roleperm"});
    }
}

