/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.earlywarn.scheme;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobDispatcher;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.exportconfig.HRWarnPreSQLHelper;

public class WarnSchemeListPlugin
extends HRDataBaseList {
    private static final Log LOGGER = LogFactory.getLog(WarnSchemeListPlugin.class);
    private static final String KEY_SELECTED_IDS = "selectedIds";

    public void beforeDoOperation(BeforeDoOperationEventArgs eve) {
        try {
            super.beforeDoOperation(eve);
            AbstractOperate op = (AbstractOperate)eve.getSource();
            String operateKey = op.getOperateKey();
            if (HRStringUtils.equals((String)"delete", (String)operateKey)) {
                List<Object> selectedIds = eve.getListSelectedData().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
                if (!selectedIds.isEmpty()) {
                    this.getPageCache().put(KEY_SELECTED_IDS, SerializationUtils.toJsonString(this.getPlanIds(selectedIds)));
                }
            } else if (HRStringUtils.equals((String)"new", (String)operateKey)) {
                Map focusNode = ((ListView)this.getView()).getTreeListView().getTreeView().getTreeState().getFocusNode();
                if (focusNode == null || ((Boolean)focusNode.get("isParent")).booleanValue()) {
                    eve.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u5de6\u4fa7\u9009\u62e9\u9884\u8b66\u573a\u666f\u3002", (String)"WarnSchemeListPlugin_2", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]));
                } else {
                    Object id = focusNode.get("id");
                    boolean exists = new HRBaseServiceHelper("hrcs_warnscene").isExists(id);
                    if (exists) {
                        this.getView().getFormShowParameter().setCustomParam("warnscene", focusNode.get("id"));
                    } else {
                        eve.setCancel(true);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u9884\u8b66\u573a\u666f\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\uff0c\u91cd\u65b0\u9009\u62e9\u3002", (String)"WarnSchemeListPlugin_3", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]));
                    }
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("error:", (Throwable)exception);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent event) {
        try {
            Map focusNode = ((ListView)this.getView()).getTreeListView().getTreeView().getTreeState().getFocusNode();
            if (focusNode != null) {
                event.getParameter().setCustomParam("warnscene", focusNode.get("id"));
            }
        }
        catch (Exception exception) {
            LOGGER.error("error:", (Throwable)exception);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eve) {
        try {
            List successIds;
            super.afterDoOperation(eve);
            AbstractOperate op = (AbstractOperate)eve.getSource();
            String operateKey = op.getOperateKey();
            if ("exportconfigsql".equals(operateKey)) {
                if (((ListView)this.getView()).getSelectedRows().size() != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"WarnSchemeListPlugin_1", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]));
                    return;
                }
                Object currentAnObjId = ((ListView)this.getView()).getCurrentSelectedRowInfo().getPrimaryKeyValue();
                HRWarnPreSQLHelper hrReportPreSQLHelper = new HRWarnPreSQLHelper();
                ArrayList<Long> idList = new ArrayList<Long>(16);
                idList.add((Long)currentAnObjId);
                hrReportPreSQLHelper.generateHRWarnSchemePreSQLFile((AbstractListPlugin)this, idList);
            } else if (HRStringUtils.equals((String)"disable", (String)operateKey)) {
                List successIds2 = eve.getOperationResult().getSuccessPkIds();
                if (!successIds2.isEmpty()) {
                    ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
                    this.getPlanIds(successIds2).values().forEach(arg_0 -> ((ScheduleManager)scheduleManager).disableSchedule(arg_0));
                }
            } else if (HRStringUtils.equals((String)"enable", (String)operateKey)) {
                List successIds3 = eve.getOperationResult().getSuccessPkIds();
                if (!successIds3.isEmpty()) {
                    ScheduleServiceHelper.enableSchedule(new ArrayList<String>(this.getPlanIds(successIds3).values()));
                }
            } else if (HRStringUtils.equals((String)"delete", (String)operateKey) && !(successIds = eve.getOperationResult().getSuccessPkIds()).isEmpty()) {
                JobDispatcher jobDispatcher = (JobDispatcher)ServiceFactory.getService(JobDispatcher.class);
                String selectedIdsStr = this.getPageCache().get(KEY_SELECTED_IDS);
                if (HRStringUtils.isNotEmpty((String)selectedIdsStr)) {
                    Map selectedIdMap = (Map)SerializationUtils.fromJsonString((String)selectedIdsStr, Map.class);
                    successIds.forEach(warnSchemeId -> {
                        String planId = (String)selectedIdMap.get(warnSchemeId.toString());
                        if (HRStringUtils.isNotEmpty((String)planId)) {
                            jobDispatcher.deletePlan(planId);
                        }
                    });
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("error:", (Throwable)exception);
        }
    }

    private Map<String, String> getPlanIds(List<Object> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_warnscheme");
        return Arrays.stream(serviceHelper.queryOriginalArray("id,planid", new QFilter[]{new QFilter("id", "in", ids)})).collect(Collectors.toMap(it -> it.getString("id"), it -> it.getString("planid"), (oldValue, newValue) -> oldValue));
    }
}

