/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.earlywarn.scheme;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.mcontrol.SearchAp;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.model.perm.req.user.GetUsableEntitiesInfoReq;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRCloudServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.formplugin.web.template.HRF7TreeListPlugin;
import kd.hr.hrcs.common.constants.earlywarn.WarnSchemeFieldConstants;
import kd.hr.hrcs.formplugin.web.earlywarn.scheme.EntityDao;

public class WarnSchemeTreeListPlugin
extends HRF7TreeListPlugin
implements WarnSchemeFieldConstants {
    private static final Log LOG = LogFactory.getLog(WarnSchemeTreeListPlugin.class);
    private String filterKey = "bizapp";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.updateSearch();
    }

    private void updateSearch() {
        SearchAp searchAp = new SearchAp();
        searchAp.setKey("searchap");
        searchAp.setSearchEmptyText(new LocaleString(ResManager.loadKDString((String)"\u641c\u7d22\u4e91/\u5e94\u7528/\u9884\u8b66\u573a\u666f\u540d\u79f0", (String)"WarningSceneTreeListPlugin_3", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0])));
        this.getView().updateControlMetadata("searchap", searchAp.createControl());
    }

    public String getBizAppId() {
        return this.filterKey;
    }

    public void initializeTree(EventObject evt) {
        super.initializeTree(evt);
        try {
            TreeNode root = this.getTreeModel().getRoot();
            this.initChildrenNode(root);
        }
        catch (Throwable exception) {
            LOG.error("error:", exception);
        }
    }

    private void initChildrenNode(TreeNode root) {
        List cloudTreeNodes = root.getChildren();
        List cloudIds = HRCloudServiceHelper.getAllHRCommonCloudIdsSort();
        String usableEntitiesInfo = new PermissionServiceHelper().getUsableEntitiesInfo(new GetUsableEntitiesInfoReq(Long.valueOf(RequestContext.get().getCurrUserId()), (Set)Sets.newHashSet((Object[])new String[]{"BillFormModel", "BaseFormModel", "QueryListModel", "DynamicFormModel", "BalanceModel"}), new HashSet(cloudIds)));
        List entityDaos = JSONObject.parseArray((String)usableEntitiesInfo, EntityDao.class);
        ArrayList hasPermEntity = Lists.newArrayListWithExpectedSize((int)entityDaos.size());
        this.getAllPermEntity(entityDaos, hasPermEntity);
        DynamicObjectCollection dynamicObjectCollection = new HRBaseServiceHelper("hrcs_warnscene").queryOriginalCollection("bizapp,name,number,id", new QFilter[]{new QFilter("fromentity", "in", (Object)hasPermEntity)});
        if (dynamicObjectCollection != null) {
            LinkedListMultimap listMultimap = LinkedListMultimap.create((int)dynamicObjectCollection.size());
            dynamicObjectCollection.forEach(dy -> {
                TreeNode treeNode = new TreeNode(dy.getString("bizapp"), dy.getString("id"), dy.getString("name"), false);
                listMultimap.put((Object)dy.getString("bizapp"), (Object)treeNode);
            });
            Set bizapp = listMultimap.keySet();
            ArrayList cloudTreeNodesTemp = Lists.newArrayListWithExpectedSize((int)cloudTreeNodes.size());
            for (TreeNode treeNode : cloudTreeNodes) {
                treeNode.setIsOpened(true);
                List<TreeNode> childrenTreeNodes = treeNode.getChildren().stream().filter(node -> bizapp.contains(node.getId())).collect(Collectors.toList());
                childrenTreeNodes.forEach(node -> {
                    node.setIsOpened(true);
                    node.setChildren(listMultimap.get((Object)node.getId()));
                });
                treeNode.setChildren(childrenTreeNodes);
                if (childrenTreeNodes.size() <= 0) continue;
                cloudTreeNodesTemp.add(treeNode);
            }
            root.setChildren((List)cloudTreeNodesTemp);
        }
    }

    private void getAllPermEntity(List<EntityDao> entityDaos, List<String> hasPermEntity) {
        for (EntityDao entityDao : entityDaos) {
            List<EntityDao> children = entityDao.getChildren();
            if (children != null) {
                this.getAllPermEntity(children, hasPermEntity);
                continue;
            }
            if (entityDao.getFid() == null) continue;
            hasPermEntity.add(entityDao.getId());
        }
    }

    public void buildCloudAppTreeListFilter(BuildTreeListFilterEvent evt) {
        try {
            String currentNodeId = (String)evt.getNodeId();
            TreeNode currentNode = this.getTreeModel().getRoot().getTreeNode(currentNodeId, 5);
            if (!currentNodeId.equals(this.getTreeModel().getRoot().getId()) && (currentNode == null || currentNode.isLeaf() && !new HRBaseServiceHelper("hrcs_warnscene").isExists((Object)currentNodeId))) {
                this.getTreeListView().focusRootNode();
                this.getTreeListView().refresh();
                return;
            }
            super.buildCloudAppTreeListFilter(evt);
            if (currentNode.getChildren() == null || currentNode.getChildren().size() == 0) {
                List filters = evt.getFilters();
                filters.forEach(filter -> {
                    if (filter.getProperty().equals("bizapp")) {
                        filter.__setProperty("warnscene");
                        Object value = filter.getValue();
                        if (value instanceof Set) {
                            filter.__setValue(((Set)value).stream().map(ob -> Long.parseLong(String.valueOf(ob))).collect(Collectors.toSet()));
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
    }

    public QFilter getHRAppFilter(ListShowParameter listShowParameter) {
        this.filterKey = "bizapp";
        return super.getHRAppFilter(listShowParameter);
    }

    public void search(SearchEnterEvent evt) {
        try {
            String searchText = evt.getText();
            if (!StringUtils.isBlank((CharSequence)searchText)) {
                List treeNodes;
                TreeNode rootNode = this.getTreeModel().getRoot();
                IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
                String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
                String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
                String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
                String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
                String oldSearchText = pageCache.get(oldSearchTextCacheKey);
                pageCache.put(oldSearchTextCacheKey, searchText);
                String matchNodesCache = pageCache.get(matchNodesCacheKey);
                TreeView treeView = this.getTreeListView().getTreeView();
                if ((oldSearchText == null || oldSearchText.equals(searchText)) && !StringUtils.isBlank((CharSequence)matchNodesCache)) {
                    String searchNodesCache = pageCache.get(searchNodesCacheKey);
                    treeNodes = StringUtils.isBlank((CharSequence)searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
                } else {
                    treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, 10);
                    pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
                    pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
                    pageCache.put(searchIndexCacheKey, String.valueOf(0));
                }
                if (treeNodes.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5df2\u5b8c\u6210\uff0c\u672a\u627e\u5230\u5339\u914d\u9879\u3002", (String)"WarningSceneTreeListPlugin_0", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]));
                } else {
                    if (StringUtils.isNotEmpty((CharSequence)pageCache.get(searchIndexCacheKey))) {
                        int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                        if (indexCache == treeNodes.size()) {
                            indexCache = 0;
                        }
                        this.focusNode(treeView, (TreeNode)treeNodes.get(indexCache));
                        pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
                    } else {
                        this.focusNode(treeView, (TreeNode)treeNodes.get(0));
                        pageCache.put(searchIndexCacheKey, String.valueOf(0));
                    }
                    pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
                }
            }
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
    }

    private void focusNode(TreeView treeView, TreeNode searchTreeNode) {
        treeView.showNode(searchTreeNode.getId());
        treeView.treeNodeClick(searchTreeNode.getParentid(), searchTreeNode.getId());
        treeView.checkNode(searchTreeNode);
        treeView.focusNode(searchTreeNode);
    }

    public void refreshNode(RefreshNodeEvent refreshNodeEvent) {
        try {
            super.initCloudAppTree();
            this.initChildrenNode(this.getTreeModel().getRoot());
            String nodeId = refreshNodeEvent.getNodeId().toString();
            TreeNode node = this.getTreeModel().getRoot().getTreeNode(nodeId, 15);
            if (node.getChildren() != null && node.getChildren().size() > 0) {
                node.setIsOpened(true);
            }
            this.focusNode(this.getTreeListView().getTreeView(), node);
            refreshNodeEvent.setChildNodes(node.getChildren());
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        block3: {
            try {
                super.beforeDoOperation(args);
                AbstractOperate op = (AbstractOperate)args.getSource();
                String operateKey = op.getOperateKey();
                if (!"viewexelog".equals(operateKey)) break block3;
                ListSelectedRowCollection selectedRows = args.getListSelectedData();
                ListView view = (ListView)this.getView();
                int focusRow = view.getFocusRow();
                for (ListSelectedRow selectedRow : selectedRows) {
                    int rowKey = selectedRow.getRowKey();
                    if (focusRow != rowKey) continue;
                    ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"hrcs_earlywarn_log", (boolean)false, (int)0, (boolean)true);
                    listShowParameter.getListFilterParameter().setFilter(new QFilter("warnscheme", "=", selectedRow.getPrimaryKeyValue()));
                    view.showForm((FormShowParameter)listShowParameter);
                    break;
                }
            }
            catch (Exception exception) {
                LOG.error("error:", (Throwable)exception);
            }
        }
    }
}

