/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.earlywarn.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.Tips;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.common.model.earlywarn.WarnMessageReceiver;
import kd.hr.hrcs.common.model.earlywarn.WarnMessageReceiverType;

@ExcludeFromJacocoGeneratedReport
public class ReceiverPageUtil {
    public static void rebuildAllLabel(IFormView view, List<WarnMessageReceiverType> receiverTypeList) {
        IFormView parentView = view.getParentView();
        ReceiverPageUtil.delAllReceiverControl(parentView);
        ReceiverPageUtil.buildAllLabel(parentView, receiverTypeList);
        view.sendFormAction(parentView);
    }

    public static void rebuildLabel(IFormView view, IFormView parentView, String receiverType, List<WarnMessageReceiver> receivers, List<String> removeItems) {
        ReceiverPageUtil.delReceiverControl(parentView, receiverType, removeItems);
        ReceiverPageUtil.buildLabel(parentView, receiverType, receivers);
        ReceiverPageUtil.updateSelCount(parentView);
        parentView.updateView("flexpanelap");
        view.sendFormAction(parentView);
    }

    public static void buildLabel(IFormView parentView, String receiverType, List<WarnMessageReceiver> receivers, List<String> removeItems) {
        ReceiverPageUtil.delReceiverControl(parentView, receiverType, removeItems);
        ReceiverPageUtil.buildLabel(parentView, receiverType, receivers);
    }

    private static void buildAllLabel(IFormView view, List<WarnMessageReceiverType> receiverTypeList) {
        if (CollectionUtils.isEmpty(receiverTypeList)) {
            return;
        }
        for (WarnMessageReceiverType warnMessageReceiverType : receiverTypeList) {
            String type = warnMessageReceiverType.getType();
            List receivers = warnMessageReceiverType.getReceivers();
            Container container = null;
            if (!type.equals("role")) continue;
            container = (Container)view.getControl("roleflexpanelap");
            for (WarnMessageReceiver receiver : receivers) {
                LabelAp label = new LabelAp();
                label.setId("labelKey_" + receiver.getId());
                label.setKey("labelKey_" + receiver.getId());
                label.setName(new LocaleString(receiver.getName() + "\u00d7"));
                label.setAutoTextWrap(false);
                label.setWidth(new LocaleString("122px"));
                label.setParentId("roleflexpanelap");
                label.setLabelStyle("2");
                label.setForeColor("#999999");
                label.setClickable(true);
                ArrayList<Map> items = new ArrayList<Map>();
                items.add(label.createControl());
                container.addControls(items);
            }
        }
    }

    private static void buildLabel(IFormView view, String receiverType, List<WarnMessageReceiver> receivers) {
        block6: {
            Container container;
            block8: {
                block7: {
                    block5: {
                        if (CollectionUtils.isEmpty(receivers)) {
                            return;
                        }
                        container = null;
                        if (!"prerelation".equals(receiverType)) break block5;
                        container = (Container)view.getControl("prerelationap");
                        for (WarnMessageReceiver receiver : receivers) {
                            ArrayList<Map> items = new ArrayList<Map>();
                            FlexPanelAp flexPanelAp = ReceiverPageUtil.addTitle("prerelation" + receiver.getId(), receiver.getName(), null, true);
                            items.add(flexPanelAp.createControl());
                            container.addControls(items);
                        }
                        break block6;
                    }
                    if (!"role".equals(receiverType)) break block7;
                    container = (Container)view.getControl("roleflexpanelap");
                    for (WarnMessageReceiver receiver : receivers) {
                        ArrayList<Map> items = new ArrayList<Map>();
                        FlexPanelAp flexPanelAp = ReceiverPageUtil.addTitle("role" + receiver.getId(), receiver.getName(), null, true);
                        items.add(flexPanelAp.createControl());
                        container.addControls(items);
                    }
                    break block6;
                }
                if (!"org".equals(receiverType)) break block8;
                container = (Container)view.getControl("orgflexpanelap");
                for (WarnMessageReceiver receiver : receivers) {
                    ArrayList<Map> items = new ArrayList<Map>();
                    FlexPanelAp flexPanelAp = ReceiverPageUtil.addTitle("org" + receiver.getId(), receiver.getName(), null, true);
                    items.add(flexPanelAp.createControl());
                    container.addControls(items);
                }
                break block6;
            }
            if (!"user".equals(receiverType)) break block6;
            container = (Container)view.getControl("userflexpanelap");
            for (WarnMessageReceiver receiver : receivers) {
                ArrayList<Map> items = new ArrayList<Map>();
                FlexPanelAp flexPanelAp = ReceiverPageUtil.addTitle("user" + receiver.getId(), receiver.getName(), null, true);
                items.add(flexPanelAp.createControl());
                container.addControls(items);
            }
        }
    }

    public static FlexPanelAp addTitle(String panelId, String labelName, String labelDescription, boolean hasNotLimit) {
        FlexPanelAp titlePanel = ReceiverPageUtil.createRowFlexPanelAp(panelId + "title", 0, "row", "stretch", false);
        titlePanel.setWidth(new LocaleString("150px"));
        titlePanel.setBackColor("#fafafa");
        Style style = new Style();
        Border border = new Border();
        String borderStyle = "1px_solid_#f1f1f1";
        border.setLeft(borderStyle);
        border.setRight(borderStyle);
        border.setTop(borderStyle);
        border.setBottom(borderStyle);
        style.setBorder(border);
        Margin margin = new Margin();
        margin.setBottom("5px");
        style.setMargin(margin);
        titlePanel.setJustifyContent("flex-start");
        ReceiverPageUtil.addControlTitle(panelId, labelName, labelDescription, titlePanel, hasNotLimit);
        titlePanel.setAlignItems("center");
        titlePanel.setStyle(style);
        return titlePanel;
    }

    private static void addControlTitle(String panelId, String labelName, final String labelDescription, FlexPanelAp fieldPanel, boolean hasNotLimit) {
        String warnVectorApId = "cbwarn" + panelId;
        VectorAp warnVectorAp = new VectorAp();
        warnVectorAp.setId(warnVectorApId);
        warnVectorAp.setKey(warnVectorApId);
        warnVectorAp.setNeedHoverClass(false);
        warnVectorAp.setfontClass("kdfont kdfont-guanbi8");
        warnVectorAp.setStyle(new Style(){
            {
                this.setMargin(new Margin(){
                    {
                        this.setRight("4px");
                    }
                });
            }
        });
        LabelAp titleLabel = new LabelAp();
        String labelId = panelId;
        titleLabel.setId(labelId);
        titleLabel.setKey(labelId);
        titleLabel.setName(new LocaleString(labelName));
        titleLabel.setForeColor("#666");
        titleLabel.setFontSize(12);
        titleLabel.setTextAlign("left");
        titleLabel.setWidth(new LocaleString("150px"));
        if (HRStringUtils.isNotEmpty((String)labelDescription)) {
            titleLabel.setCtlTips(new Tips(){
                private static final long serialVersionUID = -4763251004308201843L;
                {
                    this.setType("text");
                    this.setContent(new LocaleString(labelDescription));
                }
            });
        } else {
            fieldPanel.setStyle(new Style(){
                {
                    this.setPadding(new Padding(){
                        {
                            this.setRight("16px");
                        }
                    });
                }
            });
        }
        fieldPanel.getItems().add(titleLabel);
        fieldPanel.getItems().add(warnVectorAp);
    }

    public static FlexPanelAp createRowFlexPanelAp(String flexKey, Integer grow, String direction, String alignSelf, boolean isWrap) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(flexKey);
        flexPanelAp.setWrap(isWrap);
        flexPanelAp.setDirection(direction);
        flexPanelAp.setFontSize(12);
        flexPanelAp.setAlignSelf(alignSelf);
        flexPanelAp.setAlignItems("center");
        flexPanelAp.setGrow(grow.intValue());
        return flexPanelAp;
    }

    private static void delAllReceiverControl(IFormView view) {
        Container preRelContainer = (Container)view.getControl("prerelationap");
        String[] preRelItems = (String[])preRelContainer.getItems().stream().map(it -> it.getKey()).toArray(String[]::new);
        preRelContainer.deleteControls(preRelItems);
        Container roleContainer = (Container)view.getControl("roleflexpanelap");
        String[] roleItems = (String[])roleContainer.getItems().stream().map(it -> it.getKey()).toArray(String[]::new);
        roleContainer.deleteControls(roleItems);
        Container orgContainer = (Container)view.getControl("orgflexpanelap");
        String[] orgItems = (String[])orgContainer.getItems().stream().map(it -> it.getKey()).toArray(String[]::new);
        orgContainer.deleteControls(orgItems);
        Container userContainer = (Container)view.getControl("userflexpanelap");
        String[] userItems = (String[])userContainer.getItems().stream().map(it -> it.getKey()).toArray(String[]::new);
        userContainer.deleteControls(userItems);
        view.sendFormAction(view.getParentView());
    }

    private static void delReceiverControl(IFormView view, String receiverType, List<String> removeItems) {
        if ("prerelation".equals(receiverType)) {
            Container preRelContainer = (Container)view.getControl("prerelationap");
            List collect = removeItems.stream().map(it -> it + "title").collect(Collectors.toList());
            String[] preRelItems = (String[])collect.stream().toArray(String[]::new);
            preRelContainer.deleteControls(preRelItems);
            Container flexPanel = (Container)view.getControl("advconap");
            flexPanel.setCollapse(false);
        } else if ("role".equals(receiverType)) {
            Container roleContainer = (Container)view.getControl("roleflexpanelap");
            List collect = removeItems.stream().map(it -> it + "title").collect(Collectors.toList());
            String[] roleItems = (String[])collect.stream().toArray(String[]::new);
            roleContainer.deleteControls(roleItems);
            Container flexPanel = (Container)view.getControl("roleadvconap");
            flexPanel.setCollapse(false);
        } else if ("org".equals(receiverType)) {
            Container orgContainer = (Container)view.getControl("orgflexpanelap");
            List collect = removeItems.stream().map(it -> it + "title").collect(Collectors.toList());
            String[] orgItems = (String[])collect.stream().toArray(String[]::new);
            orgContainer.deleteControls(orgItems);
            Container flexPanel = (Container)view.getControl("orgadvconap");
            flexPanel.setCollapse(false);
        } else if ("user".equals(receiverType)) {
            Container userContainer = (Container)view.getControl("userflexpanelap");
            List collect = removeItems.stream().map(it -> it + "title").collect(Collectors.toList());
            String[] userItems = (String[])collect.stream().toArray(String[]::new);
            userContainer.deleteControls(userItems);
            Container flexPanel = (Container)view.getControl("useradvconap");
            flexPanel.setCollapse(false);
        }
    }

    public static List<WarnMessageReceiver> getMessageReceiverByType(IFormView view, String receiverType) {
        String json = view.getPageCache().get(receiverType);
        List receivers = Lists.newArrayListWithCapacity((int)16);
        if (!StringUtils.isEmpty((Object)json)) {
            receivers = SerializationUtils.fromJsonStringToList((String)json, WarnMessageReceiver.class);
        }
        return receivers;
    }

    public static List<WarnMessageReceiver> cacheMsgReceiver(IFormView view, String receiverType, List<WarnMessageReceiver> receivers) {
        String json = view.getPageCache().get(receiverType);
        List oldReceivers = Lists.newArrayListWithCapacity((int)16);
        if (!StringUtils.isEmpty((Object)json)) {
            oldReceivers = SerializationUtils.fromJsonStringToList((String)json, WarnMessageReceiver.class);
        }
        view.getPageCache().put(receiverType, SerializationUtils.toJsonString(receivers));
        return oldReceivers;
    }

    public static void putTabPageIdToCache(IFormView formView, String tab, String tabPageId) {
        formView.getPageCache().put(tab + "tabPageId", tabPageId);
    }

    public static IFormView getTabView(IFormView parentView, String tab) {
        return parentView.getViewNoPlugin(parentView.getPageCache().get(tab + "tabPageId"));
    }

    public static void updateSelCount(IFormView view) {
        Label labelAp = (Label)view.getControl("labelap1");
        int count = ReceiverPageUtil.getCount(view);
        String receiverCount = String.format(ResManager.loadKDString((String)"\u5df2\u9009(%s)", (String)"ReceiverPageUtil_0", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]), count);
        labelAp.setText(receiverCount);
    }

    private static int getCount(IFormView view) {
        List<WarnMessageReceiver> preRelReceivers = ReceiverPageUtil.getMessageReceiverByType(view, "prerelation");
        List<WarnMessageReceiver> roleReceivers = ReceiverPageUtil.getMessageReceiverByType(view, "role");
        List<WarnMessageReceiver> orgReceivers = ReceiverPageUtil.getMessageReceiverByType(view, "org");
        List<WarnMessageReceiver> userReceivers = ReceiverPageUtil.getMessageReceiverByType(view, "user");
        return preRelReceivers.size() + roleReceivers.size() + orgReceivers.size() + userReceivers.size();
    }

    public static void clearCacheMsgReceiver(IFormView view) {
        List<WarnMessageReceiver> messageReceiverByType = ReceiverPageUtil.getMessageReceiverByType(view, "prerelation");
        List<String> oldReceiverIds = messageReceiverByType.stream().map(it -> "prerelation" + it.getId().toLowerCase()).collect(Collectors.toList());
        ReceiverPageUtil.delReceiverControl(view, "prerelation", oldReceiverIds);
        List<WarnMessageReceiver> roleType = ReceiverPageUtil.getMessageReceiverByType(view, "role");
        List<String> oldRoleReceiverIds = roleType.stream().map(it -> "role" + it.getId().toLowerCase()).collect(Collectors.toList());
        ReceiverPageUtil.delReceiverControl(view, "role", oldRoleReceiverIds);
        List<WarnMessageReceiver> orgType = ReceiverPageUtil.getMessageReceiverByType(view, "org");
        List<String> oldOrgReceiverIds = orgType.stream().map(it -> "org" + it.getId().toLowerCase()).collect(Collectors.toList());
        ReceiverPageUtil.delReceiverControl(view, "org", oldOrgReceiverIds);
        List<WarnMessageReceiver> userType = ReceiverPageUtil.getMessageReceiverByType(view, "user");
        List<String> oldUserReceiverIds = userType.stream().map(it -> "user" + it.getId().toLowerCase()).collect(Collectors.toList());
        ReceiverPageUtil.delReceiverControl(view, "user", oldUserReceiverIds);
        Label labelAp = (Label)view.getControl("labelap1");
        int count = 0;
        String receiverCount = String.format(ResManager.loadKDString((String)"\u5df2\u9009(%s)", (String)"ReceiverPageUtil_0", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]), count);
        labelAp.setText(receiverCount);
        view.getPageCache().put("prerelation", "");
        view.getPageCache().put("role", "");
        view.getPageCache().put("org", "");
        view.getPageCache().put("user", "");
        Tab tab = (Tab)view.getControl("tabap");
        tab.activeTab("tabpageap");
        EntryGrid entryGrid = (EntryGrid)view.getControl("entryentity_rc");
        entryGrid.selectRows(new int[0], 0);
    }
}

