/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.validator.earlywarn.objtpl;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;

@ExcludeFromJacocoGeneratedReport
public class WarnObjTplValidator
extends AbstractValidator {
    private static final Log LOG = LogFactory.getLog(WarnObjTplValidator.class);

    public void validate() {
        try {
            String operationKey = this.getOperateKey();
            if ("disable".equals(operationKey)) {
                this.disableCheck();
            } else if ("delete".equals(operationKey)) {
                this.deleteCheck();
            }
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
    }

    private void disableCheck() {
        HRBaseServiceHelper sceneHelper;
        DynamicObject[] sceneObjs;
        ExtendedDataEntity[] data = this.getDataEntities();
        Set objTplIds = Arrays.stream(data).map(ExtendedDataEntity::getDataEntity).map(DataEntityBase::getPkValue).filter(id -> id != null && !"0".equals(String.valueOf(id))).collect(Collectors.toSet());
        if (!objTplIds.isEmpty() && (sceneObjs = (sceneHelper = new HRBaseServiceHelper("hrcs_warnscene")).queryOriginalArray(String.join((CharSequence)",", Lists.newArrayList((Object[])new String[]{"name", "warnobjtpl"})), new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("warnobjtpl", "in", objTplIds)})) != null && sceneObjs.length > 0) {
            Map objTplIdToEnableSceneNameMap = Arrays.stream(sceneObjs).collect(Collectors.groupingBy(scene -> scene.get("warnobjtpl"), Collectors.mapping(scene -> "\u201c" + scene.getString("name") + "\u201d", Collectors.toSet())));
            for (ExtendedDataEntity dataEntity : data) {
                Set sceneNames;
                DynamicObject dy = dataEntity.getDataEntity();
                Object pkValue = dy.getPkValue();
                if (pkValue == null || "0".equals(String.valueOf(pkValue)) || (sceneNames = objTplIdToEnableSceneNameMap.get(pkValue)) == null || sceneNames.isEmpty()) continue;
                this.addErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u53ef\u7528\u72b6\u6001\u9884\u8b66\u573a\u666f{0}\u5f15\u7528\u4e86\u6b64\u9884\u8b66\u5bf9\u8c61\u6a21\u677f\uff0c\u4e0d\u5141\u8bb8\u7981\u7528\u3002", (String)"WarnObjTplValidator_0", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", sceneNames)));
            }
        }
    }

    private void deleteCheck() {
        HRBaseServiceHelper sceneHelper;
        DynamicObject[] sceneObjs;
        ExtendedDataEntity[] data = this.getDataEntities();
        Set objTplIds = Arrays.stream(data).map(ExtendedDataEntity::getDataEntity).map(DataEntityBase::getPkValue).filter(id -> id != null && !"0".equals(String.valueOf(id))).collect(Collectors.toSet());
        if (!objTplIds.isEmpty() && (sceneObjs = (sceneHelper = new HRBaseServiceHelper("hrcs_warnscene")).queryOriginalArray(String.join((CharSequence)",", Lists.newArrayList((Object[])new String[]{"name", "warnobjtpl"})), new QFilter[]{new QFilter("warnobjtpl", "in", objTplIds)})) != null && sceneObjs.length > 0) {
            Map objTplIdToSceneNameMap = Arrays.stream(sceneObjs).collect(Collectors.groupingBy(scene -> scene.get("warnobjtpl"), Collectors.mapping(scene -> "\u201c" + scene.getString("name") + "\u201d", Collectors.toSet())));
            for (ExtendedDataEntity dataEntity : data) {
                Set sceneNames;
                DynamicObject dy = dataEntity.getDataEntity();
                Object pkValue = dy.getPkValue();
                if (pkValue == null || "0".equals(String.valueOf(pkValue)) || (sceneNames = objTplIdToSceneNameMap.get(pkValue)) == null || sceneNames.isEmpty()) continue;
                this.addErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u8be5\u9884\u8b66\u5bf9\u8c61\u6a21\u677f\u5df2\u88ab\u9884\u8b66\u573a\u666f{0}\u5f15\u7528\u3002", (String)"WarnObjTplValidator_1", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", sceneNames)));
            }
        }
    }
}

