/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.validator.earlywarn.plugin;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.common.model.earlywarn.WarnCommonConditionBo;
import kd.hr.hrcs.common.util.earlywarn.WarningCommonUtils;
import org.apache.commons.lang3.StringUtils;

@ExcludeFromJacocoGeneratedReport
public class CommonConditionPluginValidator
extends AbstractValidator {
    private static final Log LOG = LogFactory.getLog(CommonConditionPluginValidator.class);

    public void validate() {
        try {
            String operationKey = this.getOperateKey();
            if ("save".equals(operationKey)) {
                this.saveFieldCheck();
            } else if ("delete".equals(operationKey)) {
                this.deleteCheckSysPreSet();
                this.deleteCheckRef();
            }
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
    }

    private void saveFieldCheck() {
        ExtendedDataEntity[] data;
        for (ExtendedDataEntity dataEntity : data = this.getDataEntities()) {
            DynamicObject dy = dataEntity.getDataEntity();
            String number = dy.getString("number");
            if (WarningCommonUtils.validateNumber((String)number)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\uff0c\u53ef\u4f7f\u7528\u82f1\u6587\u5927\u5c0f\u5199\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u3002", (String)"CommonConditionPluginValidator_0", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]));
        }
    }

    private void deleteCheckRef() {
        ExtendedDataEntity[] data;
        HRBaseServiceHelper sceneHelper = new HRBaseServiceHelper("hrcs_warnscene");
        DynamicObject[] dbSceneDys = sceneHelper.queryOriginalArray("name,commoncondition", new QFilter[]{QFilter.of((String)"1 = 1", (Object[])new Object[0])});
        HashMap pluginIdToSceneNameMap = Maps.newHashMapWithExpectedSize((int)dbSceneDys.length);
        for (DynamicObject dbSceneDy : dbSceneDys) {
            String commonConditionStr = dbSceneDy.getString("commoncondition");
            if (!HRStringUtils.isNotEmpty((String)commonConditionStr)) continue;
            List conditions = JSONArray.parseArray((String)commonConditionStr, WarnCommonConditionBo.class);
            for (WarnCommonConditionBo conditionBo : conditions) {
                if (!"plugin".equals(conditionBo.getSource())) continue;
                String pluginId = conditionBo.getRuleValue();
                pluginIdToSceneNameMap.putIfAbsent(pluginId, Sets.newHashSetWithExpectedSize((int)16));
                pluginIdToSceneNameMap.computeIfPresent(pluginId, (oldKey, set) -> {
                    set.add(dbSceneDy.getString("name"));
                    return set;
                });
            }
        }
        for (ExtendedDataEntity dataEntity : data = this.getDataEntities()) {
            DynamicObject dy = dataEntity.getDataEntity();
            Object deleteId = dy.getPkValue();
            Set refSceneNameSet = (Set)pluginIdToSceneNameMap.get(String.valueOf(deleteId));
            if (refSceneNameSet == null) continue;
            this.addWarningMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u9884\u8b66\u5e38\u7528\u6761\u4ef6\u63d2\u4ef6\u201c{0}\u201d\u5df2\u88ab\u201c{1}\u201d\u5f15\u7528\uff0c\u7981\u6b62\u5220\u9664\u3002", (String)"CommonConditionPluginValidator_1", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]), dy.getString("name"), StringUtils.join((Iterable)refSceneNameSet, (String)",")));
        }
    }

    private void deleteCheckSysPreSet() {
        ExtendedDataEntity[] data;
        for (ExtendedDataEntity dataEntity : data = this.getDataEntities()) {
            DynamicObject dy = dataEntity.getDataEntity();
            if (!"1".equals(dy.getString("issyspreset"))) continue;
            this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u9884\u7f6e\u6570\u636e\u65e0\u6cd5\u5220\u9664\u3002", (String)"CommonConditionPluginValidator_2", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]));
        }
    }
}

