/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.validator.earlywarn.scene;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.inte.api.EnabledLang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.utils.WarnCommonConditionUtils;
import kd.hr.hrcs.common.constants.earlywarn.WarningSceneConstants;
import kd.hr.hrcs.common.model.earlywarn.WarnCommonConditionBo;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

@ExcludeFromJacocoGeneratedReport
public class WarnSceneCommonConditionValidator
extends AbstractValidator
implements WarningSceneConstants {
    private static final Log LOG = LogFactory.getLog(WarnSceneCommonConditionValidator.class);
    private Map<String, String> langNumberAndNameMap = InteServiceHelper.getEnabledLang().stream().collect(Collectors.toMap(EnabledLang::getNumber, EnabledLang::getName, (oldValue, newValue) -> newValue));

    public void validate() {
        try {
            String operationKey = this.getOperateKey();
            if ("save".equals(operationKey)) {
                this.saveCommonCheck();
                this.saveReferCheck();
            }
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
    }

    private void saveCommonCheck() {
        ExtendedDataEntity[] data;
        for (ExtendedDataEntity dataEntity : data = this.getDataEntities()) {
            DynamicObject dy = dataEntity.getDataEntity();
            String commonStr = dy.getString("commoncondition");
            if (!HRStringUtils.isNotEmpty((String)commonStr)) continue;
            List commonConditionBos = JSONArray.parseArray((String)commonStr, WarnCommonConditionBo.class);
            ArrayList conditionNames = Lists.newArrayListWithExpectedSize((int)commonConditionBos.size());
            for (int rowIndex = 0; rowIndex < commonConditionBos.size(); ++rowIndex) {
                WarnCommonConditionBo commonConditionBo = (WarnCommonConditionBo)commonConditionBos.get(rowIndex);
                if (this.checkIsNull(dataEntity, rowIndex, commonConditionBo)) continue;
                this.checkFieldLength(dataEntity, rowIndex, commonConditionBo);
                this.checkDuplicateName(dataEntity, rowIndex, commonConditionBo, conditionNames);
                this.checkDefaultValueAndOptionalRange(dataEntity, rowIndex, commonConditionBo);
            }
        }
    }

    private boolean checkIsNull(ExtendedDataEntity dataEntity, int rowIndex, WarnCommonConditionBo commonConditionBo) {
        ArrayList nullProperties = Lists.newArrayListWithExpectedSize((int)10);
        if (HRStringUtils.isEmpty((String)commonConditionBo.getRuleValue())) {
            nullProperties.add(ResManager.loadKDString((String)"\u201c\u53d6\u503c\u89c4\u5219\u201d", (String)"WarnSceneCommonConditionValidator_1", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]));
        }
        if (commonConditionBo.getName() == null || HRStringUtils.isEmpty((String)commonConditionBo.getName().toString())) {
            nullProperties.add(ResManager.loadKDString((String)"\u201c\u6761\u4ef6\u540d\u79f0\u201d", (String)"WarnSceneCommonConditionValidator_2", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)commonConditionBo.getValueType())) {
            nullProperties.add(ResManager.loadKDString((String)"\u201c\u6570\u636e\u7c7b\u578b\u201d", (String)"WarnSceneCommonConditionValidator_3", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)commonConditionBo.getOperator())) {
            nullProperties.add(ResManager.loadKDString((String)"\u201c\u6570\u91cf\u5173\u7cfb\u201d", (String)"WarnSceneCommonConditionValidator_4", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]));
        }
        if (commonConditionBo.getDescription() == null || HRStringUtils.isEmpty((String)commonConditionBo.getDescription().toString())) {
            nullProperties.add(ResManager.loadKDString((String)"\u201c\u63cf\u8ff0\u201d", (String)"WarnSceneCommonConditionValidator_13", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]));
        }
        if (!nullProperties.isEmpty()) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)MessageFormat.format("\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5e38\u7528\u6761\u4ef6\u201d\u7b2c{0}\u884c\uff1a{1}\uff1b", rowIndex + 1, StringUtils.join((Iterable)nullProperties, (String)"\uff0c")), (String)"WarnSceneCommonConditionValidator_5", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void checkDefaultValueAndOptionalRange(ExtendedDataEntity dataEntity, int rowIndex, WarnCommonConditionBo commonConditionBo) {
        String defaultValue = commonConditionBo.getDefaultValue();
        String optionalRange = commonConditionBo.getOptionalRange();
        if (HRStringUtils.isNotEmpty((String)optionalRange)) {
            if (this.isNotBaseDataLongId(commonConditionBo) || DataTypeEnum.BIGDECIMAL.getDataTypeKey().equals(commonConditionBo.getValueType()) || DataTypeEnum.INTEGER.getDataTypeKey().equals(commonConditionBo.getValueType())) {
                if (!this.checkNumRange(optionalRange)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)MessageFormat.format("\u201c\u5e38\u7528\u6761\u4ef6\u201d\u7b2c{0}\u884c\uff1a\u201c\u53ef\u9009\u8303\u56f4\u201d\u683c\u5f0f\u6709\u8bef\u8bf7\u6309\u8981\u6c42\u586b\u5199\uff1b", rowIndex + 1), (String)"WarnSceneCommonConditionValidator_6", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]));
                } else if (HRStringUtils.isNotEmpty((String)defaultValue)) {
                    if (!this.checkIsNum(defaultValue)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)MessageFormat.format("\u201c\u5e38\u7528\u6761\u4ef6\u201d\u7b2c{0}\u884c\uff1a\u201c\u9ed8\u8ba4\u503c\u201d\u683c\u5f0f\u6709\u8bef\u8bf7\u586b\u5199\u6570\u503c\u7c7b\u578b\u7684\u503c\uff1b", rowIndex + 1), (String)"WarnSceneCommonConditionValidator_7", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    String[] numRange = optionalRange.split(",");
                    if (new BigDecimal(defaultValue).compareTo(new BigDecimal(numRange[0])) < 0 || new BigDecimal(defaultValue).compareTo(new BigDecimal(numRange[1])) > 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)MessageFormat.format("\u201c\u5e38\u7528\u6761\u4ef6\u201d\u4e2d\u201c{0}\u201d\u53ef\u9009\u8303\u56f4\u672a\u5305\u542b\u9ed8\u8ba4\u503c\uff0c\u8bf7\u4fee\u6539\u3002", commonConditionBo.getName().getLocaleValue()), (String)"WarnSceneCommonConditionValidator_8", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]));
                    }
                }
            } else if (DataTypeEnum.DATETIME.getDataTypeKey().equals(commonConditionBo.getValueType())) {
                String[] dateRange;
                if (HRStringUtils.isNotEmpty((String)defaultValue) && (new DateTime((Object)defaultValue).isBefore((ReadableInstant)new DateTime((Object)(dateRange = optionalRange.split(","))[0])) || new DateTime((Object)defaultValue).isAfter((ReadableInstant)new DateTime((Object)dateRange[1])))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)MessageFormat.format("\u201c\u5e38\u7528\u6761\u4ef6\u201d\u4e2d\u201c{0}\u201d\u53ef\u9009\u8303\u56f4\u672a\u5305\u542b\u9ed8\u8ba4\u503c\uff0c\u8bf7\u4fee\u6539\u3002", commonConditionBo.getName().getLocaleValue()), (String)"WarnSceneCommonConditionValidator_8", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]));
                }
            } else {
                this.checkCommonDefaultValueAndOptionRange(dataEntity, commonConditionBo);
            }
        }
    }

    private void checkCommonDefaultValueAndOptionRange(ExtendedDataEntity dataEntity, WarnCommonConditionBo commonConditionBo) {
        String defaultValue = commonConditionBo.getDefaultValue();
        String optionalRange = commonConditionBo.getOptionalRange();
        if (HRStringUtils.isNotEmpty((String)optionalRange) && HRStringUtils.isNotEmpty((String)defaultValue)) {
            String[] options = optionalRange.split(",");
            boolean find = false;
            if (defaultValue.contains(",")) {
                String[] defaultValues = defaultValue.split(",");
                boolean allMatch = true;
                for (String value : defaultValues) {
                    boolean currentFind = false;
                    for (String option : options) {
                        if (!value.equals(option)) continue;
                        currentFind = true;
                        break;
                    }
                    if (currentFind) continue;
                    allMatch = false;
                    break;
                }
                find = allMatch;
            } else {
                for (String option : options) {
                    if (!defaultValue.equals(option)) continue;
                    find = true;
                    break;
                }
            }
            if (!find) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)MessageFormat.format("\u201c\u5e38\u7528\u6761\u4ef6\u201d\u4e2d\u201c{0}\u201d\u53ef\u9009\u8303\u56f4\u672a\u5305\u542b\u9ed8\u8ba4\u503c\uff0c\u8bf7\u4fee\u6539\u3002", commonConditionBo.getName().getLocaleValue()), (String)"WarnSceneCommonConditionValidator_8", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void saveReferCheck() {
        ExtendedDataEntity[] data;
        for (ExtendedDataEntity dataEntity : data = this.getDataEntities()) {
            Map referCommonConditionToSchemeName;
            DynamicObject dy = dataEntity.getDataEntity();
            if (!dy.getDataEntityState().getFromDatabase() || (referCommonConditionToSchemeName = WarnCommonConditionUtils.getReferCommonConditionToSchemeName((Long)dy.getLong("id"))).isEmpty()) continue;
            String commonStr = dy.getString("commoncondition");
            List commonConditionBos = JSONArray.parseArray((String)commonStr, WarnCommonConditionBo.class);
            Set saveConditionRuleUniqueSet = commonConditionBos.stream().map(WarnCommonConditionBo::getRuleValueUnique).collect(Collectors.toSet());
            HashMap deletedReferConditions = Maps.newHashMapWithExpectedSize((int)referCommonConditionToSchemeName.size());
            for (Map.Entry conditionBoEntry : referCommonConditionToSchemeName.entrySet()) {
                if (saveConditionRuleUniqueSet.contains(conditionBoEntry.getKey())) continue;
                deletedReferConditions.put(conditionBoEntry.getKey(), conditionBoEntry.getValue());
            }
            if (deletedReferConditions.isEmpty()) continue;
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_warnscene");
            DynamicObject dbDy = helper.queryOriginalOne("commoncondition", (Object)dy.getLong("id"));
            List dbConditions = JSONArray.parseArray((String)dbDy.getString("commoncondition"), WarnCommonConditionBo.class);
            for (WarnCommonConditionBo dbCondition : dbConditions) {
                String ruleValueUnique = dbCondition.getRuleValueUnique();
                List schemeNames = (List)deletedReferConditions.get(ruleValueUnique);
                if (schemeNames == null || schemeNames.isEmpty()) continue;
                schemeNames = schemeNames.stream().map(name -> "\u201c" + name + "\u201d").collect(Collectors.toList());
                if (dbConditions.size() == 1) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)MessageFormat.format("\u5220\u9664\u5931\u8d25\uff0c\u8be5\u6761\u4ef6\u5df2\u88ab\u9884\u8b66\u573a\u666f{0}\u5f15\u7528\u3002", String.join((CharSequence)"\u3001", schemeNames)), (String)"WarnSceneCommonConditionValidator_9", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]));
                    continue;
                }
                this.addMessage(dataEntity, ResManager.loadKDString((String)MessageFormat.format("{0}\uff1a\u5220\u9664\u5931\u8d25\uff0c\u8be5\u6761\u4ef6\u5df2\u88ab\u9884\u8b66\u573a\u666f{1}\u5f15\u7528\u3002", dbCondition.getName().getLocaleValue(), String.join((CharSequence)"\u3001", schemeNames)), (String)"WarnSceneCommonConditionValidator_11", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean checkNumRange(String optionalRange) {
        if (HRStringUtils.isEmpty((String)optionalRange)) {
            return false;
        }
        if (!optionalRange.contains(",")) {
            return false;
        }
        String[] nums = optionalRange.split(",");
        if (nums.length != 2) {
            return false;
        }
        for (String num : nums) {
            if (this.checkIsNum(num)) continue;
            return false;
        }
        return true;
    }

    private boolean checkIsNum(String num) {
        try {
            new BigDecimal(num);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private void checkFieldLength(ExtendedDataEntity dataEntity, int rowIndex, WarnCommonConditionBo commonConditionBo) {
        LocaleString name = commonConditionBo.getName();
        for (String multiLangName : name.values()) {
            if (multiLangName == null || multiLangName.length() <= 50) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)MessageFormat.format("\u201c\u5e38\u7528\u6761\u4ef6\u201d\u4e2d\u591a\u8bed\u8a00\u540d\u79f0\u201c{0}\u201d\u5b57\u7b26\u6570\u8d85\u8fc750\uff0c\u8bf7\u4fee\u6539\u3002", multiLangName), (String)"WarnSceneCommonConditionValidator_12", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkDuplicateName(ExtendedDataEntity dataEntity, int rowIndex, WarnCommonConditionBo commonConditionBo, List<LocaleString> conditionNames) {
        LocaleString name = commonConditionBo.getName();
        boolean findDuplicate = false;
        for (int nameIndex = 0; nameIndex < conditionNames.size(); ++nameIndex) {
            LocaleString conditionName = conditionNames.get(nameIndex);
            if (conditionName != null && HRStringUtils.equals((String)name.getLocaleValue(), (String)conditionName.getLocaleValue())) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)MessageFormat.format("\u201c\u5e38\u7528\u6761\u4ef6\u201d\u7b2c{0}\u884c\u201c{1}\u201d\u5728\u7b2c{2}\u884c\u5df2\u5b58\u5728\u76f8\u540c\u7684\u6761\u4ef6\u540d\u79f0", rowIndex + 1, name.getLocaleValue(), nameIndex + 1), (String)"WarnSceneCommonConditionValidator_10", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]));
                break;
            }
            Set nameEntrySet = name.entrySet();
            for (Map.Entry nameEntry : nameEntrySet) {
                String currentLangName;
                if (conditionName == null || !HRStringUtils.equals((String)(currentLangName = (String)conditionName.get(nameEntry.getKey())), (String)((String)nameEntry.getValue()))) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)MessageFormat.format("\u201c\u5e38\u7528\u6761\u4ef6\u201d\u7b2c{0}\u884c\u201c{1} {2}\u201d\u5728\u7b2c{3}\u884c\u5df2\u5b58\u5728\u76f8\u540c\u7684\u6761\u4ef6\u540d\u79f0", rowIndex + 1, this.langNumberAndNameMap.get(nameEntry.getKey()), nameEntry.getValue(), nameIndex + 1), (String)"WarnSceneCommonConditionValidator_10", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]));
                findDuplicate = true;
                break;
            }
            if (findDuplicate) break;
        }
        conditionNames.add(commonConditionBo.getName());
    }

    private boolean isNotBaseDataLongId(WarnCommonConditionBo warnCommonConditionBo) {
        String complexType = warnCommonConditionBo.getComplexType();
        String controlType = warnCommonConditionBo.getControlType();
        if (FieldComplexType.BASE_DATA.getValue().equals(complexType) || FieldComplexType.ADMIN_ORG.getValue().equals(complexType) || FieldComplexType.HIS_BASE_DATA.getValue().equals(complexType)) {
            return false;
        }
        if (FieldControlType.BASE_DATA.getValue().equals(controlType) || FieldControlType.HIS_BASE_DATA.getValue().equals(controlType)) {
            return false;
        }
        return DataTypeEnum.LONG.getDataTypeKey().equals(warnCommonConditionBo.getValueType());
    }
}

