/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.validator.earlywarn.scheme;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.enums.FilterOperatorEnum;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.WarningSceneService;
import kd.hr.hrcs.common.constants.earlywarn.WarnSchemeBaseConditionConstants;
import kd.hr.hrcs.common.constants.earlywarn.WarnSchemeFieldConstants;
import kd.hr.hrcs.common.model.earlywarn.WarnBaseConditionBo;
import kd.hr.hrcs.common.model.earlywarn.WarnCommonConditionBo;
import kd.hr.hrcs.common.model.earlywarn.WarnFilterLogicExprBo;
import kd.hr.hrcs.common.model.earlywarn.vo.WarnBaseConditionReturnVo;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

@ExcludeFromJacocoGeneratedReport
public class WarnSchemeBaseConditionValidator
extends AbstractValidator
implements WarnSchemeFieldConstants,
WarnSchemeBaseConditionConstants {
    private static final Log LOG = LogFactory.getLog(WarnSchemeBaseConditionValidator.class);
    private static final String LOGIC_KEY_PATTERN_STR = "^T\\d{2,}$";
    private static final Pattern LOGIC_KEY_PATTERN = Pattern.compile("^T\\d{2,}$");

    protected static String trim(String str) {
        return HRStringUtils.isNotEmpty((String)str) ? str.trim() : str;
    }

    public void validate() {
        try {
            String operationKey = this.getOperateKey();
            if ("save".equals(operationKey)) {
                this.saveCheckBaseCondition();
            }
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
    }

    private void saveCheckBaseCondition() {
        ExtendedDataEntity[] data;
        for (ExtendedDataEntity dataEntity : data = this.getDataEntities()) {
            DynamicObject dy = dataEntity.getDataEntity();
            DynamicObject warnScene = dy.getDynamicObject("warnscene");
            Map<Object, Object> mustInputConditions = Maps.newHashMapWithExpectedSize((int)0);
            Map<Object, Object> allCommonConditions = Maps.newHashMapWithExpectedSize((int)0);
            DynamicObject dbSceneDy = WarningSceneService.getInstance().loadSceneDyById(warnScene.getPkValue());
            String commonConditionJson = dbSceneDy.getString("commoncondition");
            if (HRStringUtils.isNotEmpty((String)commonConditionJson)) {
                List commonConditionBos = JSONArray.parseArray((String)commonConditionJson, WarnCommonConditionBo.class);
                mustInputConditions = commonConditionBos.stream().filter(WarnCommonConditionBo::isMustInput).collect(Collectors.toMap(WarnCommonConditionBo::getRuleValueUnique, condition -> condition.getName().getLocaleValue(), (x, y) -> y));
                allCommonConditions = commonConditionBos.stream().collect(Collectors.toMap(WarnCommonConditionBo::getRuleValueUnique, Function.identity(), (x, y) -> y));
            }
            String baseConditionJson = dy.getString("basecondition");
            HashMap baseConditionRuleMap = Maps.newHashMapWithExpectedSize((int)16);
            if (HRStringUtils.isNotEmpty((String)baseConditionJson)) {
                WarnBaseConditionReturnVo baseConditionReturnVo = (WarnBaseConditionReturnVo)SerializationUtils.fromJsonString((String)baseConditionJson, WarnBaseConditionReturnVo.class);
                List conditionList = baseConditionReturnVo.getBaseConditionBos();
                for (int index = 0; index < conditionList.size(); ++index) {
                    WarnBaseConditionBo baseConditionBo = (WarnBaseConditionBo)conditionList.get(index);
                    String operator = baseConditionBo.getOperator();
                    baseConditionRuleMap.put(baseConditionBo.getRuleValueUnique(), baseConditionBo.getName().getLocaleValue());
                    WarnCommonConditionBo commonConditionBo = (WarnCommonConditionBo)allCommonConditions.get(baseConditionBo.getRuleValueUnique());
                    if (commonConditionBo == null) continue;
                    this.checkSelectValueEmpty(dataEntity, baseConditionBo, operator);
                    this.checkSelectValueInOptionalRange(dataEntity, baseConditionBo);
                }
                this.checkLogicExpression(baseConditionReturnVo, dataEntity);
            }
            for (Map.Entry ruleEntry : baseConditionRuleMap.entrySet()) {
                mustInputConditions.remove(ruleEntry.getKey());
            }
            for (Map.Entry conditionEntry : allCommonConditions.entrySet()) {
                baseConditionRuleMap.remove(conditionEntry.getKey());
            }
            if (!mustInputConditions.isEmpty()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)MessageFormat.format("\u7f3a\u5c11\u5e38\u7528\u6761\u4ef6\u4e2d\u7684\u5fc5\u586b\u6761\u4ef6\u201c{0}\u201d\u3002", StringUtils.join(mustInputConditions.values(), (String)",")), (String)"WarnSchemeBaseConditionValidator_14", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]));
            }
            if (baseConditionRuleMap.isEmpty()) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)MessageFormat.format("\u9884\u8b66\u6761\u4ef6\u201c{0}\u201d\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\u3002", StringUtils.join(baseConditionRuleMap.values(), (String)",")), (String)"WarnSchemeBaseConditionValidator_9", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkSelectValueEmpty(ExtendedDataEntity dataEntity, WarnBaseConditionBo baseConditionBo, String operator) {
        if (this.isNeedValue(operator) && baseConditionBo.isMustInput()) {
            String value;
            if (HRStringUtils.isEmpty((String)baseConditionBo.getValueType())) {
                this.addErrorMessageTemp(dataEntity, ResManager.loadKDString((String)MessageFormat.format("\u8bf7\u8bbe\u7f6e\u201c{0}\u201d\u7684\u503c\u7c7b\u578b\u3002", baseConditionBo.getName().getLocaleValue()), (String)"WarnSchemeBaseConditionValidator_2", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]));
            }
            if (HRStringUtils.isEmpty((String)(value = WarnSchemeBaseConditionValidator.trim(baseConditionBo.getSelectValue())))) {
                this.addErrorMessageTemp(dataEntity, ResManager.loadKDString((String)MessageFormat.format("\u8bf7\u914d\u7f6e\u6761\u4ef6\u201c{0}\u201d\u7684\u503c\u3002", baseConditionBo.getName().getLocaleValue()), (String)"WarnSchemeBaseConditionValidator_3", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]));
            } else if ((DataTypeEnum.BIGDECIMAL.getDataTypeKey().equals(baseConditionBo.getValueType()) || DataTypeEnum.INTEGER.getDataTypeKey().equals(baseConditionBo.getValueType())) && !this.checkIsNum(value)) {
                this.addErrorMessageTemp(dataEntity, ResManager.loadKDString((String)MessageFormat.format("\u8bf7\u786e\u4fdd\u6761\u4ef6{0}\u7684\u503c\u4e3a\u6570\u5b57\u3002", baseConditionBo.getName().getLocaleValue()), (String)"WarnSchemeBaseConditionValidator_4", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void addErrorMessageTemp(ExtendedDataEntity dataEntity, String content) {
        if (this.getValidateResult().getAllErrorInfo().size() == 0) {
            this.addErrorMessage(dataEntity, String.format("%s%s", ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c", (String)"WarnSchemeBaseConditionValidator_13", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]), content));
        } else {
            this.addErrorMessage(dataEntity, content);
        }
    }

    private void checkSelectValueInOptionalRange(ExtendedDataEntity dataEntity, WarnBaseConditionBo baseConditionBo) {
        String optionalRange = baseConditionBo.getOptionalRange();
        String selectValue = baseConditionBo.getSelectValue();
        if (HRStringUtils.isNotEmpty((String)optionalRange)) {
            if (this.isNotBaseDataLongId(baseConditionBo) || DataTypeEnum.BIGDECIMAL.getDataTypeKey().equals(baseConditionBo.getValueType()) || DataTypeEnum.INTEGER.getDataTypeKey().equals(baseConditionBo.getValueType())) {
                if (HRStringUtils.isNotEmpty((String)selectValue)) {
                    if (!this.checkIsNum(selectValue)) {
                        this.addErrorMessageTemp(dataEntity, ResManager.loadKDString((String)MessageFormat.format("\u201c{0}\u201d\u9884\u8b66\u6761\u4ef6\u503c\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u586b\u5199\u6570\u503c\u7c7b\u578b\u7684\u503c\u3002", baseConditionBo.getName().getLocaleValue()), (String)"WarnSchemeBaseConditionValidator_10", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    String[] numRange = optionalRange.split(",");
                    if (new BigDecimal(selectValue).compareTo(new BigDecimal(numRange[0])) < 0 || new BigDecimal(selectValue).compareTo(new BigDecimal(numRange[1])) > 0) {
                        this.addErrorMessageTemp(dataEntity, ResManager.loadKDString((String)MessageFormat.format("\u201c{0}\u201d\u9884\u8b66\u6761\u4ef6\u7684\u503c\u4e0d\u5728\u53ef\u9009\u8303\u56f4\u201c{1}\u201d\u5185\u3002", baseConditionBo.getName().getLocaleValue(), optionalRange.replace(",", "~")), (String)"WarnSchemeBaseConditionValidator_11", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]));
                    }
                }
            } else if (DataTypeEnum.DATETIME.getDataTypeKey().equals(baseConditionBo.getValueType())) {
                String[] dateRange;
                if (HRStringUtils.isNotEmpty((String)selectValue) && (new DateTime((Object)selectValue).isBefore((ReadableInstant)new DateTime((Object)(dateRange = optionalRange.split(","))[0])) || new DateTime((Object)selectValue).isAfter((ReadableInstant)new DateTime((Object)dateRange[1])))) {
                    this.addErrorMessageTemp(dataEntity, ResManager.loadKDString((String)MessageFormat.format("\u201c{0}\u201d\u9884\u8b66\u6761\u4ef6\u7684\u503c\u4e0d\u5728\u53ef\u9009\u8303\u56f4\u201c{1}\u201d\u5185\u3002", baseConditionBo.getName().getLocaleValue(), HRDateTimeUtils.formatUserSettingFromString((String)dateRange[0]).concat("~").concat(HRDateTimeUtils.formatUserSettingFromString((String)dateRange[1]))), (String)"WarnSchemeBaseConditionValidator_11", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]));
                }
            } else {
                this.checkCommonSelectValueAndOptionRange(dataEntity, baseConditionBo);
            }
        }
    }

    private void checkLogicExpression(WarnBaseConditionReturnVo baseConditionReturnVo, ExtendedDataEntity dataEntity) {
        List expressList = baseConditionReturnVo.getLogicExpressList();
        List baseConditionBos = baseConditionReturnVo.getBaseConditionBos();
        String expressStr = baseConditionReturnVo.getLogicExpressStr();
        if (baseConditionBos.isEmpty() && HRStringUtils.isEmpty((String)expressStr)) {
            return;
        }
        Set expressNameList = expressList.stream().map(WarnFilterLogicExprBo::getName).collect(Collectors.toSet());
        String pattern = "^\\(*T[0-9]+\\)*((AND|OR)\\(*T[0-9]+\\)*)*$";
        if (!Pattern.matches(pattern, expressStr.replaceAll(" ", ""))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6761\u4ef6\u903b\u8f91\u8868\u8fbe\u5f0f\u914d\u7f6e\u9519\u8bef\u3002", (String)"WarnSchemeBaseConditionValidator_5", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]));
        }
        String[] split = expressStr.split(" ");
        int leftBracket = 0;
        int rightBracket = 0;
        for (String key : split) {
            if (HRStringUtils.isEmpty((String)key) || "AND".equals(key) || "OR".equals(key)) continue;
            if ("(".equals(key)) {
                ++leftBracket;
                continue;
            }
            if (")".equals(key)) {
                ++rightBracket;
                continue;
            }
            if (LOGIC_KEY_PATTERN.matcher(key).matches()) {
                if (expressNameList.contains(key)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)MessageFormat.format("\u83b7\u53d6\u6761\u4ef6\u201c{0}\u201d\u5931\u8d25\uff0c\u8bf7\u5220\u9664\u540e\u91cd\u65b0\u914d\u7f6e\u3002", key), (String)"WarnSchemeBaseConditionValidator_6", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]));
                continue;
            }
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)MessageFormat.format("\u6761\u4ef6\u903b\u8f91\u8868\u8fbe\u5f0f\u4e2d\u5b58\u5728\u65e0\u6548\u5b57\u7b26\u201c{0}\u201d\u3002", key), (String)"WarnSchemeBaseConditionValidator_7", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]));
        }
        if (leftBracket != rightBracket) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6761\u4ef6\u903b\u8f91\u8868\u8fbe\u5f0f\u7684\u62ec\u53f7\u6570\u91cf\u4e0d\u5339\u914d\u3002", (String)"WarnSchemeBaseConditionValidator_8", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]));
        }
    }

    private String getConditionTag(int index) {
        return index < 9 ? "T0" + (index + 1) : "T" + (index + 1);
    }

    private boolean isNeedValue(String operator) {
        if (HRStringUtils.isEmpty((String)operator)) {
            return false;
        }
        FilterOperatorEnum operatorEnum = FilterOperatorEnum.getEnum((String)operator);
        if (operatorEnum != null) {
            return operatorEnum.isNeedValue();
        }
        return false;
    }

    private boolean checkIsNum(String num) {
        try {
            new BigDecimal(num);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean isNotBaseDataLongId(WarnBaseConditionBo baseConditionBo) {
        String complexType = baseConditionBo.getComplexType();
        String controlType = baseConditionBo.getControlType();
        if (FieldComplexType.BASE_DATA.getValue().equals(complexType) || FieldComplexType.ADMIN_ORG.getValue().equals(complexType) || FieldComplexType.HIS_BASE_DATA.getValue().equals(complexType)) {
            return false;
        }
        if (FieldControlType.BASE_DATA.getValue().equals(controlType) || FieldControlType.HIS_BASE_DATA.getValue().equals(controlType)) {
            return false;
        }
        return DataTypeEnum.LONG.getDataTypeKey().equals(baseConditionBo.getValueType());
    }

    private void checkCommonSelectValueAndOptionRange(ExtendedDataEntity dataEntity, WarnBaseConditionBo baseConditionBo) {
        String selectValue = baseConditionBo.getSelectValue();
        String optionalRange = baseConditionBo.getOptionalRange();
        if (HRStringUtils.isNotEmpty((String)optionalRange) && HRStringUtils.isNotEmpty((String)selectValue)) {
            String[] options = optionalRange.split(",");
            boolean find = false;
            if (selectValue.contains(",")) {
                String[] defaultValues = selectValue.split(",");
                boolean allMatch = true;
                for (String value : defaultValues) {
                    boolean currentFind = false;
                    for (String option : options) {
                        if (!value.equals(option)) continue;
                        currentFind = true;
                        break;
                    }
                    if (currentFind) continue;
                    allMatch = false;
                    break;
                }
                find = allMatch;
            } else {
                for (String option : options) {
                    if (!selectValue.equals(option)) continue;
                    find = true;
                    break;
                }
            }
            if (!find) {
                this.addErrorMessageTemp(dataEntity, ResManager.loadKDString((String)MessageFormat.format("\u201c{0}\u201d\u9884\u8b66\u6761\u4ef6\u53ef\u9009\u8303\u56f4\u672a\u5305\u542b\u5df2\u9009\u503c\u201c{1}\u201d\uff0c\u8bf7\u4fee\u6539\u3002", baseConditionBo.getName().getLocaleValue(), baseConditionBo.getSelectValueName()), (String)"WarnSchemeBaseConditionValidator_12", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

