/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.web.earlywarn.objtpl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ISVInfo;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinConditionBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.WarnObjTplService;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.calfield.WarnCalcFieldService;
import kd.hr.hrcs.common.constants.earlywarn.WarnObjTplConstants;
import kd.hr.hrcs.common.model.earlywarn.WarnCalFieldBo;
import kd.hr.hrcs.common.model.earlywarn.WarnEntityRelationBo;
import kd.hr.hrcs.common.model.earlywarn.WarnJoinEntityBo;
import kd.hr.hrcs.common.model.earlywarn.WarnQueryFieldBo;
import kd.hr.hrcs.opplugin.validator.earlywarn.objtpl.WarnObjTplValidator;

@ExcludeFromJacocoGeneratedReport
public class WarnObjTplOp
extends HRDataBaseOp
implements WarnObjTplConstants {
    private static final Log LOG = LogFactory.getLog(WarnObjTplOp.class);

    public void onAddValidators(AddValidatorsEventArgs eventArgs) {
        try {
            super.onAddValidators(eventArgs);
            eventArgs.addValidator((AbstractValidator)new WarnObjTplValidator());
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        if (HRStringUtils.equals((String)args.getOperationKey(), (String)"save")) {
            this.save(args);
        } else if (HRStringUtils.equals((String)args.getOperationKey(), (String)"delete")) {
            this.delete(args);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        super.afterExecuteOperationTransaction(args);
    }

    private void save(BeginOperationTransactionArgs args) {
        String joinEntitiesStr = this.getOption().getVariableValue("joinEntities", "");
        String queryFieldsStr = this.getOption().getVariableValue("queryFields", "");
        String entityRelationsStr = this.getOption().getVariableValue("entityRelations", "");
        String calFieldsStr = this.getOption().getVariableValue("calculateFields", "");
        List joinEntities = Collections.emptyList();
        List queryFields = Collections.emptyList();
        List entityRelations = Collections.emptyList();
        List calculatedFields = Collections.emptyList();
        if (HRStringUtils.isNotEmpty((String)joinEntitiesStr)) {
            joinEntities = JSON.parseArray((String)joinEntitiesStr, WarnJoinEntityBo.class);
        }
        if (HRStringUtils.isNotEmpty((String)queryFieldsStr)) {
            queryFields = JSON.parseArray((String)queryFieldsStr, WarnQueryFieldBo.class);
        }
        if (HRStringUtils.isNotEmpty((String)entityRelationsStr)) {
            entityRelations = JSON.parseArray((String)entityRelationsStr, WarnEntityRelationBo.class);
        }
        if (HRStringUtils.isNotEmpty((String)calFieldsStr)) {
            calculatedFields = JSON.parseArray((String)calFieldsStr, WarnCalFieldBo.class);
        }
        ISVInfo isvInfo = ISVServiceHelper.getISVInfo();
        String isvId = isvInfo.getId();
        DynamicObject anObjDy = args.getDataEntities()[0];
        Map<Object, DynamicObject> joinEntityLoadMap = Collections.emptyMap();
        Map<Object, DynamicObject> queryFieldLoadMap = Collections.emptyMap();
        Map<Object, DynamicObject> entityRelationLoadMap = Collections.emptyMap();
        boolean fromDatabase = anObjDy.getDataEntityState().getFromDatabase();
        if (fromDatabase) {
            WarnObjTplService service = WarnObjTplService.getInstance();
            DynamicObject[] joinEntityLoads = service.loadJoinEntities(Long.valueOf(anObjDy.getLong("id")));
            joinEntityLoadMap = Arrays.stream(joinEntityLoads).collect(Collectors.toMap(DataEntityBase::getPkValue, dy -> dy));
            DynamicObject[] queryFieldLoads = service.loadQueryFields(Long.valueOf(anObjDy.getLong("id")));
            queryFieldLoadMap = Arrays.stream(queryFieldLoads).collect(Collectors.toMap(DataEntityBase::getPkValue, dy -> dy));
            DynamicObject[] entityRelationLoads = service.loadEntityRelations(Long.valueOf(anObjDy.getLong("id")));
            entityRelationLoadMap = Arrays.stream(entityRelationLoads).collect(Collectors.toMap(DataEntityBase::getPkValue, dy -> dy));
        } else {
            long warnSceneId = anObjDy.getLong("id");
            if (warnSceneId == 0L) {
                warnSceneId = ORM.create().genLongId("hrcs_warnobjtpl");
                anObjDy.set("id", (Object)warnSceneId);
            }
        }
        DynamicObject[] joinEntityCol = this.assembleAndSaveJoinEntities(anObjDy, joinEntities, joinEntityLoadMap, isvId);
        this.assembleAndSaveQueryFields(anObjDy, queryFields, queryFieldLoadMap, isvId);
        this.assembleAndSaveEntityRelations(anObjDy, entityRelations, entityRelationLoadMap, joinEntityCol, isvId);
        WarnCalcFieldService.getInstance().saveCalFieldsForWarnObjTpl(fromDatabase, Long.valueOf(anObjDy.getLong("id")), calculatedFields);
    }

    private void delete(BeginOperationTransactionArgs args) {
        List warnObjTplIds = Arrays.stream(args.getDataEntities()).map(dy -> dy.get("id")).collect(Collectors.toList());
        QFilter anObjQFilter = new QFilter("sourceid", "in", warnObjTplIds);
        HRBaseServiceHelper joinEntityHelper = new HRBaseServiceHelper("hrcs_warnscenejoinentity");
        joinEntityHelper.deleteByFilter(new QFilter[]{anObjQFilter});
        HRBaseServiceHelper queryFieldHelper = new HRBaseServiceHelper("hrcs_warnscenequeryfield");
        queryFieldHelper.deleteByFilter(new QFilter[]{anObjQFilter});
        HRBaseServiceHelper entityRelationHelper = new HRBaseServiceHelper("hrcs_warnsceneentityrel");
        entityRelationHelper.deleteByFilter(new QFilter[]{anObjQFilter});
        HRBaseServiceHelper calFieldHelper = new HRBaseServiceHelper("hrcs_warncalfield");
        QFilter calFieldQFilter = new QFilter("source", "=", (Object)"warnfield");
        calFieldQFilter.and(new QFilter("sourceid", "in", warnObjTplIds));
        calFieldHelper.deleteByFilter(new QFilter[]{calFieldQFilter});
    }

    private DynamicObject[] assembleAndSaveJoinEntities(DynamicObject anObjDy, List<WarnJoinEntityBo> joinEntities, Map<Object, DynamicObject> joinEntityLoadMap, String isvId) {
        HRBaseServiceHelper joinEntityHelper = new HRBaseServiceHelper("hrcs_warnscenejoinentity");
        DynamicObjectCollection joinEntityCol = new DynamicObjectCollection();
        Set<Long> ids = joinEntities.stream().map(joinEntityBo -> this.getLongId(joinEntityBo.getId())).collect(Collectors.toSet());
        List<Object> deleteIds = this.getDeleteId(ids, joinEntityLoadMap);
        for (WarnJoinEntityBo joinEntity : joinEntities) {
            DynamicObject joinDy = joinEntityLoadMap.get(this.getLongId(joinEntity.getId()));
            if (joinDy == null) {
                joinDy = joinEntityHelper.generateEmptyDynamicObject();
            }
            joinDy.set("sourceid", anObjDy.get("id"));
            joinDy.set("source", (Object)"warnobjtpl");
            joinDy.set("index", (Object)joinEntity.getIndex());
            joinDy.set("longnumber", (Object)joinEntity.getLongNumber());
            joinDy.set("entitynumber", (Object)joinEntity.getEntityNumber());
            joinDy.set("entityalias", (Object)joinEntity.getEntityAlias());
            joinDy.set("type", (Object)joinEntity.getType());
            joinDy.set("iscore", (Object)joinEntity.isCore());
            joinEntityCol.add((Object)joinDy);
        }
        joinEntityHelper.delete(deleteIds.toArray(new Object[0]));
        return (DynamicObject[])joinEntityHelper.save(joinEntityCol);
    }

    private void assembleAndSaveQueryFields(DynamicObject anObjDy, List<WarnQueryFieldBo> queryFields, Map<Object, DynamicObject> queryFieldLoadMap, String isvId) {
        HRBaseServiceHelper queryFieldHelper = new HRBaseServiceHelper("hrcs_warnscenequeryfield");
        DynamicObjectCollection queryFieldCol = new DynamicObjectCollection();
        Set<Long> ids = queryFields.stream().map(queryFieldBo -> this.getLongId(queryFieldBo.getId())).collect(Collectors.toSet());
        List<Object> deleteIds = this.getDeleteId(ids, queryFieldLoadMap);
        Map<String, DynamicObject> fieldAliasToFieldLoadMap = queryFieldLoadMap.values().stream().collect(Collectors.toMap(dy -> dy.getString("fieldalias"), dy -> dy));
        long newIdCount = queryFields.stream().filter(field -> HRStringUtils.isEmpty((String)field.getId())).count();
        long[] newIds = new long[1];
        int idIndex = 0;
        if (newIdCount > 0L) {
            newIds = ID.genLongIds((int)Integer.parseInt(String.valueOf(newIdCount)));
        }
        ArrayList changeNameFields = Lists.newArrayListWithExpectedSize((int)queryFields.size());
        for (WarnQueryFieldBo queryField : queryFields) {
            DynamicObject queryFieldDy = queryField.getFieldAlias().endsWith(".id") ? fieldAliasToFieldLoadMap.get(queryField.getFieldAlias()) : queryFieldLoadMap.get(this.getLongId(queryField.getId()));
            if (queryFieldDy == null) {
                queryFieldDy = queryFieldHelper.generateEmptyDynamicObject();
                long newId = newIds[idIndex++];
                queryFieldDy.set("id", (Object)newId);
                queryField.setId(String.valueOf(newId));
            }
            queryFieldDy.set("sourceid", anObjDy.get("id"));
            queryFieldDy.set("source", (Object)"warnobjtpl");
            queryFieldDy.set("entitynumber", (Object)queryField.getEntityNumber());
            queryFieldDy.set("fieldname", (Object)queryField.getFieldName());
            queryFieldDy.set("fieldalias", (Object)queryField.getFieldAlias());
            queryFieldDy.set("fieldpath", (Object)queryField.getFieldPath());
            queryFieldDy.set("valuetype", (Object)queryField.getValueType());
            queryFieldDy.set("complextype", (Object)queryField.getComplexType());
            queryFieldDy.set("controltype", (Object)queryField.getControlType());
            queryFieldCol.add((Object)queryFieldDy);
            if (!queryField.isChangeShowName()) continue;
            changeNameFields.add(queryField);
        }
        queryFieldHelper.delete(deleteIds.toArray(new Object[0]));
        queryFieldHelper.save(queryFieldCol);
        this.syncSceneQueryFieldNames(anObjDy, changeNameFields);
    }

    private void assembleAndSaveEntityRelations(DynamicObject anObjDy, List<WarnEntityRelationBo> entityRelations, Map<Object, DynamicObject> entityRelationLoadMap, DynamicObject[] joinEntityCol, String isvId) {
        HRBaseServiceHelper entityRelationHelper = new HRBaseServiceHelper("hrcs_warnsceneentityrel");
        DynamicObjectCollection entityRelationCol = new DynamicObjectCollection();
        Set<Long> ids = entityRelations.stream().map(entityRelationBo -> this.getLongId(entityRelationBo.getId())).collect(Collectors.toSet());
        List<Object> deleteIds = this.getDeleteId(ids, entityRelationLoadMap);
        Map<Object, DynamicObject> joinEntityMap = Arrays.stream(joinEntityCol).collect(Collectors.toMap(entity -> entity.get("entityalias"), entity -> entity));
        for (WarnEntityRelationBo entityRelation : entityRelations) {
            DynamicObject entityRelationDy = entityRelationLoadMap.get(this.getLongId(entityRelation.getId()));
            if (entityRelationDy == null) {
                entityRelationDy = entityRelationHelper.generateEmptyDynamicObject();
            }
            entityRelationDy.set("sourceid", anObjDy.get("id"));
            entityRelationDy.set("source", (Object)"warnobjtpl");
            DynamicObject entityDy = joinEntityMap.get(entityRelation.getEntityAlias());
            entityRelationDy.set("entityid", entityDy.getPkValue());
            entityRelationDy.set("jointype", (Object)entityRelation.getJoinType());
            DynamicObject joinEntityDy = joinEntityMap.get(entityRelation.getJoinEntityAlias());
            entityRelationDy.set("joinentityid", joinEntityDy.getPkValue());
            DynamicObjectCollection joinConditionCol = entityRelationHelper.generateEmptyEntryCollection(entityRelationDy, "joinconditions");
            List joinConditions = entityRelation.getConditions();
            for (JoinConditionBo joinCondition : joinConditions) {
                DynamicObject joinConditionDy = entityRelationHelper.generateEmptyEntryDynamicObject("joinconditions");
                joinConditionDy.set("leftprop", (Object)joinCondition.getLeftProp());
                joinConditionDy.set("comparetype", (Object)joinCondition.getCompareType());
                joinConditionDy.set("rightprop", (Object)joinCondition.getRightProp());
                joinConditionDy.set("rightproptype", (Object)joinCondition.getRightPropType());
                joinConditionDy.set("rightpropval", (Object)joinCondition.getRightPropVal());
                joinConditionDy.set("logictype", (Object)joinCondition.getLogicType());
                joinConditionCol.add((Object)joinConditionDy);
            }
            entityRelationDy.set("joinconditions", (Object)joinConditionCol);
            entityRelationCol.add((Object)entityRelationDy);
        }
        entityRelationHelper.delete(deleteIds.toArray(new Object[0]));
        entityRelationHelper.save(entityRelationCol);
    }

    private List<Object> getDeleteId(Set<Long> ids, Map<Object, DynamicObject> dyMap) {
        ArrayList deleteIds = Lists.newArrayListWithCapacity((int)10);
        for (DynamicObject dy : dyMap.values()) {
            Long id = dy.getLong("id");
            if (ids.contains(id)) continue;
            deleteIds.add(id);
        }
        return deleteIds;
    }

    private Long getLongId(String strId) {
        if (HRStringUtils.isEmpty((String)strId)) {
            return 0L;
        }
        return Long.valueOf(strId);
    }

    private void syncSceneQueryFieldNames(DynamicObject objTplDy, List<WarnQueryFieldBo> changeNameFields) {
        Object objTplId;
        HRBaseServiceHelper sceneHelper;
        DynamicObject[] sceneDys;
        if (changeNameFields != null && !changeNameFields.isEmpty() && (sceneDys = (sceneHelper = new HRBaseServiceHelper("hrcs_warnscene")).queryOriginalArray("id", new QFilter[]{new QFilter("warnobjtpl", "=", objTplId = objTplDy.getPkValue())})).length > 0) {
            DynamicObject[] queryFieldDys;
            Map fieldBoMap = changeNameFields.stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, Function.identity()));
            List sceneIds = Arrays.stream(sceneDys).map(scene -> scene.getLong("id")).collect(Collectors.toList());
            ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)2);
            qFilters.add(new QFilter("source", "=", (Object)"warnscene"));
            qFilters.add(new QFilter("fieldalias", "in", fieldBoMap.keySet()));
            qFilters.add(new QFilter("sourceid", "in", sceneIds));
            qFilters.add(new QFilter("ischangeshowname", "!=", (Object)true));
            HRBaseServiceHelper queryFieldHelper = new HRBaseServiceHelper("hrcs_warnscenequeryfield");
            ArrayList selectFields = Lists.newArrayList((Object[])new String[]{"id", "fieldalias", "fieldname"});
            for (DynamicObject queryFieldDy : queryFieldDys = queryFieldHelper.query(String.join((CharSequence)",", selectFields), qFilters.toArray(new QFilter[0]))) {
                String fieldAlias = queryFieldDy.getString("fieldalias");
                WarnQueryFieldBo queryFieldBo = (WarnQueryFieldBo)fieldBoMap.get(fieldAlias);
                queryFieldDy.set("fieldname", (Object)queryFieldBo.getFieldName());
            }
            queryFieldHelper.save(queryFieldDys);
        }
    }
}

