/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.common.generic.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.common.generic.context.IPersonGenericContext;
import kd.hrmp.hrpi.common.generic.entity.IPersonGenericEntity;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericErrorInfo;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericOperateEntity;
import kd.hrmp.hrpi.common.generic.enums.PersonGenericOperateTypeEnums;

public class PersonGenericContext<T extends IPersonGenericEntity>
implements IPersonGenericContext<T> {
    private static final Log LOGGER = LogFactory.getLog(PersonGenericContext.class);
    private T personGenericSaveEntity;
    private PersonGenericOperateTypeEnums operateTypeEnums;
    private boolean useThread;
    private boolean success = true;
    private List<PersonGenericErrorInfo> errorInfos;
    private PersonGenericOperateEntity personGenericOperateEntity;
    private Map<String, Set<String>> redundancyFieldMap;
    private Map<String, Object> customerMap;

    @Override
    public void init(T personGenericSaveEntity, boolean useThread, PersonGenericOperateTypeEnums operateTypeEnums) {
        this.setPersonGenericSaveEntity(personGenericSaveEntity);
        this.setOperateTypeEnums(operateTypeEnums);
        this.initErrorInfos(useThread);
        this.initPersonGenericOperateEntity(useThread);
        this.initRedundancyFieldMap(useThread);
        this.initCustomerMap(useThread);
    }

    protected void setPersonGenericSaveEntity(T personGenericSaveEntity) {
        this.personGenericSaveEntity = personGenericSaveEntity;
    }

    public void setOperateTypeEnums(PersonGenericOperateTypeEnums operateTypeEnums) {
        this.operateTypeEnums = operateTypeEnums;
    }

    @Override
    public PersonGenericOperateTypeEnums getOperateTypeEnums() {
        return this.operateTypeEnums;
    }

    protected void initErrorInfos(boolean useThread) {
        this.errorInfos = useThread ? new CopyOnWriteArrayList() : new ArrayList();
        this.useThread = useThread;
        for (String entityNumber : this.personGenericSaveEntity.getEntityNumberList()) {
            this.errorInfos.add(new PersonGenericErrorInfo(entityNumber, useThread));
        }
    }

    protected void initPersonGenericOperateEntity(boolean useThread) {
        this.personGenericOperateEntity = new PersonGenericOperateEntity(useThread);
    }

    @Override
    public T getPersonGenericEntity() {
        return this.personGenericSaveEntity;
    }

    @Override
    public boolean hasFailData() {
        return !this.success;
    }

    @Override
    public <TYPE> void addErrorMsg(String entityNumber, TYPE id, String errMsg) {
        this.setFail();
        PersonGenericErrorInfo errorInfo = this.getPersonGenericErrorInfo(entityNumber);
        errorInfo.addErrorMsg(id, errMsg);
    }

    @Override
    public void addExceptionMessage(String entityNumber, String exceptionMessage) {
        this.setFail();
        PersonGenericErrorInfo errorInfo = this.getPersonGenericErrorInfo(entityNumber);
        errorInfo.setExceptionMessage(exceptionMessage);
    }

    @Override
    public Set<Object> getErrorIds(String entityNumber) {
        PersonGenericErrorInfo errorInfo = this.getPersonGenericErrorInfo(entityNumber);
        return errorInfo.getErrorIds();
    }

    @Override
    public void setErrorKey(String entityNumber, String key) {
        PersonGenericErrorInfo errorInfo = this.getPersonGenericErrorInfo(entityNumber);
        errorInfo.setUniqueKey(key);
    }

    @Override
    public String getErrorKey(String entityNumber) {
        PersonGenericErrorInfo errorInfo = this.getPersonGenericErrorInfo(entityNumber);
        return errorInfo.getUniqueKey();
    }

    private PersonGenericErrorInfo getPersonGenericErrorInfo(String entityNumber) {
        for (PersonGenericErrorInfo errorInfo : this.errorInfos) {
            if (!HRStringUtils.equals((String)errorInfo.getEntityNumber(), (String)entityNumber)) continue;
            return errorInfo;
        }
        LOGGER.info("PersonGenericService ==> PersonGenericContext#getPersonGenericErrorInfo this entityNumber: {} not found, create new errorInfo.", (Object)entityNumber);
        PersonGenericErrorInfo personGenericErrorInfo = new PersonGenericErrorInfo(entityNumber, this.useThread);
        this.errorInfos.add(personGenericErrorInfo);
        return personGenericErrorInfo;
    }

    private void setFail() {
        this.success = false;
    }

    @Override
    public List<Map<String, Object>> getErrorInfos() {
        return PersonGenericErrorInfo.buildErrorInfos(this.errorInfos);
    }

    @Override
    public void addResponse(Map<String, Object> response) {
        this.personGenericOperateEntity.addResponse(response);
    }

    @Override
    public void addErrorResponse(Map<String, Object> response) {
        this.setFail();
        this.addResponse(response);
    }

    @Override
    public List<Map<String, Object>> getResultData() {
        return this.personGenericOperateEntity.getResponseData();
    }

    @Override
    public boolean isUseThread() {
        return this.useThread;
    }

    private void initRedundancyFieldMap(boolean useThread) {
        this.redundancyFieldMap = useThread ? new ConcurrentHashMap(16) : new HashMap(16);
    }

    private void initCustomerMap(boolean useThread) {
        this.customerMap = useThread ? new ConcurrentHashMap(16) : new HashMap(16);
    }

    @Override
    public void addRedundancyField(String entityNumber, String field) {
        Set<String> fields = this.redundancyFieldMap.get(entityNumber);
        if (CollectionUtils.isEmpty(fields)) {
            fields = this.useThread ? new CopyOnWriteArraySet() : new HashSet();
            this.redundancyFieldMap.put(entityNumber, fields);
        }
        fields.add(field);
    }

    @Override
    public Set<String> getRedundancyFields(String entityNumber) {
        return this.redundancyFieldMap.get(entityNumber);
    }

    @Override
    public void putCustomerParam(String key, Object value) {
        this.customerMap.put(key, value);
    }

    @Override
    public void putAllCustomerParam(Map<String, Object> custMap) {
        this.customerMap.putAll(custMap);
    }

    @Override
    public <PARAM> PARAM getCustomerParam(String key) {
        return (PARAM)this.customerMap.get(key);
    }
}

