/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.common.generic.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class PersonGenericErrorInfo {
    private final String entityNumber;
    private String exceptionMessage;
    private final List<ErrorData<?>> errorDatas;
    private String uniqueKey = "id";

    public PersonGenericErrorInfo(String entityNumber, boolean useThread) {
        this.entityNumber = entityNumber;
        this.errorDatas = useThread ? new CopyOnWriteArrayList() : new ArrayList();
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public List<ErrorData<?>> getErrorDatas() {
        return this.errorDatas;
    }

    public PersonGenericErrorInfo setUniqueKey(String uniqueKey) {
        this.uniqueKey = uniqueKey;
        return this;
    }

    public String getUniqueKey() {
        return this.uniqueKey;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public static List<Map<String, Object>> buildErrorInfos(List<PersonGenericErrorInfo> errorInfos) {
        ArrayList<Map<String, Object>> errorInfoList = new ArrayList<Map<String, Object>>(errorInfos.size());
        for (PersonGenericErrorInfo errorInfo : errorInfos) {
            HashMap<String, Object> errInfoMap = new HashMap<String, Object>(16);
            List<ErrorData<?>> errorDatas = errorInfo.getErrorDatas();
            if (errorDatas.isEmpty() && HRStringUtils.isEmpty((String)errorInfo.getExceptionMessage())) continue;
            errInfoMap.put("entityNumber", errorInfo.getEntityNumber());
            if (!errorDatas.isEmpty()) {
                ArrayList errorDataList = new ArrayList(errorDatas.size());
                for (ErrorData<?> errorData : errorDatas) {
                    HashMap<String, Object> errorDataMap = new HashMap<String, Object>(16);
                    errorDataMap.put("id", errorData.getIdRes());
                    errorDataMap.put("errMsg", errorData.getErrMsg().toString());
                    errorDataList.add(errorDataMap);
                }
                errInfoMap.put("errorDatas", errorDataList);
            }
            errInfoMap.put("exceptionMessage", errorInfo.getExceptionMessage());
            errorInfoList.add(errInfoMap);
        }
        return errorInfoList;
    }

    public <TYPE> void addErrorMsg(TYPE id, String errMsg) {
        ErrorData<?> errorData = this.getErrorData(id);
        errorData.getErrMsg().append(errMsg);
    }

    private <TYPE> ErrorData<?> getErrorData(TYPE id) {
        for (ErrorData<?> errorData : this.errorDatas) {
            if (!errorData.getId().equals(id)) continue;
            return errorData;
        }
        ErrorData<TYPE> newErrorData = new ErrorData<TYPE>(id);
        this.errorDatas.add(newErrorData);
        return newErrorData;
    }

    public Set<Object> getErrorIds() {
        return this.errorDatas.stream().map(ErrorData::getIdRes).collect(Collectors.toSet());
    }

    private static class ErrorData<TYPE> {
        private final TYPE id;
        private final StringBuffer errMsg;

        public ErrorData(TYPE id) {
            this.id = id;
            this.errMsg = new StringBuffer();
        }

        public Object getId() {
            return this.id;
        }

        public Object getIdRes() {
            if (this.id instanceof Long || this.id instanceof String) {
                return this.id;
            }
            return SerializationUtils.toJsonString(this.id);
        }

        public StringBuffer getErrMsg() {
            return this.errMsg;
        }
    }
}

