/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.common.generic.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericRelateDataEntity;
import kd.hrmp.hrpi.common.util.HRPIDynamicObjectUtil;
import org.apache.commons.collections.MapUtils;

public class PersonGenericSaveDataEntity {
    private static final Log LOGGER = LogFactory.getLog(PersonGenericSaveDataEntity.class);
    private String entityNumber;
    private DynamicObjectCollection hisDyns;
    private final List<PersonGenericRelateDataEntity> relateDataEntityList = new ArrayList<PersonGenericRelateDataEntity>();

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public PersonGenericSaveDataEntity() {
    }

    public PersonGenericSaveDataEntity setEntityNumber(String entityNumber) {
        this.entityNumber = entityNumber;
        return this;
    }

    public PersonGenericSaveDataEntity(String entityNumber, DynamicObjectCollection hisDyns) {
        this.entityNumber = entityNumber;
        this.hisDyns = hisDyns;
    }

    public DynamicObjectCollection getHisDyns() {
        return this.hisDyns;
    }

    public void setHisDyns(DynamicObjectCollection hisDyns) {
        this.hisDyns = hisDyns;
    }

    public static PersonGenericSaveDataEntity createPersonGenericDataEntity(DynamicObjectCollection hisDyns) {
        if (hisDyns.isEmpty()) {
            return null;
        }
        PersonGenericSaveDataEntity personGenericSaveDataEntity = new PersonGenericSaveDataEntity();
        String entityNumber = HRPIDynamicObjectUtil.getEntityNumber(hisDyns);
        personGenericSaveDataEntity.setEntityNumber(entityNumber).setHisDyns(hisDyns);
        if (HRStringUtils.equals((String)entityNumber, (String)"hrpi_empposorgrel")) {
            hisDyns.forEach(dynamicObject -> LOGGER.info("createPersonGenericDataEntity id is {}, boid is {}, job is {}", new Object[]{dynamicObject.getLong("id"), dynamicObject.getLong("boid"), dynamicObject.get("job")}));
        }
        return personGenericSaveDataEntity;
    }

    public static PersonGenericSaveDataEntity createPersonGenericDataEntity(Map<String, Object> dataMap) {
        if (dataMap.isEmpty()) {
            return null;
        }
        DynamicObjectCollection hisDyns = (DynamicObjectCollection)MapUtils.getObject(dataMap, (Object)"hisDyns");
        return PersonGenericSaveDataEntity.createPersonGenericDataEntity(hisDyns);
    }

    public void addRelateDataEntity(PersonGenericRelateDataEntity relateDataEntity) {
        this.relateDataEntityList.add(relateDataEntity);
    }

    public List<PersonGenericRelateDataEntity> getRelateDataEntityList() {
        return this.relateDataEntityList;
    }
}

