/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.common.generic.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.common.generic.entity.IPersonGenericEntity;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericRelateDataEntity;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericSaveDataEntity;
import org.apache.commons.collections.MapUtils;

public class PersonGenericSaveEntity
implements IPersonGenericEntity {
    private String caller;
    private boolean mustAllSuccess;
    private Long eventId;
    private boolean syncBosUser;
    private Long chgActionId;
    private final List<PersonGenericSaveDataEntity> data = new ArrayList<PersonGenericSaveDataEntity>();
    private final Map<String, DynamicObjectCollection> hisDynsMap = new HashMap<String, DynamicObjectCollection>(16);

    public PersonGenericSaveEntity() {
    }

    public PersonGenericSaveEntity(Long eventId) {
        this.eventId = eventId;
    }

    public static PersonGenericSaveEntity createPersonGenericEntity(Map<String, Object> paramMap) {
        Long eventId = MapUtils.getLong(paramMap, (Object)"eventId");
        PersonGenericSaveEntity personGenericSaveEntity = new PersonGenericSaveEntity(eventId);
        String caller = MapUtils.getString(paramMap, (Object)"caller");
        personGenericSaveEntity.setCaller(caller);
        boolean mustAllSuccess = MapUtils.getBooleanValue(paramMap, (Object)"mustAllSuccess");
        personGenericSaveEntity.setMustAllSuccess(mustAllSuccess);
        boolean syncBosUser = MapUtils.getBooleanValue(paramMap, (Object)"syncBosUser");
        personGenericSaveEntity.setSyncBosUser(syncBosUser);
        Long chgActionId = MapUtils.getLong(paramMap, (Object)"chgActionId");
        personGenericSaveEntity.setChgActionId(chgActionId);
        List data = (List)MapUtils.getObject(paramMap, (Object)"data");
        for (Map dataMap : data) {
            PersonGenericSaveDataEntity personGenericSaveDataEntity = PersonGenericSaveDataEntity.createPersonGenericDataEntity(dataMap);
            if (personGenericSaveDataEntity == null) continue;
            personGenericSaveEntity.getData().add(personGenericSaveDataEntity);
            personGenericSaveEntity.getHisDynsMap().put(personGenericSaveDataEntity.getEntityNumber(), personGenericSaveDataEntity.getHisDyns());
        }
        return personGenericSaveEntity;
    }

    public DynamicObjectCollection getHisDyns(String entityNumber) {
        return this.hisDynsMap.get(entityNumber);
    }

    public List<DynamicObjectCollection> getHisDyns() {
        return this.data.stream().filter(personGenericSaveDataEntity -> !personGenericSaveDataEntity.getHisDyns().isEmpty()).map(PersonGenericSaveDataEntity::getHisDyns).collect(Collectors.toList());
    }

    public Map<String, DynamicObjectCollection> getHisDynsMap() {
        return this.hisDynsMap;
    }

    public Long getEventId() {
        return this.eventId;
    }

    public List<PersonGenericSaveDataEntity> getData() {
        return this.data;
    }

    @Override
    public String getCaller() {
        return this.caller;
    }

    public void setCaller(String caller) {
        this.caller = caller;
    }

    public void setMustAllSuccess(boolean mustAllSuccess) {
        this.mustAllSuccess = mustAllSuccess;
    }

    public int getDataSize() {
        return this.data.size();
    }

    public boolean isSyncBosUser() {
        return this.syncBosUser;
    }

    public void setSyncBosUser(boolean syncBosUser) {
        this.syncBosUser = syncBosUser;
    }

    public Long getChgActionId() {
        return this.chgActionId;
    }

    public void setChgActionId(Long chgActionId) {
        this.chgActionId = chgActionId;
    }

    @Override
    public boolean isMustAllSuccess() {
        return this.mustAllSuccess;
    }

    @Override
    public List<String> getEntityNumberList() {
        return this.data.stream().map(PersonGenericSaveDataEntity::getEntityNumber).collect(Collectors.toList());
    }

    @Override
    public long getTotalDataSize() {
        return this.data.stream().filter(personGenericSaveDataEntity -> !personGenericSaveDataEntity.getHisDyns().isEmpty()).map(PersonGenericSaveDataEntity::getHisDyns).mapToLong(Collection::size).sum();
    }

    public void addRelateDataEntity(String entityNumber, PersonGenericRelateDataEntity relateDataEntity) {
        for (PersonGenericSaveDataEntity data : this.data) {
            if (!HRStringUtils.equals((String)data.getEntityNumber(), (String)entityNumber)) continue;
            data.addRelateDataEntity(relateDataEntity);
        }
    }

    public synchronized DynamicObjectCollection addData(String entityNumber) {
        DynamicObjectCollection newDyColl = new DynamicObjectCollection();
        PersonGenericSaveDataEntity personGenericSaveDataEntity = new PersonGenericSaveDataEntity(entityNumber, newDyColl);
        this.data.add(personGenericSaveDataEntity);
        this.hisDynsMap.put(entityNumber, newDyColl);
        return newDyColl;
    }

    public Map<String, List<Map<Long, DynamicObject>>> getMergeRelateDbDynsMap() {
        List<List<PersonGenericRelateDataEntity>> relateDataEntityListList = this.getRelateDataEntityListList();
        HashMap relateDataDynsMap = new HashMap(16);
        for (List<PersonGenericRelateDataEntity> personGenericRelateDataEntities : relateDataEntityListList) {
            for (PersonGenericRelateDataEntity personGenericRelateDataEntity : personGenericRelateDataEntities) {
                String entityNumber = personGenericRelateDataEntity.getEntityNumber();
                Map<Long, DynamicObject> relateDbDyMap = personGenericRelateDataEntity.getRelateDbDyMap();
                if (CollectionUtils.isEmpty(relateDbDyMap)) continue;
                this.mergeMap(relateDataDynsMap, entityNumber, relateDbDyMap);
            }
        }
        return relateDataDynsMap;
    }

    public Map<String, List<Map<Long, DynamicObject>>> getMergeRelateHisDynsMap() {
        List<List<PersonGenericRelateDataEntity>> relateDataEntityListList = this.getRelateDataEntityListList();
        HashMap relateDataDynsMap = new HashMap(16);
        for (List<PersonGenericRelateDataEntity> personGenericRelateDataEntities : relateDataEntityListList) {
            for (PersonGenericRelateDataEntity personGenericRelateDataEntity : personGenericRelateDataEntities) {
                String entityNumber = personGenericRelateDataEntity.getEntityNumber();
                Map<Long, DynamicObject> relateHisDyMap = personGenericRelateDataEntity.getRelateHisDyMap();
                if (CollectionUtils.isEmpty(relateHisDyMap)) continue;
                this.mergeMap(relateDataDynsMap, entityNumber, relateHisDyMap);
            }
        }
        return relateDataDynsMap;
    }

    public Map<String, List<Set<Long>>> getMergeRelateHisDynsRemoveMap() {
        List<List<PersonGenericRelateDataEntity>> relateDataEntityListList = this.getRelateDataEntityListList();
        HashMap relateDataDynsRemoveMap = new HashMap(16);
        for (List<PersonGenericRelateDataEntity> personGenericRelateDataEntities : relateDataEntityListList) {
            for (PersonGenericRelateDataEntity personGenericRelateDataEntity : personGenericRelateDataEntities) {
                String entityNumber = personGenericRelateDataEntity.getEntityNumber();
                Set<Long> relateHisDyRemoveSet = personGenericRelateDataEntity.getRelateHisDyRemoveSet();
                if (CollectionUtils.isEmpty(relateHisDyRemoveSet)) continue;
                this.mergeMap(relateDataDynsRemoveMap, entityNumber, relateHisDyRemoveSet);
            }
        }
        return relateDataDynsRemoveMap;
    }

    private <T> void mergeMap(Map<String, List<T>> relateDataDynsMap, String entityNumber, T relateDy) {
        List<T> ts = relateDataDynsMap.get(entityNumber);
        if (null != ts && ts.size() > 0) {
            ts.add(relateDy);
        } else {
            ArrayList<T> mergeList = new ArrayList<T>();
            mergeList.add(relateDy);
            relateDataDynsMap.put(entityNumber, mergeList);
        }
    }

    private List<List<PersonGenericRelateDataEntity>> getRelateDataEntityListList() {
        return this.data.stream().filter(personGenericSaveDataEntity -> !personGenericSaveDataEntity.getHisDyns().isEmpty()).filter(personGenericSaveDataEntity -> !personGenericSaveDataEntity.getRelateDataEntityList().isEmpty()).map(PersonGenericSaveDataEntity::getRelateDataEntityList).collect(Collectors.toList());
    }
}

