/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.init.InitOutMessage;
import kd.hr.hbp.common.init.InitOutParam;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.StringUtils;

public class InitValidateUtil {
    private static final Log LOG = LogFactory.getLog(InitValidateUtil.class);

    public static Date getCurrentDay() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date current = new Date();
        String currentDay = sdf.format(current);
        try {
            current = sdf.parse(currentDay);
        }
        catch (ParseException e) {
            LOG.error("InitValidateUtil.getCurrentDay error:", (Throwable)e);
        }
        return current;
    }

    public static void wrapCommonFieldInit(DynamicObject dy) {
        InitValidateUtil.wrapCommonField(dy);
        dy.set("initstatus", (Object)"0");
    }

    public static void wrapUpdCommonFieldInit(DynamicObject dy) {
        InitValidateUtil.wrapUpdCommonField(dy);
        dy.set("initstatus", (Object)"0");
    }

    public static void wrapCommonFieldProcessed(DynamicObject dy) {
        InitValidateUtil.wrapCommonField(dy);
        dy.set("initstatus", (Object)"2");
    }

    private static void wrapCommonField(DynamicObject dy) {
        long currUserId = RequestContext.get().getCurrUserId();
        dy.set("creator", (Object)currUserId);
        dy.set("modifier", (Object)currUserId);
        Date currentDate = new Date();
        dy.set("createtime", (Object)currentDate);
        dy.set("modifytime", (Object)currentDate);
        dy.set("initdatasource", (Object)"1");
    }

    private static void wrapUpdCommonField(DynamicObject dy) {
        long currUserId = RequestContext.get().getCurrUserId();
        dy.set("modifier", (Object)currUserId);
        Date currentDate = new Date();
        dy.set("modifytime", (Object)currentDate);
        dy.set("initdatasource", (Object)"1");
    }

    public static boolean isAllPropNull(String[] props, DynamicObject item) {
        EntityType type = (EntityType)item.getDataEntityType();
        for (int i = 0; i < props.length; ++i) {
            ILocaleString value;
            if (!(type.findProperty(props[i]) instanceof MuliLangTextProp ? (value = (ILocaleString)item.get(props[i])) != null && value.size() > 0 && !InitValidateUtil.isAllLangEmpty(value) : !Objects.isNull(item.get(props[i])))) continue;
            return false;
        }
        return true;
    }

    private static boolean isAllLangEmpty(ILocaleString map) {
        for (Map.Entry entry : map.entrySet()) {
            if (!StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
            return false;
        }
        return true;
    }

    public static void wrapPropsFromSourceToDy(String[] props, DynamicObject source, DynamicObject target) {
        for (String field : props) {
            try {
                target.set(field, source.get(field));
            }
            catch (Exception ext) {
                LOG.error("InitValidateUtil_wrapPropsFromSourceToDy_eroor:", (Throwable)ext);
            }
        }
    }

    public static void addMsg(InitOutParam param, Long midKey, String pkId, String errorMsg) {
        InitOutMessage msg = (InitOutMessage)param.getData().get(midKey);
        if (HRStringUtils.isEmpty((String)errorMsg)) {
            param.addSuccessMsg(midKey, pkId, " ");
            return;
        }
        if (Objects.isNull(msg)) {
            param.addErrorMsg(midKey, errorMsg);
        } else {
            msg.setSuccess(Boolean.FALSE);
            msg.setMessage(msg.getMessage() + errorMsg);
        }
    }

    public static void addMsg(InitOutParam param, Long midKey, String errorMsg) {
        if (midKey.equals(0L)) {
            return;
        }
        InitValidateUtil.addMsg(param, midKey, " ", errorMsg);
    }

    public static void addErrorMsgInSameNumber(InitOutParam param, List<DynamicObject> depList, Map<Long, HashSet<Long>> idMap, String msg) {
        for (int i = 0; i < depList.size(); ++i) {
            DynamicObject item = depList.get(i);
            HashSet<Long> ids = idMap.get(item.get("id"));
            Long midId = CollectionUtils.isEmpty(ids) ? Long.valueOf(0L) : ids.iterator().next();
            InitValidateUtil.addMsg(param, midId, msg);
        }
    }

    public static void validateOtherGroupData(InitOutParam outParam, Map<String, List<Map<String, Object>>> groupByEmpNumber, Map<Long, String> midAndEmpNumberMap) {
        Map validateMap = outParam.getData();
        for (Map.Entry entry : validateMap.entrySet()) {
            Long midId = (Long)entry.getKey();
            InitOutMessage msg = (InitOutMessage)entry.getValue();
            if (msg.getSuccess().booleanValue()) continue;
            List<Map<String, Object>> group = groupByEmpNumber.get(midAndEmpNumberMap.get(midId));
            group.forEach(item -> {
                Long itemMidId = (Long)item.get("id");
                if (InitValidateUtil.checkDateStatus(validateMap, itemMidId)) {
                    outParam.addErrorMsg(itemMidId, ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5b58\u5728\u5176\u4ed6\u9519\u8bef\u6570\u636e\u3002", (String)"InitValidateUtil_0", (String)"hrmp-hrpi-common", (Object[])new Object[0]));
                }
            });
        }
    }

    public static boolean checkDateStatus(Map<Long, InitOutMessage> outMessageMap, Map<Long, HashSet<Long>> idmapping, DynamicObject dy) {
        Long id = (Long)dy.get("id");
        HashSet<Long> set = idmapping.get(id);
        if (CollectionUtils.isEmpty(set)) {
            return false;
        }
        Long midId = idmapping.get(id).iterator().next();
        return InitValidateUtil.checkDateStatus(outMessageMap, midId);
    }

    public static boolean checkDateStatus(Map<Long, InitOutMessage> outMessageMap, Long midId) {
        if (CollectionUtils.isEmpty(outMessageMap)) {
            return true;
        }
        InitOutMessage msg = outMessageMap.get(midId);
        if (Objects.isNull(msg)) {
            return true;
        }
        return msg.getSuccess();
    }
}

