/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.common.util;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAdjuster;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class LocalDateRange
implements Serializable {
    private static final LocalDate MINP1 = LocalDate.MIN.plusDays(1L);
    private static final LocalDate MAXM1 = LocalDate.MAX.minusDays(1L);
    public static final LocalDateRange ALL = new LocalDateRange(LocalDate.MIN, LocalDate.MAX);
    private static final long serialVersionUID = 3358656715467L;
    private final LocalDate start;
    private final LocalDate end;

    public static LocalDateRange of(LocalDate startInclusive, LocalDate endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return new LocalDateRange(startInclusive, endExclusive);
    }

    public static LocalDateRange of(Date startInclusive, Date endExclusive) {
        LocalDate startInclusiveLocalDate = ZonedDateTime.ofInstant(startInclusive.toInstant(), ZoneId.systemDefault()).toLocalDate();
        LocalDate endExclusiveLocalDate = ZonedDateTime.ofInstant(endExclusive.toInstant(), ZoneId.systemDefault()).toLocalDate();
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        return new LocalDateRange(startInclusiveLocalDate, endExclusiveLocalDate);
    }

    public static LocalDateRange ofClosed(LocalDate startInclusive, LocalDate endInclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endInclusive, "endInclusive");
        if (endInclusive.isBefore(startInclusive)) {
            throw new DateTimeException("Start date must be on or before end date");
        }
        LocalDate end = endInclusive.equals(LocalDate.MAX) ? LocalDate.MAX : endInclusive.plusDays(1L);
        return new LocalDateRange(startInclusive, end);
    }

    public static LocalDateRange ofClosed(Date startInclusive, Date endInclusive) {
        LocalDate startInclusiveLocalDate = ZonedDateTime.ofInstant(startInclusive.toInstant(), ZoneId.systemDefault()).toLocalDate();
        LocalDate endInclusiveLocalDate = ZonedDateTime.ofInstant(endInclusive.toInstant(), ZoneId.systemDefault()).toLocalDate();
        Objects.requireNonNull(startInclusiveLocalDate, "startInclusive");
        Objects.requireNonNull(endInclusiveLocalDate, "endInclusive");
        if (endInclusiveLocalDate.isBefore(startInclusiveLocalDate)) {
            throw new DateTimeException("Start date must be on or before end date");
        }
        LocalDate end = endInclusiveLocalDate.equals(LocalDate.MAX) ? LocalDate.MAX : endInclusiveLocalDate.plusDays(1L);
        return new LocalDateRange(startInclusiveLocalDate, end);
    }

    public static LocalDateRange of(LocalDate startInclusive, Period period) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(period, "period");
        if (period.isNegative()) {
            throw new DateTimeException("Period must not be zero or negative");
        }
        return new LocalDateRange(startInclusive, startInclusive.plus(period));
    }

    public static LocalDateRange ofEmpty(LocalDate date) {
        Objects.requireNonNull(date, "date");
        return new LocalDateRange(date, date);
    }

    public static LocalDateRange ofUnbounded() {
        return ALL;
    }

    public static LocalDateRange ofUnboundedStart(LocalDate endExclusive) {
        return LocalDateRange.of(LocalDate.MIN, endExclusive);
    }

    public static LocalDateRange ofUnboundedEnd(LocalDate startInclusive) {
        return LocalDateRange.of(startInclusive, LocalDate.MAX);
    }

    public static LocalDateRange parse(CharSequence text) {
        Objects.requireNonNull(text, "text");
        for (int i = 0; i < text.length(); ++i) {
            char c;
            if (text.charAt(i) != '/') continue;
            char firstChar = text.charAt(0);
            if (firstChar == 'P' || firstChar == 'p') {
                Period duration = Period.parse(text.subSequence(0, i));
                LocalDate end = LocalDate.parse(text.subSequence(i + 1, text.length()));
                return LocalDateRange.of(end.minus(duration), end);
            }
            LocalDate start = LocalDate.parse(text.subSequence(0, i));
            if (i + 1 < text.length() && ((c = text.charAt(i + 1)) == 'P' || c == 'p')) {
                Period duration = Period.parse(text.subSequence(i + 1, text.length()));
                return LocalDateRange.of(start, start.plus(duration));
            }
            LocalDate end = LocalDate.parse(text.subSequence(i + 1, text.length()));
            return LocalDateRange.of(start, end);
        }
        throw new DateTimeParseException("LocalDateRange cannot be parsed, no forward slash found", text, 0);
    }

    private LocalDateRange(LocalDate startInclusive, LocalDate endExclusive) {
        if (endExclusive.isBefore(startInclusive)) {
            throw new DateTimeException("End date must be on or after start date");
        }
        if (startInclusive.equals(MAXM1)) {
            throw new DateTimeException("Range must not start at LocalDate.MAX.minusDays(1)");
        }
        if (endExclusive.equals(MINP1)) {
            throw new DateTimeException("Range must not end at LocalDate.MIN.plusDays(1)");
        }
        if (endExclusive.equals(LocalDate.MIN) || startInclusive.equals(LocalDate.MAX)) {
            throw new DateTimeException("Empty range must not be at LocalDate.MIN or LocalDate.MAX");
        }
        this.start = startInclusive;
        this.end = endExclusive;
    }

    public LocalDate getStart() {
        return this.start;
    }

    public LocalDate getEnd() {
        return this.end;
    }

    public LocalDate getEndInclusive() {
        if (this.isUnboundedEnd()) {
            return LocalDate.MAX;
        }
        return this.end.minusDays(1L);
    }

    public boolean isEmpty() {
        return this.start.equals(this.end);
    }

    public boolean isUnboundedStart() {
        return this.start.equals(LocalDate.MIN);
    }

    public boolean isUnboundedEnd() {
        return this.end.equals(LocalDate.MAX);
    }

    public LocalDateRange withStart(TemporalAdjuster adjuster) {
        return LocalDateRange.of(this.start.with(adjuster), this.end);
    }

    public LocalDateRange withEnd(TemporalAdjuster adjuster) {
        return LocalDateRange.of(this.start, this.end.with(adjuster));
    }

    public boolean contains(LocalDate date) {
        Objects.requireNonNull(date, "date");
        return this.start.compareTo(date) <= 0 && (date.compareTo(this.end) < 0 || this.isUnboundedEnd());
    }

    public boolean encloses(LocalDateRange other) {
        Objects.requireNonNull(other, "other");
        return this.start.compareTo(other.start) <= 0 && other.end.compareTo(this.end) <= 0;
    }

    public boolean abuts(LocalDateRange other) {
        Objects.requireNonNull(other, "other");
        return this.end.equals(other.start) ^ this.start.equals(other.end);
    }

    public boolean isConnected(LocalDateRange other) {
        Objects.requireNonNull(other, "other");
        return this.equals(other) || this.start.compareTo(other.end) <= 0 && other.start.compareTo(this.end) <= 0;
    }

    public boolean overlaps(LocalDateRange other) {
        Objects.requireNonNull(other, "other");
        return other.equals(this) || this.start.compareTo(other.end) < 0 && other.start.compareTo(this.end) < 0;
    }

    public LocalDateRange intersection(LocalDateRange other) {
        Objects.requireNonNull(other, "other");
        if (!this.isConnected(other)) {
            throw new DateTimeException("Ranges do not connect: " + this + " and " + other);
        }
        int cmpStart = this.start.compareTo(other.start);
        int cmpEnd = this.end.compareTo(other.end);
        if (cmpStart >= 0 && cmpEnd <= 0) {
            return this;
        }
        if (cmpStart <= 0 && cmpEnd >= 0) {
            return other;
        }
        LocalDate newStart = cmpStart >= 0 ? this.start : other.start;
        LocalDate newEnd = cmpEnd <= 0 ? this.end : other.end;
        return LocalDateRange.of(newStart, newEnd);
    }

    public LocalDateRange union(LocalDateRange other) {
        Objects.requireNonNull(other, "other");
        if (!this.isConnected(other)) {
            throw new DateTimeException("Ranges do not connect: " + this + " and " + other);
        }
        int cmpStart = this.start.compareTo(other.start);
        int cmpEnd = this.end.compareTo(other.end);
        if (cmpStart >= 0 && cmpEnd <= 0) {
            return other;
        }
        if (cmpStart <= 0 && cmpEnd >= 0) {
            return this;
        }
        LocalDate newStart = cmpStart >= 0 ? other.start : this.start;
        LocalDate newEnd = cmpEnd <= 0 ? other.end : this.end;
        return LocalDateRange.of(newStart, newEnd);
    }

    public LocalDateRange span(LocalDateRange other) {
        Objects.requireNonNull(other, "other");
        int cmpStart = this.start.compareTo(other.start);
        int cmpEnd = this.end.compareTo(other.end);
        LocalDate newStart = cmpStart >= 0 ? other.start : this.start;
        LocalDate newEnd = cmpEnd <= 0 ? other.end : this.end;
        return LocalDateRange.of(newStart, newEnd);
    }

    public List<LocalDateRange> subtract(LocalDateRange subtrahend) {
        return this.subtract(Collections.singletonList(subtrahend));
    }

    public List<LocalDateRange> subtract(List<LocalDateRange> subtrahendList) {
        ArrayList<LocalDateRange> result = new ArrayList<LocalDateRange>();
        if (this.isEmpty()) {
            return result;
        }
        List noEmptyAndOverLapSubtrahendList = subtrahendList.stream().filter(dateRange -> !dateRange.isEmpty()).filter(this::overlaps).collect(Collectors.toList());
        if (noEmptyAndOverLapSubtrahendList.isEmpty()) {
            result.add(this);
            return result;
        }
        boolean nonOverLap = noEmptyAndOverLapSubtrahendList.stream().noneMatch(this::overlaps);
        if (nonOverLap) {
            return result;
        }
        ArrayList<LocalDate> allLocalDateList = new ArrayList<LocalDate>((2 + noEmptyAndOverLapSubtrahendList.size()) * 2);
        allLocalDateList.add(this.getStart());
        allLocalDateList.add(this.getEnd());
        for (LocalDateRange subtrahend : noEmptyAndOverLapSubtrahendList) {
            allLocalDateList.add(subtrahend.getStart());
            allLocalDateList.add(subtrahend.getEnd());
        }
        List sortedDistinctLocalDateList = allLocalDateList.stream().distinct().sorted().collect(Collectors.toList());
        block1: for (int i = 1; i < sortedDistinctLocalDateList.size(); ++i) {
            LocalDateRange newDateRange = LocalDateRange.of((LocalDate)sortedDistinctLocalDateList.get(i - 1), (LocalDate)sortedDistinctLocalDateList.get(i));
            if (!this.encloses(newDateRange)) continue;
            for (LocalDateRange subtrahend : noEmptyAndOverLapSubtrahendList) {
                if (!subtrahend.encloses(newDateRange)) continue;
                continue block1;
            }
            result.add(newDateRange);
        }
        if (result.size() <= 1) {
            return result;
        }
        ArrayList<LocalDateRange> resultAfterCombine = new ArrayList<LocalDateRange>();
        resultAfterCombine.add((LocalDateRange)result.get(0));
        for (int i = 1; i < result.size(); ++i) {
            LocalDateRange after;
            LocalDateRange before = (LocalDateRange)resultAfterCombine.get(resultAfterCombine.size() - 1);
            if (before.isConnected(after = (LocalDateRange)result.get(i))) {
                resultAfterCombine.set(resultAfterCombine.size() - 1, before.withEnd(after.getEnd()));
                continue;
            }
            resultAfterCombine.add(after);
        }
        return resultAfterCombine;
    }

    public Stream<LocalDate> stream() {
        long count = this.end.toEpochDay() - this.start.toEpochDay() + (long)(this.isUnboundedEnd() ? 1 : 0);
        Spliterators.AbstractSpliterator<LocalDate> spliterator = new Spliterators.AbstractSpliterator<LocalDate>(count, 17749){
            private LocalDate current;
            {
                this.current = LocalDateRange.this.start;
            }

            @Override
            public boolean tryAdvance(Consumer<? super LocalDate> action) {
                if (this.current != null) {
                    if (this.current.isBefore(LocalDateRange.this.end)) {
                        action.accept(this.current);
                        this.current = this.current.plusDays(1L);
                        return true;
                    }
                    if (this.current.equals(LocalDate.MAX)) {
                        action.accept(LocalDate.MAX);
                        this.current = null;
                        return true;
                    }
                }
                return false;
            }

            @Override
            public Comparator<? super LocalDate> getComparator() {
                return null;
            }
        };
        return StreamSupport.stream(spliterator, false);
    }

    public boolean isAfter(LocalDate date) {
        return this.start.compareTo(date) > 0;
    }

    public boolean isBefore(LocalDate date) {
        return this.end.compareTo(date) <= 0 && this.start.compareTo(date) < 0;
    }

    public boolean isAfter(LocalDateRange other) {
        return this.start.compareTo(other.end) >= 0 && !other.equals(this);
    }

    public boolean isBefore(LocalDateRange range) {
        return this.end.compareTo(range.start) <= 0 && !range.equals(this);
    }

    public int lengthInDays() {
        if (this.isUnboundedStart() || this.isUnboundedEnd()) {
            return Integer.MAX_VALUE;
        }
        long length = this.end.toEpochDay() - this.start.toEpochDay();
        return length > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)length;
    }

    public Period toPeriod() {
        if (this.isUnboundedStart() || this.isUnboundedEnd()) {
            throw new ArithmeticException("Unbounded range cannot be converted to a Period");
        }
        return Period.between(this.start, this.end);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LocalDateRange) {
            LocalDateRange other = (LocalDateRange)obj;
            return this.start.equals(other.start) && this.end.equals(other.end);
        }
        return false;
    }

    public int hashCode() {
        return this.start.hashCode() ^ this.end.hashCode();
    }

    public String toString() {
        return this.start.toString() + '/' + this.end.toString();
    }
}

