/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class PersonGenericUtil {
    private static String YYYY_MM_DD = "yyyy-MM-dd";
    private static String SUFFIX_ZERO_TIME = " 00:00:00";
    private static final Log LOGGER = LogFactory.getLog(PersonGenericUtil.class);

    public static long dateDiff(Date date1, Date date2) {
        if (null == date1 || null == date2) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u6bd4\u8f83\u5f02\u5e38,\u5b58\u5728\u7a7a\u503c\u3002", (String)"PersonGenericUtil_0", (String)"hrmp-hrpi-common", (Object[])new Object[0]));
        }
        SimpleDateFormat df = new SimpleDateFormat(YYYY_MM_DD);
        try {
            long time1 = df.parse(df.format(date1)).getTime();
            long time2 = df.parse(df.format(date2)).getTime();
            return time1 - time2;
        }
        catch (ParseException ex) {
            LOGGER.error("PersonGenericUtil ==> dateDiff exception :{}");
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PersonGenericUtil_1", (String)"hrmp-hrpi-common", (Object[])new Object[0]));
        }
    }

    public static Date getMidnight(Date date) {
        if (date == null) {
            return null;
        }
        String dateStr = HRDateTimeUtils.format((Date)date, (String)YYYY_MM_DD);
        try {
            return HRDateTimeUtils.parseDate((String)(dateStr + SUFFIX_ZERO_TIME));
        }
        catch (ParseException parseException) {
            LOGGER.error("parse date error!", (Throwable)parseException);
            return null;
        }
    }
}

