/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.opplugin.web;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hrmp.hrpi.business.application.charge.IChargeApplication;
import kd.hrmp.hrpi.business.application.impl.charge.ChargeApplicationImpl;
import kd.hrmp.hrpi.business.application.impl.charge.ChargePersonParam;
import kd.hrmp.hrpi.business.domian.repository.HRPIChargePersonRepository;
import kd.hrmp.hrpi.business.domian.service.HRPIServiceFactory;
import kd.hrmp.hrpi.business.domian.service.ISynChargeToUserService;
import kd.hrmp.hrpi.business.helper.ChargePersonHelper;
import kd.hrmp.hrpi.common.HRPIChargePersonConstants;
import kd.hrmp.hrpi.common.enums.ChangeSourceEnum;
import kd.hrmp.hrpi.common.model.charge.SynChargeToUserModel;

public class ChargePersonRemoveOp
extends HRDataBaseOp
implements HRPIChargePersonConstants {
    private final IChargeApplication chargeApplication = new ChargeApplicationImpl();
    private final ISynChargeToUserService synChargeToUserService = HRPIServiceFactory.synChargeToUserService;
    private List<DynamicObject> chargePersonList;

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject chargeDy = e.getDataEntities()[0];
        DynamicObjectCollection depEmpCol = chargeDy.getDynamicObjectCollection("mulperson");
        Set depEmpSet = depEmpCol.stream().map(person -> person.getLong("fbasedataid.id")).collect(Collectors.toSet());
        long adminOrgId = chargeDy.getLong("adminorg.id");
        DynamicObject[] chargePersons = HRPIChargePersonRepository.getInstance().loadEffByDepEmp(depEmpSet, adminOrgId);
        OperateOption option = this.getOption();
        List propertyList = null;
        if (option.containsVariable("removeSaveField")) {
            String saveFieldStr = option.getVariableValue("removeSaveField");
            propertyList = JSON.parseArray((String)saveFieldStr, String.class);
        }
        Date lEffectDate = chargeDy.getDate("leffdt");
        String explain = chargeDy.getString("explain");
        for (DynamicObject chargePerson2 : chargePersons) {
            chargePerson2.set("leffdt", (Object)lEffectDate);
            chargePerson2.set("explain", (Object)explain);
            if (propertyList == null || propertyList.size() <= 0) continue;
            propertyList.forEach(property -> chargePerson2.set(property, chargeDy.get(property)));
        }
        this.chargePersonList = Arrays.asList(chargePersons);
        List innerChargePersonList = this.chargePersonList.stream().filter(chargePerson -> {
            DynamicObject depEmpInfo = chargePerson.getDynamicObject("chargeperson");
            long depempAdminOrgId = depEmpInfo.getLong("adminorg.id");
            return adminOrgId == depempAdminOrgId;
        }).collect(Collectors.toList());
        List outerChargePersonList = this.chargePersonList.stream().filter(chargePerson -> {
            DynamicObject depEmpInfo = chargePerson.getDynamicObject("chargeperson");
            long depempAdminOrgId = depEmpInfo.getLong("adminorg.id");
            return adminOrgId != depempAdminOrgId;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(innerChargePersonList)) {
            this.chargeApplication.removeChargePerson(new ChargePersonParam(innerChargePersonList, ChangeSourceEnum.MANUAL_ENTRY, true));
        }
        if (CollectionUtils.isNotEmpty(outerChargePersonList)) {
            this.chargeApplication.removeChargePerson(new ChargePersonParam(outerChargePersonList, ChangeSourceEnum.MANUAL_ENTRY, false));
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        if (CollectionUtils.isNotEmpty(this.chargePersonList)) {
            SynChargeToUserModel synChargeToUserModel = new SynChargeToUserModel();
            synChargeToUserModel.setChargePersonList(ChargePersonHelper.filterChargePersonList(this.chargePersonList));
            this.synChargeToUserService.removeCharge(synChargeToUserModel);
        }
    }
}

