/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.opplugin.web;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hrmp.hrpi.business.application.charge.IChargeApplication;
import kd.hrmp.hrpi.business.application.impl.charge.ChargeApplicationImpl;
import kd.hrmp.hrpi.business.application.impl.charge.ChargePersonParam;
import kd.hrmp.hrpi.business.domian.repository.HRPIChargePersonRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIPersonRepository;
import kd.hrmp.hrpi.business.domian.service.HRPIServiceFactory;
import kd.hrmp.hrpi.business.domian.service.ISynChargeToUserService;
import kd.hrmp.hrpi.business.helper.ChargePersonHelper;
import kd.hrmp.hrpi.common.HRPIChargePersonConstants;
import kd.hrmp.hrpi.common.enums.ChangeSourceEnum;
import kd.hrmp.hrpi.common.model.charge.SynChargeToUserModel;
import kd.hrmp.hrpi.opplugin.web.validator.ChargePersonValidator;
import kd.hrmp.hrpi.opplugin.web.validator.ImportChargePersonValidator;

public class ChargePersonSaveOp
extends HRDataBaseOp
implements HRPIChargePersonConstants {
    private final IChargeApplication chargeApplication = new ChargeApplicationImpl();
    private final ISynChargeToUserService synChargeToUserService = HRPIServiceFactory.synChargeToUserService;
    private List<DynamicObject> chargePersonList;

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        if (this.isImport()) {
            e.addValidator((AbstractValidator)new ImportChargePersonValidator());
            this.getOption().setVariableValue("currbizappid", "homs");
            this.getOption().setVariableValue("skipCheckDataPermission", "true");
        }
        e.addValidator((AbstractValidator)new ChargePersonValidator());
    }

    private boolean isImport() {
        return !HRStringUtils.isEmpty((String)((String)this.getOption().getVariables().get("importtype")));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operationKey = args.getOperationKey();
        args.setCancelOperation(true);
        DynamicObject[] dataEntities = args.getDataEntities();
        if ("donothing_savenew".equals(operationKey)) {
            this.chargePersonList = Lists.newArrayListWithExpectedSize((int)16);
            DynamicObject dynamicObject = dataEntities[0];
            long adminOrgId = dynamicObject.getLong("adminorg.id");
            DynamicObjectCollection depEmpInfos = dynamicObject.getDynamicObjectCollection("mulperson");
            Set personIds = depEmpInfos.stream().map(depEmpInfo -> depEmpInfo.getLong("fbasedataid.person.id")).collect(Collectors.toSet());
            Set adminOrgIds = depEmpInfos.stream().map(depEmpInfo -> depEmpInfo.getLong("fbasedataid.adminorg.id")).collect(Collectors.toSet());
            DynamicObject[] perNonTsPropArr = HRPIPersonRepository.listPernontsprops(new ArrayList(personIds));
            Map<Long, DynamicObject> perNonTsPropInfoMap = Arrays.stream(perNonTsPropArr).collect(Collectors.toMap(perNonTsProp -> perNonTsProp.getLong("person.id"), perNonTsProp -> perNonTsProp, (o1, o2) -> o1));
            depEmpInfos.forEach(depEmpInfo -> {
                DynamicObject chargePerson = new DynamicObject(dynamicObject.getDynamicObjectType());
                HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)chargePerson);
                chargePerson.set("chargeperson", depEmpInfo.get("fbasedataid"));
                DynamicObject perNonProp = (DynamicObject)perNonTsPropInfoMap.get(depEmpInfo.getLong("fbasedataid.person.id"));
                chargePerson.set("pernontsprop", (Object)perNonProp);
                chargePerson.set("leffdt", (Object)HRBaseUtils.getMaxEndDate());
                this.chargePersonList.add(chargePerson);
            });
            if (adminOrgIds.contains(adminOrgId)) {
                if (adminOrgIds.size() == 1) {
                    this.chargeApplication.addChargePerson(new ChargePersonParam(this.chargePersonList, ChangeSourceEnum.MANUAL_ENTRY, true));
                } else {
                    this.chargeApplication.addChargePerson(new ChargePersonParam(this.chargePersonList, ChangeSourceEnum.MANUAL_ENTRY, false));
                }
            } else {
                DynamicObject[] chargePersonInfoArr = HRPIChargePersonRepository.getInstance().queryEffChargeByOrgId("chargeperson", Collections.singletonList(adminOrgId), new Date());
                if (depEmpInfos.size() + chargePersonInfoArr.length > 1 || ChargePersonHelper.getCurrentOrgMainDutyPosition((long)adminOrgId)) {
                    this.chargeApplication.addChargePerson(new ChargePersonParam(this.chargePersonList, ChangeSourceEnum.MANUAL_ENTRY, false));
                } else {
                    this.chargeApplication.addChargePerson(new ChargePersonParam(this.chargePersonList, ChangeSourceEnum.MANUAL_ENTRY, true));
                }
            }
        } else if (this.isImport()) {
            this.importData(dataEntities);
        } else if ("save".equals(operationKey)) {
            this.chargeApplication.modifyChargePerson(dataEntities[0], ChangeSourceEnum.MANUAL_ENTRY);
        }
    }

    private void importData(DynamicObject[] dataEntities) {
        this.chargePersonList = Lists.newArrayList((Object[])dataEntities);
        Set personIds = this.chargePersonList.stream().map(chargePerson -> chargePerson.getLong("person.id")).collect(Collectors.toSet());
        DynamicObject[] perNonTsPropArr = HRPIPersonRepository.listPernontsprops(new ArrayList(personIds));
        Map<Long, DynamicObject> perNonTsPropInfoMap = Arrays.stream(perNonTsPropArr).collect(Collectors.toMap(perNonTsProp -> perNonTsProp.getLong("person.id"), perNonTsProp -> perNonTsProp, (o1, o2) -> o1));
        this.chargePersonList.forEach(chargePerson -> {
            DynamicObject perNonProp = (DynamicObject)perNonTsPropInfoMap.get(chargePerson.getLong("person.id"));
            chargePerson.set("pernontsprop", (Object)perNonProp);
        });
        long adminOrgId = this.chargePersonList.stream().map(chargePerson -> chargePerson.getLong("adminorg.id")).findFirst().get();
        Set adminOrgIds = this.chargePersonList.stream().map(chargePerson -> chargePerson.getDynamicObject("chargeperson").getLong("adminorg.id")).collect(Collectors.toSet());
        if (adminOrgIds.contains(adminOrgId)) {
            if (adminOrgIds.size() == 1) {
                this.chargeApplication.addChargePerson(new ChargePersonParam(this.chargePersonList, ChangeSourceEnum.MANUAL_ENTRY, true, false));
            } else {
                this.chargeApplication.addChargePerson(new ChargePersonParam(this.chargePersonList, ChangeSourceEnum.MANUAL_ENTRY, false, false));
            }
        } else {
            DynamicObject[] chargePersonInfoArr = HRPIChargePersonRepository.getInstance().queryEffChargeByOrgId("chargeperson", Collections.singletonList(adminOrgId), new Date());
            if (this.chargePersonList.size() + chargePersonInfoArr.length > 1 || ChargePersonHelper.getCurrentOrgMainDutyPosition((long)adminOrgId)) {
                this.chargeApplication.addChargePerson(new ChargePersonParam(this.chargePersonList, ChangeSourceEnum.MANUAL_ENTRY, false, false));
            } else {
                this.chargeApplication.addChargePerson(new ChargePersonParam(this.chargePersonList, ChangeSourceEnum.MANUAL_ENTRY, true, false));
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        if (CollectionUtils.isNotEmpty(this.chargePersonList)) {
            SynChargeToUserModel synChargeToUserModel = new SynChargeToUserModel();
            synChargeToUserModel.setChargePersonList(ChargePersonHelper.filterChargePersonList(this.chargePersonList));
            this.synChargeToUserService.addCharge(synChargeToUserModel);
        }
    }
}

