/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.opplugin.web.validator;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.DatePattern;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIChargePersonRepository;
import kd.hrmp.hrpi.business.helper.SystemParamHelper;
import kd.hrmp.hrpi.common.HRPIChargePersonConstants;

public class ChargePersonValidator
extends AbstractValidator
implements HRPIChargePersonConstants {
    private HRPIChargePersonRepository chargePersonRepository = HRPIChargePersonRepository.getInstance();
    private static final Log LOGGER = LogFactory.getLog(ChargePersonValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashSet depEmpIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet adminOrgIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet ids = Sets.newHashSetWithExpectedSize((int)16);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            long id;
            DynamicObject chargePersonDyn = dataEntity.getDataEntity();
            adminOrgIds.add(chargePersonDyn.getLong("adminorg.id"));
            DynamicObjectCollection mulPersons = chargePersonDyn.getDynamicObjectCollection("mulperson");
            if (!CollectionUtils.isEmpty((Collection)mulPersons)) {
                depEmpIds.addAll(mulPersons.stream().map(person -> person.getLong("fbasedataid.id")).collect(Collectors.toSet()));
            }
            if ((id = chargePersonDyn.getLong("id")) == 0L) continue;
            ids.add(id);
        }
        String selectField = "chargeperson, effdt, leffdt, datastatus";
        QFilter filter = null;
        if (!CollectionUtils.isEmpty((Collection)ids)) {
            filter = new QFilter("id", "not in", (Object)ids);
        }
        DynamicObject[] chargePersonInfoArr = this.chargePersonRepository.queryChargeByDepEmpAndAdminOrg(selectField, (Set)depEmpIds, (Set)adminOrgIds, filter);
        Map<Long, List<DynamicObject>> depEmpGroupMap = Arrays.stream(chargePersonInfoArr).collect(Collectors.groupingBy(chargePerson -> chargePerson.getLong("chargeperson.id")));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            this.checkEffDate(dataEntity);
            this.checkVersionInfo(dataEntity, depEmpGroupMap);
            this.checkOutChargePerson(dataEntity);
        }
        this.wrapErrorMsg();
    }

    private void checkOutChargePerson(ExtendedDataEntity dataEntity) {
        DynamicObject chargePersonDyn = dataEntity.getDataEntity();
        long adminOrgId = chargePersonDyn.getLong("adminorg.id");
        DynamicObjectCollection depEmpInfos = chargePersonDyn.getDynamicObjectCollection("mulperson");
        List outerChargePersonList = depEmpInfos.stream().filter(depEmpInfo -> {
            long depempAdminOrgId = depEmpInfo.getLong("fbasedataid.adminorg.id");
            return adminOrgId != depempAdminOrgId;
        }).collect(Collectors.toList());
        long orgId = chargePersonDyn.getLong("adminorg.org.id");
        boolean chooseChargePersonParameter = SystemParamHelper.getChooseChargePersonParameter((Long)orgId);
        LOGGER.info("checkOutChargePerson#adminOrgId={},outerChargePersonList.size={},chooseChargePersonParameter={}", new Object[]{adminOrgId, outerChargePersonList.size(), chooseChargePersonParameter});
        if (!CollectionUtils.isEmpty(outerChargePersonList) && !chooseChargePersonParameter) {
            for (DynamicObject dy : outerChargePersonList) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4eba\u5458[%1$s/%2$s]\u6ca1\u6709\u4efb\u804c\u5728\u884c\u653f\u7ec4\u7ec7[%3$s]\u4e0a\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u4e3a\u8be5\u7ec4\u7ec7\u7684\u90e8\u95e8\u8d1f\u8d23\u4eba;", (String)"ImportChargePersonValidator_0", (String)"hrmp-hrpi-opplugin", (Object[])new Object[]{dy.getString("fbasedataid.person.number"), dy.getString("fbasedataid.person.name"), chargePersonDyn.getString("adminorg.name")}));
            }
        }
    }

    private void wrapErrorMsg() {
        if (HRStringUtils.isEmpty((String)((String)this.getOption().getVariables().get("importtype")))) {
            return;
        }
        ValidateResult result = this.getValidateResult();
        if (result == null) {
            return;
        }
        List errorInfoList = result.getAllErrorInfo();
        if (CollectionUtils.isEmpty((Collection)errorInfoList)) {
            return;
        }
        String separator = ResManager.loadKDString((String)";", (String)"ChargePersonValidator_10", (String)"hrmp-hrpi-opplugin", (Object[])new Object[0]);
        errorInfoList.forEach(info -> info.setMessage(info.getMessage() + separator));
    }

    private void checkEffDate(ExtendedDataEntity dataEntity) {
        Date establishmentDate;
        DynamicObject chargePersonDyn = dataEntity.getDataEntity();
        Date effDt = chargePersonDyn.getDate("effdt");
        if (effDt.before(establishmentDate = chargePersonDyn.getDate("adminorg.establishmentdate"))) {
            this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u884c\u653f\u7ec4\u7ec7\u7684\u6210\u7acb\u65e5\u671f\u201c%1$s\u201d\u3002", (String)"ChargePersonValidator_0", (String)"hrmp-hrpi-opplugin", (Object[])new Object[0]), HRDateTimeUtils.format((Date)establishmentDate, (String)DatePattern.YYYY_MM_DD.getValue())));
        }
        DynamicObjectCollection mulPersons = chargePersonDyn.getDynamicObjectCollection("mulperson");
        mulPersons.forEach(person -> {
            Date startDate = person.getDate("fbasedataid.startdate");
            if (effDt.before(startDate)) {
                this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u201c%1$s\u201d\u5f53\u524d\u4efb\u804c\u7684\u5f00\u59cb\u65e5\u671f\u201c%2$s\u201d\u3002", (String)"ChargePersonValidator_1", (String)"hrmp-hrpi-opplugin", (Object[])new Object[0]), person.getString("fbasedataid.person.name"), HRDateTimeUtils.format((Date)startDate, (String)DatePattern.YYYY_MM_DD.getValue())));
            }
        });
    }

    private void checkVersionInfo(ExtendedDataEntity dataEntity, Map<Long, List<DynamicObject>> depEmpGroupMap) {
        DynamicObject chargePersonDyn = dataEntity.getDataEntity();
        Date currentEffDt = chargePersonDyn.getDate("effdt");
        Date lEffDate = chargePersonDyn.getDate("leffdt");
        DynamicObjectCollection depEmpInfos = chargePersonDyn.getDynamicObjectCollection("mulperson");
        for (DynamicObject depEmpInfo : depEmpInfos) {
            List<DynamicObject> chargePersonInfos = depEmpGroupMap.get(depEmpInfo.getLong("fbasedataid.id"));
            if (CollectionUtils.isEmpty(chargePersonInfos)) continue;
            chargePersonInfos.stream().filter(chargePerson -> this.overlaps((DynamicObject)chargePerson, currentEffDt, lEffDate)).forEach(chargePerson -> {
                String dataStatus = chargePerson.getString("datastatus");
                String personName = chargePerson.getString("chargeperson.person.name");
                if ("1".equals(dataStatus)) {
                    this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u5df2\u4e3a\u8be5\u90e8\u95e8\u8d1f\u8d23\u4eba\uff0c\u65e0\u9700\u91cd\u590d\u6dfb\u52a0\u3002", (String)"ChargePersonValidator_2", (String)"hrmp-hrpi-opplugin", (Object[])new Object[0]), personName));
                } else {
                    String effDt = HRDateTimeUtils.format((Date)(currentEffDt.compareTo(chargePerson.getDate("effdt")) > 0 ? currentEffDt : chargePerson.getDate("effdt")), (String)"yyyy-MM-dd");
                    String lEffDt = HRDateTimeUtils.format((Date)chargePerson.getDate("leffdt"), (String)"yyyy-MM-dd");
                    this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u5728[%2$s\uff0c%3$s]\u671f\u95f4\u5df2\u4e3a\u8be5\u90e8\u95e8\u8d1f\u8d23\u4eba\uff0c\u65e0\u9700\u91cd\u590d\u6dfb\u52a0\u3002", (String)"ChargePersonValidator_3", (String)"hrmp-hrpi-opplugin", (Object[])new Object[0]), personName, effDt, lEffDt));
                }
            });
        }
    }

    private boolean overlaps(DynamicObject dy, Date startDate, Date endDate) {
        return startDate.compareTo(dy.getDate("leffdt")) < 0 && dy.getDate("effdt").compareTo(endDate) < 0;
    }
}

