/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.opplugin.web.validator;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIDepempRepository;
import kd.hrmp.hrpi.business.helper.SystemParamHelper;

public class ImportChargePersonValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(ImportChargePersonValidator.class);
    private Map<String, List<DynamicObject>> chargePersonMap;
    private HasPermOrgResult hrPermOrg;
    private AuthorizedOrgResult permResult;

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        this.initData(dataEntities);
        Date currentDate = HRDateTimeUtils.truncateDate((Date)new Date());
        LinkedHashSet repeatSet = Sets.newLinkedHashSetWithExpectedSize((int)dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dy = dataEntity.getDataEntity();
            dy.set("leffdt", (Object)HRBaseUtils.getMaxEndDate());
            this.checkPermOrg(dataEntity);
            List<DynamicObject> list = this.chargePersonMap.get(dy.getString("adminorg.id") + "_" + dy.getString("person.number"));
            this.filter(list, dataEntity);
            if (currentDate.compareTo(dy.getDate("effdt")) < 0) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u5f53\u524d\u65e5\u671f;", (String)"ImportChargePersonValidator_5", (String)"hrmp-hrpi-opplugin", (Object[])new Object[0]));
            }
            if (HRStringUtils.isEmpty((String)dy.getString("adminorg.id")) || HRStringUtils.isEmpty((String)dy.getString("chargeperson.id")) || repeatSet.add(dy.getString("adminorg.id") + "_" + dy.getString("chargeperson.id"))) continue;
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u3001\u8d1f\u8d23\u4eba\u7684\u7ec4\u5408\u503c\u91cd\u590d\uff0c\u8bf7\u81f3\u5c11\u4fee\u6539\u4e00\u9879\uff1b", (String)"ImportChargePersonValidator_4", (String)"hrmp-hrpi-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkPermOrg(ExtendedDataEntity dataEntity) {
        if (this.hrPermOrg.hasAllOrgPerm() && this.permResult.isHasAllOrgPerm()) {
            return;
        }
        Long orgId = dataEntity.getDataEntity().getLong("adminorg.id");
        Long org = dataEntity.getDataEntity().getLong("adminorg.org.id");
        boolean flag = true;
        if (!this.hrPermOrg.hasAllOrgPerm() && !this.hrPermOrg.getHasPermOrgs().contains(org)) {
            flag = false;
        }
        if (flag && !this.permResult.isHasAllOrgPerm() && !this.permResult.getHasPermOrgs().contains(orgId)) {
            flag = false;
        }
        if (!flag) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\uff0c\u8bf7\u4fee\u6539;", (String)"ImportChargePersonValidator_1", (String)"hrmp-hrpi-opplugin", (Object[])new Object[0]));
        }
    }

    private void filter(List<DynamicObject> list, ExtendedDataEntity dataEntity) {
        DynamicObject dy = dataEntity.getDataEntity();
        long orgId = dy.getLong("adminorg.org.id");
        boolean chooseChargePersonParameter = SystemParamHelper.getChooseChargePersonParameter((Long)orgId);
        if (CollectionUtils.isEmpty(list)) {
            if (!chooseChargePersonParameter) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4eba\u5458[%1$s/%2$s]\u6ca1\u6709\u4efb\u804c\u5728\u884c\u653f\u7ec4\u7ec7[%3$s]\u4e0a\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u4e3a\u8be5\u7ec4\u7ec7\u7684\u90e8\u95e8\u8d1f\u8d23\u4eba;", (String)"ImportChargePersonValidator_0", (String)"hrmp-hrpi-opplugin", (Object[])new Object[]{dy.getString("person.number"), dy.getString("person.name"), dy.getString("adminorg.name")}));
                return;
            }
            String personNumber = dy.getString("person.number");
            Object[] depempDys = HRPIDepempRepository.queryDepempByPersonNumber(Collections.singleton(personNumber));
            LOGGER.info("1##personNumber={},depempDys.size={}", (Object)personNumber, (Object)depempDys.length);
            if (HRArrayUtils.isNotEmpty((Object[])depempDys) && depempDys.length == 1) {
                long org;
                long adminorgId = depempDys[0].getLong("adminorg.id");
                if (!this.checkDepEmpPermOrg(dataEntity, adminorgId, org = depempDys[0].getLong("adminorg.org.id"))) {
                    this.setValue(dy, Arrays.asList(depempDys));
                }
                return;
            }
            Map<String, Object> map = this.getPositionIds(dy);
            List idList = (List)map.get("id");
            if (idList.size() > 1) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u4e14\u53ea\u9700\u586b\u5199\u5458\u5de5\u4efb\u5c97\u5c97\u4f4d/\u6807\u51c6\u5c97\u4f4d/\u804c\u4f4d\u4e2d\u7684\u4e00\u4e2a;", (String)"ImportChargePersonValidator_2", (String)"hrmp-hrpi-opplugin", (Object[])new Object[0]));
                return;
            }
            list = Arrays.asList(depempDys);
            list = this.filterEmpDept(list, dy.getLong("position.id"), "position.id");
            list = this.filterEmpDept(list, dy.getLong("stdposition.id"), "stdposition.id");
            list = this.filterEmpDept(list, dy.getLong("job.id"), "stdposition.job.id");
            if ((list = this.filterEmpDept(list, dy.getLong("depadminorg.id"), "adminorg.id")).size() != 1) {
                if (idList.size() == 0) {
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4eba\u5458[%1$s/%2$s]\u6709\u591a\u4e2a\u4efb\u804c\uff0c\u8bf7\u586b\u5199\u5176\u4efb\u804c\u90e8\u95e8\u4ee5\u53ca\u4efb\u5c97\u5c97\u4f4d/\u6807\u51c6\u5c97\u4f4d/\u804c\u4f4d;", (String)"ImportChargePersonValidator_7", (String)"hrmp-hrpi-opplugin", (Object[])new Object[]{dy.getString("person.number"), dy.getString("person.name")}));
                } else {
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4eba\u5458[%1$s/%2$s]\u672a\u5728\u90e8\u95e8[%3$s]\u4efb\u5c97[%4$s]\uff0c\u8bf7\u91cd\u65b0\u586b\u5199;", (String)"ImportChargePersonValidator_8", (String)"hrmp-hrpi-opplugin", (Object[])new Object[]{dy.getString("person.number"), dy.getString("person.name"), dy.getString("adminorg.name"), dy.getString(map.get("name") + "." + "name")}));
                }
                return;
            }
            LOGGER.info("2##personId={},list.size={}", (Object)personNumber, (Object)list.size());
            long adminorgId = ((DynamicObject)list.get(0)).getLong("adminorg.id");
            long org = ((DynamicObject)list.get(0)).getLong("adminorg.org.id");
            if (!this.checkDepEmpPermOrg(dataEntity, adminorgId, org)) {
                this.setValue(dy, list);
            }
        } else {
            LOGGER.info("3##list.size={}", (Object)list.size());
            if (list.size() == 1) {
                long org;
                long adminorgId = list.get(0).getLong("adminorg.id");
                if (!this.checkDepEmpPermOrg(dataEntity, adminorgId, org = list.get(0).getLong("adminorg.org.id"))) {
                    this.setValue(dy, list);
                }
                return;
            }
            Map<String, Object> map = this.getPositionIds(dy);
            List idList = (List)map.get("id");
            if (idList.size() > 1) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u4e14\u53ea\u9700\u586b\u5199\u5458\u5de5\u4efb\u5c97\u5c97\u4f4d/\u6807\u51c6\u5c97\u4f4d/\u804c\u4f4d\u4e2d\u7684\u4e00\u4e2a;", (String)"ImportChargePersonValidator_2", (String)"hrmp-hrpi-opplugin", (Object[])new Object[0]));
                return;
            }
            list = this.filterEmpDept(list, dy.getLong("position.id"), "position.id");
            list = this.filterEmpDept(list, dy.getLong("stdposition.id"), "stdposition.id");
            if ((list = this.filterEmpDept(list, dy.getLong("job.id"), "stdposition.job.id")).size() != 1) {
                if (idList.size() == 0) {
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4eba\u5458[%1$s/%2$s]\u5728\u672c\u90e8\u95e8\u6709\u591a\u4e2a\u4efb\u804c\uff0c\u8bf7\u586b\u5199\u5176\u4efb\u5c97\u5c97\u4f4d/\u6807\u51c6\u5c97\u4f4d/\u804c\u4f4d;", (String)"ImportChargePersonValidator_3", (String)"hrmp-hrpi-opplugin", (Object[])new Object[]{dy.getString("person.number"), dy.getString("person.name")}));
                } else {
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4eba\u5458[%1$s/%2$s]\u672a\u5728\u672c\u90e8\u95e8\u4efb\u5c97[%3$s]\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u4efb\u5c97\u5c97\u4f4d/\u6807\u51c6\u5c97\u4f4d/\u804c\u4f4d;", (String)"ImportChargePersonValidator_6", (String)"hrmp-hrpi-opplugin", (Object[])new Object[]{dy.getString("person.number"), dy.getString("person.name"), dy.getString(map.get("name") + "." + "name")}));
                }
                return;
            }
            this.setValue(dy, list);
        }
    }

    private void setValue(DynamicObject dy, List<DynamicObject> list) {
        dy.set("chargeperson", (Object)list.get(0));
        DynamicObjectCollection collection = dy.getDynamicObjectCollection("mulperson");
        DynamicObject changeOperateObj = new DynamicObject(collection.getDynamicObjectType());
        changeOperateObj.set("fbasedataid", (Object)list.get(0));
        collection.add((Object)changeOperateObj);
    }

    private List<DynamicObject> filterEmpDept(List<DynamicObject> list, long id, String propertyName) {
        if (id != 0L) {
            list = list.stream().filter(deptEmpDy -> deptEmpDy.getLong(propertyName) == id).collect(Collectors.toList());
        }
        return list;
    }

    private Map<String, Object> getPositionIds(DynamicObject dy) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        ArrayList idList = Lists.newArrayListWithCapacity((int)3);
        long id = dy.getLong("position.id");
        map.put("id", idList);
        String property = null;
        if (id != 0L) {
            idList.add(id);
            property = "position";
        }
        if ((id = dy.getLong("stdposition.id")) != 0L) {
            idList.add(id);
            property = "stdposition";
        }
        if ((id = dy.getLong("job.id")) != 0L) {
            idList.add(id);
            property = "job";
        }
        map.put("name", property);
        return map;
    }

    private void initData(ExtendedDataEntity[] dataEntities) {
        HashSet orgIdSet = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        HashSet personNumberSet = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dy = dataEntity.getDataEntity();
            orgIdSet.add(dy.getLong("adminorg.id"));
            personNumberSet.add(dy.getString("person.number"));
        }
        DynamicObject[] chargePersonDys = HRPIDepempRepository.queryByOrgAndPersonNumber((Set)orgIdSet, (Set)personNumberSet);
        this.chargePersonMap = Arrays.stream(chargePersonDys).collect(Collectors.groupingBy(chargePersonDy -> chargePersonDy.getString("adminorg.id") + "_" + chargePersonDy.getString("person.number")));
        this.hrPermOrg = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"21", (String)"homs", (String)"homs_adminorgdetail", (String)"47150e89000000ac", (boolean)false);
        this.permResult = (AuthorizedOrgResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedAdminOrgSet", (Object[])new Object[]{RequestContext.get().getCurrUserId(), "homs", "homs_adminorgdetail", "47150e89000000ac", "boid"});
    }

    private boolean checkDepEmpPermOrg(ExtendedDataEntity dataEntity, long adminorgId, long orgId) {
        DynamicObject dy = dataEntity.getDataEntity();
        if (this.hrPermOrg.hasAllOrgPerm() && this.permResult.isHasAllOrgPerm()) {
            return false;
        }
        boolean flag = true;
        if (!this.hrPermOrg.hasAllOrgPerm() && !this.hrPermOrg.getHasPermOrgs().contains(orgId)) {
            flag = false;
        }
        if (flag && !this.permResult.isHasAllOrgPerm() && !this.permResult.getHasPermOrgs().contains(adminorgId)) {
            flag = false;
        }
        if (!flag) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4eba\u5458\u201c{0}/{1}\u201d\u4efb\u804c\u90e8\u95e8\u4e0d\u5728\u7528\u6237\u6743\u9650\u5185\uff0c\u60a8\u65e0\u6743\u8bbe\u7f6e\u8be5\u5458\u5de5\u4e3a\u90e8\u95e8\u8d1f\u8d23\u4eba\u3002", (String)"ImportChargePersonValidator_9", (String)"hrmp-hrpi-opplugin", (Object[])new Object[]{dy.getString("person.number"), dy.getString("person.name")}));
            return true;
        }
        return false;
    }
}

