/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.application.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.qing.util.MapUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.i18n.api.model.TelephoneParseResult;
import kd.bos.i18n.mservice.I18nServiceHelper;
import kd.bos.ksql.util.StringUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.application.IApplyApplication;
import kd.hrmp.hrpi.business.domian.repository.HBSSBaseDataRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIDepempRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmployeeRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIPersonRepository;
import kd.hrmp.hrpi.business.domian.service.HRPIServiceFactory;
import kd.hrmp.hrpi.business.domian.service.impl.HRPositionServiceImpl;
import kd.hrmp.hrpi.business.domian.service.openapi.ISyncSysUserService;
import kd.hrmp.hrpi.business.infrastructure.utils.DateUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import kd.hrmp.hrpi.common.HRPIPageConstants;
import kd.hrmp.hrpi.common.HRPIValueConstants;
import kd.hrmp.hrpi.common.generic.result.PersonGenericResult;

public class ApplyApplicationImpl
implements IApplyApplication {
    private static final Log LOG = LogFactory.getLog(ApplyApplicationImpl.class);
    public static final ThreadLocal<HashMap<String, Object>> ID_MAP_TL = new ThreadLocal();
    public static final ThreadLocal<HashSet<Long>> PER_ID_List_TL = new ThreadLocal();
    public static final ThreadLocal<HashMap<Long, Long>> DARK_POS_ID_List_TL = new ThreadLocal();
    public static ThreadLocal<Map<Long, Map<String, Object>>> TL_POSJOBRELMAP = new ThreadLocal();
    public static ThreadLocal<Map<Long, Map<String, Object>>> TL_STDPOSJOBRELMAP = new ThreadLocal();
    private final String OLD_PERSON_FIELD = "oldperson";
    private final String SUFFIX_R = "-R";
    private final String PERSON_ID_MAP = "personIdMap";

    @Override
    public Map<String, Object> addEmployee(List<Map<String, Object>> employeeListInfo) {
        return this.addEmployee(employeeListInfo, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> addEmployee(List<Map<String, Object>> employeeListInfo, String caller) {
        LOG.info("ApplyApplicationImpl.addEmployee:{}", employeeListInfo);
        if (employeeListInfo == null || employeeListInfo.isEmpty()) {
            return PersonGenericResult.create().message(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"ApplyApplicationImpl_0", (String)"hrmp-hrpi-business", (Object[])new Object[0])).fail().buildResult();
        }
        ArrayList<Object> numberList = new ArrayList<Object>(employeeListInfo.size());
        HashSet labStatusSet = Sets.newHashSetWithExpectedSize((int)employeeListInfo.size());
        HashSet oldPersonIdSet = Sets.newHashSetWithExpectedSize((int)employeeListInfo.size());
        HashMap personMap = Maps.newHashMapWithExpectedSize((int)employeeListInfo.size());
        for (Map<String, Object> item2 : employeeListInfo) {
            this.setCheckCreatePerson(item2);
            Long oldPerson = (Long)item2.get("oldperson");
            if (this.checkCreatePersonFlag(item2)) {
                personMap.put(oldPerson, (Long)item2.get("person"));
                item2.put("person", oldPerson);
            }
            Object numberObj = item2.get("number");
            StringBuilder validateMsg = new StringBuilder();
            this.checkCommonParam(validateMsg, item2);
            this.checkCommonParamForAdd(validateMsg, item2);
            this.checkBaseInfo(validateMsg, item2);
            this.wrapParamAndValidateResult(item2, validateMsg, labStatusSet);
            numberList.add(numberObj);
            if (!Objects.nonNull(oldPerson) || oldPersonIdSet.add(oldPerson)) continue;
            this.wrapParamValidate(item2, ResManager.loadKDString((String)"\u540c\u6279\u6b21\u6570\u636e\u4e0d\u5141\u8bb8\u6709\u76f8\u540c\u7684oldperson\u3002", (String)"ApplyApplicationImpl_31", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        this.checkNumber("exits", numberList, employeeListInfo);
        this.preDealWithPersonIDAlreadyExist(employeeListInfo);
        this.fillCommonParamByOldNumber(employeeListInfo);
        Map<String, Object> initParam = this.initParam(employeeListInfo, labStatusSet, oldPersonIdSet, item -> (Map)item.get("baseinfo"));
        this.initEmpPosParam(employeeListInfo);
        try {
            Map<String, DynamicObjectCollection> dys = this.createEmployee(employeeListInfo);
            Map<String, Object> param = this.buildDatasByCollection(new ArrayList<DynamicObjectCollection>(dys.values()));
            Optional.ofNullable(caller).ifPresent(call -> param.put("caller", call));
            Map<String, Object> validateResult = HRPIServiceFactory.personGenericService.validate(param);
            this.removePersonDataAndBuildErrorMsg(param, employeeListInfo, validateResult, "person", "hrpi_person"::equals);
            Map<String, Object> personSaveInfo = HRPIServiceFactory.personGenericService.saveBatch(param);
            Map<String, Object> result = this.getResult(employeeListInfo, validateResult, personSaveInfo);
            this.wrapSuccessIdSet(employeeListInfo, personSaveInfo, result);
            this.addResultFourPersonInfo(result, employeeListInfo, personMap);
            Map<String, Object> map = result;
            return map;
        }
        catch (Exception ex) {
            LOG.error("addEmployee error", (Throwable)ex);
            Map map = PersonGenericResult.exception((String)ex.getMessage());
            return map;
        }
        finally {
            ID_MAP_TL.remove();
        }
    }

    private void addResultFourPersonInfo(Map<String, Object> result, List<Map<String, Object>> employeeListInfo, Map<Long, Long> personMap) {
        ArrayList resultFourPeopleList = Lists.newArrayListWithCapacity((int)employeeListInfo.size());
        employeeListInfo.stream().filter(item -> !item.containsKey("checkresultmsg")).forEach(item -> {
            Map baseInfo = (Map)item.get("baseinfo");
            Long employeeId = (Long)baseInfo.get("employee");
            Long depEmpId = (Long)baseInfo.get("depemp");
            Long cmpEmpId = (Long)baseInfo.get("cmpemp");
            Long personId = (Long)item.get("person");
            Long infoPersonId = (Long)personMap.get(personId);
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            map.put("oldPersonId", infoPersonId == null ? personId : infoPersonId);
            map.put("newPersonId", personId);
            map.put("oldEmpId", employeeId);
            map.put("newEmpId", employeeId);
            map.put("oldCmpEmpId", cmpEmpId);
            map.put("newCmpEmpId", cmpEmpId);
            map.put("oldDepEmpId", depEmpId);
            map.put("newDepEmpId", depEmpId);
            resultFourPeopleList.add(map);
        });
        result.put("resultFourPerson", resultFourPeopleList);
    }

    private void setCheckCreatePerson(Map<String, Object> item) {
        Boolean flag = Boolean.FALSE;
        Map personMap = (Map)item.get("pernontsprop");
        if (personMap == null) {
            item.put("checkcreateperson", flag);
            return;
        }
        Object obj = personMap.get("checkcreateperson");
        if (obj instanceof Boolean) {
            flag = (Boolean)obj;
        }
        item.put("checkcreateperson", flag);
    }

    private boolean checkCreatePersonFlag(Map<String, Object> map) {
        return Objects.nonNull(map.get("oldperson")) && (Boolean)map.get("checkcreateperson") == false;
    }

    private void preDealWithPersonIDAlreadyExist(List<Map<String, Object>> employeeListInfo) {
        List<Long> personIDs = employeeListInfo.stream().filter(this::checkCreatePersonFlag).map(map -> (Long)map.get("person")).collect(Collectors.toList());
        List repeatPersonIds = personIDs.stream().filter(e -> Collections.frequency(personIDs, e) > 1).distinct().collect(Collectors.toList());
        employeeListInfo.forEach(map -> {
            if (repeatPersonIds.contains(map.get("person"))) {
                String resultMsg = Objects.nonNull(map.get("checkresultmsg")) ? (String)map.get("checkresultmsg") : "";
                map.put("checkresultmsg", String.join((CharSequence)";", resultMsg, ResManager.loadKDString((String)"\u540c\u4e00\u6279\u6b21\u4e2d\u5b58\u5728\u91cd\u590d\u7684person\u3002", (String)"ApplyApplicationImpl_32", (String)"hrmp-hrpi-business", (Object[])new Object[0])));
            }
        });
        personIDs.removeIf(repeatPersonIds::contains);
        Map<Long, DynamicObject> existPersonWithDy = Arrays.stream(HRPIPersonRepository.listDataOfAllProperties(personIDs)).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        if (MapUtils.isEmpty(existPersonWithDy)) {
            LOG.info("there is no one data that database contains the personId");
            return;
        }
        Map checkMap = HRPIServiceFactory.employeeService.checkEmployeeStatus(new ArrayList<Object>(existPersonWithDy.keySet()), "person");
        Map<Long, DynamicObject> personIdWithEmpEntRel = Arrays.stream(HRPIEmployeeRepository.fixIfRepeatNumber(HRPIEmployeeRepository.empentrelServiceHelper.query("person.id,empnumber,startdate,employee,firststartdate,oldempnumber,inheritnumber", new QFilter[]{new QFilter("person", "in", existPersonWithDy.keySet()), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter()}))).collect(Collectors.toMap(dy -> dy.getLong("person.id"), dy -> dy));
        Map<Long, DynamicObject> personIdWithPert = Arrays.stream(HRPIPersonRepository.listDataOfAllProperties(existPersonWithDy.keySet(), "hrpi_pertsprop")).collect(Collectors.toMap(dy -> dy.getLong("person.id"), dy -> dy, (k1, k2) -> k1));
        Map<Long, DynamicObject> personIdWithRegion = Arrays.stream(HRPIPersonRepository.listDataOfAllProperties(existPersonWithDy.keySet(), "hrpi_perregion")).collect(Collectors.toMap(dy -> dy.getLong("person.id"), dy -> dy, (k1, k2) -> k1));
        Map<Long, DynamicObject> personIdWithContact = Arrays.stream(HRPIPersonRepository.listDataOfAllProperties(existPersonWithDy.keySet(), "hrpi_percontact")).collect(Collectors.toMap(dy -> dy.getLong("person.id"), dy -> dy, (k1, k2) -> k1));
        Map<Long, DynamicObject> personIdWithNon = Arrays.stream(HRPIPersonRepository.listDataOfAllProperties(existPersonWithDy.keySet(), "hrpi_pernontsprop")).collect(Collectors.toMap(dy -> dy.getLong("person.id"), dy -> dy, (k1, k2) -> k1));
        employeeListInfo.stream().filter(this::checkCreatePersonFlag).forEach(map -> {
            if (((Boolean)checkMap.get(map.get("person"))).booleanValue()) {
                String resultMsg = Objects.nonNull(map.get("checkresultmsg")) ? (String)map.get("checkresultmsg") : "";
                map.put("checkresultmsg", String.join((CharSequence)";", resultMsg, ResManager.loadKDString((String)"\u8be5personID\u5728\u7cfb\u7edf\u4e2d\u5df2\u6709\u201c\u7528\u5de5\u8fdb\u884c\u4e2d\u201d\u7684\u5458\u5de5\u3002", (String)"ApplyApplicationImpl_35", (String)"hrmp-hrpi-business", (Object[])new Object[0])));
            } else {
                map.put("hrpi_person", existPersonWithDy.get(map.get("person")));
            }
            map.put("samePersonId", null != existPersonWithDy.get(map.get("person")));
            Map baseInfo = (Map)map.get("baseinfo");
            String oldEmpNumber = (String)baseInfo.get("oldempnumber");
            if (((Boolean)map.get("samePersonId")).booleanValue()) {
                baseInfo.put("oldempnumber", ((DynamicObject)existPersonWithDy.get(map.get("person"))).getString("number"));
                this.fillCommonParam(baseInfo, (DynamicObject)personIdWithEmpEntRel.get(map.get("person")));
            } else if (!oldEmpNumber.equals(((DynamicObject)existPersonWithDy.get(map.get("person"))).getString("number"))) {
                String resultMsg = Objects.nonNull(map.get("checkresultmsg")) ? (String)map.get("checkresultmsg") : "";
                map.put("checkresultmsg", String.join((CharSequence)";", resultMsg, ResManager.loadKDString((String)"\u8be5\u6570\u636e\u4f20\u5165\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u7684\u81ea\u7136\u4ebaID,\u4e14\u8be5\u81ea\u7136\u4ebaID\u5bf9\u5e94\u7684\u5de5\u53f7\u4e0e\u4f20\u5165\u7684oldempnumber\u4e0d\u4e00\u81f4\u3002", (String)"ApplyApplicationImpl_34", (String)"hrmp-hrpi-business", (Object[])new Object[0])));
            }
            map.put("hrpi_pertsprop", personIdWithPert.get(map.get("person")));
            map.put("hrpi_perregion", personIdWithRegion.get(map.get("person")));
            map.put("hrpi_percontact", personIdWithContact.get(map.get("person")));
            map.put("hrpi_pernontsprop", personIdWithNon.get(map.get("person")));
        });
    }

    private void addOldNumber(List<String> oldNumberList, Map<String, Object> map) {
        Object baseInfo = map.get("baseinfo");
        if (baseInfo instanceof Map) {
            Object oldNumber = ((Map)baseInfo).get("oldempnumber");
            String oldNumberStr = null;
            if (oldNumber instanceof String) {
                oldNumberStr = (String)oldNumber;
            }
            if (!HRStringUtils.isEmpty(oldNumberStr)) {
                oldNumberList.add(oldNumberStr);
            }
        } else {
            throw new IllegalArgumentException("Expected a Map for baseInfo, but got: " + baseInfo);
        }
    }

    private void fillCommonParamByOldNumber(List<Map<String, Object>> employeeListInfo) {
        ArrayList<String> oldNumberList = new ArrayList<String>();
        employeeListInfo.stream().filter(map -> map.get("samePersonId") == null || (Boolean)map.get("samePersonId") == false).forEach(map -> this.addOldNumber((List<String>)oldNumberList, (Map<String, Object>)map));
        if (!CollectionUtils.isEmpty(oldNumberList)) {
            Map<String, DynamicObject> numberWithDy = Arrays.stream(HRPIEmployeeRepository.fixIfRepeatNumber(HRPIEmployeeRepository.listEmpEntByNumbers(String.join((CharSequence)",", "id", "employee", "person_id", "empnumber", "employee_id", "laborreltype", "startdate", "preemployee", "oldempnumber", "firststartdate", "mid", "person"), oldNumberList))).collect(Collectors.toMap(dy -> dy.getString("empnumber"), dy -> dy));
            employeeListInfo.forEach(map -> {
                Map baseInfo = (Map)map.get("baseinfo");
                String oldEmpNumber = (String)baseInfo.get("oldempnumber");
                if (!StringUtil.isEmpty((String)oldEmpNumber) && !numberWithDy.containsKey(oldEmpNumber)) {
                    String resultMsg = Objects.nonNull(map.get("checkresultmsg")) ? (String)map.get("checkresultmsg") : "";
                    map.put("checkresultmsg", String.join((CharSequence)";", resultMsg, ResManager.loadKDString((String)"\u4f20\u5165\u7684\u524d\u5de5\u53f7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u6570\u636e\u3002", (String)"ApplyApplicationImpl_36", (String)"hrmp-hrpi-business", (Object[])new Object[0])));
                }
            });
        }
    }

    private void wrapSuccessIdSet(List<Map<String, Object>> employeeListInfo, Map<String, Object> personSaveInfo, Map<String, Object> result) {
        List<HashMap<String, Object>> versionChange = this.transferVersionChangeData(personSaveInfo);
        if (versionChange != null && !versionChange.isEmpty()) {
            HashSet personSet = Sets.newHashSetWithExpectedSize((int)employeeListInfo.size());
            HashSet employeeSet = Sets.newHashSetWithExpectedSize((int)employeeListInfo.size());
            HashSet cmpempSet = Sets.newHashSetWithExpectedSize((int)employeeListInfo.size());
            HashSet depempSet = Sets.newHashSetWithExpectedSize((int)employeeListInfo.size());
            versionChange.stream().filter(item -> "hrpi_empposorgrel".equals(item.get("entitynumber"))).map(item -> (DynamicObject[])item.get("newDynamicObjects")).flatMap(Arrays::stream).forEach(item -> {
                personSet.add((Long)item.get("person_id"));
                employeeSet.add((Long)item.get("employee_id"));
                cmpempSet.add((Long)item.get("cmpemp_id"));
                depempSet.add((Long)item.get("depemp_id"));
            });
            HashMap<String, HashSet> successIdResult = new HashMap<String, HashSet>();
            successIdResult.put("person_id", personSet);
            successIdResult.put("employee_id", employeeSet);
            successIdResult.put("cmpemp_id", cmpempSet);
            successIdResult.put("depemp_id", depempSet);
            result.put("successInfo", successIdResult);
        }
    }

    private Set<Long> wrapSuccessIdSetForSingle(List<Map<String, Object>> employeeListInfo, Map<String, Object> personSaveInfo, Map<String, Object> result, String idField, List<String> entitys) {
        List<HashMap<String, Object>> versionChange = this.transferVersionChangeData(personSaveInfo);
        String specialEntity = String.join((CharSequence)"_", "hrpi", idField.split("_")[0]);
        if (versionChange != null && !versionChange.isEmpty()) {
            HashSet idSet = Sets.newHashSetWithExpectedSize((int)employeeListInfo.size());
            versionChange.stream().map(item -> (DynamicObject[])item.get("newDynamicObjects")).flatMap(Arrays::stream).filter(item -> entitys.contains(item.getDynamicObjectType().getName())).forEach(item -> {
                String entityNumber = item.getDynamicObjectType().getName();
                Long id = entityNumber.equals(specialEntity) ? (Long)item.get("boid") : (Long)item.get(idField);
                idSet.add(id);
            });
            HashMap<String, HashSet> successIdResult = new HashMap<String, HashSet>();
            successIdResult.put(idField, idSet);
            result.put("successInfo", successIdResult);
            return idSet;
        }
        return new HashSet<Long>();
    }

    private List<HashMap<String, Object>> transferVersionChangeData(Map<String, Object> personSaveInfo) {
        return Optional.ofNullable((List)personSaveInfo.get("data")).filter(value -> value.size() > 0).map(value -> (HashMap)value.get(0)).map(value -> (HashMap)value.get("data")).map(value -> (List)value.get("versionChangeRespDataList")).orElse(null);
    }

    private void checkCommonParam(StringBuilder validateMsg, Map<String, Object> item) {
        Object personObj = item.get("person");
        Object numberObj = item.get("number");
        if (null == personObj) {
            validateMsg.append(ResManager.loadKDString((String)"person\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApplyApplicationImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0])).append(';');
        }
        if (null == numberObj) {
            validateMsg.append(ResManager.loadKDString((String)"\u5de5\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"ApplyApplicationImpl_3", (String)"hrmp-hrpi-business", (Object[])new Object[0])).append(';');
        }
    }

    private void checkCommonParamForAdd(StringBuilder validateMsg, Map<String, Object> item) {
        Object nameObj = item.get("name");
        Object phoneObj = item.get("phone");
        Long gender = Optional.ofNullable((Map)item.get("pernontsprop")).map(tmp -> (Long)tmp.get("gender")).orElse(0L);
        if (null == nameObj) {
            validateMsg.append(ResManager.loadKDString((String)"\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a", (String)"ApplyApplicationImpl_2", (String)"hrmp-hrpi-business", (Object[])new Object[0])).append(';');
        }
        if (gender.equals(0L)) {
            validateMsg.append(ResManager.loadKDString((String)"\u6027\u522b\u4e0d\u80fd\u4e3a\u7a7a", (String)"ApplyApplicationImpl_22", (String)"hrmp-hrpi-business", (Object[])new Object[0])).append(';');
        }
        if (null == phoneObj) {
            validateMsg.append(ResManager.loadKDString((String)"\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApplyApplicationImpl_4", (String)"hrmp-hrpi-business", (Object[])new Object[0])).append(';');
        } else {
            String validataPhone = this.validatePhone((String)phoneObj);
            if (null != validataPhone) {
                validateMsg.append(ResManager.loadKDString((String)"\u624b\u673a\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ApplyApplicationImpl_5", (String)"hrmp-hrpi-business", (Object[])new Object[0])).append(';');
            }
        }
        Map nonProp = (Map)item.get("pernontsprop");
        if (nonProp == null || nonProp.isEmpty()) {
            validateMsg.append(ResManager.loadKDString((String)"\u975e\u65f6\u5e8f\u6027\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApplyApplicationImpl_7", (String)"hrmp-hrpi-business", (Object[])new Object[0])).append(';');
        }
    }

    private void checkCommonParamForUpdate(StringBuilder validateMsg, Map<String, Object> item) {
        String validataPhone;
        Object phoneObj = item.get("phone");
        if (Objects.nonNull(phoneObj) && null != (validataPhone = this.validatePhone((String)phoneObj))) {
            validateMsg.append(ResManager.loadKDString((String)"\u624b\u673a\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ApplyApplicationImpl_5", (String)"hrmp-hrpi-business", (Object[])new Object[0])).append(';');
        }
    }

    private void wrapParamAndValidateResult(Map<String, Object> item, StringBuilder validateMsg) {
        this.wrapParamAndValidateResult(item, validateMsg, null);
    }

    private void wrapParamAndValidateResult(Map<String, Object> item, StringBuilder validateMsg, Set<Long> labStatusSet) {
        HashMap<String, Object> baseInfo;
        Object personObj = item.get("person");
        Object nameObj = item.get("name");
        Object numberObj = item.get("number");
        Object phone = item.get("phone");
        HashMap<String, Object> perContract = (HashMap<String, Object>)item.get("percontact");
        if (CollectionUtils.isEmpty((Map)perContract) && phone != null) {
            perContract = new HashMap<String, Object>(16);
            item.put("percontact", perContract);
        }
        if (Objects.nonNull(phone)) {
            perContract.put("phone", phone);
        }
        if (CollectionUtils.isEmpty((Map)(baseInfo = (HashMap<String, Object>)item.get("baseinfo")))) {
            baseInfo = new HashMap<String, Object>();
            item.put("baseinfo", baseInfo);
        }
        Long labStatus = (Long)baseInfo.get("laborrelstatus");
        if (labStatusSet != null && labStatus != null) {
            labStatusSet.add(labStatus);
        }
        baseInfo.put("person", personObj);
        if (Objects.nonNull(nameObj)) {
            baseInfo.put("name", nameObj);
        }
        baseInfo.put("number", numberObj);
        if (!validateMsg.toString().isEmpty()) {
            item.put("checkresultmsg", validateMsg.toString());
        }
    }

    private void checkBaseInfo(StringBuilder validateMsg, Map<String, Object> item) {
        Map baseInfo = (Map)item.get("baseinfo");
        if (baseInfo == null || baseInfo.isEmpty()) {
            validateMsg.append(ResManager.loadKDString((String)"\u201cbaseinfo\u57fa\u672c\u4fe1\u606f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApplyApplicationImpl_6", (String)"hrmp-hrpi-business", (Object[])new Object[0])).append(';');
        } else {
            Long cepemp;
            Long depemp;
            Date startDate = (Date)baseInfo.get("startdate");
            if (Objects.isNull(startDate)) {
                validateMsg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u3002", (String)"ApplyApplicationImpl_15", (String)"hrmp-hrpi-business", (Object[])new Object[0])).append(';');
            } else if (DateUtil.compareDate(startDate, new Date()) > 0) {
                validateMsg.append(ResManager.loadKDString((String)"\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4f7f\u7528\u672a\u6765\u65e5\u671f\u3002", (String)"ApplyApplicationImpl_25", (String)"hrmp-hrpi-business", (Object[])new Object[0])).append(';');
            }
            Long employee = (Long)baseInfo.get("employee");
            if (Objects.isNull(employee)) {
                validateMsg.append(ResManager.loadKDString((String)"\u201cemployee\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApplyApplicationImpl_19", (String)"hrmp-hrpi-business", (Object[])new Object[0])).append(';');
            }
            if (Objects.isNull(depemp = (Long)baseInfo.get("depemp"))) {
                validateMsg.append(ResManager.loadKDString((String)"\u201cdepemp\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApplyApplicationImpl_20", (String)"hrmp-hrpi-business", (Object[])new Object[0])).append(';');
            }
            if (Objects.isNull(cepemp = (Long)baseInfo.get("cmpemp"))) {
                validateMsg.append(ResManager.loadKDString((String)"\u201ccmpemp\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApplyApplicationImpl_21", (String)"hrmp-hrpi-business", (Object[])new Object[0])).append(';');
            }
            this.checkEmpPosOrgRels(validateMsg, baseInfo);
        }
    }

    private void checkEmpPosOrgRels(StringBuilder validateMsg, Map<String, Object> item) {
        List empPosOrgRels = (List)item.get("empposorgrels");
        if (CollectionUtils.isEmpty((Collection)empPosOrgRels)) {
            validateMsg.append(ResManager.loadKDString((String)"\u201cempposorgrels\u201d\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApplyApplicationImpl_17", (String)"hrmp-hrpi-business", (Object[])new Object[0])).append(';');
        } else {
            Date startDate;
            if (empPosOrgRels.size() > 1) {
                validateMsg.append(ResManager.loadKDString((String)"empposorgrels\u4fe1\u606f\u5757\u53ea\u80fd\u5f55\u5165\u4e00\u6bb5\u5f53\u524d\u4e3b\u4efb\u804c\u7ecf\u5386\u3002", (String)"ApplyApplicationImpl_16", (String)"hrmp-hrpi-business", (Object[])new Object[0])).append(';');
            }
            if (Objects.isNull(startDate = (Date)((Map)empPosOrgRels.get(0)).get("startdate"))) {
                validateMsg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4efb\u804c\u5f00\u59cb\u65e5\u671f\u3002", (String)"ApplyApplicationImpl_18", (String)"hrmp-hrpi-business", (Object[])new Object[0])).append(';');
            } else if (DateUtil.compareDate(startDate, new Date()) > 0) {
                validateMsg.append(ResManager.loadKDString((String)"\u4efb\u804c\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4f7f\u7528\u672a\u6765\u65e5\u671f\u3002", (String)"ApplyApplicationImpl_26", (String)"hrmp-hrpi-business", (Object[])new Object[0])).append(';');
            }
            Boolean isPrimary = (Boolean)((Map)empPosOrgRels.get(0)).get("isprimary");
            if (!Boolean.TRUE.equals(isPrimary)) {
                validateMsg.append(ResManager.loadKDString((String)"\u521b\u5efa\u5458\u5de5\u7684\u4efb\u804c\u7ecf\u5386\u5fc5\u987b\u4e3a\u4e3b\u4efb\u804c\u7ecf\u5386\u3002", (String)"ApplyApplicationImpl_27", (String)"hrmp-hrpi-business", (Object[])new Object[0])).append(';');
            }
        }
    }

    private String validatePhone(String phoneDy) {
        TelephoneParseResult telephoneParseResult = I18nServiceHelper.parseTelephone((String)phoneDy);
        if (!telephoneParseResult.isSuccess()) {
            return telephoneParseResult.getErrorMsg();
        }
        List countryList = telephoneParseResult.getCountryList();
        Map result = I18nServiceHelper.verifyTelephoneNumberFormat((String)telephoneParseResult.getTelephone(), (String[])countryList.toArray(new String[0]));
        if (HRObjectUtils.isEmpty((Object)result)) {
            return ResManager.loadKDString((String)"\u683c\u5f0f\u6709\u8bef", (String)"ApplyApplicationImpl_8", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
        }
        if (!HRStringUtils.equals((String)Boolean.TRUE.toString(), (String)((String)result.get("code")))) {
            return (String)result.get("message");
        }
        return null;
    }

    private Map<String, DynamicObjectCollection> createEmployee(List<Map<String, Object>> employeeListInfo) {
        HashMap<String, DynamicObjectCollection> result = new HashMap<String, DynamicObjectCollection>(16);
        try {
            for (Map<String, Object> employeeParam : employeeListInfo) {
                if (employeeParam.containsKey("checkresultmsg")) continue;
                HRPIServiceFactory.applyService.createPersonDys(result, employeeParam);
                long nonPersonId = HRPIServiceFactory.applyService.createPersonAttachDys("pernontsprop", result, employeeParam);
                long pertsId = HRPIServiceFactory.applyService.createPersonAttachDys("pertsprop", result, employeeParam);
                long perContact = HRPIServiceFactory.applyService.createPersonAttachDys("percontact", result, employeeParam);
                long perRegion = HRPIServiceFactory.applyService.createPersonAttachDys("perregion", result, employeeParam);
                Map<String, Long> empIdMap = HRPIServiceFactory.applyService.createEmployeeDys(result, employeeParam);
                Long emptrelId = empIdMap.get("hrpi_empentrel");
                Map<String, Long> cmpIdMap = HRPIServiceFactory.applyService.createCmpDys(result, employeeParam);
                Map<String, Long> depIdMap = HRPIServiceFactory.applyService.createDepempDys(result, emptrelId, nonPersonId, employeeParam);
                this.wrapIdMapForCreateEmp(employeeParam, employeeListInfo.size(), nonPersonId, pertsId, perContact, perRegion, empIdMap, cmpIdMap, depIdMap);
            }
        }
        catch (Exception ex) {
            LOG.error("savePerson getDynamic error", (Throwable)ex);
            throw new KDBizException(" packed data error ");
        }
        return result;
    }

    private void wrapIdMapForCreateEmp(Map<String, Object> employeeParam, int size, long nonPersonId, long perTsPropId, long perContactId, long perRegionId, Map<String, Long> empIdMap, Map<String, Long> cmpIdMap, Map<String, Long> depIdMap) {
        HashMap<String, Object> idMap = ID_MAP_TL.get();
        if (Objects.isNull(idMap)) {
            idMap = new HashMap();
            ID_MAP_TL.set(idMap);
        }
        Map info = (Map)employeeParam.get("baseinfo");
        Long personId = (Long)employeeParam.get("person");
        Long employeeId = (Long)info.get("employee");
        Long cmpId = (Long)info.get("cmpemp");
        Long depEmpId = (Long)info.get("depemp");
        this.buildIdMap("hrpi_person", idMap, size, personId, personId);
        this.buildIdMap("hrpi_pertsprop", idMap, size, perTsPropId, personId);
        this.buildIdMap("hrpi_pernontsprop", idMap, size, nonPersonId, personId);
        this.buildIdMap("hrpi_percontact", idMap, size, perContactId, personId);
        this.buildIdMap("hrpi_perregion", idMap, size, perRegionId, personId);
        this.buildIdMap("hrpi_employee", idMap, size, employeeId, personId);
        this.buildIdMap("hrpi_empentrel", idMap, size, empIdMap.get("hrpi_empentrel"), personId);
        this.buildIdMap("hrpi_empnonentrel", idMap, size, empIdMap.get("hrpi_empnonentrel"), personId);
        this.buildIdMap("hrpi_cmpemp", idMap, size, cmpId, personId);
        this.buildIdMap("hrpi_managingscope", idMap, size, cmpIdMap.get("hrpi_managingscope"), personId);
        this.buildIdMap("hrpi_depemp", idMap, size, depEmpId, personId);
        this.buildIdMap("hrpi_empposorgrel", idMap, size, depIdMap.get("hrpi_empposorgrel"), personId);
        this.buildIdMap("hspm_ermanfile", idMap, size, depIdMap.get("hspm_ermanfile"), personId);
        this.buildIdMap("hrpi_personrolerel", idMap, size, depIdMap.get("hrpi_personrolerel"), personId);
    }

    private void buildIdMap(String entityName, HashMap<String, Object> idMap, int size, Long boId, Long personId) {
        Map tmpIdMap = (Map)idMap.get(entityName);
        if (CollectionUtils.isEmpty((Map)tmpIdMap)) {
            tmpIdMap = Maps.newHashMapWithExpectedSize((int)size);
            idMap.put(entityName, tmpIdMap);
        }
        tmpIdMap.put(boId, personId);
    }

    @Override
    public Map<String, Object> saveEmpOrgrels(List<Map<String, Object>> empOrgrels) {
        return this.saveEmpOrgrels(empOrgrels, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> saveEmpOrgrels(List<Map<String, Object>> empOrgrels, String caller) {
        LOG.info("ApplyApplicationImpl.saveEmpOrgrels:{}", empOrgrels);
        if (empOrgrels == null || empOrgrels.isEmpty()) {
            return PersonGenericResult.create().message(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"ApplyApplicationImpl_0", (String)"hrmp-hrpi-business", (Object[])new Object[0])).fail().buildResult();
        }
        ArrayList<Long> depempList = new ArrayList<Long>(empOrgrels.size());
        ArrayList<String> numberList = new ArrayList<String>(empOrgrels.size());
        empOrgrels.forEach(emp -> {
            depempList.add((Long)emp.get("depemp"));
            numberList.add((String)emp.get("number"));
        });
        DynamicObject[] empDys = HRPIEmployeeRepository.fixIfRepeatNumber(HRPIEmployeeRepository.listEmpEntByNumbers(String.join((CharSequence)",", "id", "person_id", "empnumber", "employee_id", "laborreltype", "startdate", "labrelstatusprd_id"), numberList));
        HashMap employeeIdMap = Maps.newHashMapWithExpectedSize((int)empDys.length);
        ArrayList<Long> personIdList = new ArrayList<Long>(empOrgrels.size());
        for (DynamicObject emp2 : empDys) {
            HashMap<String, Long> idMap = new HashMap<String, Long>(16);
            idMap.put("employee", (Long)emp2.get("employee_id"));
            idMap.put("empentrel", (Long)emp2.get("id"));
            idMap.put("person", (Long)emp2.get("person_id"));
            idMap.put("laborreltype", (Long)emp2.get("laborreltype.id"));
            idMap.put("labrelstatusprd_id", emp2.getLong("labrelstatusprd_id"));
            personIdList.add(emp2.getLong("person_id"));
            employeeIdMap.put(emp2.getString("empnumber"), idMap);
        }
        this.validate(empOrgrels, employeeIdMap);
        DynamicObject[] depeDys = HRPIDepempRepository.listDepempIds(depempList, "id");
        Set hasDepempIds = Arrays.stream(depeDys).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        ArrayList addList = Lists.newArrayListWithExpectedSize((int)depempList.size());
        ArrayList updateList = Lists.newArrayListWithExpectedSize((int)depempList.size());
        for (Map map : empOrgrels) {
            Long depempId = (Long)map.get("depemp");
            if (map.containsKey("checkresultmsg")) continue;
            if (!hasDepempIds.contains(depempId)) {
                addList.add(map);
                continue;
            }
            updateList.add(map);
        }
        try {
            Map<String, DynamicObjectCollection> dys = HRPIServiceFactory.applyService.updateAndAddDepempDys(personIdList, depempList, employeeIdMap, addList, updateList);
            Map<String, Object> map = this.buildDatasByCollection(new ArrayList<DynamicObjectCollection>(dys.values()));
            Optional.ofNullable(caller).ifPresent(call -> param.put("caller", call));
            Map<String, Object> validateResult = HRPIServiceFactory.personGenericService.validate(map);
            this.removePersonDataAndBuildErrorMsg(map, empOrgrels, validateResult, "depemp", "hrpi_depemp"::equals);
            Map<String, Object> saveResult = HRPIServiceFactory.personGenericService.saveBatch(map);
            this.syncOrgPosToBosUser(saveResult);
            Map<String, Object> result = this.getResult(empOrgrels, validateResult, saveResult);
            Set<Long> depIds = this.wrapSuccessIdSetForSingle(empOrgrels, saveResult, result, "depemp_id", HRPIPageConstants.DEPEMPENTITYS);
            this.disableDarkPos(depIds);
            Map<String, Object> map2 = result;
            return map2;
        }
        catch (Exception ex) {
            LOG.error("saveEmpOrgrels error", (Throwable)ex);
            Map map = PersonGenericResult.exception((String)ex.getMessage());
            return map;
        }
        finally {
            ID_MAP_TL.remove();
            DARK_POS_ID_List_TL.remove();
            TL_POSJOBRELMAP.remove();
            TL_STDPOSJOBRELMAP.remove();
        }
    }

    private void disableDarkPos(Set<Long> depIds) {
        Map darkPosMap = DARK_POS_ID_List_TL.get();
        if (!CollectionUtils.isEmpty((Map)darkPosMap)) {
            ArrayList darkPosIds = Lists.newArrayListWithExpectedSize((int)darkPosMap.size());
            for (Map.Entry entry : darkPosMap.entrySet()) {
                if (!depIds.contains(entry.getKey())) continue;
                darkPosIds.add(entry.getValue());
            }
            HRPositionServiceImpl.getInstance().disableDarkPosition(darkPosIds.toArray());
        }
    }

    private void validate(List<Map<String, Object>> empOrgrels, Map<String, Map<String, Long>> employeeIdMap) {
        for (Map<String, Object> item : empOrgrels) {
            Date startDate;
            StringBuilder validateMsg = new StringBuilder();
            String number = (String)item.get("number");
            if (!employeeIdMap.containsKey(number)) {
                validateMsg.append(ResManager.loadKDString((String)"\u5de5\u53f7\u4e0d\u5b58\u5728", (String)"ApplyApplicationImpl_9", (String)"hrmp-hrpi-business", (Object[])new Object[0])).append(';');
            }
            if (Objects.isNull(startDate = (Date)item.get("startdate"))) {
                validateMsg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4efb\u804c\u5f00\u59cb\u65e5\u671f\u3002", (String)"ApplyApplicationImpl_18", (String)"hrmp-hrpi-business", (Object[])new Object[0])).append(';');
            } else if (DateUtil.compareDate(startDate, new Date()) > 0) {
                validateMsg.append(ResManager.loadKDString((String)"\u4efb\u804c\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4f7f\u7528\u672a\u6765\u65e5\u671f\u3002", (String)"ApplyApplicationImpl_26", (String)"hrmp-hrpi-business", (Object[])new Object[0])).append(';');
            }
            if (validateMsg.toString().isEmpty()) continue;
            item.put("checkresultmsg", validateMsg.toString());
        }
    }

    private void checkNumber(String checkType, List<Object> numberList, List<Map<String, Object>> checkList) {
        Map checkMap = HRPIServiceFactory.employeeService.checkEmployeeStatus(numberList, "empnumber".toUpperCase(Locale.ROOT));
        checkList.forEach(checkInfo -> {
            String number = (String)checkInfo.get("number");
            String inheritNumber = Optional.ofNullable((Map)checkInfo.get("baseinfo")).map(item -> (String)item.get("inheritnumber")).orElse("");
            if (null != number) {
                String msg;
                Object checkNumber = checkMap.get(number);
                String string = checkType.equalsIgnoreCase("exits") ? (null != checkNumber && checkNumber.equals(Boolean.TRUE) && !"2".equals(inheritNumber) ? ResManager.loadKDString((String)"\u5de5\u53f7\u5df2\u7ecf\u5b58\u5728", (String)"ApplyApplicationImpl_10", (String)"hrmp-hrpi-business", (Object[])new Object[0]) : null) : (msg = null == checkNumber || checkNumber.equals(Boolean.FALSE) ? ResManager.loadKDString((String)"\u5de5\u53f7\u4e0d\u5b58\u5728", (String)"ApplyApplicationImpl_9", (String)"hrmp-hrpi-business", (Object[])new Object[0]) : null);
                if (null != msg) {
                    checkInfo.merge("checkresultmsg", msg, (a, b) -> a + ";" + b);
                }
            }
        });
    }

    private Map<Long, String> checkPhoneByPerson(List<String> phoneList) {
        DynamicObject[] checkDys;
        HashMap<Long, String> resultMap = new HashMap<Long, String>(16);
        QFilter qf = new QFilter("phone", "in", phoneList);
        for (DynamicObject check : checkDys = HRPIPersonRepository.checkPersonInfo(qf, "hrpi_percontact", "phone")) {
            long personId = check.getLong("person.id");
            resultMap.put(personId, check.getString("phone"));
        }
        if (!resultMap.isEmpty()) {
            Map checkMap = HRPIServiceFactory.employeeService.checkEmployeeStatus(new ArrayList<Object>(resultMap.keySet()), "person");
            for (Map.Entry person : checkMap.entrySet()) {
                Long personId = (Long)person.getKey();
                if (resultMap.containsKey(personId)) continue;
                resultMap.remove(personId);
            }
        }
        return resultMap;
    }

    @Override
    public Map<String, Object> saveEmpentrels(List<Map<String, Object>> empenTrels) {
        return this.saveEmpentrels(empenTrels, null);
    }

    @Override
    public Map<String, Object> saveEmpentrels(List<Map<String, Object>> empenTrels, String caller) {
        LOG.info("ApplyApplicationImpl.saveEmpentrels:{}", empenTrels);
        if (empenTrels == null || empenTrels.isEmpty()) {
            return PersonGenericResult.create().message(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"ApplyApplicationImpl_0", (String)"hrmp-hrpi-business", (Object[])new Object[0])).fail().buildResult();
        }
        ArrayList employeeList = new ArrayList(empenTrels.size());
        ArrayList<Object> numberList = new ArrayList<Object>(empenTrels.size());
        HashSet labStatusSet = Sets.newHashSetWithExpectedSize((int)empenTrels.size());
        empenTrels.forEach(emp -> {
            employeeList.add((Long)emp.get("employee"));
            numberList.add(emp.get("number"));
            Long labStatus = (Long)emp.get("laborrelstatus");
            if (Objects.nonNull(labStatus)) {
                labStatusSet.add(labStatus);
            }
        });
        this.initParam(empenTrels, labStatusSet, null, item -> item);
        this.checkNumber("notexits", numberList, empenTrels);
        try {
            Map<String, DynamicObjectCollection> dys = HRPIServiceFactory.applyService.updateEmployeeDys(empenTrels.stream().filter(person -> !person.containsKey("checkresultmsg")).collect(Collectors.toList()));
            Map<String, Object> hisParam = this.buildDatasByCollection(new ArrayList<DynamicObjectCollection>(dys.values()));
            Optional.ofNullable(caller).ifPresent(call -> hisParam.put("caller", call));
            Map<String, Object> validateResult = HRPIServiceFactory.personGenericService.validate(hisParam);
            this.removePersonDataAndBuildErrorMsg(hisParam, empenTrels, validateResult, "employee", "hrpi_employee"::equals);
            Map<String, Object> personSaveInfo = HRPIServiceFactory.personGenericService.saveBatch(hisParam);
            Map<String, Object> result = this.getResult(empenTrels, validateResult, personSaveInfo);
            this.wrapSuccessIdSetForSingle(empenTrels, personSaveInfo, result, "employee_id", HRPIPageConstants.EMPLOYEEUPENTITYS);
            return result;
        }
        catch (Exception ex) {
            LOG.error("saveEmpentrels error", (Throwable)ex);
            return PersonGenericResult.exception((String)ex.getMessage());
        }
    }

    private Map<String, Object> initParam(List<Map<String, Object>> params, Set<Long> labStatusSet, Set<Long> oldPersonIdSet, Function<Map<String, Object>, Map<String, Object>> func) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        Map<Long, Long> labStatusMap = HBSSBaseDataRepository.queryLabStatusPrd(labStatusSet);
        Map<Long, DynamicObject> perRelEmpent = this.getOldEmpDys(oldPersonIdSet);
        for (Map<String, Object> param : params) {
            Map<String, Object> item = func.apply(param);
            Long labStatus = (Long)item.get("laborrelstatus");
            if (Objects.nonNull(labStatus)) {
                Long labStatusPrd = labStatusMap.get(labStatus);
                item.put("labrelstatusprd", labStatusPrd);
                if (HRPIValueConstants.LABRELSTATUSPRD_END.equals(labStatusPrd) && item.get("enddate") == null) {
                    String resultMsg = Objects.nonNull(param.get("checkresultmsg")) ? (String)param.get("checkresultmsg") : "";
                    param.put("checkresultmsg", String.join((CharSequence)";", resultMsg, ResManager.loadKDString((String)"\u7528\u5de5\u7ed3\u675f\u65e5\u671f\u201cenddate\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApplyApplicationImpl_28", (String)"hrmp-hrpi-business", (Object[])new Object[0])));
                }
            }
            Long oldPersonId = (Long)param.get("oldperson");
            String inheritNumber = (String)item.get("inheritnumber");
            if (Objects.nonNull(oldPersonId)) {
                if (perRelEmpent != null && perRelEmpent.containsKey(oldPersonId)) {
                    DynamicObject oldEmpEnt = perRelEmpent.get(oldPersonId);
                    String empNumber = oldEmpEnt.getString("empnumber");
                    if ("2".equals(inheritNumber) && !empNumber.equals(param.get("number"))) {
                        String resultMsg = Objects.nonNull(param.get("checkresultmsg")) ? (String)param.get("checkresultmsg") : "";
                        param.put("checkresultmsg", String.join((CharSequence)";", resultMsg, ResManager.loadKDString((String)"\u8f93\u5165\u7684\u5de5\u53f7number\u4e0e\u524d\u5de5\u53f7\u4e0d\u4e00\u81f4\u3002", (String)"ApplyApplicationImpl_30", (String)"hrmp-hrpi-business", (Object[])new Object[0])));
                    }
                    this.fillCommonParam(item, oldEmpEnt);
                    continue;
                }
                String resultMsg = Objects.nonNull(param.get("checkresultmsg")) ? (String)param.get("checkresultmsg") : "";
                param.put("checkresultmsg", String.join((CharSequence)";", resultMsg, ResManager.loadKDString((String)"\u53c2\u6570\u201coldperson\u201d\uff1a\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u524d\u79bb\u804c\u4eba\u5458personID\u3002", (String)"ApplyApplicationImpl_29", (String)"hrmp-hrpi-business", (Object[])new Object[0])));
                continue;
            }
            this.ifEmptyThenFill(param, "personindexid", "person");
            this.ifEmptyThenFill(item, "mid", "employee");
            this.ifEmptyThenFill(item, "firststartdate", "startdate");
        }
        return returnMap;
    }

    private void ifEmptyThenFill(Map<String, Object> map, String key, String keyFrom) {
        if (ObjectUtils.isEmpty((Object)map.get(key))) {
            map.put(key, map.get(keyFrom));
        }
    }

    private Map<Long, DynamicObject> getOldEmpDys(Set<Long> oldPersonIdSet) {
        HashMap perRelEmpent = null;
        if (!CollectionUtils.isEmpty(oldPersonIdSet)) {
            DynamicObject[] quitEmptrel = HRPIEmployeeRepository.getQuitEmptrel(oldPersonIdSet, "person, empnumber, employee, firststartdate, oldempnumber, inheritnumber");
            perRelEmpent = Maps.newHashMapWithExpectedSize((int)quitEmptrel.length);
            for (DynamicObject item : quitEmptrel) {
                perRelEmpent.put(item.getLong("person_id"), item);
            }
        }
        return perRelEmpent;
    }

    private void fillCommonParam(Map<String, Object> item, DynamicObject oldEmpEnt) {
        if (null == oldEmpEnt) {
            return;
        }
        item.put("preemployee", oldEmpEnt.getLong("employee_id"));
        item.put("oldempnumber", oldEmpEnt.getString("empnumber"));
        item.put("firststartdate", oldEmpEnt.getDate("firststartdate"));
        item.put("mid", oldEmpEnt.get("employee.mid"));
        item.put("personindexid", oldEmpEnt.get("person.personindexid"));
    }

    private void wrapParamValidate(Map<String, Object> param, String validateMsg) {
        String resultMsg = Objects.nonNull(param.get("checkresultmsg")) ? (String)param.get("checkresultmsg") : "";
        param.put("checkresultmsg", String.join((CharSequence)";", resultMsg, validateMsg));
    }

    private void initEmpPosParam(List<Map<String, Object>> params) {
        for (Map<String, Object> param : params) {
            Map baseInfo = (Map)param.get("baseinfo");
            Long labStatusPrd = (Long)baseInfo.get("labrelstatusprd");
            if (!HRPIValueConstants.LABRELSTATUSPRD_END.equals(labStatusPrd)) continue;
            List empPosOrgRels = (List)baseInfo.get("empposorgrels");
            ((Map)empPosOrgRels.get(0)).put("islatestrecord", "1");
        }
    }

    @Override
    public Map<String, Object> savePersonInfo(List<Map<String, Object>> personInfos) {
        return this.savePersonInfo(personInfos, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> savePersonInfo(List<Map<String, Object>> personInfos, String caller) {
        if (personInfos == null || personInfos.isEmpty()) {
            return PersonGenericResult.create().message(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"ApplyApplicationImpl_0", (String)"hrmp-hrpi-business", (Object[])new Object[0])).fail().buildResult();
        }
        ArrayList<Object> numberList = new ArrayList<Object>(personInfos.size());
        ArrayList<String> phoneList = new ArrayList<String>(personInfos.size());
        for (Map<String, Object> item : personInfos) {
            Object numberObj = item.get("number");
            String phoneObj = (String)item.get("phone");
            StringBuilder validateMsg = new StringBuilder();
            this.checkCommonParam(validateMsg, item);
            this.checkCommonParamForUpdate(validateMsg, item);
            this.wrapParamAndValidateResult(item, validateMsg);
            Map baseInfo = (Map)item.get("baseinfo");
            baseInfo.remove("number");
            numberList.add(numberObj);
            phoneList.add(phoneObj);
        }
        LOG.info(" savePersonInfo numberlist {}", numberList);
        this.checkNumber("notexits", numberList, personInfos);
        Map<Long, String> phoneCheckResult = this.checkPhoneByPerson(phoneList);
        if (!phoneCheckResult.isEmpty()) {
            HashSet<String> phoneSet = new HashSet<String>(phoneCheckResult.values());
            personInfos.forEach(phoneCheck -> {
                String queryPhone;
                Long personId = (Long)phoneCheck.get("person");
                String phone = (String)phoneCheck.get("phone");
                if (personId != null && personId > 0L && phone != null && (queryPhone = (String)phoneCheckResult.get(personId)) != null && !queryPhone.equalsIgnoreCase(phone) && phoneSet.contains(phone)) {
                    phoneCheck.merge("checkresultmsg", ResManager.loadKDString((String)"\u8be5\u624b\u673a\u53f7\u5df2\u5b58\u5728\u3002", (String)"ApplyApplicationImpl_11", (String)"hrmp-hrpi-business", (Object[])new Object[0]), (a, b) -> a + ";" + b);
                }
            });
        }
        try {
            PER_ID_List_TL.set(Sets.newHashSetWithExpectedSize((int)personInfos.size()));
            Map<String, DynamicObjectCollection> dys = HRPIServiceFactory.applyService.updatePersonDys(personInfos.stream().filter(person -> !person.containsKey("checkresultmsg")).collect(Collectors.toList()));
            Map<String, Object> hisParam = this.buildDatasByCollection(new ArrayList<DynamicObjectCollection>(dys.values()));
            Optional.ofNullable(caller).ifPresent(call -> hisParam.put("caller", call));
            Map<String, Object> validateResult = HRPIServiceFactory.personGenericService.validate(hisParam);
            this.removePersonDataAndBuildErrorMsg(hisParam, personInfos, validateResult, "person", "hrpi_person"::equals);
            Map<String, Object> personSaveInfo = HRPIServiceFactory.personGenericService.saveBatch(this.buildDatasByCollection(new ArrayList<DynamicObjectCollection>(dys.values())));
            this.syncToBosUser(personSaveInfo);
            Map<String, Object> result = this.getResult(personInfos, validateResult, personSaveInfo);
            this.wrapSuccessIdSetForSingle(personInfos, personSaveInfo, result, "person_id", HRPIPageConstants.PERSONENTITYS);
            Map<String, Object> map = result;
            return map;
        }
        catch (Exception ex) {
            LOG.error("savePersonInfo error:", (Throwable)ex);
            Map map = PersonGenericResult.exception((String)ex.getMessage());
            return map;
        }
        finally {
            PER_ID_List_TL.remove();
        }
    }

    private void syncToBosUser(Map<String, Object> saveResult) {
        Set modPerIds = PER_ID_List_TL.get();
        if (!CollectionUtils.isEmpty((Collection)modPerIds)) {
            ISyncSysUserService.getInstance().syncSysUser(new ArrayList<Long>(modPerIds));
        }
    }

    private void syncOrgPosToBosUser(Map<String, Object> saveResult) {
        Boolean success = (Boolean)saveResult.get("success");
        if (!success.booleanValue()) {
            return;
        }
        List<HashMap<String, Object>> versionChange = this.transferVersionChangeData(saveResult);
        HashSet modPerIds = null;
        if (!CollectionUtils.isEmpty(versionChange)) {
            for (Map map : versionChange) {
                DynamicObject[] dys;
                String entityNumber = (String)map.get("entitynumber");
                if (!"hrpi_empposorgrel".equals(entityNumber) || (dys = (DynamicObject[])map.get("newDynamicObjects")) == null || dys.length <= 0) continue;
                int length = dys.length;
                modPerIds = Sets.newHashSetWithExpectedSize((int)length);
                for (DynamicObject dy : dys) {
                    modPerIds.add((Long)dy.get("person_id"));
                }
            }
        }
        if (!CollectionUtils.isEmpty(modPerIds)) {
            ISyncSysUserService.getInstance().syncSysUser(new ArrayList<Long>(modPerIds));
        }
    }

    @Override
    public Map<String, Object> discardEmpExp(Map<String, Object> param) {
        Map<String, Object> validateResult = this.validateDiscardEmpExp(param);
        Map result = (Map)validateResult.get("msg");
        if (!CollectionUtils.isEmpty((Map)result)) {
            return result;
        }
        List depEmpIds = (List)param.get("depEmpIds");
        DynamicObject[] demps = HRPIDepempRepository.listDepByDepIds(depEmpIds, "boid");
        if (demps == null || demps.length == 0) {
            return PersonGenericResult.exception((String)ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u5e9f\u5f03\u7684\u7ec4\u7ec7\u4ebaID\u3002", (String)"ApplyApplicationImpl_12", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        ArrayList depIdList = Lists.newArrayListWithExpectedSize((int)demps.length);
        for (DynamicObject demp : demps) {
            depIdList.add((Long)demp.get("boid"));
        }
        return HRPIServiceFactory.applyService.discardDeps(depIdList);
    }

    private Map<String, Object> validateDiscardEmpExp(Map<String, Object> param) {
        HashMap<String, Object> validateResult = new HashMap<String, Object>();
        List depEmpIds = null;
        try {
            depEmpIds = (List)param.get("depEmpIds");
        }
        catch (ClassCastException e) {
            validateResult.put("msg", PersonGenericResult.exception((String)ResManager.loadKDString((String)"\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ApplyApplicationImpl_14", (String)"hrmp-hrpi-business", (Object[])new Object[0])));
            return validateResult;
        }
        if (CollectionUtils.isEmpty((Collection)depEmpIds)) {
            validateResult.put("msg", PersonGenericResult.exception((String)ResManager.loadKDString((String)"\u5165\u53c2\u201cdepEmpIds\u201d\u4e3a\u7a7a\u3002", (String)"ApplyApplicationImpl_13", (String)"hrmp-hrpi-business", (Object[])new Object[0])));
            return validateResult;
        }
        return validateResult;
    }

    private Map<String, Object> getResult(List<Map<String, Object>> listInfo, Map<String, Object> validateInfo, Map<String, Object> saveInfo) {
        ArrayList errorMsgList = new ArrayList();
        listInfo.forEach(emp -> {
            String errorMsg = (String)emp.get("checkresultmsg");
            if (errorMsg != null) {
                HashMap msg = new HashMap(16);
                msg.put("id", emp.get("number"));
                if (emp.containsKey("depemp")) {
                    msg.put("depemp", emp.get("depemp"));
                }
                msg.put("errMsg", errorMsg);
                errorMsgList.add(msg);
            }
        });
        if (!errorMsgList.isEmpty()) {
            validateInfo.put("success", false);
            validateInfo.put("errorInfoMsg", errorMsgList);
        }
        if (Boolean.FALSE.equals(saveInfo.get("success"))) {
            validateInfo.put("success", saveInfo.get("success"));
            validateInfo.put("message", saveInfo.get("message"));
        }
        validateInfo.put("data", saveInfo.get("data"));
        return validateInfo;
    }

    protected Map<String, Object> buildDatasByCollection(List<DynamicObjectCollection> collections) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        ArrayList datas = Lists.newArrayListWithExpectedSize((int)collections.size());
        for (int i = 0; i < collections.size(); ++i) {
            if (CollectionUtils.isEmpty((Collection)((Collection)collections.get(i)))) continue;
            HashMap item = Maps.newHashMapWithExpectedSize((int)1);
            item.put("hisDyns", collections.get(i));
            datas.add(item);
        }
        paramMap.put("data", datas);
        paramMap.put("caller", "common");
        paramMap.put("mustAllSuccess", Boolean.TRUE);
        Long eventId = ORM.create().genLongId("hrpi_event");
        paramMap.put("eventId", eventId);
        return paramMap;
    }

    private void removePersonDataAndBuildErrorMsg(Map<String, Object> param, List<Map<String, Object>> employeeListInfo, Map<String, Object> validateResult, String idFiledName, Function<String, Boolean> getIdFuc) {
        List datas = (List)param.get("data");
        Boolean success = (Boolean)validateResult.get("success");
        if (success.booleanValue() || validateResult.get("errInfos") == null) {
            return;
        }
        HashMap<String, Object> idMap = ID_MAP_TL.get();
        List errInfos = (List)validateResult.get("errInfos");
        HashMap personIdAndMsgMap = Maps.newHashMapWithExpectedSize((int)errInfos.size());
        errInfos.forEach(item -> {
            String entityNumber = (String)item.get("entityNumber");
            List errorDatas = (List)item.get("errorDatas");
            if (!CollectionUtils.isEmpty((Collection)errorDatas)) {
                errorDatas.forEach(errdata -> {
                    Long id = (Long)errdata.get("id");
                    String errMsg = (String)errdata.get("errMsg");
                    Long personId = Optional.ofNullable(idMap).map(idMapValue -> (Map)idMapValue.get(entityNumber)).map(idValue -> (Long)idValue.get(id)).orElse(0L);
                    String msg = (String)personIdAndMsgMap.get(personId);
                    String newMsg = Objects.isNull(msg) ? errMsg : (msg.contains(errMsg) ? msg : String.join((CharSequence)";", msg, errMsg));
                    personIdAndMsgMap.put(personId, newMsg);
                });
            }
        });
        if (!CollectionUtils.isEmpty((Collection)datas)) {
            datas.forEach(item -> {
                DynamicObjectCollection collection = (DynamicObjectCollection)item.get("hisDyns");
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Long id;
                    DynamicObject dy = (DynamicObject)iterator.next();
                    String entityName = dy.getDynamicObjectType().getName();
                    Long l = id = (Boolean)getIdFuc.apply(entityName) != false ? (Long)dy.get("boid") : (Long)dy.get(idFiledName);
                    if (id == null || id == 0L) {
                        Long l2 = id = (Boolean)getIdFuc.apply(entityName) != false ? (Long)dy.get("id") : (Long)dy.get(idFiledName);
                    }
                    if (!personIdAndMsgMap.containsKey(id)) continue;
                    iterator.remove();
                }
            });
        }
        for (Map<String, Object> item2 : employeeListInfo) {
            Long personId = (Long)item2.get(idFiledName);
            if (item2.containsKey("checkresultmsg") || !personIdAndMsgMap.containsKey(personId)) continue;
            item2.put("checkresultmsg", personIdAndMsgMap.get(personId));
        }
    }
}

