/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.application.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hrmp.hrpi.business.application.IEmployeeInfoQueryService;
import kd.hrmp.hrpi.business.domian.repository.HRPIBosUserRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmployeeRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIPersonRepository;
import kd.hrmp.hrpi.business.infrastructure.utils.DynamicTransformUtil;
import kd.hrmp.hrpi.business.tools.CustomRuleUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class EmployeeInfoQueryServiceImpl
implements IEmployeeInfoQueryService {
    private static final Log logger = LogFactory.getLog(EmployeeInfoQueryServiceImpl.class);
    private final Map<String, String[]> ENTITYMAP = Maps.newHashMapWithExpectedSize((int)30);
    private static final Set<String> ignoreProp = new HashSet<String>(Arrays.asList("multilanguagetext", "creator", "createtime", "modifier", "modifiertime", "modifytime", "vid", "sourcevid", "firstbsed", "changebsed", "ismodify", "bred", "brled", "brfd", "bsed", "bsled", "changedescription", "hisversion", "initstatus", "initbatch", "initdatasource"));
    private static final Set<String> transferIgnoreProp = new HashSet<String>(Arrays.asList("id", "person", "employee", "cmpemp", "depemp", "person_id", "employee_id", "cmpemp_id", "depemp_id", "datastatus", "iscurrentversion"));
    private static ThreadPool THREAD\uff3fPOOL = ThreadPools.newCachedThreadPool((String)"HRPI.EmployeeInfoQueryServiceImpl", (String)"hrpi");

    public EmployeeInfoQueryServiceImpl() {
        this.ENTITYMAP.put("001", new String[]{"hrpi_pernontsprop"});
        this.ENTITYMAP.put("002", new String[]{"hrpi_pertsprop"});
        this.ENTITYMAP.put("003", new String[]{"hrpi_percontact"});
        this.ENTITYMAP.put("004", new String[]{"hrpi_perregion"});
        this.ENTITYMAP.put("007", new String[]{"hrpi_percre"});
        this.ENTITYMAP.put("009", new String[]{"hrpi_pereduexp"});
        this.ENTITYMAP.put("010", new String[]{"hrpi_pereduexpcert"});
        this.ENTITYMAP.put("011", new String[]{"hrpi_emrgcontact"});
        this.ENTITYMAP.put("012", new String[]{"hrpi_fertilityinfo"});
        this.ENTITYMAP.put("013", new String[]{"hrpi_rsmproskl"});
        this.ENTITYMAP.put("014", new String[]{"hrpi_rsmpatinv"});
        this.ENTITYMAP.put("015", new String[]{"hrpi_preworkexp"});
        this.ENTITYMAP.put("016", new String[]{"hrpi_perserlen"});
        this.ENTITYMAP.put("017", new String[]{"hrpi_perrprecord"});
        this.ENTITYMAP.put("018", new String[]{"hrpi_perprotitle"});
        this.ENTITYMAP.put("019", new String[]{"hrpi_perpractqual"});
        this.ENTITYMAP.put("020", new String[]{"hrpi_perocpqual"});
        this.ENTITYMAP.put("021", new String[]{"hrpi_perhobby"});
        this.ENTITYMAP.put("022", new String[]{"hrpi_peraddress"});
        this.ENTITYMAP.put("023", new String[]{"hrpi_partymember"});
        this.ENTITYMAP.put("024", new String[]{"hrpi_languageskills"});
        this.ENTITYMAP.put("025", new String[]{"hrpi_familymemb"});
        this.ENTITYMAP.put("026", new String[]{"hrpi_empproexp"});
        this.ENTITYMAP.put("027", new String[]{"hrpi_debardinfo"});
    }

    @Override
    public Map<String, Map<String, Object>> queryEmployeeInfo(String identifyIdType, List<String> identityId, Set<String> searchTypeList, Date searchDate) {
        DynamicObject[] idRelArr = this.getIdentityPersonRelByType(identityId, identifyIdType);
        if (idRelArr.length == 0) {
            logger.error("EmployeeInfoQueryServiceImpl: search identityId is null");
            return new HashMap<String, Map<String, Object>>();
        }
        Map<String, Long> inputAndEmployIdRel = EmployeeInfoQueryServiceImpl.buildInputAndEmployIdRel(identifyIdType, idRelArr);
        HashSet personIdSet = Sets.newHashSetWithExpectedSize((int)identityId.size());
        personIdSet.addAll(inputAndEmployIdRel.values());
        Map<String, Map<String, Object>> resultMap = this.buildEmployeeDate(identifyIdType, identityId, idRelArr, inputAndEmployIdRel, searchTypeList);
        CountDownLatch countDownLatch = new CountDownLatch(searchTypeList.size());
        for (String searchType : searchTypeList) {
            THREAD\uff3fPOOL.execute(() -> {
                try {
                    Map<Long, List<DynamicObject>> attachDateMap = this.getEntityDynamicObjects(searchType, searchDate, personIdSet);
                    if (!CollectionUtils.isEmpty(attachDateMap)) {
                        this.buildResultMapByAttachDys(resultMap, attachDateMap, inputAndEmployIdRel, searchType);
                    }
                }
                catch (Exception e) {
                    logger.error("EmployeeInfoQueryServiceImpl.queryEmployeeInfo error:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
                    throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"EmployeeInfoQueryServiceImpl_0", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
                }
                finally {
                    countDownLatch.countDown();
                }
            }, RequestContext.get());
        }
        try {
            boolean await = countDownLatch.await(60000L, TimeUnit.MILLISECONDS);
            if (await) {
                logger.info("EmployeeInfoQueryServiceImpl.queryEmployeeInfo countdown end");
            }
        }
        catch (InterruptedException e) {
            logger.error("EmployeeInfoQueryServiceImpl.queryEmployeeInfo countdown error:", (Throwable)e);
        }
        return resultMap;
    }

    private DynamicObject[] getIdentityPersonRelByType(List<String> identityId, String identifyIdType) {
        DynamicObject[] employeeArr = new DynamicObject[]{};
        switch (identifyIdType) {
            case "EMPID": {
                employeeArr = HRPIEmployeeRepository.listEmployeeIds(this.transferStringToLong(identityId), "id, person, empnumber");
                break;
            }
            case "PERID": {
                employeeArr = HRPIEmployeeRepository.listEmployeeByPersonIds("id, person, empnumber", this.transferStringToLong(identityId));
                break;
            }
            case "EMPNO": {
                employeeArr = HRPIEmployeeRepository.listEmployeeByNumber("id, person, empnumber", identityId);
                break;
            }
            case "USER": {
                employeeArr = HRPIBosUserRepository.getPersonIdsByUserId(this.transferStringToLong(identityId));
                break;
            }
        }
        return employeeArr;
    }

    private List<Long> transferStringToLong(List<String> identityId) {
        ArrayList identityIds = Lists.newArrayListWithExpectedSize((int)identityId.size());
        for (String item : identityId) {
            identityIds.add(Long.valueOf(item));
        }
        return identityIds;
    }

    private static Map<String, Long> buildInputAndEmployIdRel(String identifyIdType, DynamicObject[] objects) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)objects.length);
        String idType = "";
        switch (identifyIdType) {
            case "EMPID": {
                idType = "id";
                break;
            }
            case "PERID": {
                idType = "person";
                break;
            }
            case "EMPNO": {
                idType = "empnumber";
                break;
            }
            case "USER": {
                idType = "user";
                break;
            }
        }
        for (DynamicObject item : objects) {
            map.put(item.getString(idType), CustomRuleUtil.getPersonId(item));
        }
        return map;
    }

    private Map<String, Map<String, Object>> buildEmployeeDate(String identifyIdType, List<String> identityIdList, DynamicObject[] personUserList, Map<String, Long> inputAndEmployIdRel, Set<String> searchTypeList) {
        HashMap employeeMap = Maps.newHashMapWithExpectedSize((int)personUserList.length);
        for (DynamicObject item : personUserList) {
            employeeMap.put(CustomRuleUtil.getPersonId(item), item);
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)identityIdList.size());
        String empKey = StringUtils.equals((CharSequence)"USER", (CharSequence)identifyIdType) ? "employee" : "id";
        for (String s : identityIdList) {
            Long personId = inputAndEmployIdRel.get(s);
            DynamicObject personUser = (DynamicObject)employeeMap.get(personId);
            if (Objects.isNull(personUser) || Objects.isNull(personId)) continue;
            HashMap item = Maps.newHashMapWithExpectedSize((int)50);
            item.put("employee_id", personUser.get(empKey));
            item.put("person_id", personUser.get("person"));
            item.put("empnumber", personUser.get("empnumber"));
            for (String searchType : searchTypeList) {
                String[] entity = this.ENTITYMAP.get(searchType);
                if (!Objects.nonNull(entity)) continue;
                String entityNumber = entity[0];
                item.put(entityNumber, null);
            }
            resultMap.put(s, item);
        }
        return resultMap;
    }

    private Map<Long, List<DynamicObject>> getEntityDynamicObjects(String searchType, Date searchDate, Set<Long> personIds) {
        String entityNumber = this.ENTITYMAP.get(searchType)[0];
        DynamicObject[] attachDys = HRPIPersonRepository.loadPersonAttachInfo(DynamicTransformUtil.getDynamicPropString(entityNumber, ignoreProp), personIds, entityNumber, null);
        Map<Long, List<DynamicObject>> employeeData = Arrays.stream(attachDys).collect(Collectors.groupingBy(item -> (Long)item.get("person_id")));
        return employeeData;
    }

    private void buildResultMapByAttachDys(Map<String, Map<String, Object>> resultMap, Map<Long, List<DynamicObject>> attachMap, Map<String, Long> inputAndEmployIdRel, String searchType) {
        for (Map.Entry<String, Long> idMap : inputAndEmployIdRel.entrySet()) {
            String key = idMap.getKey();
            Long personId = idMap.getValue();
            List<DynamicObject> attachList = attachMap.get(personId);
            if (CollectionUtils.isEmpty(attachList)) continue;
            String entityNumber = this.ENTITYMAP.get(searchType)[0];
            List<Map<String, Object>> attach = DynamicTransformUtil.dynamicBaseDataToMap(attachList, transferIgnoreProp);
            resultMap.get(key).put(entityNumber, attach);
        }
    }
}

