/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.application.impl.charge;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hrmp.hrpi.business.application.charge.IChargeApplication;
import kd.hrmp.hrpi.business.application.impl.charge.ChargeApplicationImpl;
import kd.hrmp.hrpi.business.application.impl.charge.ChargePersonService;
import kd.hrmp.hrpi.business.domian.repository.HRPIChargePersonRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIDepempRepository;

public abstract class AbstractChargePersonStrategy
implements ChargePersonService {
    protected static final Log logger = LogFactory.getLog(AbstractChargePersonStrategy.class);
    protected Map<String, Map<String, Object>> paramMap = Maps.newHashMapWithExpectedSize((int)16);
    protected IChargeApplication chargeApplication = new ChargeApplicationImpl();
    protected HRPIChargePersonRepository chargePersonRepository = HRPIChargePersonRepository.getInstance();
    protected List<DynamicObject> chargePersonList = Lists.newArrayListWithExpectedSize((int)16);
    protected List<DynamicObject> synChargeToUserList = Lists.newArrayListWithExpectedSize((int)16);

    protected DynamicObject[] getChargePersonByPersonAndAdminOrg(List<Map<String, Object>> chargePersonParam) {
        DynamicObject[] depEmpInfoArr;
        Set depEmpIdForEmployees;
        if (CollectionUtils.isEmpty(chargePersonParam)) {
            return null;
        }
        HashSet adminOrgIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet depEmpIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet employeeIds = Sets.newHashSetWithExpectedSize((int)16);
        for (Map<String, Object> param : chargePersonParam) {
            Long adminOrgId = (Long)param.get("adminorg");
            Long depEmpId = (Long)param.get("depemp");
            Long employeeId = (Long)param.get("employee");
            if (adminOrgId != null && adminOrgId != 0L) {
                adminOrgIds.add(adminOrgId);
            }
            if (depEmpId != null && depEmpId != 0L) {
                depEmpIds.add(depEmpId);
            } else {
                employeeIds.add(employeeId);
            }
            String paramKey = this.buildParamKey(adminOrgId, depEmpId, employeeId);
            this.paramMap.put(paramKey, param);
        }
        if (!CollectionUtils.isEmpty((Collection)employeeIds) && !CollectionUtils.isEmpty(depEmpIdForEmployees = Arrays.stream(depEmpInfoArr = HRPIDepempRepository.listDepByEmployeeIds(employeeIds, "id")).map(depEmpInfo -> depEmpInfo.getLong("id")).collect(Collectors.toSet()))) {
            depEmpIds.addAll(depEmpIdForEmployees);
        }
        if (!CollectionUtils.isEmpty((Collection)adminOrgIds)) {
            return this.chargePersonRepository.loadEffByPersonAndAdminOrg(depEmpIds, adminOrgIds);
        }
        return this.chargePersonRepository.loadEffByDepEmp(depEmpIds);
    }

    protected String buildParamKey(Long adminOrgId, Long depEmpId, Long employeeId) {
        StringBuilder paramKey = new StringBuilder();
        if (adminOrgId != null && adminOrgId != 0L) {
            paramKey.append(adminOrgId);
        }
        if (depEmpId != null && depEmpId != 0L) {
            return paramKey.append("-").append(depEmpId).toString();
        }
        return paramKey.append(employeeId).toString();
    }

    protected void setIfNonNull(Consumer<Object> dySetter, Object val) {
        if (val != null) {
            dySetter.accept(val);
        }
    }
}

