/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.application.impl.charge;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hrmp.hrpi.business.application.impl.charge.AbstractChargePersonStrategy;
import kd.hrmp.hrpi.business.application.impl.charge.ChargePersonParam;
import kd.hrmp.hrpi.business.domian.repository.HRPIPersonRepository;
import kd.hrmp.hrpi.business.domian.service.HRPIServiceFactory;

public class AddChargePersonStrategy
extends AbstractChargePersonStrategy {
    @Override
    public List<Long> setChargePerson(List<Map<String, Object>> chargePersonParam) {
        if (!CollectionUtils.isEmpty(chargePersonParam)) {
            List<Map<String, Object>> resultChargePersonParam = this.filterRepeatChargePerson(chargePersonParam);
            if (resultChargePersonParam == null || resultChargePersonParam.size() == 0) {
                return Lists.newArrayListWithExpectedSize((int)0);
            }
            Set personIds = resultChargePersonParam.stream().map(param -> (Long)param.get("person")).collect(Collectors.toSet());
            DynamicObject[] perNonTsPropArr = HRPIPersonRepository.listPernontsprops(new ArrayList<Long>(personIds));
            Map<Long, DynamicObject> perNonTsPropInfoMap = Arrays.stream(perNonTsPropArr).collect(Collectors.toMap(perNonTsProp -> perNonTsProp.getLong("person.id"), perNonTsProp -> perNonTsProp, (o1, o2) -> o1));
            long[] ids = ORM.create().genLongIds("hrpi_chargeperson", resultChargePersonParam.size());
            int i = 0;
            for (Map<String, Object> param2 : resultChargePersonParam) {
                DynamicObject chargePerson2 = this.chargePersonRepository.getServiceHelper().generateEmptyDynamicObject();
                chargePerson2.set("id", (Object)ids[i]);
                chargePerson2.set("adminorg", param2.get("adminorg"));
                chargePerson2.set("effdt", param2.get("effdt"));
                Object leffdtObject = param2.get("leffdt");
                if (Objects.nonNull(leffdtObject)) {
                    chargePerson2.set("leffdt", leffdtObject);
                } else {
                    chargePerson2.set("leffdt", (Object)HRBaseUtils.getMaxEndDate());
                }
                Long personId = (Long)param2.get("person");
                chargePerson2.set("chargeperson", param2.get("depemp"));
                chargePerson2.set("pernontsprop", (Object)perNonTsPropInfoMap.get(personId));
                chargePerson2.set("changesource", param2.get("changesource"));
                chargePerson2.set("isagencycharge", (Object)"0");
                Object ismain = param2.get("ismain");
                chargePerson2.set("ismain", ismain != null ? ismain : "1");
                chargePerson2.set("creator", (Object)RequestContext.get().getCurrUserId());
                chargePerson2.set("explain", param2.get("explain"));
                this.chargePersonList.add(chargePerson2);
                if (((Boolean)param2.getOrDefault("isSynChargeToUser", true)).booleanValue()) {
                    this.synChargeToUserList.add(chargePerson2);
                }
                ++i;
            }
            this.chargeApplication.addChargePerson(new ChargePersonParam((List<DynamicObject>)this.chargePersonList, chargePersonParam, false));
            if (!CollectionUtils.isEmpty((Collection)this.synChargeToUserList)) {
                HRPIServiceFactory.synChargeToUserService.addCharge(this.synChargeToUserList);
            }
        }
        return this.chargePersonList.stream().map(chargePerson -> chargePerson.getLong("id")).collect(Collectors.toList());
    }

    private List<Map<String, Object>> filterRepeatChargePerson(List<Map<String, Object>> chargePersonParam) {
        ArrayList resultChargePersonParam = Lists.newArrayListWithExpectedSize((int)chargePersonParam.size());
        DynamicObject[] chargePersonArrFromDb = this.getChargePersonByPersonAndAdminOrg(chargePersonParam);
        if (chargePersonArrFromDb == null || chargePersonArrFromDb.length == 0) {
            return chargePersonParam;
        }
        Map<String, DynamicObject> keyVsDynMap = Arrays.stream(chargePersonArrFromDb).collect(Collectors.toMap(dyn -> dyn.getLong("adminorg.id") + "-" + dyn.getLong("chargeperson.id"), dyn -> dyn, (o1, o2) -> o1));
        for (Map<String, Object> param : chargePersonParam) {
            Long adminOrgId = (Long)param.get("adminorg");
            Long depEmpId = (Long)param.get("depemp");
            String key = adminOrgId + "-" + depEmpId;
            DynamicObject chargePersonDyn = keyVsDynMap.get(key);
            if (Objects.nonNull(chargePersonDyn)) {
                Date leffdtFromDb;
                Date effdtFromDb;
                Object effdtObject = param.get("effdt");
                if (Objects.isNull(effdtObject)) {
                    logger.info("effdt is empty!");
                    continue;
                }
                Date effdt = (Date)effdtObject;
                Date leffdt = new Date();
                Object leffdtObject = param.get("leffdt");
                leffdt = Objects.nonNull(leffdtObject) ? (Date)leffdtObject : HRBaseUtils.getMaxEndDate();
                if (this.isOverlap(effdt, leffdt, effdtFromDb = chargePersonDyn.getDate("effdt"), leffdtFromDb = chargePersonDyn.getDate("leffdt"))) continue;
                resultChargePersonParam.add(param);
                continue;
            }
            resultChargePersonParam.add(param);
        }
        return resultChargePersonParam;
    }

    private boolean isOverlap(Date startDateFromDB, Date endDateFromDB, Date startDate, Date endDate) {
        return !HRDateTimeUtils.dayBefore((Date)endDateFromDB, (Date)startDate) && !HRDateTimeUtils.dayBefore((Date)endDate, (Date)startDateFromDB);
    }

    @Override
    protected DynamicObject[] getChargePersonByPersonAndAdminOrg(List<Map<String, Object>> chargePersonParam) {
        if (CollectionUtils.isEmpty(chargePersonParam)) {
            return null;
        }
        HashSet adminOrgIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet depEmpIds = Sets.newHashSetWithExpectedSize((int)16);
        for (Map<String, Object> param : chargePersonParam) {
            Long adminOrgId = (Long)param.get("adminorg");
            Long depEmpId = (Long)param.get("depemp");
            adminOrgIds.add(adminOrgId);
            depEmpIds.add(depEmpId);
            this.paramMap.put(adminOrgId + "-" + depEmpId, param);
        }
        return this.chargePersonRepository.loadEffingByPersonAndAdminOrg(depEmpIds, adminOrgIds);
    }
}

