/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.application.impl.charge;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.application.charge.IChargeApplication;
import kd.hrmp.hrpi.business.application.impl.charge.ChargePersonParam;
import kd.hrmp.hrpi.business.application.impl.charge.ChargePersonServiceContext;
import kd.hrmp.hrpi.business.domian.repository.HRPIChargeLogRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIChargePersonRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIDepempRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIPersonRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIPersonRolerelRepository;
import kd.hrmp.hrpi.business.domian.service.IChargeService;
import kd.hrmp.hrpi.business.domian.service.impl.ChargeServiceImpl;
import kd.hrmp.hrpi.business.domian.service.impl.SynChargeToUserService;
import kd.hrmp.hrpi.common.HRPIChargePersonConstants;
import kd.hrmp.hrpi.common.enums.ChangeSourceEnum;
import kd.hrmp.hrpi.common.model.charge.ModifyResult;
import kd.hrmp.hrpi.common.model.charge.QueryTagParam;
import kd.hrmp.hrpi.common.util.LocalDateRange;

public class ChargeApplicationImpl
implements IChargeApplication,
HRPIChargePersonConstants {
    private static final Log logger = LogFactory.getLog(ChargeApplicationImpl.class);
    private IChargeService chargeService = ChargeServiceImpl.getInstance();
    private HRPIChargePersonRepository chargePersonRepository = HRPIChargePersonRepository.getInstance();
    private HRPIChargeLogRepository chargeLogRepository = HRPIChargeLogRepository.getInstance();
    private static final String DATA_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String DATA_FORMAT_STR = "yyyy-MM-dd";

    @Override
    public void addChargePerson(ChargePersonParam chargePersonParam) {
        List<DynamicObject> chargePersons = chargePersonParam.getChargePersons();
        if (CollectionUtils.isEmpty(chargePersons)) {
            return;
        }
        this.chargeService.addChargePerson(chargePersons);
        this.chargeService.writeChargeLog(chargePersonParam, "0");
        if (chargePersonParam.isSynPosition()) {
            this.chargeService.setPositionCharge(chargePersonParam, "0");
        }
    }

    @Override
    public void modifyChargePerson(DynamicObject chargePerson, ChangeSourceEnum changeSourceEnum) {
        if (chargePerson == null) {
            return;
        }
        ModifyResult modifyResult = this.chargeService.modifyChargePerson(chargePerson);
        this.chargeService.writeChargeLog(chargePerson, "2", changeSourceEnum, modifyResult);
    }

    @Override
    public void modifyChargePersonWithoutCheck(DynamicObject chargePerson) {
        if (chargePerson == null) {
            return;
        }
        this.chargeService.modifyChargePersonWithoutCheck(chargePerson);
    }

    @Override
    public void removeChargePerson(ChargePersonParam chargePersonParam) {
        List<DynamicObject> chargePersonList = chargePersonParam.getChargePersons();
        if (CollectionUtils.isEmpty(chargePersonList)) {
            return;
        }
        this.chargeService.removeChargePerson(chargePersonList);
        this.chargeService.writeChargeLog(chargePersonParam, "1");
        if (chargePersonParam.isSynPosition()) {
            this.chargeService.setPositionCharge(chargePersonParam, "1");
        }
    }

    @Override
    public void discardChargePerson(ChargePersonParam chargePersonParam) {
        List<DynamicObject> chargePersonList = chargePersonParam.getChargePersons();
        if (CollectionUtils.isEmpty(chargePersonList)) {
            return;
        }
        this.chargeService.discardChargePerson(chargePersonList);
        this.chargeService.writeChargeLog(chargePersonParam, "3");
        if (chargePersonParam.isSynPosition()) {
            this.chargeService.setPositionCharge(chargePersonParam, "3");
        }
    }

    @Override
    public Map<Long, String> getLogContent(DynamicObjectCollection pageData) {
        HashSet modifyDataIdSet = Sets.newHashSetWithExpectedSize((int)16);
        HashSet ids = Sets.newHashSetWithExpectedSize((int)16);
        Date date2999 = HisEffDateCommonService.getInstance().getDate2999(null);
        for (DynamicObject pageDatum : pageData) {
            if (HRStringUtils.equals((String)pageDatum.getString("operatetype"), (String)"2")) {
                modifyDataIdSet.add(pageDatum.getLong("id"));
            }
            if (pageDatum.getDynamicObjectType().getProperty("effdt") != null) {
                pageDatum.set("effdt", date2999.equals(pageDatum.getDate("effdt")) ? null : pageDatum.getDate("effdt"));
            }
            ids.add(pageDatum.getLong("id"));
        }
        DynamicObject[] chargeLogInfoArr = this.chargeLogRepository.queryLogById("id, person", ids);
        Map<Long, DynamicObjectCollection> chargeLogPersonMap = Arrays.stream(chargeLogInfoArr).collect(Collectors.toMap(chargeLog -> chargeLog.getLong("id"), chargeLog -> chargeLog.getDynamicObjectCollection("person")));
        DynamicObject[] modifyDataEntities = this.chargeLogRepository.getLogEntry(modifyDataIdSet);
        HashMap modifyDataMap = Maps.newHashMapWithExpectedSize((int)modifyDataEntities.length);
        HashSet depEmpIds = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject modifyData : modifyDataEntities) {
            long chargePersonLogId = modifyData.getLong("log.id");
            long depEmpId = modifyData.getLong("beforecharge.chargeperson.id");
            depEmpIds.add(depEmpId);
            List logEntryGroup = modifyDataMap.getOrDefault(chargePersonLogId, new ArrayList());
            logEntryGroup.add(modifyData);
            modifyDataMap.put(chargePersonLogId, logEntryGroup);
        }
        DynamicObject[] depEmpInfoArr = HRPIDepempRepository.listDepempIds(new ArrayList<Long>(depEmpIds), "id, person");
        Map<Long, DynamicObject> demEmpInfoMap = Arrays.stream(depEmpInfoArr).collect(Collectors.toMap(demEmp -> demEmp.getLong("id"), demEmp -> demEmp));
        MainEntityType logMainEntityType = MetadataServiceHelper.getDataEntityType((String)"hrpi_chargepersonlog");
        IDataEntityProperty property = logMainEntityType.getProperties().stream().filter(prop -> HRStringUtils.equals((String)prop.getName(), (String)"operatetype")).findFirst().get();
        ComboProp comboProp = (ComboProp)property;
        HashMap<Long, String> contentMap = new HashMap<Long, String>(pageData.size());
        MainEntityType chargeMainEntityType = MetadataServiceHelper.getDataEntityType((String)"hrpi_chargeperson");
        Map<String, IDataEntityProperty> chargePropMap = chargeMainEntityType.getProperties().stream().filter(prop -> HRStringUtils.isNotEmpty((String)prop.getName()) && prop.getDisplayName() != null).collect(Collectors.toMap(IMetadata::getName, prop -> prop, (v1, v2) -> v2));
        for (DynamicObject data : pageData) {
            StringBuilder logContent = this.getLogContent(modifyDataMap, demEmpInfoMap, comboProp, chargePropMap, data, chargeLogPersonMap);
            contentMap.put(data.getLong("id"), logContent.toString());
        }
        return contentMap;
    }

    private StringBuilder getLogContent(Map<Long, List<DynamicObject>> modifyDataMap, Map<Long, DynamicObject> demEmpInfoMap, ComboProp comboProp, Map<String, IDataEntityProperty> chargePropMap, DynamicObject data, Map<Long, DynamicObjectCollection> chargeLogPersonMap) {
        String operateType = data.getString("operatetype");
        StringBuilder logContent = new StringBuilder();
        if (HRStringUtils.equals((String)operateType, (String)"2")) {
            this.getModifyLog(modifyDataMap, chargePropMap, demEmpInfoMap, data, logContent);
        } else {
            DynamicObjectCollection persons = chargeLogPersonMap.get(data.getLong("id"));
            String personInfo = persons.stream().map(person -> person.getString("fbasedataid.person.name") + "\uff08" + person.getString("fbasedataid.person.number") + "\uff09").collect(Collectors.joining("\u3001"));
            logContent.append(comboProp.getItemByName(operateType));
            logContent.append("\uff1a");
            logContent.append(personInfo);
        }
        return logContent;
    }

    private void getModifyLog(Map<Long, List<DynamicObject>> modifyDataMap, Map<String, IDataEntityProperty> chargePropMap, Map<Long, DynamicObject> demEmpInfoMap, DynamicObject data, StringBuilder logContent) {
        List<DynamicObject> modifyDataList = modifyDataMap.get(data.getLong("id"));
        for (DynamicObject modifyData : modifyDataList) {
            DynamicObject beforeCharge = modifyData.getDynamicObject("beforecharge");
            String modifyFieldName = modifyData.getString("modifyfieldname");
            DynamicObject afterCharge = modifyData.getDynamicObject("aftercharge");
            IDataEntityProperty prop = chargePropMap.get(modifyFieldName);
            String displayName = prop.getDisplayName().getLocaleValue();
            String beforeValue = "";
            String afterValue = "";
            if (prop instanceof DateProp) {
                beforeValue = HRDateTimeUtils.formatDate((Date)beforeCharge.getDate(modifyFieldName));
                afterValue = HRDateTimeUtils.formatDate((Date)afterCharge.getDate(modifyFieldName));
            } else if (prop instanceof ComboProp) {
                beforeValue = ((ComboProp)prop).getItemByName(beforeCharge.getString(modifyFieldName));
                afterValue = ((ComboProp)prop).getItemByName(afterCharge.getString(modifyFieldName));
            }
            long depEmpId = beforeCharge.getLong("chargeperson.id");
            DynamicObject depEmpInfo = demEmpInfoMap.get(depEmpId);
            logContent.append(depEmpInfo.getString("person.name"));
            logContent.append("\uff08").append(depEmpInfo.getString("person.number")).append("\uff09\uff1a");
            logContent.append(displayName).append("\uff08\u201c").append(beforeValue).append("\u201d");
            logContent.append(String.format(ResManager.loadKDString((String)"\u4fee\u6539\u4e3a\u201c%s\u201d\uff09\uff1b", (String)"ChargePersonLogApplication_0", (String)"hrmp-hrpi-business", (Object[])new Object[0]), afterValue));
        }
    }

    @Override
    public void openLogList(IFormView view, Set<Long> orgIdSet) {
        ListShowParameter toShowParameter = new ListShowParameter();
        toShowParameter.setBillFormId("hrpi_chargepersonlog");
        toShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (!CollectionUtils.isEmpty(orgIdSet)) {
            toShowParameter.getCustomParams().put("adminOrgIds", orgIdSet.stream().map(Object::toString).collect(Collectors.joining(",")));
        }
        view.showForm((FormShowParameter)toShowParameter);
    }

    @Override
    public void dataUpgrade() {
        DynamicObject[] mainChargeRole = HRPIPersonRolerelRepository.getMainChargeRole();
        if (mainChargeRole.length == 0) {
            return;
        }
        String selectField = "id, person, adminorg, depemp, role, bsed, bsled, startdate, enddate";
        Map<Long, List<DynamicObject>> roleMap = Arrays.stream(mainChargeRole).collect(Collectors.groupingBy(role -> role.getLong("boid"), Collectors.toList()));
        Set<Long> roleBoIdSet = roleMap.keySet();
        DynamicObject[] personRoleRelArr = HRPIPersonRolerelRepository.getPersonRoleRel(selectField, roleBoIdSet);
        if (personRoleRelArr.length == 0) {
            return;
        }
        HashSet personIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet depEmpIds = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject personRole : personRoleRelArr) {
            personIds.add(personRole.getLong("person.id"));
            depEmpIds.add(personRole.getLong("depemp.id"));
        }
        DynamicObject[] perNonTsPropArr = HRPIPersonRepository.listPernontsprops(new ArrayList<Long>(personIds));
        Map<Long, DynamicObject> perNonTsPropInfoMap = Arrays.stream(perNonTsPropArr).collect(Collectors.toMap(perNonTsProp -> perNonTsProp.getLong("person.id"), perNonTsProp -> perNonTsProp, (o1, o2) -> o1));
        DynamicObject[] chargePersonInfoArr = HRPIChargePersonRepository.getInstance().queryOriginalChargeByDepEmps("id, chargeperson", depEmpIds);
        Map<Long, DynamicObject> chargePersonInfoMap = Arrays.stream(chargePersonInfoArr).collect(Collectors.toMap(chargePerson -> chargePerson.getLong("chargeperson"), chargePerson -> chargePerson));
        ArrayList<DynamicObject> chargePersonList = new ArrayList<DynamicObject>(personRoleRelArr.length);
        for (DynamicObject personRoleRel : personRoleRelArr) {
            this.addChargePerson(roleMap, chargePersonList, personRoleRel, perNonTsPropInfoMap, chargePersonInfoMap);
        }
        this.chargePersonRepository.save(chargePersonList.toArray(new DynamicObject[0]));
    }

    @Override
    public Map<String, Object> setChargePerson(List<Map<String, Object>> chargePersonParam) {
        ChargePersonServiceContext chargePersonServiceContext = new ChargePersonServiceContext(chargePersonParam);
        String errMsg = chargePersonServiceContext.validParam();
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        if (!HRStringUtils.isEmpty((String)errMsg)) {
            result.put("ErrMsg", errMsg);
            result.put("code", 201);
        } else {
            List<Long> data = chargePersonServiceContext.setChargePerson();
            result.put("data", data);
            result.put("code", 200);
        }
        return result;
    }

    @Override
    public void setChargePersonByPosition(List<Map<String, Object>> positionParam) {
        if (CollectionUtils.isEmpty(positionParam)) {
            return;
        }
        List<String> leaderFlagList = Arrays.asList("true", "false");
        Map<String, List<Map>> map = positionParam.stream().filter(param -> leaderFlagList.contains(String.valueOf(param.get("isleader")))).collect(Collectors.groupingBy(param -> String.valueOf(param.get("isleader"))));
        this.removeChargePersonByPosition(map.get("false"));
        this.addChargePersonByPosition(map.get("true"));
    }

    private void addChargePersonByPosition(List<Map<String, Object>> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map<Long, Date> positionMap = list.stream().collect(Collectors.toMap(position -> (Long)position.get("positionId"), position -> (Date)position.get("effdt")));
        DynamicObjectCollection chargePersonDyCol = this.chargePersonRepository.queryByPositionIds(positionMap.keySet());
        Map<Long, DynamicObject> chargePersonMap = chargePersonDyCol.stream().collect(Collectors.toMap(dy -> dy.getLong("chargeperson.id"), dy -> dy, (value1, value2) -> value1.getDate("leffdt").compareTo(value2.getDate("leffdt")) > 0 ? value1 : value2));
        DynamicObjectCollection deptEmpDyCol = HRPIDepempRepository.queryByPositionIds(positionMap.keySet());
        Set personIdSet = deptEmpDyCol.stream().map(deptEmpDy -> deptEmpDy.getLong("person.id")).collect(Collectors.toSet());
        DynamicObject[] perNonTsPropArr = HRPIPersonRepository.listPernontsprops(new ArrayList<Long>(personIdSet));
        Map<Long, DynamicObject> perNonTsPropInfoMap = Arrays.stream(perNonTsPropArr).collect(Collectors.toMap(perNonTsProp -> perNonTsProp.getLong("person.id"), perNonTsProp -> perNonTsProp, (o1, o2) -> o1));
        ArrayList<DynamicObject> newList = new ArrayList<DynamicObject>(deptEmpDyCol.size());
        for (DynamicObject deptEmpDy2 : deptEmpDyCol) {
            Date startDate = deptEmpDy2.getDate("startdate");
            Date effDt = positionMap.get(deptEmpDy2.getLong("position.id"));
            effDt = startDate == null || effDt.compareTo(startDate) >= 0 ? effDt : HRDateTimeUtils.truncateDate((Date)startDate);
            DynamicObject chargePersonDy = chargePersonMap.get(deptEmpDy2.getLong("id"));
            if (chargePersonDy != null) {
                if ("1".equals(chargePersonDy.getString("datastatus"))) continue;
                effDt = chargePersonDy.getDate("leffdt").compareTo(effDt) > 0 ? chargePersonDy.getDate("leffdt") : effDt;
            }
            newList.add(this.buildChargePersonDy(deptEmpDy2, effDt, perNonTsPropInfoMap.get(deptEmpDy2.getLong("person.id"))));
        }
        this.addChargePerson(new ChargePersonParam(newList, ChangeSourceEnum.POSITION_CHANGE, false));
        SynChargeToUserService.getInstance().addCharge(newList);
    }

    private DynamicObject buildChargePersonDy(DynamicObject deptEmpDy, Date effDt, DynamicObject perNonTsPropDy) {
        DynamicObject newDy = this.chargePersonRepository.getServiceHelper().generateEmptyDynamicObject();
        newDy.set("adminorg", (Object)deptEmpDy.getLong("adminorg.id"));
        newDy.set("creator", (Object)RequestContext.get().getCurrUserId());
        newDy.set("chargeperson", (Object)deptEmpDy.getLong("id"));
        newDy.set("leffdt", (Object)HRBaseUtils.getMaxEndDate());
        newDy.set("effdt", (Object)effDt);
        newDy.set("isagencycharge", (Object)"0");
        newDy.set("changesource", (Object)ChangeSourceEnum.POSITION_CHANGE.getId());
        newDy.set("pernontsprop", (Object)perNonTsPropDy);
        newDy.set("ismain", (Object)"1");
        return newDy;
    }

    private void removeChargePersonByPosition(List<Map<String, Object>> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map<Long, Date> positionMap = list.stream().collect(Collectors.toMap(position -> (Long)position.get("positionId"), position -> (Date)position.get("effdt")));
        DynamicObject[] dys = this.chargePersonRepository.loadByPositionIds(positionMap.keySet());
        List<DynamicObject> chargePersonList = Arrays.stream(dys).peek(chargePersonDy -> chargePersonDy.set("leffdt", positionMap.get(chargePersonDy.getLong("chargeperson.position.id")))).collect(Collectors.toList());
        this.removeChargePerson(new ChargePersonParam(chargePersonList, ChangeSourceEnum.POSITION_CHANGE, false));
        SynChargeToUserService.getInstance().removeCharge(chargePersonList);
    }

    @Override
    public Map<Long, List<Map<String, Object>>> queryChargePersonByOrgId(List<Long> orgIds, Date queryDate) {
        if (CollectionUtils.isEmpty(orgIds) || orgIds.size() > 5000) {
            return null;
        }
        if (queryDate == null) {
            queryDate = new Date();
        }
        String selectField = "adminorg, chargeperson, pernontsprop, isagencycharge, effdt, leffdt, datastatus, ismain, changesource";
        logger.info("queryChargePersonByOrgId queryEffChargeByOrgId start!");
        DynamicObject[] chargePersonInfoArr = this.chargePersonRepository.queryEffChargeByOrgId(selectField, orgIds, queryDate);
        logger.info("queryChargePersonByOrgId queryEffChargeByOrgId end!");
        HashSet depEmpIds = Sets.newHashSetWithExpectedSize((int)chargePersonInfoArr.length);
        HashSet personIds = Sets.newHashSetWithExpectedSize((int)chargePersonInfoArr.length);
        for (DynamicObject chargePerson : chargePersonInfoArr) {
            depEmpIds.add(chargePerson.getLong("chargeperson.id"));
            personIds.add(chargePerson.getLong("chargeperson.person.id"));
        }
        logger.info("queryChargePersonByOrgId listDepemps start!");
        DynamicObject[] depEmpInfoArr = HRPIDepempRepository.listDepemps(depEmpIds);
        logger.info("queryChargePersonByOrgId listDepemps end!");
        Map<Long, DynamicObject> depEmpInfoMap = Arrays.stream(depEmpInfoArr).collect(Collectors.toMap(depEmpInfo -> depEmpInfo.getLong("id"), depEmpInfo -> depEmpInfo));
        logger.info("queryChargePersonByOrgId listPernontspropsByProp start!");
        DynamicObject[] perNonTsPropArr = HRPIPersonRepository.listPernontspropsByProp("person.id, headsculpture", new ArrayList<Long>(personIds));
        logger.info("queryChargePersonByOrgId listPernontspropsByProp end!");
        Map<Long, DynamicObject> perNonTsPropInfoMap = Arrays.stream(perNonTsPropArr).collect(Collectors.toMap(perNonTsPropInfo -> perNonTsPropInfo.getLong("person.id"), perNonTsPropInfo -> perNonTsPropInfo, (o1, o2) -> o1));
        HashMap resultList = Maps.newHashMapWithExpectedSize((int)chargePersonInfoArr.length);
        for (DynamicObject chargePersonInfo : chargePersonInfoArr) {
            DynamicObject perNonTsPropInfo2;
            HashMap chargePersonInfoMap = Maps.newHashMapWithExpectedSize((int)16);
            long adminOrgId = chargePersonInfo.getLong("adminorg.id");
            long personId = chargePersonInfo.getLong("chargeperson.person.id");
            chargePersonInfoMap.put("id", chargePersonInfo.getLong("id"));
            chargePersonInfoMap.put("adminorg", adminOrgId);
            chargePersonInfoMap.put("adminorg.name", chargePersonInfo.getString("adminorg.name"));
            chargePersonInfoMap.put("adminorg.number", chargePersonInfo.getString("adminorg.number"));
            chargePersonInfoMap.put("person", personId);
            chargePersonInfoMap.put("isagencycharge", chargePersonInfo.getBoolean("isagencycharge"));
            chargePersonInfoMap.put("effdt", chargePersonInfo.getDate("effdt"));
            chargePersonInfoMap.put("leffdt", chargePersonInfo.getDate("leffdt"));
            chargePersonInfoMap.put("ismain", chargePersonInfo.getString("ismain"));
            chargePersonInfoMap.put("changesource.id", chargePersonInfo.getLong("changesource.id"));
            chargePersonInfoMap.put("datastatus", chargePersonInfo.getString("datastatus"));
            long chargePersonId = chargePersonInfo.getLong("chargeperson.id");
            DynamicObject depEmpInfo2 = depEmpInfoMap.get(chargePersonId);
            if (depEmpInfo2 != null) {
                chargePersonInfoMap.put("depemp", depEmpInfo2.getLong("id"));
                this.buildChargeInfoMap(chargePersonInfoMap, depEmpInfo2);
            }
            if ((perNonTsPropInfo2 = perNonTsPropInfoMap.get(personId)) != null) {
                chargePersonInfoMap.put("headsculpture", perNonTsPropInfo2.getString("headsculpture"));
            }
            List chargeInfoList = resultList.getOrDefault(adminOrgId, new ArrayList());
            chargeInfoList.add(chargePersonInfoMap);
            resultList.put(adminOrgId, chargeInfoList);
        }
        return resultList;
    }

    private void buildPersonInfo(Map<Long, DynamicObject> depEmpInfoMap, Map<Long, DynamicObject> perNonTsPropInfoMap, DynamicObject chargePersonInfo, Map<String, Object> chargePersonInfoMap, long adminOrgId, long personId) {
        DynamicObject perNonTsPropInfo;
        chargePersonInfoMap.put("id", chargePersonInfo.getLong("id"));
        chargePersonInfoMap.put("adminorg", adminOrgId);
        chargePersonInfoMap.put("adminorg.name", chargePersonInfo.getString("adminorg.name"));
        chargePersonInfoMap.put("adminorg.number", chargePersonInfo.getString("adminorg.number"));
        chargePersonInfoMap.put("person", personId);
        chargePersonInfoMap.put("isagencycharge", chargePersonInfo.getBoolean("isagencycharge"));
        chargePersonInfoMap.put("effdt", chargePersonInfo.getDate("effdt"));
        chargePersonInfoMap.put("leffdt", chargePersonInfo.getDate("leffdt"));
        chargePersonInfoMap.put("ismain", chargePersonInfo.getString("ismain"));
        chargePersonInfoMap.put("datastatus", chargePersonInfo.getString("datastatus"));
        long chargePersonId = chargePersonInfo.getLong("chargeperson.id");
        DynamicObject depEmpInfo = depEmpInfoMap.get(chargePersonId);
        if (depEmpInfo != null) {
            chargePersonInfoMap.put("depemp", depEmpInfo.getLong("id"));
            this.buildChargeInfoMap(chargePersonInfoMap, depEmpInfo);
        }
        if ((perNonTsPropInfo = perNonTsPropInfoMap.get(personId)) != null) {
            chargePersonInfoMap.put("headsculpture", perNonTsPropInfo.getString("headsculpture"));
        }
    }

    @Override
    public Map<Long, List<Map<String, Object>>> queryChargeByPersonId(List<Long> personIds, Date queryDate) {
        if (CollectionUtils.isEmpty(personIds) || personIds.size() > 5000) {
            return null;
        }
        if (queryDate == null) {
            queryDate = new Date();
        }
        String selectField = "adminorg, chargeperson, isagencycharge, chargeperson.person.id, ismain, effdt, leffdt";
        DynamicObject[] chargePersonInfoArr = this.chargePersonRepository.queryEffChargeByPersonId(selectField, personIds, queryDate);
        HashMap chargePersonInfoMap = Maps.newHashMapWithExpectedSize((int)chargePersonInfoArr.length);
        for (DynamicObject chargePersonInfo : chargePersonInfoArr) {
            HashMap chargeInfoMap = Maps.newHashMapWithExpectedSize((int)16);
            chargeInfoMap.put("adminorg", chargePersonInfo.getLong("adminorg.id"));
            chargeInfoMap.put("number", chargePersonInfo.getString("adminorg.number"));
            chargeInfoMap.put("name", chargePersonInfo.getString("adminorg.name"));
            chargeInfoMap.put("isagencycharge", chargePersonInfo.getBoolean("isagencycharge"));
            chargeInfoMap.put("ismain", chargePersonInfo.getString("ismain"));
            chargeInfoMap.put("chargeperson", chargePersonInfo.getLong("chargeperson.id"));
            chargeInfoMap.put("effdt", chargePersonInfo.getDate("effdt"));
            chargeInfoMap.put("leffdt", chargePersonInfo.getDate("leffdt"));
            long personId = chargePersonInfo.getLong("chargeperson.person.id");
            List chargePersonInfoList = chargePersonInfoMap.getOrDefault(personId, new ArrayList());
            chargePersonInfoList.add(chargeInfoMap);
            chargePersonInfoMap.put(personId, chargePersonInfoList);
        }
        return chargePersonInfoMap;
    }

    @Override
    public Map<Long, List<Map<String, Object>>> queryPastChargeByOrgId(List<Long> orgIds, Date queryDate) {
        if (CollectionUtils.isEmpty(orgIds) || orgIds.size() > 5000) {
            return null;
        }
        if (queryDate == null) {
            queryDate = new Date();
        }
        String selectField = "adminorg, chargeperson, pernontsprop, isagencycharge, effdt, leffdt, datastatus, ismain, changesource";
        DynamicObject[] chargePersonInfoArr = this.chargePersonRepository.queryPastChargeByOrgId(selectField, orgIds, queryDate);
        HashSet depEmpIds = Sets.newHashSetWithExpectedSize((int)chargePersonInfoArr.length);
        HashSet personIds = Sets.newHashSetWithExpectedSize((int)chargePersonInfoArr.length);
        for (DynamicObject chargePerson : chargePersonInfoArr) {
            depEmpIds.add(chargePerson.getLong("chargeperson.id"));
            personIds.add(chargePerson.getLong("chargeperson.person.id"));
        }
        DynamicObject[] depEmpInfoArr = HRPIDepempRepository.listDepemps(depEmpIds);
        Map<Long, DynamicObject> depEmpInfoMap = Arrays.stream(depEmpInfoArr).collect(Collectors.toMap(depEmpInfo -> depEmpInfo.getLong("id"), depEmpInfo -> depEmpInfo));
        DynamicObject[] perNonTsPropArr = HRPIPersonRepository.listPernontsprops(new ArrayList<Long>(personIds));
        Map<Long, DynamicObject> perNonTsPropInfoMap = Arrays.stream(perNonTsPropArr).collect(Collectors.toMap(perNonTsPropInfo -> perNonTsPropInfo.getLong("person.id"), perNonTsPropInfo -> perNonTsPropInfo, (o1, o2) -> o1));
        HashMap chargeInfoResultMap = Maps.newHashMapWithExpectedSize((int)chargePersonInfoArr.length);
        for (DynamicObject chargePersonInfo : chargePersonInfoArr) {
            DynamicObject perNonTsPropInfo2;
            long chargeId = chargePersonInfo.getLong("id");
            long adminOrgId = chargePersonInfo.getLong("adminorg.id");
            long personId = chargePersonInfo.getLong("chargeperson.person.id");
            long chargePersonId = chargePersonInfo.getLong("chargeperson.id");
            HashMap chargeInfoMap = Maps.newHashMapWithExpectedSize((int)16);
            chargeInfoMap.put("id", chargeId);
            chargeInfoMap.put("person", personId);
            chargeInfoMap.put("isagencycharge", chargePersonInfo.getBoolean("isagencycharge"));
            chargeInfoMap.put("effdt", chargePersonInfo.getDate("effdt"));
            chargeInfoMap.put("leffdt", chargePersonInfo.getDate("leffdt"));
            chargeInfoMap.put("ismain", chargePersonInfo.getString("ismain"));
            chargeInfoMap.put("changesource.id", chargePersonInfo.getLong("changesource.id"));
            chargeInfoMap.put("datastatus", chargePersonInfo.getString("datastatus"));
            DynamicObject depEmpInfo2 = depEmpInfoMap.get(chargePersonId);
            if (depEmpInfo2 != null) {
                this.buildChargeInfoMap(chargeInfoMap, depEmpInfo2);
            }
            if ((perNonTsPropInfo2 = perNonTsPropInfoMap.get(personId)) != null) {
                chargeInfoMap.put("headsculpture", perNonTsPropInfo2.getString("headsculpture"));
            }
            List chargeInfoList = chargeInfoResultMap.getOrDefault(adminOrgId, new ArrayList());
            chargeInfoList.add(chargeInfoMap);
            chargeInfoResultMap.put(adminOrgId, chargeInfoList);
        }
        return chargeInfoResultMap;
    }

    @Override
    public Map<Long, List<Map<String, Object>>> queryChargeWithParentByOrgId(List<Long> orgIds, Date queryDate) {
        Map orgList;
        logger.info("queryChargeWithParentByOrgId start : orgIds {}", orgIds);
        try {
            orgList = (Map)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgStructQueryService", (String)"adminOrgStructQuery", (Object[])new Object[]{orgIds, queryDate, Boolean.FALSE});
            logger.info("queryChargeWithParentByOrgId1 adminOrgStructQuery:{}", (Object)JSON.toJSONString((Object)orgList));
        }
        catch (Exception ex) {
            logger.error("queryChargeWithParentByOrgId1 orgIds:{} error:{}", (Object)orgIds.toArray(), (Object)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5f02\u5e38\u3002", (String)"ChargeApplicationImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        return this.buildChargeInfoFromOrgInfoMap(orgIds, queryDate, orgList);
    }

    @Override
    public Map<Long, List<Map<String, Object>>> queryChargeWithParentByOrgId(List<Long> orgIds, Date queryDate, Long structProject) {
        Map orgList;
        try {
            orgList = (Map)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSStructProjectService", (String)"queryStructInfoByProId", (Object[])new Object[]{orgIds, queryDate, structProject, Boolean.FALSE});
            logger.info("queryChargeWithParentByOrgId2 adminOrgStructQuery:{}", (Object)JSON.toJSONString((Object)orgList));
        }
        catch (Exception ex) {
            logger.error("queryChargeWithParentByOrgId2 orgIds:{} error:{}", (Object)orgIds.toArray(), (Object)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u6839\u636e\u67b6\u6784\u65b9\u6848ID\u67e5\u8be2\u7ed3\u6784\u4fe1\u606f\u3002", (String)"ChargeApplicationImpl_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        return this.buildChargeInfoFromOrgInfoMap(orgIds, queryDate, orgList);
    }

    private void buildChargeInfoMap(Map<String, Object> chargeInfoMap, DynamicObject depEmpInfo) {
        chargeInfoMap.put("depemp", depEmpInfo.getLong("id"));
        chargeInfoMap.put("name", depEmpInfo.getString("person.name"));
        chargeInfoMap.put("number", depEmpInfo.getString("person.number"));
        chargeInfoMap.put("postype", depEmpInfo.getString("postype.name"));
        chargeInfoMap.put("postype.id", depEmpInfo.getLong("postype.id"));
        chargeInfoMap.put("apositiontype", depEmpInfo.getString("apositiontype"));
        chargeInfoMap.put("position", depEmpInfo.getString("position.name"));
        chargeInfoMap.put("position.id", depEmpInfo.getLong("position.id"));
        chargeInfoMap.put("stdposition", depEmpInfo.getString("stdposition.name"));
        chargeInfoMap.put("stdposition.id", depEmpInfo.getLong("stdposition.id"));
        long employeeId = depEmpInfo.getLong("employee.id");
        chargeInfoMap.put("employee.id", employeeId);
        chargeInfoMap.put("laborreltype", depEmpInfo.getString("employee.laborreltype.name"));
        chargeInfoMap.put("laborrelstatus", depEmpInfo.getString("employee.laborrelstatus.name"));
        chargeInfoMap.put("isprimary", depEmpInfo.get("isprimary"));
        chargeInfoMap.put("workrole.id", depEmpInfo.getLong("position.workrole.id"));
        chargeInfoMap.put("workrole.name", depEmpInfo.getString("position.workrole.name"));
        chargeInfoMap.put("workrole.number", depEmpInfo.getString("position.workrole.number"));
    }

    private void addChargePerson(Map<Long, List<DynamicObject>> roleMap, List<DynamicObject> chargePersonList, DynamicObject personRoleRel, Map<Long, DynamicObject> perNonTsPropInfoMap, Map<Long, DynamicObject> chargePersonInfoMap) {
        long roleId = personRoleRel.getLong("role.id");
        Date personRoleStartDt = personRoleRel.getDate("startdate");
        Date personRoleEndDt = personRoleRel.getDate("enddate");
        List<DynamicObject> roleHisList = roleMap.get(roleId);
        for (DynamicObject role : roleHisList) {
            Date roleEffDt = role.getDate("bsed");
            Date roleEndDt = role.getDate("bsled");
            long depEmpId = personRoleRel.getLong("depemp.id");
            DynamicObject chargePersonInfo = chargePersonInfoMap.get(depEmpId);
            if (HRDateTimeUtils.dayBefore((Date)roleEndDt, (Date)personRoleStartDt) || HRDateTimeUtils.dayBefore((Date)personRoleEndDt, (Date)roleEffDt) || chargePersonInfo != null) continue;
            DynamicObject chargePerson = this.chargePersonRepository.getServiceHelper().generateEmptyDynamicObject();
            Long changeSource = HRDateTimeUtils.dayBefore((Date)personRoleStartDt, (Date)roleEffDt) ? ChangeSourceEnum.POSITION_CHANGE.getId() : ChangeSourceEnum.OFFICE_CHANGE.getId();
            chargePerson.set("adminorg", personRoleRel.get("adminorg"));
            chargePerson.set("chargeperson", personRoleRel.get("depemp"));
            long personId = personRoleRel.getLong("person.id");
            DynamicObject perNonTsProp = perNonTsPropInfoMap.get(personId);
            chargePerson.set("pernontsprop", (Object)perNonTsProp);
            chargePerson.set("creator", (Object)RequestContext.get().getCurrUserId());
            chargePerson.set("changesource", (Object)changeSource);
            chargePerson.set("isagencycharge", (Object)"0");
            chargePerson.set("effdt", (Object)(HRDateTimeUtils.dayBefore((Date)personRoleStartDt, (Date)roleEffDt) ? roleEffDt : personRoleStartDt));
            Date lEffDt = HRDateTimeUtils.dayBefore((Date)personRoleEndDt, (Date)roleEndDt) ? personRoleEndDt : roleEndDt;
            String dataStatus = HRDateTimeUtils.dayBefore((Date)lEffDt, (Date)Objects.requireNonNull(HRBaseUtils.getMaxEndDate())) ? "2" : "1";
            chargePerson.set("datastatus", (Object)dataStatus);
            chargePerson.set("leffdt", (Object)lEffDt);
            chargePersonList.add(chargePerson);
        }
    }

    @Override
    public DynamicObject[] queryChargeTag(List<QueryTagParam> queryTagParamList) {
        DynamicObject[] chargePersons = this.queryChargePerson(queryTagParamList);
        Map personAndDepVsLocalDateRange = queryTagParamList.stream().collect(Collectors.groupingBy(queryTagParam -> String.format("%s+%s", queryTagParam.getPersonId(), queryTagParam.getDepId()), Collectors.mapping(queryTagParam -> LocalDateRange.ofClosed((Date)queryTagParam.getDate(), (Date)queryTagParam.getDate()), Collectors.toList())));
        return (DynamicObject[])Arrays.stream(chargePersons).filter(chargePerson -> {
            LocalDateRange dataDateRange = LocalDateRange.of((Date)chargePerson.getDate("effdt"), (Date)chargePerson.getDate("leffdt"));
            String key = String.format("%s+%s", chargePerson.getLong("chargeperson.person.id"), chargePerson.getLong("adminorg.id"));
            List inParamDateRangeList = personAndDepVsLocalDateRange.getOrDefault(key, Collections.emptyList());
            Optional<LocalDateRange> any = inParamDateRangeList.stream().filter(paramDateRange -> paramDateRange.overlaps(dataDateRange)).findAny();
            return any.isPresent();
        }).toArray(DynamicObject[]::new);
    }

    private DynamicObject[] queryChargePerson(List<QueryTagParam> queryTagParamList) {
        Set<Long> adminOrgList = queryTagParamList.stream().map(QueryTagParam::getDepId).collect(Collectors.toSet());
        List<Date> dateList = queryTagParamList.stream().map(QueryTagParam::getDate).collect(Collectors.toList());
        Set<Long> personIdSet = queryTagParamList.stream().map(QueryTagParam::getPersonId).collect(Collectors.toSet());
        return HRPIChargePersonRepository.getInstance().queryEffChargeByPersonAndOrgAndDate("id, ismain, chargeperson.id, adminorg, effdt, leffdt", personIdSet, ChargeApplicationImpl.getMinDate(dateList), ChargeApplicationImpl.getMaxDate(dateList), adminOrgList);
    }

    public static Date getMinDate(List<Date> dateList) {
        if (dateList != null && dateList.size() > 0) {
            if (dateList.size() > 1) {
                Optional minOpt = dateList.stream().reduce((bsed, bsed2) -> bsed.before((Date)bsed2) ? bsed : bsed2);
                return (Date)minOpt.get();
            }
            return dateList.get(0);
        }
        return null;
    }

    public static Date getMaxDate(List<Date> dateList) {
        if (dateList != null && dateList.size() > 0) {
            if (dateList.size() > 1) {
                Optional minOpt = dateList.stream().reduce((bsed, bsed2) -> bsed.after((Date)bsed2) ? bsed : bsed2);
                return (Date)minOpt.get();
            }
            return dateList.get(0);
        }
        return null;
    }

    public Map<Long, List<Map<String, Object>>> buildChargeInfoFromOrgInfoMap(List<Long> orgIds, Date queryDate, Map<String, Map<String, Object>> orgList) {
        if (!CollectionUtils.isEmpty(orgList)) {
            HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
            HashSet orgAndParentOrgIds = Sets.newHashSetWithExpectedSize((int)16);
            HashMap adminOrgParentIdMap = Maps.newHashMapWithExpectedSize((int)16);
            orgAndParentOrgIds.addAll(orgIds);
            for (Map.Entry<String, Map<String, Object>> orgInfoMap : orgList.entrySet()) {
                Map<String, Object> orgInfoMapValue = orgInfoMap.getValue();
                orgAndParentOrgIds.add((Long)orgInfoMapValue.get("parentorg"));
                adminOrgParentIdMap.put(Long.valueOf(orgInfoMap.getKey()), (Long)orgInfoMapValue.get("parentorg"));
            }
            Map<Long, List<Map<String, Object>>> chargePersonInfoMap = this.queryChargePersonByOrgId(new ArrayList<Long>(orgAndParentOrgIds), queryDate);
            adminOrgParentIdMap.forEach((adminOrgId, parentOrgId) -> {
                List chargeInfoList = (List)chargePersonInfoMap.get(adminOrgId);
                List parentChargeInfoList = (List)chargePersonInfoMap.get(parentOrgId);
                if (!CollectionUtils.isEmpty((Collection)chargeInfoList)) {
                    chargeInfoList.forEach(chargeInfo -> chargeInfo.put("parentorg", parentOrgId));
                } else {
                    chargeInfoList = Lists.newArrayListWithExpectedSize((int)16);
                    HashMap chargeInfo2 = Maps.newHashMapWithExpectedSize((int)16);
                    chargeInfo2.put("adminorg", adminOrgId);
                    chargeInfo2.put("parentorg", parentOrgId);
                    chargeInfoList.add(chargeInfo2);
                }
                if (!CollectionUtils.isEmpty((Collection)parentChargeInfoList)) {
                    resultMap.put(parentOrgId, parentChargeInfoList);
                }
                resultMap.put(adminOrgId, chargeInfoList);
            });
            return resultMap;
        }
        return null;
    }

    @Override
    public Map<String, List<Map<String, Object>>> queryChargePersonByOrgIdAndDate(List<Map<String, Object>> queryParam) {
        if (CollectionUtils.isEmpty(queryParam) || queryParam.size() > 5000) {
            logger.info("queryChargePersonByOrgIdAndDate_Null");
            return null;
        }
        HashMap resultList = Maps.newHashMapWithExpectedSize((int)queryParam.size());
        try {
            HashSet<Long> orgIds = new HashSet<Long>(16);
            Date minDate = this.reBuildParam(queryParam, orgIds);
            Object[] chargeDyArr = HRPIChargePersonRepository.getInstance().queryChargeManByOrgIdAndDate(orgIds, minDate);
            if (HRArrayUtils.isEmpty((Object[])chargeDyArr)) {
                return new HashMap<String, List<Map<String, Object>>>(4);
            }
            Map<Long, List<DynamicObject>> chargePersonMap = Arrays.stream(chargeDyArr).collect(Collectors.groupingBy(dy -> dy.getLong("adminorg.id")));
            HashSet personIds = Sets.newHashSetWithExpectedSize((int)chargeDyArr.length);
            HashSet depEmpIds = Sets.newHashSetWithExpectedSize((int)chargeDyArr.length);
            for (Object chargePerson : chargeDyArr) {
                depEmpIds.add(chargePerson.getLong("chargeperson.id"));
                personIds.add(chargePerson.getLong("chargeperson.person.id"));
            }
            logger.info("queryChargePersonByOrgIdAndDate queryData start!");
            DynamicObject[] depEmpInfoArr = HRPIDepempRepository.listDepemps(depEmpIds);
            Map<Long, DynamicObject> depEmpInfoMap = Arrays.stream(depEmpInfoArr).collect(Collectors.toMap(depEmpInfo -> depEmpInfo.getLong("id"), depEmpInfo -> depEmpInfo));
            DynamicObject[] perNonTsPropArr = HRPIPersonRepository.listPernontspropsByProp("person.id, headsculpture", new ArrayList<Long>(personIds));
            logger.info("queryChargePersonByOrgIdAndDate queryData end!");
            Map<Long, DynamicObject> perNonTsPropInfoMap = Arrays.stream(perNonTsPropArr).collect(Collectors.toMap(perNonTsPropInfo -> perNonTsPropInfo.getLong("person.id"), perNonTsPropInfo -> perNonTsPropInfo, (o1, o2) -> o1));
            for (Map<String, Object> queryPar : queryParam) {
                Date queryDate;
                Long orgId = (Long)queryPar.get("orgid");
                if (orgId == null || (queryDate = this.getQueryDate(queryPar)) == null) continue;
                String retDateStr = HRDateTimeUtils.format((Date)queryDate, (String)DATA_FORMAT_STR);
                List<DynamicObject> chargePersons = chargePersonMap.get(orgId);
                String retKey = orgId + "_" + retDateStr;
                if (!CollectionUtils.isEmpty(chargePersons)) {
                    List chargePersonInfos = chargePersons.stream().filter(dy -> queryDate.compareTo(dy.getDate("effdt")) >= 0 && queryDate.compareTo(dy.getDate("leffdt")) < 0).collect(Collectors.toList());
                    ArrayList<HashMap> chargeInfoList = new ArrayList<HashMap>(10);
                    for (DynamicObject chargePersonInfo : chargePersonInfos) {
                        HashMap chargePersonInfoMap = Maps.newHashMapWithExpectedSize((int)16);
                        long adminOrgId = chargePersonInfo.getLong("adminorg.id");
                        long personId = chargePersonInfo.getLong("chargeperson.person.id");
                        this.buildPersonInfo(depEmpInfoMap, perNonTsPropInfoMap, chargePersonInfo, chargePersonInfoMap, adminOrgId, personId);
                        chargeInfoList.add(chargePersonInfoMap);
                        resultList.put(retKey, chargeInfoList);
                    }
                    continue;
                }
                resultList.put(retKey, new ArrayList(10));
                logger.warn("queryChargePersonByOrgIdAndDate->find change person empty->{}", (Object)retKey);
            }
        }
        catch (Exception e) {
            logger.error("queryChargePersonByOrgIdAndDate error", (Throwable)e);
            return new HashMap<String, List<Map<String, Object>>>(4);
        }
        return resultList;
    }

    private Date getQueryDate(Map<String, Object> queryPar) throws ParseException {
        Object dateObj = queryPar.get("date");
        if (dateObj instanceof Date) {
            return (Date)dateObj;
        }
        if (dateObj instanceof String) {
            try {
                return HRDateTimeUtils.parseDate((String)((String)dateObj), (String)DATA_FORMAT);
            }
            catch (Exception es) {
                logger.error("parseGetQueryDateError");
                return HRDateTimeUtils.parseDate((String)((String)dateObj), (String)DATA_FORMAT_STR);
            }
        }
        return null;
    }

    private Date reBuildParam(List<Map<String, Object>> queryParam, Set<Long> orgIds) throws ParseException {
        Date minDate = new Date();
        for (Map<String, Object> queryPar : queryParam) {
            Date paramDate;
            orgIds.add((Long)queryPar.get("orgid"));
            Object dateObj = queryPar.get("date");
            if (dateObj instanceof Date) {
                paramDate = (Date)dateObj;
                if (minDate.compareTo(paramDate) > 0) {
                    minDate = paramDate;
                }
                queryPar.put("date", HRDateTimeUtils.format((Date)paramDate, (String)DATA_FORMAT));
                continue;
            }
            if (dateObj instanceof String) {
                if (HRStringUtils.isEmpty((String)((String)dateObj))) {
                    Date dt = new Date();
                    Date date = HRDateTimeUtils.truncateDate((Date)dt);
                    if (minDate.compareTo(date) > 0) {
                        minDate = date;
                    }
                    queryPar.put("date", date);
                    continue;
                }
                try {
                    paramDate = HRDateTimeUtils.parseDate((String)((String)dateObj), (String)DATA_FORMAT);
                    if (minDate.compareTo(paramDate) <= 0) continue;
                    minDate = paramDate;
                }
                catch (Exception es) {
                    Date paramDate2 = HRDateTimeUtils.parseDate((String)((String)dateObj), (String)DATA_FORMAT_STR);
                    if (minDate.compareTo(paramDate2) > 0) {
                        minDate = paramDate2;
                    }
                    logger.error("parseDateError");
                }
                continue;
            }
            Date date = HRDateTimeUtils.truncateDate((Date)new Date());
            queryPar.put("date", date);
        }
        return minDate;
    }
}

