/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.application.impl.charge;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.hrmp.hrpi.common.enums.ChangeSourceEnum;

public class ChargePersonParam {
    private List<DynamicObject> chargePersons;
    private ChangeSourceEnum changeSourceEnum;
    private boolean isSynPosition;
    private boolean isGroupLog = true;
    private Map<String, Map<String, Object>> paramMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<String, Object> other;

    public ChargePersonParam(List<DynamicObject> chargePersons, ChangeSourceEnum changeSourceEnum, boolean isSynPosition) {
        this.chargePersons = chargePersons;
        this.changeSourceEnum = changeSourceEnum;
        this.isSynPosition = isSynPosition;
    }

    public ChargePersonParam(List<DynamicObject> chargePersons, List<Map<String, Object>> param, boolean isSynPosition) {
        this.chargePersons = chargePersons;
        this.isSynPosition = isSynPosition;
        if (!CollectionUtils.isEmpty(param)) {
            for (Map<String, Object> paramData : param) {
                Long adminOrgId = (Long)paramData.get("adminorg");
                Long depEmpId = (Long)paramData.get("depemp");
                Long employeeId = (Long)paramData.get("employee");
                if (adminOrgId != null && adminOrgId != 0L && depEmpId != null && depEmpId != 0L) {
                    this.paramMap.put(adminOrgId + "-" + depEmpId, paramData);
                    continue;
                }
                if (employeeId == null || employeeId == 0L) continue;
                this.paramMap.put(employeeId + "", paramData);
            }
        }
    }

    public ChargePersonParam(List<DynamicObject> chargePersons, ChangeSourceEnum changeSourceEnum, boolean isSynPosition, boolean isGroupLog) {
        this(chargePersons, changeSourceEnum, isSynPosition);
        this.isGroupLog = isGroupLog;
    }

    public ChargePersonParam() {
    }

    public Long getChangeSourceId(Object adminOrg, Object chargePerson, Object employee) {
        if (CollectionUtils.isEmpty(this.paramMap)) {
            return this.changeSourceEnum.getId();
        }
        Map<String, Object> dataMap = this.paramMap.get(this.getDynamicObjectId(adminOrg) + "-" + this.getDynamicObjectId(chargePerson));
        if (CollectionUtils.isEmpty(dataMap)) {
            dataMap = this.paramMap.get(this.getDynamicObjectId(employee) + "");
        }
        if (!CollectionUtils.isEmpty(dataMap)) {
            return (Long)dataMap.get("changesource");
        }
        return null;
    }

    private Long getDynamicObjectId(Object object) {
        Long id = object instanceof DynamicObject ? Long.valueOf(((DynamicObject)object).getLong("id")) : (Long)object;
        return id;
    }

    public List<DynamicObject> getChargePersons() {
        return this.chargePersons;
    }

    public void setChargePersons(List<DynamicObject> chargePersons) {
        this.chargePersons = chargePersons;
    }

    public ChangeSourceEnum getChangeSourceEnum() {
        return this.changeSourceEnum;
    }

    public void setChangeSourceEnum(ChangeSourceEnum changeSourceEnum) {
        this.changeSourceEnum = changeSourceEnum;
    }

    public boolean isSynPosition() {
        return this.isSynPosition;
    }

    public void setSynPosition(boolean synPosition) {
        this.isSynPosition = synPosition;
    }

    public Map<String, Object> getOther() {
        return this.other;
    }

    public void setOther(Map<String, Object> other) {
        this.other = other;
    }

    public boolean isGroupLog() {
        return this.isGroupLog;
    }

    public Map<String, Map<String, Object>> getParamMap() {
        return this.paramMap;
    }

    public void setParamMap(Map<String, Map<String, Object>> paramMap) {
        this.paramMap = paramMap;
    }
}

