/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.application.impl.charge;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.application.impl.charge.AddChargePersonStrategy;
import kd.hrmp.hrpi.business.application.impl.charge.ChargePersonService;
import kd.hrmp.hrpi.business.application.impl.charge.DiscardChargePersonStrategy;
import kd.hrmp.hrpi.business.application.impl.charge.ModifyChargePersonStrategy;
import kd.hrmp.hrpi.business.application.impl.charge.RemoveChargePersonStrategy;
import kd.hrmp.hrpi.common.HRPIChargePersonConstants;

public class ChargePersonServiceContext
implements HRPIChargePersonConstants {
    private static final Log logger = LogFactory.getLog(ChargePersonServiceContext.class);
    private Map<String, ChargePersonService> chargePersonServiceMap = Maps.newHashMapWithExpectedSize((int)16);
    private List<Map<String, Object>> chargePersonParam;

    private void initServiceMap() {
        this.chargePersonServiceMap.put("0", new AddChargePersonStrategy());
        this.chargePersonServiceMap.put("1", new RemoveChargePersonStrategy());
        this.chargePersonServiceMap.put("2", new ModifyChargePersonStrategy());
        this.chargePersonServiceMap.put("3", new DiscardChargePersonStrategy());
    }

    public ChargePersonServiceContext(List<Map<String, Object>> chargePersonParam) {
        this.chargePersonParam = chargePersonParam;
        this.initServiceMap();
    }

    public String validParam() {
        String errMsg = "";
        for (Map<String, Object> param : this.chargePersonParam) {
            Object effDt;
            String operateType = (String)param.get("operatetype");
            if (!"1".equals(operateType) || HRStringUtils.isEmpty((String)(errMsg = this.effDtValid(effDt = param.get("effdt"))))) continue;
            return errMsg;
        }
        return errMsg;
    }

    public List<Long> setChargePerson() {
        Map<String, List<Map>> operateTypeGroupMap = this.chargePersonParam.stream().filter(param -> param.get("operatetype") != null).collect(Collectors.groupingBy(param -> (String)param.get("operatetype")));
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        logger.info("ChargePersonServiceContext setChargePerson operateTypeGroupMap size:{}", (Object)operateTypeGroupMap.size());
        operateTypeGroupMap.forEach((operateType, param) -> {
            ChargePersonService chargePersonService = this.chargePersonServiceMap.get(operateType);
            if (chargePersonService != null) {
                logger.info("ChargePersonServiceContext chargePersonService type:{}", (Object)chargePersonService.getClass().getName());
                List<Long> ids = chargePersonService.setChargePerson((List<Map<String, Object>>)param);
                if (!CollectionUtils.isEmpty(ids)) {
                    result.addAll(ids);
                }
            }
        });
        return result;
    }

    private String effDtValid(Object effDt) {
        if (effDt == null) {
            return ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"ChargePersonServiceContext_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
        }
        Date today = HRDateTimeUtils.dateFormatDate((Date)new Date());
        if (((Date)effDt).after(today)) {
            return ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u5f53\u524d\u65e5\u671f", (String)"ChargePersonServiceContext_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
        }
        return "";
    }
}

