/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.application.impl.charge;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.hrmp.hrpi.business.application.impl.charge.AbstractChargePersonStrategy;
import kd.hrmp.hrpi.business.application.impl.charge.ChargePersonParam;
import kd.hrmp.hrpi.business.domian.service.HRPIServiceFactory;

public class DiscardChargePersonStrategy
extends AbstractChargePersonStrategy {
    @Override
    public List<Long> setChargePerson(List<Map<String, Object>> chargePersonParam) {
        logger.info("DiscardChargePersonStrategy setChargePerson begin!");
        if (!CollectionUtils.isEmpty(chargePersonParam)) {
            DynamicObject[] chargePersonArr = this.getChargePersonByPersonAndAdminOrg(chargePersonParam);
            if (chargePersonArr == null || chargePersonArr.length == 0) {
                return null;
            }
            logger.info("Discard Charge Person size:" + chargePersonArr.length);
            for (DynamicObject chargePerson2 : chargePersonArr) {
                long adminOrgId = chargePerson2.getLong("adminorg.id");
                long chargePersonId = chargePerson2.getLong("chargeperson.id");
                long employeeId = chargePerson2.getLong("chargeperson.employee.id");
                String paramKey1 = this.buildParamKey(adminOrgId, chargePersonId, 0L);
                String paramKey2 = this.buildParamKey(0L, 0L, employeeId);
                if (!this.paramMap.containsKey(paramKey1) && !this.paramMap.containsKey(paramKey2)) continue;
                this.chargePersonList.add(chargePerson2);
            }
            if (!CollectionUtils.isEmpty((Collection)this.chargePersonList)) {
                this.chargeApplication.discardChargePerson(new ChargePersonParam((List<DynamicObject>)this.chargePersonList, chargePersonParam, false));
                HRPIServiceFactory.synChargeToUserService.removeCharge(this.chargePersonList);
            }
        }
        return this.chargePersonList.stream().map(chargePerson -> chargePerson.getLong("id")).collect(Collectors.toList());
    }

    @Override
    protected DynamicObject[] getChargePersonByPersonAndAdminOrg(List<Map<String, Object>> chargePersonParam) {
        if (CollectionUtils.isEmpty(chargePersonParam)) {
            return null;
        }
        HashSet adminOrgIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet depEmpIds = Sets.newHashSetWithExpectedSize((int)16);
        for (Map<String, Object> param : chargePersonParam) {
            Long adminOrgId = (Long)param.get("adminorg");
            Long depEmpId = (Long)param.get("depemp");
            adminOrgIds.add(adminOrgId);
            depEmpIds.add(depEmpId);
            this.paramMap.put(adminOrgId + "-" + depEmpId, param);
        }
        DynamicObject[] chargePersonDynArr = this.chargePersonRepository.loadEffingByPersonAndAdminOrg(depEmpIds, adminOrgIds);
        ArrayList chargePersonDynList = Lists.newArrayListWithExpectedSize((int)chargePersonDynArr.length);
        for (DynamicObject chargePerson : chargePersonDynArr) {
            Boolean isExcludeManual;
            String paramKey = chargePerson.getLong("adminorg.id") + "-" + chargePerson.getLong("chargeperson.id");
            Map paramMap = (Map)this.paramMap.get(paramKey);
            if (Objects.isNull(paramMap) || (isExcludeManual = paramMap.getOrDefault("isexcludemanual", false)).booleanValue() && 1040L == chargePerson.getLong("changesource.id")) continue;
            chargePersonDynList.add(chargePerson);
        }
        return chargePersonDynList.toArray(new DynamicObject[0]);
    }
}

