/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.repository;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.service.IBlackListLogService;
import kd.hrmp.hrpi.business.domian.service.impl.BlackListLogServiceImpl;
import kd.hrmp.hrpi.common.enums.BlackListPageEnum;

public class BlackListForPageUtils {
    private static final BlackListForPageUtils blackListUtils = new BlackListForPageUtils();
    private static final String MAIL_REG = "^\\w{1,500}([\\._\\\\-]{0,500}\\w){0,500}@(\\w+[\\w|\\-]{0,500}\\.){1,63}[\\w|\\-]+$";
    private static final Pattern PATTERN = Pattern.compile("^\\w{1,500}([\\._\\\\-]{0,500}\\w){0,500}@(\\w+[\\w|\\-]{0,500}\\.){1,63}[\\w|\\-]+$");

    public static BlackListForPageUtils getInstance() {
        return blackListUtils;
    }

    public void showForm(FormShowParameter formShowParameter, IFormView view, CloseCallBack closeCallBack) {
        if (!HRObjectUtils.isEmpty((Object)closeCallBack)) {
            formShowParameter.setCloseCallBack(closeCallBack);
        }
        view.showForm(formShowParameter);
    }

    public FormShowParameter showFormParam(ShowType showType, String formId, Map<String, Object> customParam, String targetKey) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.getOpenStyle().setShowType(showType);
        if (HRStringUtils.isNotEmpty((String)targetKey)) {
            formShowParameter.getOpenStyle().setTargetKey(targetKey);
        }
        if (!CollectionUtils.isEmpty(customParam)) {
            Set<Map.Entry<String, Object>> entries = customParam.entrySet();
            entries.stream().forEach(entry -> formShowParameter.setCustomParam((String)entry.getKey(), entry.getValue()));
        }
        return formShowParameter;
    }

    public Map<String, Object> saveBlackListLog(String operationType, DynamicObject dy, DynamicObject sourceDy) {
        Map<String, Object> map = this.assembleLogParams(operationType, dy, sourceDy);
        IBlackListLogService blackListLogService = BlackListLogServiceImpl.getInstance();
        Map<String, Object> resultMap = blackListLogService.saveBlackListLog(map);
        return resultMap;
    }

    public static boolean isEmail(String email) {
        Matcher m = PATTERN.matcher(email);
        return m.matches();
    }

    private Map<String, Object> assembleLogParams(String operationType, DynamicObject dynamicObject, DynamicObject sourceDy) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("operation", operationType);
        paramMap.put("creator", RequestContext.get().getCurrUserId());
        paramMap.put("createtime", new Date());
        paramMap.put("personname", dynamicObject.getString("name"));
        paramMap.put("personnumber", dynamicObject.getString("number"));
        paramMap.put("issysperson", dynamicObject.getBoolean("issysperson"));
        paramMap.put("source", dynamicObject.getString("datasource"));
        paramMap.put("empnumber", dynamicObject.getString("empnumber"));
        switch (operationType) {
            case "1": {
                paramMap.put("operationreason", dynamicObject.getString("toreason.name"));
                paramMap.put("description", dynamicObject.getString("reasondetail"));
                break;
            }
            case "2": {
                paramMap.put("operationreason", HRStringUtils.isEmpty((String)sourceDy.getString("removereason.name")) ? sourceDy.getString("rmreasonstr") : sourceDy.getString("removereason.name"));
                paramMap.put("description", sourceDy.getString("rmreasondetail"));
                break;
            }
            case "3": {
                paramMap.put("operationreason", ResManager.loadKDString((String)"\u4fee\u6539", (String)"BlackListForPageUtils_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
                paramMap.put("description", dynamicObject.getString("modifyreason"));
                List<Map<String, String>> mapList = this.assembleModifyEntry(dynamicObject, sourceDy);
                paramMap.put("entryentity", mapList);
            }
        }
        return paramMap;
    }

    private List<Map<String, String>> assembleModifyEntry(DynamicObject dataEntity, DynamicObject sourceDy) {
        List<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        boolean isSysPerson = dataEntity.getBoolean("issysperson");
        if (isSysPerson) {
            resultList = this.changedField("toreason", dataEntity, sourceDy, resultList, Boolean.TRUE);
            resultList = this.changedField("reasondetail", dataEntity, sourceDy, resultList, Boolean.FALSE);
        }
        if (!isSysPerson) {
            resultList = this.changedField("name", dataEntity, sourceDy, resultList, Boolean.FALSE);
            resultList = this.changedField("phone", dataEntity, sourceDy, resultList, Boolean.FALSE);
            resultList = this.changedField("email", dataEntity, sourceDy, resultList, Boolean.FALSE);
            resultList = this.changedField("gender", dataEntity, sourceDy, resultList, Boolean.TRUE);
            resultList = this.changedField("nation", dataEntity, sourceDy, resultList, Boolean.TRUE);
            resultList = this.changedField("toreason", dataEntity, sourceDy, resultList, Boolean.TRUE);
            resultList = this.changedField("reasondetail", dataEntity, sourceDy, resultList, Boolean.FALSE);
            DynamicObjectCollection oriEntryEntity = sourceDy.getDynamicObjectCollection("entryentity");
            StringBuilder oriCardInfo = new StringBuilder();
            StringBuilder newCardInfo = new StringBuilder();
            DynamicObjectCollection newEntryEntity = dataEntity.getDynamicObjectCollection("entryentity");
            if (oriEntryEntity.size() != 0) {
                for (DynamicObject dy : oriEntryEntity) {
                    if (dy.getBoolean("ismaincard")) {
                        String mainCardType = dy.getString("cardtype.name");
                        String mainCardNum = dy.getString("cardnumber").trim();
                        String oriMainCardInfo = mainCardType + "-" + mainCardNum;
                        if (newEntryEntity.size() != 0) {
                            for (DynamicObject dynamicObject : newEntryEntity) {
                                if (dynamicObject.getBoolean("ismaincard")) {
                                    String newMainCardType = dynamicObject.getString("cardtype.name");
                                    String newMainCardNum = dynamicObject.getString("cardnumber").trim();
                                    String newMainCardInfo = newMainCardType + "-" + newMainCardNum;
                                    this.compareIsChange(oriMainCardInfo, newMainCardInfo, "maincardtype", resultList);
                                    continue;
                                }
                                String cardTypeName = dynamicObject.getString("cardtype.name");
                                String cardNum = dynamicObject.getString("cardnumber").trim();
                                String cardInfo = cardTypeName + "-" + cardNum;
                                newCardInfo.append(cardInfo);
                            }
                            continue;
                        }
                        this.compareIsChange(oriMainCardInfo, null, "maincardtype", resultList);
                        continue;
                    }
                    String cardTypeName = dy.getString("cardtype.name");
                    String cardNum = dy.getString("cardnumber").trim();
                    String cardInfo = cardTypeName + "-" + cardNum;
                    oriCardInfo.append(cardInfo);
                }
                this.compareIsChange(oriCardInfo.toString(), newCardInfo.toString(), "cardtype", resultList);
            } else {
                for (DynamicObject dynamicObject : newEntryEntity) {
                    if (dynamicObject.getBoolean("ismaincard")) {
                        String newMainCardType = dynamicObject.getString("cardtype.name");
                        String newMainCardNum = dynamicObject.getString("cardnumber").trim();
                        String newMainCardInfo = newMainCardType + "-" + newMainCardNum;
                        this.compareIsChange(null, newMainCardInfo, "maincardtype", resultList);
                        continue;
                    }
                    String cardTypeName = dynamicObject.getString("cardtype.name");
                    String cardNum = dynamicObject.getString("cardnumber").trim();
                    String cardInfo = cardTypeName + "-" + cardNum;
                    newCardInfo.append(cardInfo);
                }
                this.compareIsChange(null, newCardInfo.toString(), "cardtype", resultList);
            }
        }
        return resultList;
    }

    private List<Map<String, String>> changedField(String field, DynamicObject dataEntity, DynamicObject sourceDy, List<Map<String, String>> list, Boolean isBaseData) {
        StringBuilder fieldName = new StringBuilder(field);
        if (isBaseData.booleanValue()) {
            fieldName.append(".name");
        }
        String afterName = dataEntity.getString(fieldName.toString());
        String beforeName = sourceDy.getString(fieldName.toString());
        this.compareIsChange(beforeName, afterName, field, list);
        return list;
    }

    private void compareIsChange(String oriValue, String updateValue, String field, List<Map<String, String>> list) {
        if (!HRStringUtils.equals((String)updateValue, (String)oriValue)) {
            HashMap<String, String> map = new HashMap<String, String>(3);
            map.put("fieldname", BlackListPageEnum.getValueByKey((String)field));
            map.put("updatebefore", oriValue);
            map.put("updateafter", updateValue);
            list.add(map);
        }
    }
}

