/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.repository;

import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class CommonQueryRepository {
    private CommonQueryRepository() {
    }

    public static CommonQueryRepository getInstance() {
        return CommonQueryInstance.INSTANCE;
    }

    public DynamicObject[] queryColsInfoByIds(String entityName, Set<String> cols, Set<Long> idSet) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityName);
        return hrBaseServiceHelper.query(StringUtils.join((Object[])cols.toArray(), (String)","), new QFilter[]{new QFilter("id", "in", idSet)});
    }

    public DynamicObject loadInfoById(String entityName, Long id) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityName);
        return hrBaseServiceHelper.loadDynamicObject(new QFilter[]{new QFilter("id", "=", (Object)id)});
    }

    public DynamicObject[] loadInfoByIds(String entityName, Set<Long> idSet) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityName);
        return hrBaseServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", idSet)});
    }

    public DynamicObject[] queryColsInfoByFilter(String entityName, Set<String> cols, QFilter filter) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityName);
        return hrBaseServiceHelper.query(StringUtils.join((Object[])cols.toArray(), (String)","), new QFilter[]{filter});
    }

    public DynamicObject[] queryInfoByBoId(String entityName, Set<String> cols, Long boId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityName);
        QFilter boIdFilter = new QFilter("boid", "=", (Object)boId);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"0", "1"});
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        return hrBaseServiceHelper.query(StringUtils.join((Object[])cols.toArray(), (String)","), new QFilter[]{boIdFilter, dataStatusFilter, isCurrentVersionFilter});
    }

    public DynamicObject[] queryInfoBySourceVId(String entityName, Set<String> cols, Long hisVId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityName);
        QFilter sourceVIdFilter = new QFilter("sourcevid", "=", (Object)hisVId);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"-4"});
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        return hrBaseServiceHelper.query(StringUtils.join((Object[])cols.toArray(), (String)","), new QFilter[]{sourceVIdFilter, dataStatusFilter, isCurrentVersionFilter}, "createtime desc");
    }

    public DynamicObject queryDataByHisId(String entityName, Long hisId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityName);
        return hrBaseServiceHelper.queryOne(new QFilter[]{new QFilter("id", "=", (Object)hisId)});
    }

    private static class CommonQueryInstance {
        private static CommonQueryRepository INSTANCE = new CommonQueryRepository();

        private CommonQueryInstance() {
        }
    }
}

