/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.repository;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.common.HRPIAttachReviseConstansts;
import org.apache.commons.collections4.CollectionUtils;

public class HRPIAttachReviseConRepository
implements HRPIAttachReviseConstansts {
    private static final Log LOGGER = LogFactory.getLog(HRPIAttachReviseConRepository.class);
    protected static final HRBaseServiceHelper bosEntityMetaServiceHelper = new HRBaseServiceHelper("bos_entitymeta");
    protected static final HRBaseServiceHelper attachReviseConServiceHelper = new HRBaseServiceHelper("hrpi_attachrevisecon");

    public static HRBaseServiceHelper getBosEntityMetaHelper() {
        return bosEntityMetaServiceHelper;
    }

    public static HRBaseServiceHelper getAttachReviseConHelper() {
        return attachReviseConServiceHelper;
    }

    public static DynamicObject getEntityMetaIdOfEntityName(String entityName) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        qFilterList.add(new QFilter("number", "=", (Object)entityName));
        qFilterList.add(new QFilter("enabled", "=", (Object)"1"));
        try (TXHandle txHandle = TX.notSupported();){
            DynamicObject dynamicObject = bosEntityMetaServiceHelper.queryOriginalOne("id", qFilterList.toArray(new QFilter[0]));
            return dynamicObject;
        }
    }

    public static Map<String, List<String>> getReviseConfigByEntityMetaId(String entityMetaId) {
        DynamicObjectCollection dynamicObjectCollection;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        qFilterList.add(new QFilter("entitymeta", "=", (Object)entityMetaId));
        DynamicObject reviseConfigDy = attachReviseConServiceHelper.loadDynamicObject(qFilterList.toArray(new QFilter[0]));
        Map<String, List<String>> fieldTypeResultMap = new HashMap<String, List<String>>(16);
        if (reviseConfigDy != null && CollectionUtils.isNotEmpty((Collection)(dynamicObjectCollection = reviseConfigDy.getDynamicObjectCollection("entryentity")))) {
            fieldTypeResultMap = dynamicObjectCollection.stream().filter(dynamicObject -> HRStringUtils.equals((String)"1", (String)dynamicObject.getString("datastatus"))).collect(Collectors.groupingBy(dy -> dy.getString("fieldtype"))).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, row -> ((List)row.getValue()).stream().map(entry -> entry.getString("fieldtag")).collect(Collectors.toList())));
        }
        return fieldTypeResultMap;
    }

    public static List<String> getAllFieldsByEntityName(String entityName) {
        QFilter metadataFilter = new QFilter("entitymeta.number", "=", (Object)entityName);
        DynamicObject dyn = attachReviseConServiceHelper.queryOne("entryentity.fieldtag", new QFilter[]{metadataFilter});
        ArrayList fieldIdentification = Lists.newArrayListWithExpectedSize((int)16);
        DynamicObjectCollection entryEntityCol = dyn.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryEntityCol) {
            fieldIdentification.add(entry.getString("fieldtag"));
        }
        return fieldIdentification;
    }

    public static List<String> getFieldsByEntityNameAndType(String entityName, List<Long> fieldType) {
        QFilter metadataFilter = new QFilter("entitymeta.number", "=", (Object)entityName);
        QFilter fieldTypeFilter = new QFilter("entryentity.newfieldtype", "in", fieldType);
        DynamicObject dyn = attachReviseConServiceHelper.queryOne("entryentity.fieldtag", new QFilter[]{metadataFilter, fieldTypeFilter});
        ArrayList fieldIdentification = Lists.newArrayListWithExpectedSize((int)16);
        DynamicObjectCollection entryEntityCol = dyn.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryEntityCol) {
            fieldIdentification.add(entry.getString("fieldtag"));
        }
        return fieldIdentification;
    }

    private static String getMetadataIdByEntityName(String entityName) {
        QFilter numberFilter = new QFilter("number", "=", (Object)entityName);
        QFilter enableFilter = new QFilter("enabled", "=", (Object)"1");
        DynamicObject bosEntityMetaDyn = bosEntityMetaServiceHelper.queryOriginalOne("id", new QFilter[]{numberFilter, enableFilter});
        return bosEntityMetaDyn.getString("id");
    }
}

