/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.repository;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class HRPIBlackListRepository {
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("hrpi_blacklist");
    private static final HRPIBlackListRepository REPOSITORY = new HRPIBlackListRepository();
    private static final Log LOGGER = LogFactory.getLog(HRPIBlackListRepository.class);

    private HRPIBlackListRepository() {
    }

    public static HRPIBlackListRepository getInstance() {
        return REPOSITORY;
    }

    public DynamicObject generateEmptyDy() {
        return SERVICE_HELPER.generateEmptyDynamicObject();
    }

    public List<DynamicObject> assembleDyEdit(List<Map<String, Object>> paramList, Map<String, String> operateMap, Set<String> rightSet, Map<String, DynamicObject> dyMap) {
        ArrayList<DynamicObject> dyList = new ArrayList<DynamicObject>(paramList.size());
        for (Map<String, Object> paramMap : paramList) {
            String number = String.valueOf(paramMap.get("number"));
            QFilter numFilter = new QFilter("number", "=", (Object)number);
            try {
                DynamicObject dynamicObject = SERVICE_HELPER.loadDynamicObject(new QFilter[]{numFilter});
                if (HRObjectUtils.isEmpty((Object)dynamicObject)) {
                    operateMap.put(number, "according to the number,can not find data in db");
                    rightSet.remove(number);
                    continue;
                }
                DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
                DynamicObjectCollection cloneEntry = (DynamicObjectCollection)HRObjectUtils.clone((Object)entryentity);
                cloneEntry.clear();
                for (DynamicObject dy : entryentity) {
                    DynamicObject clone = (DynamicObject)HRObjectUtils.clone((Object)dy);
                    cloneEntry.add((Object)clone);
                }
                DynamicObject cloneDy = (DynamicObject)HRObjectUtils.clone((Object)dynamicObject);
                cloneDy.set("entryentity", (Object)cloneEntry);
                dyMap.put(dynamicObject.getString("number"), cloneDy);
                this.assembleDyByMap(paramMap, dynamicObject, "3");
                dyList.add(dynamicObject);
            }
            catch (Exception ex) {
                LOGGER.error("HRPIBlackListRepository.assembleDy(List, Map, Map).error", (Throwable)ex);
                operateMap.put(number, "according to the number,find more than one data in db");
                rightSet.remove(number);
            }
        }
        return dyList;
    }

    private void assembleDyByMap(Map<String, Object> paramMap, DynamicObject dynamicObject, String operateType) {
        if (HRObjectUtils.isEmpty((Object)paramMap.get("number"))) {
            String number = CodeRuleServiceHelper.getNumber((String)"hpfs_blacklist", (DynamicObject)dynamicObject, null);
            LOGGER.info("coderule.generate.number.for.HRPIBlackListRepository.assembleDyByMap.is={}={}", (Object)number, (Object)new Date());
            dynamicObject.set("number", (Object)number);
        } else {
            String number = String.valueOf(paramMap.get("number"));
            LOGGER.info("HRPIBlackListRepository.assembleDyByMap.number={}={}", (Object)number, (Object)new Date());
            dynamicObject.set("number", (Object)number);
        }
        this.setField(dynamicObject, paramMap, "empnumber");
        this.setField(dynamicObject, paramMap, "name");
        this.setField(dynamicObject, paramMap, "phone");
        this.setField(dynamicObject, paramMap, "email");
        this.setField(dynamicObject, paramMap, "reasondetail");
        this.setField(dynamicObject, paramMap, "datasource");
        this.setField(dynamicObject, paramMap, "toreason");
        this.setField(dynamicObject, paramMap, "nation");
        this.setField(dynamicObject, paramMap, "gender");
        this.setField(dynamicObject, paramMap, "employee");
        this.setField(dynamicObject, paramMap, "adminororg");
        this.setField(dynamicObject, paramMap, "adminorg");
        this.setField(dynamicObject, paramMap, "position");
        this.setField(dynamicObject, paramMap, "job");
        this.setField(dynamicObject, paramMap, "quitreason");
        this.setField(dynamicObject, paramMap, "quittype");
        this.setField(dynamicObject, paramMap, "quitdate");
        dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
        if ("1".equals(operateType)) {
            dynamicObject.set("createtime", HRObjectUtils.isEmpty((Object)paramMap.get("createtime")) ? new Date() : paramMap.get("createtime"));
            dynamicObject.set("creator", HRObjectUtils.isEmpty((Object)paramMap.get("creator")) ? Long.valueOf(RequestContext.get().getCurrUserId()) : paramMap.get("creator"));
        }
        dynamicObject.set("issysperson", (Object)(!HRObjectUtils.isEmpty((Object)paramMap.get("issysperson")) && "1".equals(String.valueOf(paramMap.get("issysperson"))) ? Boolean.TRUE : Boolean.FALSE));
        this.setCardInfo(dynamicObject, paramMap, operateType);
    }

    public List<DynamicObject> assembleDy(List<Map<String, Object>> paramList) {
        ArrayList<DynamicObject> dyList = new ArrayList<DynamicObject>(paramList.size());
        for (Map<String, Object> paramMap : paramList) {
            DynamicObject dynamicObject = SERVICE_HELPER.generateEmptyDynamicObject();
            this.assembleDyByMap(paramMap, dynamicObject, "1");
            dyList.add(dynamicObject);
        }
        return dyList;
    }

    public DynamicObject[] queryByFilter(String selectProperties, QFilter[] filters) {
        if (HRStringUtils.isEmpty((String)selectProperties)) {
            return SERVICE_HELPER.loadDynamicObjectArray(filters);
        }
        return SERVICE_HELPER.query(selectProperties, filters);
    }

    public DynamicObject queryOne(String selectProperties, QFilter[] filters) {
        if (HRStringUtils.isEmpty((String)selectProperties)) {
            return SERVICE_HELPER.loadDynamicObject(filters);
        }
        return SERVICE_HELPER.queryOne(selectProperties, filters);
    }

    public void delAttment(QFilter[] filters) {
        SERVICE_HELPER.deleteByFilter(filters);
    }

    public void saveAtt(DynamicObject[] atts) {
        SERVICE_HELPER.save(atts);
    }

    private void setField(DynamicObject dy, Map<String, Object> paramMap, String fieldKey) {
        if (!HRObjectUtils.isEmpty((Object)paramMap.get(fieldKey))) {
            if ("quitreason".equals(fieldKey) || "quittype".equals(fieldKey)) {
                dy.set(fieldKey + "id", paramMap.get(fieldKey));
                return;
            }
            dy.set(fieldKey, paramMap.get(fieldKey));
        }
    }

    private void setCardInfo(DynamicObject dynamicObject, Map<String, Object> paramMap, String operateType) {
        switch (operateType) {
            case "1": {
                this.setCardInfoForNew(dynamicObject, paramMap);
                break;
            }
            case "3": {
                this.setCardInfoForEdit(dynamicObject, paramMap);
                break;
            }
        }
    }

    private void setCardInfoForNew(DynamicObject dynamicObject, Map<String, Object> paramMap) {
        DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
        Object maincardtype = paramMap.get("maincardtype");
        Object maincardnumber = paramMap.get("maincardnumber");
        if (!HRObjectUtils.isEmpty((Object)maincardtype) && !HRObjectUtils.isEmpty((Object)maincardnumber) && (maincardtype instanceof DynamicObject || maincardtype instanceof Long) && maincardnumber instanceof String) {
            DynamicObject mainCardDy = entryentity.addNew();
            mainCardDy.set("cardtype", paramMap.get("maincardtype"));
            mainCardDy.set("cardnumber", paramMap.get("maincardnumber"));
            mainCardDy.set("ismaincard", (Object)Boolean.TRUE);
        }
        Object cardtype = paramMap.get("cardtype");
        Object cardnumber = paramMap.get("cardnumber");
        if (!HRObjectUtils.isEmpty((Object)cardtype) && !HRObjectUtils.isEmpty((Object)cardnumber) && (cardtype instanceof DynamicObject || cardtype instanceof Long) && cardnumber instanceof String) {
            DynamicObject cardDy = entryentity.addNew();
            cardDy.set("cardtype", cardtype);
            cardDy.set("cardnumber", cardnumber);
            cardDy.set("ismaincard", (Object)Boolean.FALSE);
        }
    }

    private void setCardInfoForEdit(DynamicObject dynamicObject, Map<String, Object> paramMap) {
        DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
        Iterator iterator = entryentity.iterator();
        Object maincardtype = paramMap.get("maincardtype");
        Object maincardnumber = paramMap.get("maincardnumber");
        if (!HRObjectUtils.isEmpty((Object)maincardtype) && !HRObjectUtils.isEmpty((Object)maincardnumber) && (maincardtype instanceof DynamicObject || maincardtype instanceof Long) && maincardnumber instanceof String) {
            while (iterator.hasNext()) {
                DynamicObject entryDy = (DynamicObject)iterator.next();
                if (!entryDy.getBoolean("ismaincard")) continue;
                iterator.remove();
            }
            DynamicObject mainCardDy = entryentity.addNew();
            mainCardDy.set("cardtype", paramMap.get("maincardtype"));
            mainCardDy.set("cardnumber", paramMap.get("maincardnumber"));
            mainCardDy.set("ismaincard", (Object)Boolean.TRUE);
        }
        Object cardtype = paramMap.get("cardtype");
        Object cardnumber = paramMap.get("cardnumber");
        if (!HRObjectUtils.isEmpty((Object)cardtype) && !HRObjectUtils.isEmpty((Object)cardnumber) && cardtype instanceof DynamicObject && cardnumber instanceof String) {
            while (iterator.hasNext()) {
                DynamicObject entryDy = (DynamicObject)iterator.next();
                DynamicObject cardTypeDy = (DynamicObject)cardtype;
                if (entryDy.getLong("cardtype.id") != cardTypeDy.getLong("id")) continue;
                entryDy.set("cardtype", cardtype);
                entryDy.set("cardnumber", cardnumber);
                entryDy.set("ismaincard", (Object)Boolean.FALSE);
                return;
            }
            DynamicObject cardDy = entryentity.addNew();
            cardDy.set("cardtype", cardtype);
            cardDy.set("cardnumber", cardnumber);
            cardDy.set("ismaincard", (Object)Boolean.FALSE);
        }
    }
}

