/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.repository;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;

public class HRPIBosUserRepository {
    private static final Log logger = LogFactory.getLog(HRPIBosUserRepository.class);
    protected static final HRBaseServiceHelper bosUserServiceHelper = new HRBaseServiceHelper("bos_user");
    protected static final HRBaseServiceHelper personUserRelServiceHelper = new HRBaseServiceHelper("hrpi_personuserrel");
    protected static final HRBaseServiceHelper syncLogServiceHelper = new HRBaseServiceHelper("hrpi_synclog");

    public static HRBaseServiceHelper getSyncLogHelper() {
        return syncLogServiceHelper;
    }

    public static HRBaseServiceHelper getPersonUserRelHelper() {
        return personUserRelServiceHelper;
    }

    public static HRBaseServiceHelper getBosUserHelper() {
        return bosUserServiceHelper;
    }

    public static Object[] saveUser(DynamicObjectCollection dys) {
        return personUserRelServiceHelper.save(dys);
    }

    public static DynamicObject[] getBosUser(String selectProperties, List<String> numbers, QFilter qFilter) {
        QFilter qf = new QFilter("number", "in", numbers);
        QFilter statusQf = new QFilter("isforbidden", "=", (Object)"0");
        QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
        if (qFilter != null) {
            qf.and(qFilter);
        }
        return bosUserServiceHelper.query(selectProperties, new QFilter[]{qf, qFilter, statusQf, statusFilter});
    }

    public static DynamicObject[] getBosUserById(String selectProperties, List<Long> pkId) {
        QFilter qf = new QFilter("id", "in", pkId);
        QFilter statusQf = new QFilter("enable", "=", (Object)"1");
        return bosUserServiceHelper.query(selectProperties, new QFilter[]{qf, statusQf});
    }

    public static DynamicObject[] getBosUserAllInfoById(List<Long> pkId) {
        QFilter qf = new QFilter("id", "in", pkId);
        return bosUserServiceHelper.loadDynamicObjectArray(new QFilter[]{qf});
    }

    public static DynamicObject[] getBosUserAllInfoByCustomerFilter(QFilter customerQFilter) {
        return bosUserServiceHelper.loadDynamicObjectArray(new QFilter[]{customerQFilter});
    }

    public static DynamicObject[] getPersonUserRel(String type, List<Long> personIds, String statusType) {
        QFilter qf = null;
        if ("person".equals(type)) {
            qf = new QFilter(type, "in", personIds);
        } else if ("user".equals(type)) {
            qf = new QFilter(type, "in", personIds);
        }
        if ("disableupdate".equals(statusType) || "userupdate".equals(statusType) || "userdisable".equals(statusType) || "personuserreldisable".equals(statusType)) {
            return personUserRelServiceHelper.loadDynamicObjectArray(new QFilter[]{qf});
        }
        QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
        return personUserRelServiceHelper.loadDynamicObjectArray(new QFilter[]{qf, statusFilter});
    }

    public static DynamicObject[] getPersonUserRelBySynType(String type, List<Long> personIds, String synType) {
        QFilter qf = null;
        if ("person".equals(type)) {
            qf = new QFilter(type, "in", personIds);
        } else if ("user".equals(type)) {
            qf = new QFilter(type, "in", personIds);
        }
        QFilter statusFilter = null;
        statusFilter = "back_quit".equals(synType) || "enble_bos_user".equals(synType) || "disble_bos_user".equals(synType) ? new QFilter("enable", "=", (Object)"0") : new QFilter("enable", "=", (Object)"1");
        return personUserRelServiceHelper.loadDynamicObjectArray(new QFilter[]{qf, statusFilter});
    }

    public static DynamicObject[] getBosUserByIdAndSyn(String selectProperties, List<Long> pkId, String synType) {
        QFilter qf = new QFilter("id", "in", pkId);
        if ("back_join".equals(synType)) {
            qf.and(new QFilter("enable", "=", (Object)"1"));
        }
        return bosUserServiceHelper.query(selectProperties, new QFilter[]{qf});
    }

    public static DynamicObject[] getPersonIdsByUserId(List<Long> userId) {
        QFilter qf = new QFilter("user", "in", userId);
        QFilter enableQF = QFilterUtil.getEnable();
        return personUserRelServiceHelper.queryOriginalArray("personindexid,mid,user,employee,person,cmpemp,createtime", new QFilter[]{qf, enableQF});
    }

    public static DynamicObject[] getRelByPersonIds(List<Long> personIds) {
        QFilter qf = new QFilter("person", "in", personIds);
        QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
        return personUserRelServiceHelper.queryOriginalArray("personindexid,mid,user,employee,person,cmpemp", new QFilter[]{qf, statusFilter});
    }

    public static DynamicObject[] getUserIdByPersonInfo(QFilter qFilter) {
        return personUserRelServiceHelper.queryOriginalArray("id,personindexid,mid,user,employee,person,cmpemp", new QFilter[]{qFilter});
    }

    public static DynamicObject[] getUserRelateByPersonInfo(QFilter qFilter) {
        return personUserRelServiceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public static void saveSyncLog(DynamicObjectCollection dynamicObjects) {
        syncLogServiceHelper.save(dynamicObjects);
    }

    public static DynamicObject[] getSyncLog(long id, int batchCount) {
        QFilter qFilter = new QFilter("id", ">", (Object)id);
        QFilter qf = new QFilter("trytime", "<=", (Object)2);
        QFilter statusFilter = new QFilter("status", "=", (Object)"0");
        return syncLogServiceHelper.query("id,creatorid,createtime,number,trytime,status,param,rtparam,modifierid,modifytime,name,synctype", new QFilter[]{qf, statusFilter, qFilter}, "id", batchCount);
    }

    public static DynamicObject[] getSyncLogByFilter(List<String> nameList, List<String> numberList) {
        QFilter numberFilter = new QFilter("number", "in", numberList);
        QFilter nameFilter = new QFilter("name", "in", nameList);
        Date date = HRDateTimeUtils.addDay((Date)new Date(), (long)-4L);
        QFilter qFilter = new QFilter("createtime", ">=", (Object)date);
        return syncLogServiceHelper.loadDynamicObjectArray(new QFilter[]{numberFilter, nameFilter, qFilter});
    }

    public static DynamicObject[] getSyncLogByIds(List<Long> pkIds) {
        QFilter qf = new QFilter("id", "in", pkIds);
        return syncLogServiceHelper.loadDynamicObjectArray(new QFilter[]{qf});
    }

    public static DynamicObject[] getBosUserInfo(QFilter[] filters) {
        return bosUserServiceHelper.query("number,idcard,phone,email,name,isforbidden", filters);
    }

    public static DynamicObject[] getBosUserInfoOrig(QFilter[] filters) {
        return bosUserServiceHelper.queryOriginalArray("number,id", filters);
    }

    public static DynamicObject[] getBosUserByTerm(String selectProperties, List<String> numbers, List<String> nameList, String filterField, String otherFilterField) {
        QFilter qf = new QFilter(filterField, "in", numbers);
        QFilter nameFilter = new QFilter(otherFilterField, "in", nameList);
        QFilter statusQf = new QFilter("enable", "=", (Object)"1");
        return bosUserServiceHelper.query(selectProperties, new QFilter[]{qf, nameFilter, statusQf});
    }
}

