/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.repository;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hrmp.hrpi.business.domian.repository.HRPIBaseRepository;

public class HRPIChargePersonRepository
extends HRPIBaseRepository {
    public HRPIChargePersonRepository() {
        super("hrpi_chargeperson");
    }

    public static HRPIChargePersonRepository getInstance() {
        return ChargePersonInstance.INSTANCE;
    }

    public DynamicObject[] queryEffChargeByOrgId(String selectField, List<Long> adminOrgId, Date queryDate) {
        QFilter filter = new QFilter("adminorg", "in", adminOrgId);
        filter.and("effdt", "<=", (Object)queryDate);
        filter.and("leffdt", ">", (Object)queryDate);
        filter.and("datastatus", "=", (Object)"1");
        return this.serviceHelper.query(selectField, new QFilter[]{filter});
    }

    public DynamicObject[] queryEffChargeByPersonId(String selectField, List<Long> personIds, Date queryDate) {
        QFilter filter = new QFilter("chargeperson.person", "in", personIds);
        filter.and("effdt", "<=", (Object)queryDate);
        filter.and("leffdt", ">", (Object)queryDate);
        filter.and("datastatus", "in", (Object)new String[]{"1", "2"});
        return this.serviceHelper.query(selectField, new QFilter[]{filter});
    }

    public DynamicObject[] queryEffChargeByPersonAndOrgAndDate(String selectField, Collection<Long> personIdCollection, Date minDate, Date maxDate, Collection<Long> adminOrgIdCollection) {
        QFilter effDtFilter = new QFilter("effdt", "<=", (Object)maxDate).and("leffdt", ">=", (Object)minDate);
        QFilter personIdFilter = new QFilter("chargeperson.person.id", "in", personIdCollection);
        QFilter adminOrgIdFilter = new QFilter("adminorg.id", "in", adminOrgIdCollection);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2"});
        return this.serviceHelper.query(selectField, new QFilter[]{dataStatusFilter, personIdFilter, adminOrgIdFilter, effDtFilter});
    }

    public DynamicObject[] queryPastChargeByOrgId(String selectField, List<Long> adminOrgId, Date queryDate) {
        QFilter filter = new QFilter("adminorg.id", "in", adminOrgId);
        filter.and("effdt", "<=", (Object)queryDate);
        filter.and("datastatus", "in", (Object)new String[]{"1", "2"});
        return this.serviceHelper.query(selectField, new QFilter[]{filter});
    }

    public DynamicObject[] loadEffByDepEmp(Set<Long> depEmpSet) {
        QFilter depEmpFilter = new QFilter("chargeperson", "in", depEmpSet);
        QFilter effectingFilter = new QFilter("datastatus", "=", (Object)"1");
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{depEmpFilter, effectingFilter});
    }

    public DynamicObject[] loadEffByDepEmp(Set<Long> depEmpSet, long adminOrgId) {
        QFilter depEmpFilter = new QFilter("chargeperson", "in", depEmpSet);
        QFilter effectingFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter adminFilter = new QFilter("adminorg.id", "=", (Object)adminOrgId);
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{depEmpFilter, effectingFilter, adminFilter});
    }

    public DynamicObject[] loadEffByPersonAndAdminOrg(Set<Long> depEmpIdSet, Set<Long> adminOrgId) {
        QFilter adminOrgFilter = new QFilter("adminorg.id", "in", adminOrgId);
        QFilter idFilter = new QFilter("chargeperson.id", "in", depEmpIdSet);
        QFilter effectingFilter = new QFilter("datastatus", "=", (Object)"1");
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter, adminOrgFilter, effectingFilter});
    }

    public DynamicObject[] loadEffingByPersonAndAdminOrg(Set<Long> depEmpIdSet, Set<Long> adminOrgId) {
        QFilter adminOrgFilter = new QFilter("adminorg.id", "in", adminOrgId);
        QFilter idFilter = new QFilter("chargeperson.id", "in", depEmpIdSet);
        QFilter effectingFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2"});
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter, adminOrgFilter, effectingFilter});
    }

    public DynamicObject loadOneById(long id) {
        return this.serviceHelper.loadSingle((Object)id);
    }

    public DynamicObject[] queryOriginalByIdList(String selectFields, List<Long> idList) {
        QFilter idFilter = new QFilter("id", "in", idList);
        return this.serviceHelper.queryOriginalArray(selectFields, new QFilter[]{idFilter});
    }

    public DynamicObject[] queryChargeByDepEmpAndAdminOrg(String selectField, Set<Long> depEmpIdSet, Set<Long> adminOrgId, QFilter others) {
        QFilter adminOrgFilter = new QFilter("adminorg.id", "in", adminOrgId);
        QFilter idFilter = new QFilter("chargeperson", "in", depEmpIdSet);
        String[] dataStatus = new String[]{"1", "2"};
        QFilter effectingFilter = new QFilter("datastatus", "in", (Object)dataStatus);
        return this.serviceHelper.query(selectField, new QFilter[]{idFilter, adminOrgFilter, effectingFilter, others});
    }

    public DynamicObject[] queryOriginalChargeByDepEmps(String selectFields, Set<Long> depEmpSet) {
        QFilter depEmpFilter = new QFilter("chargeperson", "in", depEmpSet);
        QFilter effectingFilter = new QFilter("datastatus", "=", (Object)"1");
        return this.serviceHelper.queryOriginalArray(selectFields, new QFilter[]{depEmpFilter, effectingFilter});
    }

    public Map<Long, Boolean> isDepEmpAreCharge(Set<Long> depEmpSet) {
        DynamicObject[] dynamicObjects = this.queryOriginalChargeByDepEmps("id, chargeperson.id", depEmpSet);
        Map<Long, Boolean> result = Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("chargeperson.id"), dy -> true, (v, v2) -> v));
        depEmpSet.forEach(depEmpId -> result.putIfAbsent((Long)depEmpId, false));
        return result;
    }

    public DynamicObject[] loadByPositionIds(Set<Long> positionIdSet) {
        QFilter positionFilter = new QFilter("chargeperson.position.id", "in", positionIdSet);
        QFilter effectingFilter = new QFilter("datastatus", "=", (Object)"1");
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{positionFilter, effectingFilter});
    }

    public DynamicObjectCollection queryByPositionIds(Set<Long> positionIdSet) {
        QFilter positionFilter = new QFilter("chargeperson.position.id", "in", positionIdSet);
        String[] dataStatus = new String[]{"1", "2"};
        QFilter effectingFilter = new QFilter("datastatus", "in", (Object)dataStatus);
        return this.serviceHelper.queryOriginalCollection("id,datastatus,chargeperson.id,effdt,leffdt,adminorg.id", new QFilter[]{positionFilter, effectingFilter});
    }

    public DynamicObject[] queryChargeManByOrgIdAndDate(Set<Long> orgIds, Date minDate) {
        QFilter effDtFilter = new QFilter("leffdt", ">=", (Object)minDate);
        QFilter adminOrgIdFilter = new QFilter("adminorg.id", "in", orgIds);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2"});
        return this.serviceHelper.query("adminorg, chargeperson, pernontsprop, isagencycharge, effdt, leffdt, datastatus, ismain", new QFilter[]{dataStatusFilter, adminOrgIdFilter, effDtFilter});
    }

    public DynamicObject[] loadByPks(Object[] pks) {
        return this.serviceHelper.loadDynamicObjectArray(pks);
    }

    private static class ChargePersonInstance {
        private static final HRPIChargePersonRepository INSTANCE = new HRPIChargePersonRepository();

        private ChargePersonInstance() {
        }
    }
}

