/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.repository;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmployeeRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIManFileRepository;
import kd.hrmp.hrpi.business.domian.repository.RepositoryUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.DateUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.DynamicTransformUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import kd.hrmp.hrpi.common.HRPIPageConstants;
import kd.hrmp.hrpi.common.HRPIValueConstants;

public class HRPIDepempRepository {
    private static final Log logger = LogFactory.getLog(HRPIDepempRepository.class);
    public static final HRBaseServiceHelper depempServiceHelper = new HRBaseServiceHelper("hrpi_depemp");
    public static final HRBaseServiceHelper empRelServiceHelper = new HRBaseServiceHelper("hrpi_empposorgrel");
    public static final HRBaseServiceHelper empRelAllServiceHelper = new HRBaseServiceHelper("hrpi_emporgrelall");
    protected static final HRBaseServiceHelper empRelInitServiceHelper = new HRBaseServiceHelper("hrpi_onboardempexp_init");
    private static final String FIELD_DEP_EMP_ID = "depemp_id";

    public static DynamicObject getDepemp(Long depempId) {
        QFilter qf = new QFilter("id", "=", (Object)depempId);
        String dynamicPropString = DynamicTransformUtil.getDynamicPropString(depempServiceHelper.getEntityName());
        return depempServiceHelper.queryOne(dynamicPropString, new QFilter[]{qf, QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] listDepemps(Collection<Long> depempIds) {
        QFilter qf = new QFilter("id", "in", depempIds);
        String dynamicPropString = DynamicTransformUtil.getDynamicPropString(depempServiceHelper.getEntityName());
        return depempServiceHelper.query(dynamicPropString, new QFilter[]{qf, QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] listDepempsByVid(Collection<Long> depVids) {
        QFilter qf = new QFilter("id", "in", depVids);
        String dynamicPropString = DynamicTransformUtil.getDynamicPropString(depempServiceHelper.getEntityName());
        return depempServiceHelper.query(dynamicPropString + ",modifier,modifytime,hisversion,iscurrentversion,sourcevid", new QFilter[]{qf, QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] listDepempIds(List<Long> depempIds, String selectProps) {
        QFilter qFilter = new QFilter("id", "in", depempIds);
        return depempServiceHelper.query(selectProps, new QFilter[]{qFilter, QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] listDepByDepIds(Collection<Long> depEmpIds, String selectProps) {
        QFilter qFilter = new QFilter("boid", "in", depEmpIds);
        return depempServiceHelper.query(selectProps, new QFilter[]{qFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] listDepByEmployeeIds(Collection<Long> employeeIds, String selectProps) {
        QFilter qFilter = new QFilter("employee", "in", employeeIds);
        return depempServiceHelper.queryOriginalArray(selectProps, new QFilter[]{qFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] listDepByDepIdsNotInitFinish(Collection<Long> depEmpIds, String selectProps) {
        QFilter qFilter = new QFilter("boid", "in", depEmpIds);
        return depempServiceHelper.query(selectProps, new QFilter[]{qFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter()});
    }

    public static DynamicObject[] listEmpExpByDepIds(Collection<Long> depEmpIds, String selectProps) {
        QFilter qFilter = new QFilter(FIELD_DEP_EMP_ID, "in", depEmpIds);
        return empRelServiceHelper.query(selectProps, new QFilter[]{qFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter()});
    }

    public static DynamicObject[] listEmpExpAllByDepIds(Collection<Long> depEmpIds, String selectProps) {
        QFilter qFilter = new QFilter(FIELD_DEP_EMP_ID, "in", depEmpIds);
        return empRelAllServiceHelper.query(selectProps, new QFilter[]{qFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] listByDepIdsAndEntityName(String entityName, Collection<Long> depEmpIds, String selectProps) {
        QFilter qFilter = new QFilter(FIELD_DEP_EMP_ID, "in", depEmpIds);
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
        return helper.query(selectProps, new QFilter[]{qFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject getDepempModelIds(Long depempId) {
        String selects = "id,employee,person,cmpemp";
        QFilter qf = new QFilter("id", "=", (Object)depempId);
        return depempServiceHelper.queryOriginalOne(selects, new QFilter[]{qf, QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] listEmpposOrgrels(List<Long> depempIds) {
        QFilter qf = new QFilter("depemp.id", "in", depempIds);
        String dynamicPropString = DynamicTransformUtil.getDynamicPropString(empRelServiceHelper.getEntityName());
        return empRelServiceHelper.queryOriginalArray(dynamicPropString, new QFilter[]{qf, QFilterUtil.getStatusFilters(), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] listEmpposOrgrelsById(List<Long> empPosIds) {
        QFilter qf = new QFilter("id", "in", empPosIds);
        return empRelServiceHelper.loadDynamicObjectArray(new QFilter[]{qf});
    }

    public static DynamicObject[] listDataEmpposOrgrels(List<Long> depempIds) {
        QFilter qf = new QFilter("depemp.id", "in", depempIds);
        String dynamicPropString = DynamicTransformUtil.getDynamicPropString(empRelServiceHelper.getEntityName());
        return empRelServiceHelper.queryOriginalArray(dynamicPropString, new QFilter[]{qf, QFilterUtil.getDataStatusFilter(), QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] listEmpposOrgrelDys(List<Long> depempIds) {
        QFilter qf = new QFilter("depemp.id", "in", depempIds);
        String dynamicPropString = DynamicTransformUtil.getDynamicPropString(empRelServiceHelper.getEntityName());
        return empRelServiceHelper.query(dynamicPropString, new QFilter[]{qf, QFilterUtil.getStatusFilters(), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] listDataEmpposOrgrelDys(List<Long> depempIds) {
        QFilter qf = new QFilter("depemp.id", "in", depempIds);
        String dynamicPropString = DynamicTransformUtil.getDynamicPropString(empRelServiceHelper.getEntityName());
        return empRelServiceHelper.query(dynamicPropString, new QFilter[]{qf, QFilterUtil.getDataStatusFilter(), QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] listDepEmpDysByPerson(List<Long> personIds, String selectProps) {
        QFilter qf = new QFilter("person_id", "in", personIds);
        return depempServiceHelper.query(selectProps, new QFilter[]{qf, QFilterUtil.getDataStatusFilter(), QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] listDepEmps(QFilter qf, String selectProps) {
        return depempServiceHelper.query(selectProps, new QFilter[]{qf, QFilterUtil.getDataStatusFilter(), QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] listDepEmpDysByPerson(List<Long> personIds) {
        QFilter qf = new QFilter("person_id", "in", personIds);
        String dynamicPropString = DynamicTransformUtil.getDynamicPropString(depempServiceHelper.getEntityName());
        return depempServiceHelper.query(dynamicPropString, new QFilter[]{qf, QFilterUtil.getDataStatusFilter(), QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] listEmpposOrgrelDysByPerson(List<Long> personIds) {
        QFilter qf = new QFilter("person_id", "in", personIds);
        String dynamicPropString = DynamicTransformUtil.getDynamicPropString(empRelServiceHelper.getEntityName());
        return empRelServiceHelper.query(dynamicPropString, new QFilter[]{qf, QFilterUtil.getDataStatusFilter(), QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish()});
    }

    public static Map<Long, Set<Long>> getAllUsersOfOrg(String posType, List<Long> orgIds) {
        QFilter orgFilter = new QFilter("adminorg.id", "in", orgIds);
        orgFilter.and(new QFilter("businessstatus", "=", (Object)"1"));
        if (!"1".equals(posType)) {
            orgFilter.and(new QFilter("postype.number", "=", (Object)posType));
        }
        return HRPIDepempRepository.getUsers(new QFilter[]{orgFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()}, "adminorg.id");
    }

    public static Map<Long, Set<Long>> getAllUsersOfOrgteam(String posType, List<Long> orgteamIds) {
        QFilter orgFilter = new QFilter("orgteam.id", "in", orgteamIds);
        orgFilter.and(new QFilter("businessstatus", "=", (Object)"1"));
        if (!"1".equals(posType)) {
            orgFilter.and(new QFilter("postype.number", "=", (Object)posType));
        }
        return HRPIDepempRepository.getUsers(new QFilter[]{orgFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()}, "orgteam.id");
    }

    public static Map<Long, Set<Long>> getAllUsersOfPosition(String posType, List<Long> positionIds) {
        QFilter orgFilter = new QFilter("position.id", "in", positionIds);
        orgFilter.and(new QFilter("businessstatus", "=", (Object)"1"));
        if (!"1".equals(posType)) {
            orgFilter.and(new QFilter("postype.number", "=", (Object)posType));
        }
        return HRPIDepempRepository.getUsers(new QFilter[]{orgFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()}, "position.id");
    }

    public static Map<Long, Set<Long>> getAllUsersOfDutyworkroles(String posType, List<Long> dutyworkrolesIds) {
        QFilter orgFilter = new QFilter("dutyworkroles.id", "in", dutyworkrolesIds);
        orgFilter.and(new QFilter("businessstatus", "=", (Object)"1"));
        if (!"1".equals(posType)) {
            orgFilter.and(new QFilter("postype.number", "=", (Object)posType));
        }
        return HRPIDepempRepository.getUsers(new QFilter[]{orgFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()}, "dutyworkroles.id");
    }

    public static Map<Long, Set<Long>> getUsers(QFilter[] filters, String key) {
        DynamicObject[] dynamicObjects;
        HashMap<Long, Set<Long>> userMap = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject userDy : dynamicObjects = depempServiceHelper.queryOriginalArray("person.id,position.id,adminorg.id,orgteam.id,dutyworkroles.id", filters)) {
            Long keyId = userDy.getLong(key);
            Long personId = userDy.getLong("person.id");
            HashSet<Long> userSet = (HashSet<Long>)userMap.get(keyId);
            if (userSet == null) {
                userSet = new HashSet<Long>();
                userSet.add(personId);
                userMap.put(keyId, userSet);
                continue;
            }
            userSet.add(personId);
        }
        return userMap;
    }

    public static DynamicObject[] getEmpposOrgrelByPersonIds(List<Long> personIds) {
        QFilter qf = new QFilter("person.id", "in", personIds);
        QFilter postTypeFlter = new QFilter("businessstatus", "=", (Object)"1");
        return empRelServiceHelper.queryOriginalArray("depemp.id,id,adminorg.id,postype.id,position.id,position.name,person.id,cmpemp.id,employee.id,stdposition.id,darkposition.id,darkposition.name,isprimary, apositiontype", new QFilter[]{qf, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish(), postTypeFlter});
    }

    public static DynamicObject[] getEmpposOrgrelByEmployeeIds(List<Long> employeeIds) {
        QFilter qf = new QFilter("employee.id", "in", employeeIds);
        QFilter postTypeFlter = new QFilter("businessstatus", "=", (Object)"1");
        return empRelServiceHelper.queryOriginalArray("depemp.id,id,adminorg.id,postype.id,position.id,position.name,person.id,cmpemp.id,employee.id,stdposition.id,darkposition.id,darkposition.name,isprimary, apositiontype", new QFilter[]{qf, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish(), postTypeFlter});
    }

    public static DynamicObject[] getDepEmpByPersonIds(List<Long> personIds) {
        QFilter qf = new QFilter("person.id", "in", personIds);
        QFilter statusFilter = new QFilter("businessstatus", "=", (Object)"1");
        return depempServiceHelper.queryOriginalArray("id,person.id,cmpemp.id,employee.id,postype.id,isprimary", new QFilter[]{qf, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish(), statusFilter});
    }

    public static DynamicObject[] getCurrentPersonByAdminOrgs(List<Long> adminOrgIds, Date queryDate) {
        return HRPIDepempRepository.getCurrentPersonByOrgs("adminorg.id", adminOrgIds, queryDate);
    }

    public static DynamicObject[] getCurrentPersonByOrgteams(List<Long> orgteamIds, Date queryDate) {
        return HRPIDepempRepository.getCurrentPersonByOrgs("orgteam.id", orgteamIds, queryDate);
    }

    public static DynamicObject[] getCurrentPersonByOrgs(String proper, List<Long> orgIds, Date queryDate) {
        QFilter[] qFilters;
        boolean queryDateEmpty;
        QFilter orgQf = new QFilter(proper, "in", orgIds);
        QFilter currentQf = new QFilter("employee.laborrelstatus.labrelstatusprd", "=", (Object)HRPIValueConstants.LABRELSTATUSPRD_ING);
        boolean bl = queryDateEmpty = queryDate == null || DateUtil.dayEquals(queryDate, new Date());
        if (queryDateEmpty) {
            qFilters = new QFilter[]{orgQf, currentQf, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getStatusFilters(), QFilterUtil.getInitStatusFinish()};
        } else {
            QFilter startQf = new QFilter("startdate", "<=", (Object)queryDate);
            QFilter endDateQf = new QFilter("enddate", ">=", (Object)queryDate);
            qFilters = new QFilter[]{orgQf, startQf, endDateQf, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()};
        }
        DynamicObject[] depempsTmp = depempServiceHelper.queryOriginalArray("id,orgteam.id,otclassify.id,adminorg.id,employee.id,person.id,person.name,person.number,postype.name,postype.number", qFilters);
        if (!queryDateEmpty && depempsTmp.length > 0) {
            QFilter endDateQf;
            QFilter startQf;
            Map<Long, List<DynamicObject>> empDepMap = Arrays.stream(depempsTmp).collect(Collectors.groupingBy(depemp -> depemp.getLong("employee.id")));
            QFilter activeFilter = new QFilter("laborrelstatus.labrelstatusprd", "=", (Object)HRPIValueConstants.LABRELSTATUSPRD_ING);
            QFilter boidFilter = new QFilter("boid", "in", empDepMap.keySet());
            DynamicObject[] activeEmployeeArr = HRPIEmployeeRepository.employeeServiceHelper.queryOriginalArray("id,boid", new QFilter[]{boidFilter, activeFilter, startQf = new QFilter("startdate", "<=", (Object)queryDate), endDateQf = new QFilter("enddate", ">=", (Object)queryDate), QFilterUtil.getInitStatusFinish()});
            if (activeEmployeeArr.length > 0) {
                List activeEmployeeBoids = Arrays.stream(activeEmployeeArr).map(employee -> employee.getLong("boid")).collect(Collectors.toList());
                empDepMap.keySet().removeIf(employeeid -> !activeEmployeeBoids.contains(employeeid));
                return (DynamicObject[])empDepMap.values().stream().flatMap(Collection::stream).toArray(DynamicObject[]::new);
            }
        }
        return depempsTmp;
    }

    public static DynamicObject[] listDepempByDutyworkroles(List<Long> dutyworkrolesIdList) {
        QFilter qFilter = new QFilter("dutyworkroles.id", "in", dutyworkrolesIdList);
        qFilter.and(QFilterUtil.getCurrentQf()).and(QFilterUtil.getDataStatusFilter()).and(QFilterUtil.getInitStatusFinish());
        return depempServiceHelper.queryOriginalArray("id,person.id,employee.id,dutyworkroles.id,dutyworkroles.number,position.id,position.number,postype.id,postype.number", qFilter.toArray());
    }

    public static DynamicObject[] getDepEmpByEmployeeIds(List<Long> employeeIds, QFilter qFilter) {
        QFilter qf = new QFilter("employee", "in", employeeIds);
        if (qFilter != null) {
            qf.and(qFilter);
        }
        return depempServiceHelper.loadDynamicObjectArray(new QFilter[]{qf, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] getDepEmpByDepEmpIds(List<Long> empIds, QFilter qFilter) {
        QFilter qf = new QFilter("id", "in", empIds);
        if (qFilter != null) {
            qf.and(qFilter);
        }
        return depempServiceHelper.loadDynamicObjectArray(new QFilter[]{qf, QFilterUtil.getCurrentQf(), QFilterUtil.getStatusFilters(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] getLabRelRecordByRecordIds(List<Long> recordIds) {
        QFilter qf = new QFilter("laborrelrecord", "in", recordIds);
        return depempServiceHelper.queryOriginalArray("id,employee.id,laborrelrecord.id", new QFilter[]{qf, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getStatusFilters(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] getDepEmpByEmployeeId(List<Long> employeeIds) {
        String depEmpProp = DynamicTransformUtil.getDynamicPropString(depempServiceHelper.getEntityName());
        QFilter empIdFilter = new QFilter("employee.id", "in", employeeIds);
        return depempServiceHelper.query(depEmpProp + ",modifier,modifytime,hisversion,iscurrentversion,sourcevid,boid", new QFilter[]{empIdFilter, QFilterUtil.getInitStatusFinish()}, "startdate asc,createtime asc");
    }

    public static DynamicObject[] getEmpPosByDepId(List<Long> depIds) {
        String depEmpProp = DynamicTransformUtil.getDynamicPropString(empRelServiceHelper.getEntityName());
        return empRelServiceHelper.query(depEmpProp + ",modifytime,sourcevid", new QFilter[]{new QFilter("depemp.id", "in", depIds), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] loadEmpPosByBoId(Collection<Long> boid) {
        QFilter boFilter = new QFilter("id", "in", boid);
        return empRelServiceHelper.loadDynamicObjectArray(new QFilter[]{boFilter, QFilterUtil.getInitStatusFinish()});
    }

    public static Map<String, Map<Long, DynamicObject>> loadDepempInfo(Set<Long> depempIds) {
        HashMap<String, Map<Long, DynamicObject>> result = new HashMap<String, Map<Long, DynamicObject>>(depempIds.size());
        Object[] depempDyArray = depempServiceHelper.loadDynamicObjectArray(depempIds.toArray(new Object[0]));
        if (!HRArrayUtils.isEmpty((Object[])depempDyArray)) {
            RepositoryUtil.wrapResultFromSources(result, (DynamicObject[])depempDyArray, "hrpi_depemp", "id");
            HRPIDepempRepository.loadDepempDys(depempIds, result);
        }
        return result;
    }

    private static void loadDepempDys(Collection<Long> depIds, Map<String, Map<Long, DynamicObject>> result) {
        QFilter idQf = new QFilter("depemp", "in", depIds);
        QFilter[] qFilters = new QFilter[]{idQf, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()};
        HRPIPageConstants.DEPEMPENTITYS.forEach(depeEntity -> {
            Object[] dynamicObjects;
            if (!depeEntity.equals("hrpi_depemp") && !depeEntity.equals("hspm_ermanfile")) {
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(depeEntity);
                Object[] dynamicObjects2 = serviceHelper.loadDynamicObjectArray(qFilters);
                if (!HRArrayUtils.isEmpty((Object[])dynamicObjects2)) {
                    RepositoryUtil.wrapResultFromSources(result, (DynamicObject[])dynamicObjects2, depeEntity, "depemp.id");
                }
            } else if (depeEntity.equals("hspm_ermanfile") && !HRArrayUtils.isEmpty((Object[])(dynamicObjects = HRPIManFileRepository.listErFileByDepIds(depIds)))) {
                RepositoryUtil.wrapResultFromSources(result, (DynamicObject[])dynamicObjects, depeEntity, "depemp.id");
            }
        });
    }

    public static int countIntersectEmpOrgrels(List<QFilter> qFilterList) {
        return depempServiceHelper.count("hrpi_depemp", qFilterList.toArray(new QFilter[0]));
    }

    public static DynamicObject[] loadEmpPosByEmployeeId(Collection<Long> employeeIdSet) {
        QFilter employeeFilter = new QFilter("employee_id", "in", employeeIdSet);
        return empRelInitServiceHelper.loadDynamicObjectArray(new QFilter[]{employeeFilter, QFilterUtil.getCurrentQf()});
    }

    public static List<Long> queryPrimaryEmpose(long id, int top) {
        StringBuilder sql = new StringBuilder("SELECT top ");
        sql.append(top).append(',').append(0);
        sql.append(" empent.fpersonid from t_hrpi_empentrel empent left join t_hrpi_personuserrel userrel on empent.fpersonid = userrel.fpersonid where empent.flabrelstatusprdid = 1010 and empent.fiscurrentversion='1' and empent.finitstatus='2'");
        sql.append(" and userrel.fid is null");
        sql.append(" and empent.fpersonid > ").append(id);
        sql.append(" ORDER BY empent.fpersonid");
        List personIds = (List)DB.query((DBRoute)new DBRoute("hr"), (String)sql.toString(), null, resultSet -> {
            ArrayList<Long> personIdList = new ArrayList<Long>(10);
            while (resultSet.next()) {
                personIdList.add(resultSet.getLong("fpersonid"));
            }
            return personIdList;
        });
        return personIds;
    }

    public static List<QFilter> getFilters() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
        filters.add(new QFilter("businessstatus", "=", (Object)"1"));
        filters.add(new QFilter("isprimary", "=", (Object)"1"));
        filters.add(new QFilter("postype", "=", (Object)1010L));
        filters.add(new QFilter("employee.laborrelstatus.labrelstatusprd", "in", (Object)1010L));
        filters.add(QFilterUtil.getInitStatusFinish());
        return filters;
    }

    public static List<Long> queryWorkRole(long id, int top) {
        StringBuilder sql = new StringBuilder("SELECT top ");
        sql.append(top).append(',').append(0);
        sql.append(" thp.fdepempid from t_hrpi_empposorgrel thp left join t_hrpi_personrolerel th on th.fdepempid = thp.fdepempid where thp.fiscurrentversion = '1' and thp.finitstatus='2'");
        sql.append(" and th.fid is null");
        sql.append(" and thp.fdepempid > ").append(id);
        sql.append(" ORDER BY thp.fdepempid");
        List depList = (List)DB.query((DBRoute)new DBRoute("hr"), (String)sql.toString(), null, resultSet -> {
            ArrayList tmpList = Lists.newArrayListWithExpectedSize((int)top);
            while (resultSet.next()) {
                tmpList.add(resultSet.getLong("fdepempid"));
            }
            return tmpList;
        });
        return depList;
    }

    public static DynamicObject[] listEmpposOrgrelDysByProps(List<Long> depempIds, String dynamicPropString) {
        QFilter qf = new QFilter("depemp.id", "in", depempIds);
        return empRelServiceHelper.query(dynamicPropString, new QFilter[]{qf, QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish(), QFilterUtil.getDataStatusFilter()});
    }

    public static boolean existByInitBatch(Long batchNumber) {
        return depempServiceHelper.isExists(new QFilter("initbatch", "=", (Object)batchNumber));
    }

    public static DynamicObject[] queryEmpOrgRelAllForSync(List<Long> depempIds) {
        QFilter qf = new QFilter("depemp.id", "in", depempIds);
        return empRelAllServiceHelper.query("person,issingle,startdate,description,enddate,sysenddate,servicelength,isprimary,isexistprobation,depemp,workplace,businessstatus,variationtype,postype,isinsystem,apositiontype,adminorg,company,position,job,startprobation,endprobation,employee,cmpemp,stdposition", new QFilter[]{qf, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] getDepEmpBySourceVid(Set<Long> sourceVidSet) {
        String depEmpProp = DynamicTransformUtil.getDynamicPropString(empRelServiceHelper.getEntityName());
        QFilter hisFilter = new QFilter("id", "in", sourceVidSet);
        return empRelServiceHelper.query(depEmpProp + ",modifytime,sourcevid", new QFilter[]{hisFilter, QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] getDepEmpByOrgAndPersonId(Set<Long> orgIds, Set<Long> personIds, Date queryDate) {
        if (queryDate == null) {
            queryDate = new Date();
        }
        QFilter dateFilter = new QFilter("startdate", "<=", (Object)queryDate);
        dateFilter.and("enddate", ">=", (Object)queryDate);
        String selectField = "person, employee, adminorg, apositiontype, position, postype, stdposition";
        return HRPIDepempRepository.getDepEmpByOrgAndPersonId(selectField, orgIds, personIds, dateFilter);
    }

    public static DynamicObject[] getPastDepEmpByOrgAndPersonId(Set<Long> orgIds, Set<Long> personIds, Date queryDate) {
        if (queryDate == null) {
            queryDate = new Date();
        }
        QFilter dateFilter = new QFilter("enddate", ">=", (Object)queryDate);
        String selectField = "person, employee, adminorg, apositiontype, position, postype, stdposition, startdate, enddate";
        return HRPIDepempRepository.getDepEmpByOrgAndPersonId(selectField, orgIds, personIds, dateFilter);
    }

    public static DynamicObject[] getDepEmpByOrgAndPersonId(String selectField, Set<Long> orgIds, Set<Long> personIds, QFilter otherFilter) {
        QFilter orgFilter = new QFilter("adminorg", "in", orgIds);
        QFilter personFilter = new QFilter("person", "in", personIds);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2"});
        return depempServiceHelper.query(selectField, new QFilter[]{orgFilter, personFilter, dataStatusFilter, otherFilter});
    }

    public static DynamicObject[] getDepEmpByOrgAndPersonId(String selectField, long orgIds, Set<Long> personIds, QFilter otherFilter) {
        QFilter orgFilter = new QFilter("adminorg", "=", (Object)orgIds);
        QFilter personFilter = new QFilter("person", "in", personIds);
        QFilter currentDataFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
        return depempServiceHelper.queryOriginalArray(selectField, new QFilter[]{orgFilter, personFilter, currentDataFilter, otherFilter});
    }

    public static DynamicObject[] queryByOrgAndPersonId(Set<Long> orgIdSet, Set<Long> personIdSet) {
        QFilter orgFilter = new QFilter("adminorg.id", "in", orgIdSet);
        QFilter idFilter = new QFilter("person.id", "in", personIdSet);
        QFilter commonQFilter = new QFilter("employee.laborrelstatus.labrelstatusprd.id", "=", (Object)1010L);
        commonQFilter.and("iscurrentversion", "=", (Object)Character.valueOf('1')).and(QFilterUtil.getInitStatusFinish());
        Date currentDate = HRDateTimeUtils.getNowDate();
        commonQFilter.and("startdate", "<=", (Object)currentDate);
        commonQFilter.and("enddate", ">", (Object)currentDate);
        return depempServiceHelper.query("person,startdate,enddate,adminorg,position,stdposition,apositiontype", new QFilter[]{idFilter, orgFilter, commonQFilter});
    }

    public static DynamicObject[] queryByOrgAndPersonNumber(Set<Long> orgIdSet, Set<String> personNumberSet) {
        QFilter orgFilter = new QFilter("adminorg.id", "in", orgIdSet);
        QFilter idFilter = new QFilter("person.number", "in", personNumberSet);
        QFilter commonQFilter = new QFilter("employee.laborrelstatus.labrelstatusprd.id", "=", (Object)1010L);
        commonQFilter.and("iscurrentversion", "=", (Object)Character.valueOf('1')).and(QFilterUtil.getInitStatusFinish());
        Date currentDate = HRDateTimeUtils.getNowDate();
        commonQFilter.and("startdate", "<=", (Object)currentDate);
        commonQFilter.and("enddate", ">", (Object)currentDate);
        return depempServiceHelper.query("person,startdate,enddate,adminorg,position,stdposition,apositiontype,employee", new QFilter[]{idFilter, orgFilter, commonQFilter});
    }

    public static DynamicObject[] queryDepempByPersonId(Set<Long> personIdSet) {
        QFilter idFilter = new QFilter("person.id", "in", personIdSet);
        QFilter commonQFilter = new QFilter("employee.laborrelstatus.labrelstatusprd.id", "=", (Object)1010L);
        commonQFilter.and("iscurrentversion", "=", (Object)Character.valueOf('1')).and(QFilterUtil.getInitStatusFinish());
        Date currentDate = HRDateTimeUtils.getNowDate();
        commonQFilter.and("startdate", "<=", (Object)currentDate);
        commonQFilter.and("enddate", ">", (Object)currentDate);
        return depempServiceHelper.query("person,startdate,enddate,adminorg,position,stdposition,apositiontype", new QFilter[]{idFilter, commonQFilter});
    }

    public static DynamicObject[] queryDepempByPersonNumber(Set<String> personNumberSet) {
        QFilter idFilter = new QFilter("person.number", "in", personNumberSet);
        QFilter commonQFilter = new QFilter("employee.laborrelstatus.labrelstatusprd.id", "=", (Object)1010L);
        commonQFilter.and("iscurrentversion", "=", (Object)Character.valueOf('1')).and(QFilterUtil.getInitStatusFinish());
        Date currentDate = HRDateTimeUtils.getNowDate();
        commonQFilter.and("startdate", "<=", (Object)currentDate);
        commonQFilter.and("enddate", ">", (Object)currentDate);
        return depempServiceHelper.query("person,startdate,enddate,adminorg,position,stdposition,apositiontype, employee", new QFilter[]{idFilter, commonQFilter});
    }

    public static DynamicObjectCollection queryByPositionIds(Set<Long> positionIdSet) {
        QFilter positionQFilter = new QFilter("position.id", "in", positionIdSet);
        QFilter commonQFilter = new QFilter("employee.laborrelstatus.labrelstatusprd.id", "=", (Object)1010L);
        commonQFilter.and("iscurrentversion", "=", (Object)Character.valueOf('1')).and(QFilterUtil.getInitStatusFinish());
        Date currentDate = HRDateTimeUtils.getNowDate();
        commonQFilter.and("startdate", "<=", (Object)currentDate);
        commonQFilter.and("enddate", ">", (Object)currentDate);
        QFilter dataStatusFilter = QFilterUtil.getDataStatusFilter();
        return depempServiceHelper.queryOriginalCollection("adminorg.id,id,position.id,person.id,startdate", new QFilter[]{positionQFilter, commonQFilter, dataStatusFilter});
    }

    public static DynamicObject[] listPrimaryDys(String entityName, List<Long> queryIds, String primary, String queryField) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        QFilter qf = null;
        QFilter statusFilters = QFilterUtil.getStatusFilters();
        QFilter currentQf = QFilterUtil.getCurrentQf();
        QFilter initStatusFinish = QFilterUtil.getInitStatusFinish();
        qf = queryField.equals("depemp") ? ("hrpi_depemp".equals(entityName) ? new QFilter("id", "in", queryIds) : new QFilter("depemp", "in", queryIds)) : new QFilter("employee", "in", queryIds);
        currentQf.and(statusFilters).and(initStatusFinish).and(qf);
        if ("1".equals(primary)) {
            QFilter primaryFilter = new QFilter("isprimary", "=", (Object)"1");
            currentQf.and(primaryFilter);
        }
        String dynamicPropString = DynamicTransformUtil.getDynamicPropString(serviceHelper.getEntityName());
        return serviceHelper.query(dynamicPropString, new QFilter[]{currentQf});
    }

    public static List<DynamicObject> listDataEmpOrgrelsById(Collection<Long> queryId, String type) {
        QFilter boFilter = new QFilter(type, "in", queryId);
        String dynamicPropString = DynamicTransformUtil.getDynamicPropString(empRelServiceHelper.getEntityName());
        return Arrays.asList(empRelServiceHelper.query(dynamicPropString, new QFilter[]{boFilter, QFilterUtil.getDataStatusFilter(), QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish()}));
    }

    public static DynamicObject[] queryDepEmpByEmployeeId(List<Long> employeeIds, QFilter qFilter) {
        String depEmpProp = DynamicTransformUtil.getDynamicPropString(depempServiceHelper.getEntityName());
        QFilter empIdFilter = new QFilter("employee.id", "in", employeeIds);
        if (qFilter != null) {
            empIdFilter.and(qFilter);
        }
        return depempServiceHelper.query("createtime," + depEmpProp, new QFilter[]{empIdFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter()});
    }

    public static DynamicObject[] getDepEmpByNumber(Collection<String> numbers) {
        QFilter empIdFilter = new QFilter("person.number", "in", numbers);
        String depEmpProp = DynamicTransformUtil.getDynamicPropString(depempServiceHelper.getEntityName());
        return depempServiceHelper.query(depEmpProp, new QFilter[]{empIdFilter, QFilterUtil.getCurrentQf()});
    }

    public static DynamicObject[] queryEffectingByBoIds(String selectFields, Collection<Long> boIdList) {
        QFilter qFilter = new QFilter("boid", "in", boIdList);
        qFilter.and(QFilterUtil.getInitStatusFinish());
        qFilter.and(QFilterUtil.getDataStatusFilter());
        return depempServiceHelper.query(selectFields, qFilter.toArray());
    }

    public static void save(DynamicObject[] dynamicObjects) {
        depempServiceHelper.save(dynamicObjects);
    }
}

